/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr;

import com.adobe.xmp.XMPMeta;
import com.adobe.xmp.properties.XMPPropertyInfo;
import com.apple.its.asset.lsr.AssetBundleScheme;
import com.apple.its.asset.lsr.DisplayGamut;
import com.apple.its.asset.lsr.Idiom;
import com.apple.its.asset.lsr.ImageScale;
import com.apple.its.asset.lsr.ImageStackLayer;
import com.apple.its.asset.lsr.LSRException;
import com.apple.its.asset.lsr.LSRFile;
import com.apple.its.asset.lsr.io.ImageBuffer;
import com.apple.its.asset.lsr.json.Contents;
import com.apple.its.asset.lsr.json.Image;
import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.xmp.XmpDirectory;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

public class ImageSet
extends ArrayList<Entry> {
    static final String CHANNEL_DEPTH_HDR_STRING = "[PNG-IHDR] Bits Per Sample";
    static final List<Integer> VALID_CHANNEL_BIT_DEPTHS = Arrays.asList(1, 2, 4, 8, 16);
    private String name = "Content";

    public ImageSet() {
    }

    public ImageSet(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.trim().isEmpty()) {
            throw new IllegalArgumentException("name is blank");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("name contains slash");
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public boolean add(Image json, ImageBuffer imageBuffer) {
        return this.add(new Entry(json, imageBuffer));
    }

    public boolean add(File source, ImageScale scale) throws IOException {
        return this.add(source, scale, Idiom.universal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(File source, ImageScale scale, Idiom idiom) throws IOException {
        Preconditions.checkNotNull((Object)((Object)scale));
        Preconditions.checkNotNull((Object)((Object)idiom));
        Preconditions.checkNotNull((Object)source);
        try (Closer closer = Closer.create();){
            InputStream in = (InputStream)closer.register((Closeable)new FileInputStream(source));
            Image image = new Image(idiom.toString(), source.getName(), scale.toString(), DisplayGamut.srgb.toString());
            Entry entry = new Entry(image, ImageBuffer.create(ImageBuffer.Strategy.heap, source.getName(), in, -1L));
            boolean bl = this.add(entry);
            return bl;
        }
    }

    public void add(ImageBuffer imageBuffer, String name, ImageScale scale, Idiom idiom) {
        Image image = new Image(idiom, name, scale, DisplayGamut.srgb);
        this.add(image, ImageBuffer.create(name, imageBuffer.toBytes()));
    }

    public void add(ImageBuffer imageBuffer, String name, ImageScale scale, Idiom idiom, DisplayGamut displayGamut) {
        Image image = new Image(idiom, name, scale, displayGamut);
        this.add(image, ImageBuffer.create(name, imageBuffer.toBytes()));
    }

    public Set<ImageScale> scales() {
        return Sets.newEnumSet((Iterable)Iterables.transform((Iterable)this, (Function)new Function<Entry, ImageScale>(){

            public ImageScale apply(Entry input) {
                if (input == null) {
                    return null;
                }
                return input.scale();
            }
        }), ImageScale.class);
    }

    public Set<Idiom> idiomSet() {
        return Sets.newEnumSet((Iterable)Iterables.transform((Iterable)this, (Function)new Function<Entry, Idiom>(){

            public Idiom apply(Entry input) {
                return input == null ? null : ((Entry)input).json.idiom;
            }
        }), Idiom.class);
    }

    public Set<DisplayGamut> displayGamutSet() {
        return Sets.newEnumSet((Iterable)Iterables.transform((Iterable)this, (Function)new Function<Entry, DisplayGamut>(){

            public DisplayGamut apply(Entry input) {
                return input == null ? null : ((Entry)input).json.displayGamut;
            }
        }), DisplayGamut.class);
    }

    public ImageBuffer getImageWithScale(final String scale) {
        Entry entry = (Entry)Iterables.getFirst((Iterable)Iterables.filter((Iterable)this, (Predicate)new Predicate<Entry>(){

            public boolean apply(Entry input) {
                return input != null && input.scale() != null && Objects.equal((Object)scale, (Object)input.scale().toString());
            }
        }), null);
        return entry == null ? null : entry.imageBuffer();
    }

    public ImageScale bestScale() {
        if (this.assetBundleScheme() == AssetBundleScheme.fat) {
            return ((Entry)this.get(0)).scale();
        }
        List scales = this.stream().map(entry -> entry.scale()).collect(Collectors.toList());
        ImageScale largestScale = (ImageScale)((Object)Collections.max(scales));
        return largestScale;
    }

    public DisplayGamut bestDisplayGamut() {
        if (this.assetBundleScheme() == AssetBundleScheme.thin) {
            return ((Entry)this.get(0)).displayGamut();
        }
        for (Entry entry : this) {
            if (!entry.displayGamut().equals((Object)DisplayGamut.display_p3)) continue;
            return DisplayGamut.display_p3;
        }
        return DisplayGamut.srgb;
    }

    public AssetBundleScheme assetBundleScheme() {
        if (this.size() > 1) {
            return AssetBundleScheme.fat;
        }
        return AssetBundleScheme.thin;
    }

    public void outputTo(String dir, ZipArchiveOutputStream zip) throws IOException {
        Preconditions.checkNotNull((Object)dir);
        Preconditions.checkNotNull((Object)zip);
        for (Entry entry : this) {
            String filename = LSRFile.joinPath(dir, entry.filename());
            LSRFile.checkFileName(filename);
            zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(filename));
            entry.imageBuffer().copyTo((OutputStream)zip);
            zip.closeArchiveEntry();
        }
        zip.putArchiveEntry((ArchiveEntry)new ZipArchiveEntry(LSRFile.joinPath(dir, "Contents.json")));
        this.getContents().outputTo((OutputStream)zip);
        zip.closeArchiveEntry();
    }

    public Contents getContents() {
        Contents json = new Contents();
        json.info = LSRFile.config.defaultInfo();
        json.images = Lists.newArrayList((Iterable)Iterables.transform((Iterable)this, (Function)new Function<Entry, Image>(){

            public Image apply(Entry input) {
                return input.json();
            }
        }));
        json.validate();
        return json;
    }

    public void exportTo(File file, final ImageScale scale, final Idiom idiom) throws IOException {
        ((Entry)Iterables.find((Iterable)this, (Predicate)new Predicate<Entry>(){

            public boolean apply(Entry input) {
                return input != null && input.scale() == scale && input.idiom() == idiom;
            }
        })).imageBuffer().copyTo(file);
    }

    public void validate(ImageStackLayer layer) throws LSRException {
        if (this.name == null || this.name.trim().isEmpty()) {
            throw new LSRException("ImageSet name is not set");
        }
        if (this.isEmpty()) {
            throw new LSRException("no image in image set");
        }
        for (Entry e : this) {
            e.validate(layer, this);
        }
    }

    String dir() {
        return this.name() + ".imageset";
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.name == null ? 0 : this.name.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ImageSet) {
            ImageSet that = (ImageSet)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Iterables.elementsEqual((Iterable)this, (Iterable)that);
        }
        return false;
    }

    public static class Entry {
        private final Image json;
        private final ImageBuffer buffer;

        public Entry(Image json, ImageBuffer buffer) {
            this.json = (Image)Preconditions.checkNotNull((Object)json);
            this.buffer = (ImageBuffer)Preconditions.checkNotNull((Object)buffer);
        }

        public ImageScale scale() {
            return this.json.scale;
        }

        public String filename() {
            return this.json.filename;
        }

        public Idiom idiom() {
            return this.json.idiom;
        }

        public ImageBuffer imageBuffer() {
            return this.buffer;
        }

        public Image json() {
            return this.json;
        }

        public DisplayGamut displayGamut() {
            return this.json.displayGamut;
        }

        public void validate(ImageStackLayer layer, ImageSet imageSet) throws LSRException {
            this.json.validate();
            LSRFile.checkFileName(this.jsonFile(layer, imageSet));
            if (this.buffer.size() == 0L) {
                throw new LSRException("0 byte image is not allowed");
            }
        }

        private String jsonFile(ImageStackLayer layer, ImageSet imageSet) {
            return LSRFile.joinPath(layer.dir(), imageSet.dir(), this.json.filename);
        }

        public Integer imageChannelDepth() {
            try {
                Metadata metadata = ImageMetadataReader.readMetadata((InputStream)this.imageBuffer().asInputStream());
                for (XmpDirectory xmpDirectory : metadata.getDirectoriesOfType(XmpDirectory.class)) {
                    XMPMeta xmpMeta = xmpDirectory.getXMPMeta();
                    for (XMPPropertyInfo property : xmpMeta) {
                        if (property == null || property.getPath() == null) continue;
                        for (Integer depth : VALID_CHANNEL_BIT_DEPTHS) {
                            if (!property.getValue().contains(depth.toString())) continue;
                            return depth;
                        }
                    }
                }
                for (Directory directory : metadata.getDirectories()) {
                    for (Tag tag : directory.getTags()) {
                        for (Integer depth : VALID_CHANNEL_BIT_DEPTHS) {
                            if (!tag.toString().contains(depth.toString())) continue;
                            return depth;
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return -1;
        }

        public String toString() {
            return this.buffer.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Entry) {
                Entry that = (Entry)o;
                return Objects.equal((Object)this.json, (Object)that.json) && Objects.equal((Object)this.buffer, (Object)that.buffer);
            }
            return false;
        }
    }
}

