/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum ImageScale {
    _na(0),
    _1x(1),
    _2x(2),
    _3x(3);

    static final Pattern PATTERN;
    final int x;

    private ImageScale(int x) {
        this.x = x;
    }

    @JsonValue
    public String toString() {
        if (this.x == 0) {
            return "na";
        }
        return this.x + "x";
    }

    @JsonCreator
    public static ImageScale of(String s) {
        Matcher matcher = PATTERN.matcher((CharSequence)Preconditions.checkNotNull((Object)s));
        if (matcher.matches()) {
            int x = Integer.parseInt(matcher.group(1));
            for (ImageScale is : ImageScale.values()) {
                if (x != is.x) continue;
                return is;
            }
            return _na;
        }
        throw new IllegalArgumentException("invalid value for ImageScale: " + s);
    }

    static {
        PATTERN = Pattern.compile("_?(\\d)x?");
    }
}

