/*
 * Decompiled with CFR 0.152.
 */
package com.apple.its.asset.lsr;

import com.apple.its.asset.lsr.ImageSet;
import com.apple.its.asset.lsr.ImageStackLayer;
import com.apple.its.asset.lsr.LSRFile;
import com.apple.its.asset.lsr.io.ImageBuffer;
import com.apple.its.asset.lsr.json.Properties;
import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class CmdLineTool {
    static boolean verbose = false;
    static boolean checkImage = false;

    public static void main(String[] args) {
        ArrayList<File> files = new ArrayList<File>();
        for (String arg : args) {
            if (arg.startsWith("-")) {
                if (arg.length() < 2) {
                    CmdLineTool.fatal(1, "Illegal argument: " + arg);
                }
                switch (arg.charAt(1)) {
                    case 'v': {
                        verbose = true;
                        break;
                    }
                    case 'c': {
                        checkImage = true;
                        break;
                    }
                    case '?': 
                    case 'h': {
                        CmdLineTool.usage();
                        break;
                    }
                    default: {
                        CmdLineTool.fatal(1, "Illegal option: " + arg);
                        break;
                    }
                }
                continue;
            }
            CmdLineTool.list(files, new File(arg));
        }
        int bad = 0;
        int good = 0;
        int width = 0;
        for (File f : files) {
            width = Math.max(width, f.getName().length());
        }
        for (File file : files) {
            try {
                LSRFile lsrFile = new LSRFile(file, checkImage ? ImageBuffer.Strategy.heap : ImageBuffer.Strategy.none);
                lsrFile.validate();
                ++good;
                if (lsrFile.getRootContents() == null) {
                    throw new IllegalStateException("missing root level Contents.json");
                }
                int version = lsrFile.getRootContents().info.version;
                String author = lsrFile.getRootContents().info.author;
                System.out.format("%-" + width + "s | %10s | %d layers | version %d | %s\n", file.getName(), lsrFile.canvasSize().toShortString(), lsrFile.size(), version, author);
                if (!verbose) continue;
                for (ImageStackLayer layer : lsrFile) {
                    Properties properties = layer.getProperties();
                    System.out.println("\t" + layer.name() + ": " + properties);
                    if (!checkImage) continue;
                    for (ImageSet.Entry e : layer.getImageSet()) {
                        Dimension dimension = CmdLineTool.imageSize(e.imageBuffer().asInputStream());
                        System.out.println("\t\timage name=" + e.filename() + " dimension=" + dimension.width + "x" + dimension.height);
                        if (properties == null || dimension.width == properties.frameSize.width && dimension.height == properties.frameSize.height) continue;
                        System.err.println("actual image dimension doesn't match frameSize in Contents.json");
                    }
                }
            }
            catch (Throwable t) {
                System.out.format("%-" + width + "s | ERROR: %s\n", file.getName(), t.getMessage());
                t.printStackTrace(System.err);
                ++bad;
            }
        }
        CmdLineTool.info(String.format("%s\n%d files processed (%d good, %d bad)", Strings.repeat((String)"-", (int)80), files.size(), good, bad));
    }

    static void usage() {
        System.out.println("lsrtool [-vch] [file ...]\n    -v     verbose, prints layer information\n    -c     check images, print actual dimension\n    -h     prints help and usage\n");
        System.exit(0);
    }

    static void list(List<File> files, File ... args) {
        if (args == null || files == null) {
            return;
        }
        for (File file : args) {
            if (file.isDirectory()) {
                CmdLineTool.list(files, file.listFiles());
                continue;
            }
            if (file.exists()) {
                files.add(file);
                continue;
            }
            CmdLineTool.error("file not found: " + file);
        }
    }

    static Dimension imageSize(InputStream in) {
        try {
            BufferedImage image = ImageIO.read(in);
            Dimension dimension = new Dimension(((Image)image).getWidth(null), ((Image)image).getHeight(null));
            return dimension;
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    static void info(String msg) {
        System.out.println(msg);
    }

    static void error(String msg) {
        System.err.println(msg);
    }

    static void fatal(int code, String msg) {
        System.err.println(msg);
        System.exit(code);
    }
}

