/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.util;

import com.signiant.mobilize.ddsclient.core.Relay;
import com.signiant.mobilize.ddsclient.util.DCLogger;
import com.signiant.mobilize.ddsclient.util.DdsConfigLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelayLoader {
    private String targetPcHost;

    public void setTargetPcHost(String targetPcHost) {
        this.targetPcHost = targetPcHost;
    }

    public List<Relay> loadRelays() {
        DCLogger.debug(this.getClass(), "loading relays for " + this.targetPcHost);
        List<Relay> relays = new ArrayList<Relay>();
        List<Object> ddsCfgLines = new ArrayList();
        try {
            ddsCfgLines = DdsConfigLoader.instance().loadDdsCfg();
        }
        catch (Exception ex) {
            DCLogger.warning(this.getClass(), "caught exception and will try to connect pc without relays. ex: " + ex);
        }
        String indicator1 = "Proxy for " + this.targetPcHost + " is";
        String indicator2 = "Proxies for " + this.targetPcHost + " are";
        String indicator3 = "Proxy for * is";
        String indicator4 = "Proxies for * are";
        for (String string : ddsCfgLines) {
            boolean bFound = false;
            String indicator = "";
            if (string.startsWith(indicator1)) {
                bFound = true;
                indicator = indicator1;
            } else if (string.startsWith(indicator2)) {
                bFound = true;
                indicator = indicator2;
            } else if (string.startsWith(indicator3)) {
                bFound = true;
                indicator = indicator3;
            } else if (string.startsWith(indicator4)) {
                bFound = true;
                indicator = indicator4;
            }
            if (!bFound) continue;
            String strRelays = string.substring(indicator.length(), string.length());
            relays = this.extractRelays(strRelays);
            break;
        }
        return relays;
    }

    private List<Relay> extractRelays(String strRelays) {
        ArrayList<Relay> relays = new ArrayList<Relay>();
        strRelays = strRelays.trim();
        StringTokenizer tokens = new StringTokenizer(strRelays, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            int index = token.indexOf(" ");
            String hostName = token.substring(0, index).trim();
            String port = token.substring(index + 1 + "port=".length(), token.length()).trim();
            Relay relay = new Relay(hostName, Integer.parseInt(port));
            DCLogger.debug(this.getClass(), "relay: " + relay.toText());
            relays.add(relay);
        }
        return relays;
    }
}

