/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.util;

import com.signiant.mobilize.ddsclient.core.exception.DdsClientException;
import com.signiant.mobilize.ddsclient.util.IoUtil;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfigLoader {
    public static final String exceptionMessage = "Could not load default configuration file.";
    public static final String rapidBasicInstallIndicator = "RBI_enabled=";
    public static final String orgIdIndicator = "DEF_org_id=";
    public static final String orgIdKeylessIndicator = "DEF_org_id_keyless=";
    public static final String unixInstallDirIndicator = "DEF_install_dir_UNIX=";
    public static final String windowsInstallDirIndicator = "DEF_install_dir_WIN=";
    public static final String defUnixUserIndicator = "DEF_default_user_UNIX=";
    public static final String defWindowsUserIndicator = "DEF_default_user_WIN=";
    public static final String windowsDomainIndicator = "DEF_windows_domain=";
    public static final String defWindowsUserPasswordIndicator = "DEF_default_user_password_WIN=";
    public static final String agentPortIndicator = "DEF_agent_port=";
    public static final String udpMsgIndicator = "DEF_udpmsg=";
    public static final String udpOrigPortRangeIndicator = "DEF_udp_orig_port_range=";
    public static final String udpDestPortRangeIndicator = "DEF_udp_dest_port_range=";
    public static final String eventServerPortIndicator = "DEF_event_server_port=";
    public static final String eventServerParamsIndicator = "DEF_event_server_parms=";
    public static final String defUnixDirIndicator = "DEF_default_dir_UNIX=";
    public static final String defWindowsDirIndicator = "DEF_default_dir_WIN=";
    public static final String caSignatureIndicator = "DEF_ca_signature=";
    public static final String optionSettingsIndicator = "DEF_option_settings=";
    public static final String agentRegistrationUrlIndicator = "DEF_agent_registration_URL=";
    public static final String unixAdminIndicator = "DEF_administrator_UNIX";
    public static final String windowsAdminIndicator = "DEF_administrator_WIN";
    public static final String relayIndicator = "Relay";
    public static final String tunnelIndicator = "Tunnel";
    public static final String grantIndicator = "Grant";
    public static final String windowsGrantIndicator = "Grant_WIN";
    public static final String unixGrantIndicator = "Grant_UNIX";
    public static final String rbiUnixGrantIndicator = "RBI_grant_UNIX";
    public static final String rbiWindowsGrantIndicator = "RBI_grant_WIN";
    private String rapidBasicInstall = "";
    private String orgId = "";
    private String certificateAuthorityOrganizationId = "";
    private String orgIdKeyless = "";
    private String unixInstallDir = "";
    private String windowsInstallDir = "";
    private String defUnixUser = "";
    private String defWindowsUser = "";
    private String windowsDomain = "";
    private String defWindowsUserPassword = "";
    private String agentPort = "";
    private String udpMsg = "";
    private String udpOrigPortRange = "";
    private String udpDestPortRange = "";
    private String eventServerPort = "";
    private String eventServerParams = "";
    private String defUnixDir = "";
    private String defWindowsDir = "";
    private String caSignature = "";
    private String optionSettings = "";
    private String agentRegistrationUrl = "";
    private List<String> unixAdmin = new ArrayList<String>();
    private List<String> windowsAdmin = new ArrayList<String>();
    private List<String> relays = new ArrayList<String>();
    private List<String> tunnels = new ArrayList<String>();
    private List<String> grants = new ArrayList<String>();
    private List<String> windowsGrants = new ArrayList<String>();
    private List<String> unixGrants = new ArrayList<String>();
    private List<String> rbiUnixGrants = new ArrayList<String>();
    private List<String> rbiWindowsGrants = new ArrayList<String>();
    private boolean bConfigLoaded = false;
    private String fullPathToDefaultCfg;
    private static DefaultConfigLoader instance = new DefaultConfigLoader();

    private DefaultConfigLoader() {
    }

    public DefaultConfigLoader(String path) {
        this.fullPathToDefaultCfg = path;
    }

    public static DefaultConfigLoader instance() {
        return instance;
    }

    public String getRapidBasicInstall() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.rapidBasicInstall;
    }

    public String getRapidBasicInstallForFile() {
        return rapidBasicInstallIndicator + this.rapidBasicInstall + "\n";
    }

    public void setRapidBasicInstall(String rapidBasicInstall) {
        this.rapidBasicInstall = rapidBasicInstall;
    }

    public String getOrgId() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.orgId;
    }

    public void setCertificateAuthorityOrganizationId(String certificateAuthorityOrganizationId) {
        this.certificateAuthorityOrganizationId = certificateAuthorityOrganizationId;
    }

    public String getOrgIdForFile() {
        return orgIdIndicator + this.certificateAuthorityOrganizationId + "\n";
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgIdKeyless() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.orgIdKeyless;
    }

    public String getOrgIdKeylessForFile() {
        return orgIdKeylessIndicator + this.orgIdKeyless + "\n";
    }

    public void setOrgIdKeyless(String orgIdKeyless) {
        this.orgIdKeyless = orgIdKeyless;
    }

    public String getUnixInstallDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.unixInstallDir;
    }

    public String getUnixInstallDirForFile() {
        return unixInstallDirIndicator + this.unixInstallDir + "\n";
    }

    public void setUnixInstallDir(String unixInstallDir) {
        this.unixInstallDir = unixInstallDir;
    }

    public String getWindowsInstallDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.windowsInstallDir;
    }

    public String getWindowsInstallDirForFile() {
        return windowsInstallDirIndicator + this.windowsInstallDir + "\n";
    }

    public void setWindowsInstallDir(String windowsInstallDir) {
        this.windowsInstallDir = windowsInstallDir;
    }

    public String getDefUnixUser() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.defUnixUser;
    }

    public String getDefUnixUserForFile() {
        return defUnixUserIndicator + this.defUnixUser + "\n";
    }

    public void setDefUnixUser(String defUnixUser) {
        this.defUnixUser = defUnixUser;
    }

    public String getDefWindowsUser() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.defWindowsUser;
    }

    public String getDefWindowsUserForFile() {
        return defWindowsUserIndicator + this.defWindowsUser + "\n";
    }

    public void setDefWindowsUser(String defWindowsUser) {
        this.defWindowsUser = defWindowsUser;
    }

    public String getWindowsDomain() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.windowsDomain;
    }

    public String getWindowsDomainForFile() {
        return windowsDomainIndicator + this.windowsDomain + "\n";
    }

    public void setWindowsDomain(String windowsDomain) {
        this.windowsDomain = windowsDomain;
    }

    public String getDefWindowsUserPassword() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.defWindowsUserPassword;
    }

    public String getDefWindowsUserPasswordForFile() {
        return defWindowsUserPasswordIndicator + this.defWindowsUserPassword + "\n";
    }

    public void setDefWindowsUserPassword(String defWindowsUserPassword) {
        this.defWindowsUserPassword = defWindowsUserPassword;
    }

    public String getAgentPort() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.agentPort;
    }

    public String getAgentPortForFile() {
        return agentPortIndicator + this.agentPort + "\n";
    }

    public void setAgentPort(String agentPort) {
        this.agentPort = agentPort;
    }

    public String getUdpMsg() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.udpMsg;
    }

    public String getUdpMsgForFile() {
        return udpMsgIndicator + this.udpMsg + "\n";
    }

    public void setUdpMsg(String udpMsg) {
        this.udpMsg = udpMsg;
    }

    public String getUdpOrigPortRange() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.udpOrigPortRange;
    }

    public String getUdpOrigPortRangeForFile() {
        return udpOrigPortRangeIndicator + this.udpOrigPortRange + "\n";
    }

    public void setUdpOrigPortRange(String udpOrigPortRange) {
        this.udpOrigPortRange = udpOrigPortRange;
    }

    public String getUdpDestPortRange() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.udpDestPortRange;
    }

    public String getUdpDestPortRangeForFile() {
        return udpDestPortRangeIndicator + this.udpDestPortRange + "\n";
    }

    public void setUdpDestPortRange(String udpDestPortRange) {
        this.udpDestPortRange = udpDestPortRange;
    }

    public String getEventServerPort() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.eventServerPort;
    }

    public String getEventServerPortForFile() {
        return eventServerPortIndicator + this.eventServerPort + "\n";
    }

    public void setEventServerPort(String eventServerPort) {
        this.eventServerPort = eventServerPort;
    }

    public String getEventServerParams() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.eventServerParams;
    }

    public String getEventServerParamsForFile() {
        return eventServerParamsIndicator + this.eventServerParams + "\n";
    }

    public void setEventServerParams(String eventServerParams) {
        this.eventServerParams = eventServerParams;
    }

    public String getDefUnixDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.defUnixDir;
    }

    public String getDefUnixDirForFile() {
        return defUnixDirIndicator + this.defUnixDir + "\n";
    }

    public void setDefUnixDir(String defUnixDir) {
        this.defUnixDir = defUnixDir;
    }

    public String getDefWindowsDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.defWindowsDir;
    }

    public String getDefWindowsDirForFile() {
        return defWindowsDirIndicator + this.defWindowsDir + "\n";
    }

    public void setDefWindowsDir(String defWindowsDir) {
        this.defWindowsDir = defWindowsDir;
    }

    public String getCaSignature() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.caSignature;
    }

    public String getCaSignatureForFile() {
        return caSignatureIndicator + this.caSignature + "\n";
    }

    public void setCaSignature(String caSignature) {
        this.caSignature = caSignature;
    }

    public String getOptionSettings() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.optionSettings;
    }

    public String getOptionSettingsForFile() {
        return optionSettingsIndicator + this.optionSettings + "\n";
    }

    public void setOptionSettings(String optionSettings) {
        this.optionSettings = optionSettings;
    }

    public String getAgentRegistrationUrl() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.agentRegistrationUrl;
    }

    public String getAgentRegistrationUrlForFile() {
        return agentRegistrationUrlIndicator + this.agentRegistrationUrl + "\n";
    }

    public void setAgentRegistrationUrl(String agentRegistrationUrl) {
        this.agentRegistrationUrl = agentRegistrationUrl;
    }

    public List<String> getUnixAdmin() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.unixAdmin;
    }

    public String getUnixAdminForFile() {
        String retValue = "";
        for (int i = 1; i <= this.unixAdmin.size(); ++i) {
            retValue = retValue + "DEF_administrator_UNIX[" + Integer.toString(i) + "]=" + this.unixAdmin.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setUnixAdmin(List<String> unixAdmin) {
        this.unixAdmin = unixAdmin;
    }

    public List<String> getWindowsAdmin() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.windowsAdmin;
    }

    public String getWindowsAdminForFile() {
        String retValue = "";
        for (int i = 1; i <= this.windowsAdmin.size(); ++i) {
            retValue = retValue + "DEF_administrator_WIN[" + Integer.toString(i) + "]=" + this.windowsAdmin.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setWindowsAdmin(List<String> windowsAdmin) {
        this.windowsAdmin = windowsAdmin;
    }

    public List<String> getRelays() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.relays;
    }

    public String getRelaysForFile() {
        String retValue = "";
        for (int i = 1; i <= this.relays.size(); ++i) {
            retValue = retValue + "Relay[" + Integer.toString(i) + "]=" + this.relays.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setRelays(List<String> relays) {
        this.relays = relays;
    }

    public List<String> getTunnels() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.tunnels;
    }

    public String getTunnelsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.tunnels.size(); ++i) {
            retValue = retValue + "Tunnel[" + Integer.toString(i) + "]=" + this.tunnels.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setTunnels(List<String> tunnels) {
        this.tunnels = tunnels;
    }

    public List<String> getGrants() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.grants;
    }

    public String getGrantsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.grants.size(); ++i) {
            retValue = retValue + "Grant[" + Integer.toString(i) + "]=" + this.grants.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setGrants(List<String> grants) {
        this.grants = grants;
    }

    public List<String> getWindowsGrants() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.windowsGrants;
    }

    public String getWindowsGrantsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.windowsGrants.size(); ++i) {
            retValue = retValue + "Grant_WIN[" + Integer.toString(i) + "]=" + this.windowsGrants.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setWindowsGrants(List<String> windowsGrants) {
        this.windowsGrants = windowsGrants;
    }

    public List<String> getUnixGrants() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.unixGrants;
    }

    public String getUnixGrantsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.unixGrants.size(); ++i) {
            retValue = retValue + "Grant_UNIX[" + Integer.toString(i) + "]=" + this.unixGrants.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setUnixGrants(List<String> unixGrants) {
        this.unixGrants = unixGrants;
    }

    public List<String> getRbiUnixGrants() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.rbiUnixGrants;
    }

    public String getRbiUnixGrantsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.rbiUnixGrants.size(); ++i) {
            retValue = retValue + "RBI_grant_UNIX[" + Integer.toString(i) + "]=" + this.rbiUnixGrants.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setRbiUnixGrants(List<String> rbiUnixGrants) {
        this.rbiUnixGrants = rbiUnixGrants;
    }

    public List<String> getRbiWindowsGrants() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDefaultConfiguration();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.rbiWindowsGrants;
    }

    public String getRbiWindowsGrantsForFile() {
        String retValue = "";
        for (int i = 1; i <= this.rbiWindowsGrants.size(); ++i) {
            retValue = retValue + "RBI_grant_WIN[" + Integer.toString(i) + "]=" + this.rbiWindowsGrants.get(i - 1) + "\n";
        }
        return retValue;
    }

    public void setRbiWindowsGrants(List<String> rbiWindowsGrants) {
        this.rbiWindowsGrants = rbiWindowsGrants;
    }

    public String getPathToDefaultCfg() {
        return this.fullPathToDefaultCfg;
    }

    public void setFullPathToDefaultCfg(String ddsCfgFullPath) {
        this.fullPathToDefaultCfg = ddsCfgFullPath;
    }

    public String getFullPathToDefaultCfg() {
        return this.fullPathToDefaultCfg;
    }

    public void loadDefaultConfiguration() throws Exception {
        if (this.bConfigLoaded) {
            return;
        }
        try {
            FileInputStream fis = new FileInputStream(this.fullPathToDefaultCfg);
            List<String> ddsCfgLines = IoUtil.readLines(fis, true);
            for (String line : ddsCfgLines) {
                String[] adminValuePair;
                String admin;
                if ((line = line.trim()).startsWith(rapidBasicInstallIndicator)) {
                    this.rapidBasicInstall = line.substring(rapidBasicInstallIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(orgIdIndicator)) {
                    this.orgId = line.substring(orgIdIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(orgIdKeylessIndicator)) {
                    this.orgIdKeyless = line.substring(orgIdKeylessIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(unixInstallDirIndicator)) {
                    this.unixInstallDir = line.substring(unixInstallDirIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(windowsInstallDirIndicator)) {
                    this.windowsInstallDir = line.substring(windowsInstallDirIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(defUnixUserIndicator)) {
                    this.defUnixUser = line.substring(defUnixUserIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(defWindowsUserIndicator)) {
                    this.defWindowsUser = line.substring(defWindowsUserIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(windowsDomainIndicator)) {
                    this.windowsDomain = line.substring(windowsDomainIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(defWindowsUserPasswordIndicator)) {
                    this.defWindowsUserPassword = line.substring(defWindowsUserPasswordIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(agentPortIndicator)) {
                    this.agentPort = line.substring(agentPortIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(udpMsgIndicator)) {
                    this.udpMsg = line.substring(udpMsgIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(udpOrigPortRangeIndicator)) {
                    this.udpOrigPortRange = line.substring(udpOrigPortRangeIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(udpDestPortRangeIndicator)) {
                    this.udpDestPortRange = line.substring(udpDestPortRangeIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(eventServerPortIndicator)) {
                    this.eventServerPort = line.substring(eventServerPortIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(eventServerParamsIndicator)) {
                    this.eventServerParams = line.substring(eventServerParamsIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(defUnixDirIndicator)) {
                    this.defUnixDir = line.substring(defUnixDirIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(defWindowsDirIndicator)) {
                    this.defWindowsDir = line.substring(defWindowsDirIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(caSignatureIndicator)) {
                    this.caSignature = line.substring(caSignatureIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(optionSettingsIndicator)) {
                    this.optionSettings = line.substring(optionSettingsIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(agentRegistrationUrlIndicator)) {
                    this.agentRegistrationUrl = line.substring(agentRegistrationUrlIndicator.length(), line.length());
                    continue;
                }
                if (line.startsWith(unixAdminIndicator)) {
                    admin = line.substring(unixAdminIndicator.length(), line.length());
                    adminValuePair = admin.split("=");
                    this.unixAdmin.add(adminValuePair[1]);
                    continue;
                }
                if (line.startsWith(windowsAdminIndicator)) {
                    admin = line.substring(windowsAdminIndicator.length(), line.length());
                    adminValuePair = admin.split("=");
                    this.windowsAdmin.add(adminValuePair[1]);
                    continue;
                }
                if (line.startsWith(relayIndicator)) {
                    String relay = line.substring(relayIndicator.length(), line.length());
                    String[] relayValuePair = relay.split("=");
                    this.relays.add(relayValuePair[1]);
                    continue;
                }
                if (line.startsWith(tunnelIndicator)) {
                    String tunnel = line.substring(tunnelIndicator.length(), line.length());
                    String[] tunnelValuePair = tunnel.split("=");
                    this.tunnels.add(tunnelValuePair[1]);
                    continue;
                }
                if (line.startsWith(grantIndicator)) {
                    String[] grantValuePair;
                    String grant;
                    if (line.startsWith(windowsGrantIndicator)) {
                        grant = line.substring(windowsGrantIndicator.length(), line.length());
                        grantValuePair = grant.split("=");
                        this.windowsGrants.add(grantValuePair[1]);
                        continue;
                    }
                    if (line.startsWith(unixGrantIndicator)) {
                        grant = line.substring(unixGrantIndicator.length(), line.length());
                        grantValuePair = grant.split("=");
                        this.unixGrants.add(grantValuePair[1]);
                        continue;
                    }
                    grant = line.substring(grantIndicator.length(), line.length());
                    grantValuePair = grant.split("=");
                    this.grants.add(grantValuePair[1]);
                    continue;
                }
                if (line.startsWith(rbiUnixGrantIndicator)) {
                    String unixRbi = line.substring(rbiUnixGrantIndicator.length(), line.length());
                    String[] unixRbiValuePair = unixRbi.split("=");
                    this.rbiUnixGrants.add(unixRbiValuePair[1]);
                    continue;
                }
                if (!line.startsWith(rbiWindowsGrantIndicator)) continue;
                String windowsRbi = line.substring(rbiWindowsGrantIndicator.length(), line.length());
                String[] windowsRbiValuePair = windowsRbi.split("=");
                this.rbiWindowsGrants.add(windowsRbiValuePair[1]);
            }
            this.bConfigLoaded = true;
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
    }

    public void writeDefaultConfiguration() throws Exception {
        try {
            FileInputStream fis = new FileInputStream(this.fullPathToDefaultCfg);
            List<String> ddsCfgLines = IoUtil.readLines(fis, true);
            ArrayList<String> existingDdsCfgLines = new ArrayList<String>();
            for (String line : ddsCfgLines) {
                if ((line = line.trim()).startsWith(rapidBasicInstallIndicator) || line.startsWith(orgIdIndicator) || line.startsWith(orgIdKeylessIndicator) || line.startsWith(unixInstallDirIndicator) || line.startsWith(windowsInstallDirIndicator) || line.startsWith(defUnixUserIndicator) || line.startsWith(defWindowsUserIndicator) || line.startsWith(windowsDomainIndicator) || line.startsWith(defWindowsUserPasswordIndicator) || line.startsWith(agentPortIndicator) || line.startsWith(udpMsgIndicator) || line.startsWith(udpOrigPortRangeIndicator) || line.startsWith(udpDestPortRangeIndicator) || line.startsWith(eventServerPortIndicator) || line.startsWith(eventServerParamsIndicator) || line.startsWith(defUnixDirIndicator) || line.startsWith(defWindowsDirIndicator) || line.startsWith(caSignatureIndicator) || line.startsWith(optionSettingsIndicator) || line.startsWith(agentRegistrationUrlIndicator) || line.startsWith(unixAdminIndicator) || line.startsWith(windowsAdminIndicator) || line.startsWith(relayIndicator) || line.startsWith(tunnelIndicator) || line.startsWith(grantIndicator) || line.startsWith(rbiUnixGrantIndicator) || line.startsWith(rbiWindowsGrantIndicator)) continue;
                existingDdsCfgLines.add(line);
            }
            boolean writtenDefConfig = false;
            FileOutputStream fos = new FileOutputStream(this.fullPathToDefaultCfg);
            for (String existingCnfigurationString : existingDdsCfgLines) {
                if (!writtenDefConfig && existingCnfigurationString.equalsIgnoreCase("-----BEGIN DDSPKG.INF-----")) {
                    fos.write(this.getRapidBasicInstallForFile().getBytes());
                    fos.write(this.getOrgIdForFile().getBytes());
                    fos.write(this.getOrgIdKeylessForFile().getBytes());
                    fos.write(this.getUnixInstallDirForFile().getBytes());
                    fos.write(this.getWindowsInstallDirForFile().getBytes());
                    fos.write(this.getDefUnixUserForFile().getBytes());
                    fos.write(this.getDefWindowsUserForFile().getBytes());
                    fos.write(this.getWindowsDomainForFile().getBytes());
                    fos.write(this.getDefWindowsUserPasswordForFile().getBytes());
                    fos.write(this.getAgentPortForFile().getBytes());
                    fos.write(this.getUdpMsgForFile().getBytes());
                    fos.write(this.getUdpOrigPortRangeForFile().getBytes());
                    fos.write(this.getUdpDestPortRangeForFile().getBytes());
                    fos.write(this.getEventServerPortForFile().getBytes());
                    fos.write(this.getEventServerParamsForFile().getBytes());
                    fos.write(this.getDefUnixDirForFile().getBytes());
                    fos.write(this.getDefWindowsDirForFile().getBytes());
                    fos.write(this.getCaSignatureForFile().getBytes());
                    fos.write(this.getOptionSettingsForFile().getBytes());
                    fos.write(this.getAgentRegistrationUrlForFile().getBytes());
                    fos.write(this.getUnixAdminForFile().getBytes());
                    fos.write(this.getWindowsAdminForFile().getBytes());
                    fos.write(this.getRelaysForFile().getBytes());
                    fos.write(this.getTunnelsForFile().getBytes());
                    fos.write(this.getGrantsForFile().getBytes());
                    fos.write(this.getWindowsGrantsForFile().getBytes());
                    fos.write(this.getUnixGrantsForFile().getBytes());
                    fos.write(this.getRbiUnixGrantsForFile().getBytes());
                    fos.write(this.getRbiWindowsGrantsForFile().getBytes());
                    writtenDefConfig = true;
                }
                existingCnfigurationString = existingCnfigurationString + "\n";
                fos.write(existingCnfigurationString.getBytes());
            }
            fos.flush();
            fos.close();
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException(exceptionMessage);
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
    }

    public boolean isBConfigLoaded() {
        return this.bConfigLoaded;
    }

    public void setBConfigLoaded(boolean configLoaded) {
        this.bConfigLoaded = configLoaded;
    }
}

