/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.util;

import com.signiant.mobilize.ddsclient.core.exception.DdsClientException;
import com.signiant.mobilize.ddsclient.util.IoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DdsConfigLoader {
    private String binDir;
    private int pcPort;
    private String logDir;
    private String securityDir;
    private boolean bConfigLoaded = false;
    private String fullPathToDdsCfg = System.getProperty("CFGFILEPATH");
    private static DdsConfigLoader instance = new DdsConfigLoader();
    private static List<String> ddsCfgLines = null;
    private static long lastUpdateCfgTimestamp = 0L;

    private DdsConfigLoader() {
        if (this.fullPathToDdsCfg != null && this.fullPathToDdsCfg.trim().equals("")) {
            this.fullPathToDdsCfg = "/etc/dds.cfg";
        }
    }

    public static DdsConfigLoader instance() {
        return instance;
    }

    public void setFullPathToDdsCfg(String ddsCfgFullPath) {
        this.fullPathToDdsCfg = ddsCfgFullPath;
    }

    public String getFullPathToDdsCfg() {
        return this.fullPathToDdsCfg;
    }

    public String getDDSBinDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDDSConf();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.binDir;
    }

    public String getSecurityDir() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDDSConf();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.securityDir;
    }

    public int getPcPort() throws DdsClientException {
        try {
            if (!this.bConfigLoaded) {
                this.loadDDSConf();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.pcPort;
    }

    public String getPathToDdsCfg() {
        return this.fullPathToDdsCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<String> loadDdsCfg() throws Exception {
        if (this.fullPathToDdsCfg == null) {
            this.fullPathToDdsCfg = System.getProperty("CFGFILEPATH");
            if (this.fullPathToDdsCfg != null && this.fullPathToDdsCfg.trim().equals("")) {
                this.fullPathToDdsCfg = "/etc/dds.cfg";
            }
        }
        FileInputStream fis = null;
        File file = null;
        try {
            file = new File(this.fullPathToDdsCfg);
            long fileModifyedAt = file.lastModified();
            if (ddsCfgLines == null || lastUpdateCfgTimestamp < fileModifyedAt) {
                fis = new FileInputStream(file);
                ddsCfgLines = IoUtil.readLines(fis, true);
                lastUpdateCfgTimestamp = fileModifyedAt;
            }
            Object var6_4 = null;
            if (fis == null) return ddsCfgLines;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fis == null) throw throwable;
            fis.close();
            fis = null;
            throw throwable;
        }
        fis.close();
        return ddsCfgLines;
    }

    public void loadDDSConf() throws Exception {
        if (this.bConfigLoaded) {
            return;
        }
        List<String> ddsCfgLines = this.loadDdsCfg();
        String signiantIniIndicator = "Applications configuration file is";
        String pcPortIndicator = "Process control port is";
        String logDirIndicator = "Log directory is";
        String securityDirIndicator = "Security directory is";
        String installDirIndicator = "Install directory is";
        String iniFile = null;
        for (String line : ddsCfgLines) {
            if ((line = line.trim()).startsWith(signiantIniIndicator)) {
                iniFile = line.substring(signiantIniIndicator.length(), line.length());
                iniFile = iniFile.replaceAll("\"", "").trim();
                continue;
            }
            if (line.startsWith(installDirIndicator)) {
                this.binDir = line.substring(installDirIndicator.length(), line.length());
                this.binDir = this.binDir.replaceAll("\"", "").trim();
                continue;
            }
            if (line.startsWith(pcPortIndicator)) {
                String strPcPort = line.substring(pcPortIndicator.length(), line.length());
                strPcPort = strPcPort.replaceAll("\"", "").trim();
                this.pcPort = Integer.parseInt(strPcPort);
                continue;
            }
            if (line.startsWith(logDirIndicator)) {
                this.logDir = line.substring(logDirIndicator.length(), line.length());
                this.logDir = this.logDir.replaceAll("\"", "").trim();
                continue;
            }
            if (!line.startsWith(securityDirIndicator)) continue;
            this.securityDir = line.substring(securityDirIndicator.length(), line.length());
            this.securityDir = this.securityDir.replaceAll("\"", "").trim();
        }
        this.bConfigLoaded = true;
    }
}

