/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.util;

import com.signiant.mobilize.ddsclient.core.exception.DdsClientException;
import com.signiant.mobilize.ddsclient.util.IoUtil;
import com.signiant.mobilize.ddsclient.util.OsUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigLoader {
    private Map<String, String> signiantIni = new HashMap<String, String>();
    private int pcPort;
    private String logDir;
    private String securityDir;
    private String ddsCertxDir;
    private String opensslDir;
    private boolean bSigniantIniLoaded;
    private String fullPathToDdsCfg;
    private Object mutex = new Object();
    protected static ConfigLoader instance = new ConfigLoader();

    protected ConfigLoader() {
        this.fullPathToDdsCfg = System.getProperty("CFGFILEPATH");
        if (this.fullPathToDdsCfg != null && this.fullPathToDdsCfg.trim().equals("")) {
            this.fullPathToDdsCfg = "/etc/dds.cfg";
        }
    }

    public static ConfigLoader instance() {
        return instance;
    }

    public void setFullPathToDdsCfg(String ddsCfgFullPath) {
        this.fullPathToDdsCfg = ddsCfgFullPath;
    }

    public String getFullPathToDdsCfg() {
        return this.fullPathToDdsCfg;
    }

    public String getDDSBinDir() throws DdsClientException {
        try {
            if (!this.bSigniantIniLoaded) {
                this.loadSigniantIni();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.signiantIni.get("DDS_BIN");
    }

    public String getSecurityDir() throws DdsClientException {
        try {
            if (!this.bSigniantIniLoaded) {
                this.loadSigniantIni();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.securityDir;
    }

    public String getTempDir() throws DdsClientException {
        try {
            if (!this.bSigniantIniLoaded) {
                this.loadSigniantIni();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.signiantIni.get("TEMPDIR");
    }

    public String getDdsCertxDir() throws DdsClientException {
        if (this.ddsCertxDir == null) {
            String ddsBinDir = this.getDDSBinDir();
            String threePartyDir = ddsBinDir.substring(0, ddsBinDir.length() - (File.separator + "bin").length()) + File.separator + "3rdparty";
            this.ddsCertxDir = threePartyDir + File.separator + "jboss" + File.separator + "bin";
        }
        return this.ddsCertxDir;
    }

    public String getOpensslDir() throws DdsClientException {
        if (this.opensslDir == null) {
            this.opensslDir = OsUtil.isWindows() ? this.getDdsCertxDir() : File.separator + "usr" + File.separator + "bin";
        }
        return this.opensslDir;
    }

    public int getPcPort() throws DdsClientException {
        try {
            if (!this.bSigniantIniLoaded) {
                this.loadSigniantIni();
            }
        }
        catch (Exception ex) {
            DdsClientException ddsEx = new DdsClientException("Could not load configuration file.");
            ddsEx.initCause((Throwable)ex);
            throw ddsEx;
        }
        return this.pcPort;
    }

    public String getSigInitProperty(String propName) throws Exception {
        if (!this.bSigniantIniLoaded) {
            this.loadSigniantIni();
        }
        return this.signiantIni.get(propName);
    }

    public String getPathToDdsCfg() {
        return this.fullPathToDdsCfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    List<String> loadDdsCfg() throws Exception {
        if (this.fullPathToDdsCfg == null) {
            this.fullPathToDdsCfg = System.getProperty("CFGFILEPATH");
            if (this.fullPathToDdsCfg != null && this.fullPathToDdsCfg.trim().equals("")) {
                this.fullPathToDdsCfg = "/etc/dds.cfg";
            }
        }
        FileInputStream fis = null;
        List<String> ddsCfgLines = null;
        try {
            fis = new FileInputStream(this.fullPathToDdsCfg);
            ddsCfgLines = IoUtil.readLines(fis, true);
            Object var4_3 = null;
            if (fis == null) return ddsCfgLines;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fis == null) throw throwable;
            fis.close();
            fis = null;
            throw throwable;
        }
        fis.close();
        return ddsCfgLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSigniantIni() throws Exception {
        if (this.bSigniantIniLoaded) {
            return;
        }
        Object object = this.mutex;
        synchronized (object) {
            List<String> ddsCfgLines = this.loadDdsCfg();
            String iniFile = null;
            for (String line : ddsCfgLines) {
                String signiantIniIndicator = "Applications configuration file is";
                String pcPortIndicator = "Process control port is";
                String logDirIndicator = "Log directory is";
                String securityDirIndicator = "Security directory is";
                if ((line = line.trim()).startsWith(signiantIniIndicator)) {
                    iniFile = line.substring(signiantIniIndicator.length(), line.length());
                    iniFile = iniFile.replaceAll("\"", "").trim();
                } else if (line.startsWith(pcPortIndicator)) {
                    String strPcPort = line.substring(pcPortIndicator.length(), line.length());
                    strPcPort = strPcPort.replaceAll("\"", "").trim();
                    this.pcPort = Integer.parseInt(strPcPort);
                } else if (line.startsWith(logDirIndicator)) {
                    this.logDir = line.substring(logDirIndicator.length(), line.length());
                    this.logDir = this.logDir.replaceAll("\"", "").trim();
                } else if (line.startsWith(securityDirIndicator)) {
                    this.securityDir = line.substring(securityDirIndicator.length(), line.length());
                    this.securityDir = this.securityDir.replaceAll("\"", "").trim();
                }
                if (iniFile == null || this.pcPort == 0 || this.logDir == null) continue;
                break;
            }
            if (iniFile.trim().equals("")) {
                iniFile = "/usr/signiant/dds/web/signiant.ini";
            }
            List<String> iniLines = IoUtil.readLines(new FileInputStream(iniFile), true);
            for (String line : iniLines) {
                if (line.startsWith("#")) continue;
                int index = line.indexOf("=");
                if (index != -1) {
                    String key = line.substring(0, index).trim();
                    String value = line.substring(index + 1, line.length()).trim();
                    this.signiantIni.put(key, value);
                    continue;
                }
                if (line.trim().length() == 0) continue;
                this.signiantIni.put(line, "");
            }
        }
        this.bSigniantIniLoaded = true;
    }
}

