/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.util;

import com.signiant.mobilize.ddsclient.util.DCLogger;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;

public class CertProcessor {
    private String strCert;
    private X509Certificate cert;

    public CertProcessor(String strCert) {
        this.strCert = strCert;
    }

    public CertProcessor(X509Certificate cert) {
        this.cert = cert;
    }

    public X509Certificate getCertificate() throws Exception {
        if (this.cert == null) {
            this.cert = this.convertCertificate(this.strCert);
        }
        return this.cert;
    }

    public String getIssuerDN() throws Exception {
        if (this.cert == null) {
            this.cert = this.convertCertificate(this.strCert);
        }
        return this.cert.getIssuerDN().toString();
    }

    public String getSubjectDN() throws Exception {
        if (this.cert == null) {
            this.cert = this.convertCertificate(this.strCert);
        }
        return this.cert.getSubjectDN().getName();
    }

    public String getDN() throws Exception {
        return this.getSubjectDN();
    }

    public String getSHA1FingerPrint() throws Exception {
        if (this.cert == null) {
            this.cert = this.convertCertificate(this.strCert);
        }
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(this.cert.getEncoded());
        byte[] digest = md.digest();
        String strFP = this.getHexString(digest);
        return strFP;
    }

    public boolean isValid() {
        boolean bValid = true;
        try {
            if (this.cert == null) {
                this.cert = this.convertCertificate(this.strCert);
            }
        }
        catch (CertificateException ex) {
            bValid = false;
            DCLogger.warning(this.getClass(), "the certificate is not valid: cannot create the X509Certificate instance", ex);
        }
        bValid = CertProcessor.isValid(this.cert);
        return bValid;
    }

    public static boolean isValid(X509Certificate aCert) {
        boolean bValid = true;
        try {
            aCert.checkValidity();
        }
        catch (CertificateExpiredException expiredEx) {
            bValid = false;
            DCLogger.warning(CertProcessor.class, "the certificate is expired.", expiredEx);
        }
        catch (CertificateNotYetValidException validdEx) {
            bValid = false;
            DCLogger.warning(CertProcessor.class.getClass(), "the certificate not yet valid.", validdEx);
        }
        return bValid;
    }

    private X509Certificate convertCertificate(String strCert) throws CertificateException {
        byte[] bytes = strCert.getBytes();
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
        return cert;
    }

    private String getHexString(byte[] in) {
        String[] hexchars = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            int v = in[i] & 0xFF;
            out.append(hexchars[v >> 4]);
            out.append(hexchars[v & 0xF]);
        }
        String rslt = new String(out);
        return rslt;
    }
}

