/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.core.security.validatorimpl;

import com.signiant.mobilize.ddsclient.core.security.validator.CertificateInvalidException;
import com.signiant.mobilize.ddsclient.core.security.validator.InvalidPeerException;
import com.signiant.mobilize.ddsclient.core.security.validator.SSLSessionValidator;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDSClientSSLSessionVerification
implements SSLSessionValidator {
    protected boolean bWildCardSupport = true;

    @Override
    public void supportWildCardNames(boolean bSet) {
        this.bWildCardSupport = bSet;
    }

    @Override
    public void validPeer(String peerHost, SSLSession session) throws InvalidPeerException, Exception {
        boolean bValid = false;
        X509Certificate peerCert = this.getPeerCertificate(session);
        String certHostName = this.extractHostName(peerCert.getSubjectX500Principal());
        List<String> altNames = this.extractAltNames(peerCert);
        if (altNames.size() > 0) {
            bValid = this.peerMatchAltNames(peerHost, altNames, this.bWildCardSupport);
        }
        if (!bValid && peerHost.equalsIgnoreCase(certHostName)) {
            bValid = true;
        }
        if (!bValid) {
            throw new InvalidPeerException(peerHost);
        }
    }

    @Override
    public void validPeerCertificate(SSLSession session) throws CertificateInvalidException {
        try {
            X509Certificate peerCert = this.getPeerCertificate(session);
            peerCert.checkValidity();
        }
        catch (Exception exception) {
            throw new CertificateInvalidException(exception);
        }
    }

    protected boolean peerMatchAltNames(String peerHost, List<String> altNames, boolean bWildCardSupport) {
        boolean bMatch = false;
        String[] peerComps = peerHost.split("\\.", 2);
        String peerHead = peerComps[0];
        String peerTail = null;
        if (peerComps.length > 1) {
            peerTail = peerComps[1];
        }
        Iterator<String> iter = altNames.iterator();
        while (iter.hasNext() && !bMatch) {
            if (bWildCardSupport) {
                String altHeadExplicit;
                String altName = iter.next();
                String[] altComps = altName.split("\\.", 2);
                String altHead = altComps[0];
                String altTail = null;
                if (altComps.length > 1) {
                    altTail = altComps[1];
                    if (!altTail.equalsIgnoreCase(peerTail)) continue;
                    if (altHead.equals("*") || altHead.equals("\\*") || altHead.equalsIgnoreCase(peerHead)) {
                        bMatch = true;
                        break;
                    }
                    if (!Pattern.matches("[^\\*]\\*", altHead)) continue;
                    altHeadExplicit = altHead.substring(0, altHead.length() - 1);
                    if (!peerHead.toLowerCase().startsWith(altHeadExplicit.toLowerCase())) continue;
                    bMatch = true;
                    break;
                }
                if (Pattern.matches("[^\\*]\\*", altHead)) {
                    altHeadExplicit = altHead.substring(0, altHead.length() - 1);
                    if (!peerHead.toLowerCase().startsWith(altHeadExplicit.toLowerCase())) continue;
                    bMatch = true;
                    break;
                }
                bMatch = peerHost.equalsIgnoreCase(altName);
                continue;
            }
            bMatch = peerHost.equalsIgnoreCase(iter.next());
        }
        return bMatch;
    }

    protected List<String> extractAltNames(X509Certificate peerCert) throws CertificateParsingException {
        ArrayList<String> altNames = new ArrayList<String>();
        Collection<List<?>> names = peerCert.getSubjectAlternativeNames();
        if (names != null) {
            for (List<?> asn1 : names) {
                Integer type;
                int nSize = asn1.size();
                if (nSize != 2 || (type = (Integer)asn1.get(0)) != 2) continue;
                altNames.add((String)asn1.get(1));
            }
        }
        return altNames;
    }

    protected X509Certificate getPeerCertificate(SSLSession session) throws Exception {
        return (X509Certificate)session.getPeerCertificates()[0];
    }

    protected String extractHostName(X500Principal x500Principal) {
        return this.parseHostNameCanonical(x500Principal.getName("CANONICAL"));
    }

    protected String parseHostNameCanonical(String dnName) {
        String hostName = "";
        int nIndex = dnName.indexOf("cn=");
        if (nIndex > -1) {
            int nLength = dnName.length();
            int nEnd = dnName.indexOf(",", nIndex);
            if (nEnd > -1) {
                nLength = nEnd;
            }
            hostName = dnName.substring(nIndex + 3, nLength);
        }
        return hostName;
    }
}

