/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp.packets;

import com.signiant.mobilize.ddsclient.connection.udp.packets.DatagramBuffer;
import java.net.InetSocketAddress;

public class TransportConnect {
    public static int HOSTNAME_SZ = 128;
    public static int SIZE = HOSTNAME_SZ * 2 + 24;

    public static byte type(DatagramBuffer dgb) {
        return dgb.buffer.get(0);
    }

    public static void type(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(0, value);
    }

    public static byte protocol_version(DatagramBuffer dgb) {
        return dgb.buffer.get(1);
    }

    public static void protocol_version(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(1, value);
    }

    public static short max_payload(DatagramBuffer dgb) {
        return dgb.buffer.getShort(2);
    }

    public static void max_payload(DatagramBuffer dgb, short value) {
        dgb.buffer.putShort(2, value);
    }

    public static int initial_sequence(DatagramBuffer dgb) {
        return dgb.buffer.getInt(4);
    }

    public static void initial_sequence(DatagramBuffer dgb, int value) {
        dgb.buffer.putInt(4, value);
    }

    public static int flow_window_size(DatagramBuffer dgb) {
        return dgb.buffer.getInt(8);
    }

    public static void flow_window_size(DatagramBuffer dgb, int value) {
        dgb.buffer.putInt(8, value);
    }

    public static int bandwidth(DatagramBuffer dgb) {
        return dgb.buffer.getInt(12);
    }

    public static void bandwidth(DatagramBuffer dgb, int value) {
        dgb.buffer.putInt(12, value);
    }

    public static int seq_number(DatagramBuffer dgb) {
        return dgb.getUnsignedShort(16);
    }

    public static void seq_number(DatagramBuffer dgb, int value) {
        dgb.putUnsignedShort(16, value);
    }

    public static int flags(DatagramBuffer dgb) {
        return dgb.getUnsignedShort(18);
    }

    public static void flags(DatagramBuffer dgb, int value) {
        dgb.putUnsignedShort(18, value);
    }

    public static int src_port(DatagramBuffer dgb) {
        return dgb.getUnsignedShort(20);
    }

    public static void src_port(DatagramBuffer dgb, int value) {
        dgb.putUnsignedShort(20, value);
    }

    public static int tgt_port(DatagramBuffer dgb) {
        return dgb.getUnsignedShort(22);
    }

    public static void tgt_port(DatagramBuffer dgb, int value) {
        dgb.putUnsignedShort(22, value);
    }

    public static String src_host_name(DatagramBuffer dgb) {
        return dgb.getNullTerminatedString(24);
    }

    public static void src_host_name(DatagramBuffer dgb, String value) {
        dgb.putString(24, HOSTNAME_SZ, value);
    }

    public static String tgt_host_name(DatagramBuffer dgb) {
        return dgb.getNullTerminatedString(24 + HOSTNAME_SZ);
    }

    public static void tgt_host_name(DatagramBuffer dgb, String value) {
        dgb.putString(24 + HOSTNAME_SZ, HOSTNAME_SZ, value);
    }

    public static InetSocketAddress src(DatagramBuffer dgb) {
        return new InetSocketAddress(TransportConnect.src_host_name(dgb), TransportConnect.src_port(dgb));
    }

    public static void src(DatagramBuffer dgb, InetSocketAddress address) {
        TransportConnect.src_host_name(dgb, address.getHostName());
        TransportConnect.src_port(dgb, address.getPort());
    }

    public static InetSocketAddress tgt(DatagramBuffer dgb) {
        return new InetSocketAddress(TransportConnect.tgt_host_name(dgb), TransportConnect.tgt_port(dgb));
    }

    public static void tgt(DatagramBuffer dgb, InetSocketAddress address) {
        TransportConnect.tgt_host_name(dgb, address.getHostName());
        TransportConnect.tgt_port(dgb, address.getPort());
    }
}

