/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp.packets;

import com.signiant.interactivetransfer.engine.udp.exceptions.InvalidPacketException;
import com.signiant.interactivetransfer.engine.udp.exceptions.PacketResentCountExceededException;
import com.signiant.interactivetransfer.engine.udp.exceptions.WouldBlockException;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.udp.MicrosecondTimer;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import com.signiant.mobilize.ddsclient.connection.udp.packets.ConnectionPacket;
import com.signiant.mobilize.ddsclient.connection.udp.packets.PacketType;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.Arrays;

public class DatagramBuffer {
    static int nextBufferId = 0;
    int bufferId;
    ByteBuffer buffer;
    Callback callback;
    long sentReadAtTime;
    public String owner;
    int timeToLive;
    boolean acked;

    public DatagramBuffer(UdpSession session) {
        this.buffer = ByteBuffer.allocateDirect(1480 + 8);
        this.callback = null;
        this.bufferId = nextBufferId++;
    }

    public DatagramBuffer(UdpSession session, TransportType t) {
        int sz = t.minimumSize();
        if (t == TransportType.NAK || t == TransportType.PMTU) {
            sz = 1480 + 8;
        }
        this.buffer = ByteBuffer.allocateDirect(sz);
        this.buffer.put(0, (byte)t.code());
        this.buffer.position(sz);
        this.callback = null;
        this.bufferId = nextBufferId++;
    }

    public void release() {
        this.buffer = null;
    }

    public int getCurrentPayloadSize() {
        return this.buffer.capacity();
    }

    public void reset() {
        this.buffer.clear();
        if (this.callback != null) {
            this.callback.trigger();
            this.callback = null;
        }
        this.timeToLive = 0;
        this.acked = false;
    }

    public void rewind() {
        this.timeToLive = 0;
        this.buffer.rewind();
    }

    public boolean isAcked() {
        return this.acked;
    }

    public void doAck(boolean acked) {
        this.acked = acked;
    }

    public int length() {
        return this.buffer.limit();
    }

    public boolean isEmpty() {
        return this.buffer.limit() == 0;
    }

    public int read(DatagramChannel channel) throws IOException {
        this.buffer.clear();
        int result = channel.read(this.buffer);
        if (result > 0) {
            this.sentReadAtTime = MicrosecondTimer.getInstance().get();
            this.buffer.flip();
            this.checkPacket();
        }
        return result;
    }

    public int write(DatagramChannel channel) throws IOException {
        int result;
        block7: {
            if (this.timeToLive > 500) {
                throw new PacketResentCountExceededException();
            }
            if (this.buffer.position() > 0) {
                this.buffer.flip();
            }
            result = 0;
            try {
                result = channel.write(this.buffer);
                if (result == 0 && !this.isTransportPacket()) {
                    throw new WouldBlockException();
                }
            }
            catch (IOException e) {
                if (e.getMessage() == null || !e.getMessage().equals("No buffer space available")) {
                    throw e;
                }
                if (this.isTransportPacket()) break block7;
                throw new WouldBlockException();
            }
        }
        if (result > 0) {
            this.sentReadAtTime = MicrosecondTimer.getInstance().get();
            ++this.timeToLive;
        }
        return result;
    }

    public boolean isTransportPacket() {
        return this.buffer.get(0) < 0;
    }

    public boolean isConnectionPacket() {
        return this.buffer.get(0) >= 0;
    }

    public TransportType transportType() throws InvalidPacketException {
        this.buffer.position(0);
        short code = (short)(this.buffer.get() & 0xFF);
        return TransportType.code(code);
    }

    public PacketType packetType() {
        if (!this.isConnectionPacket()) {
            return null;
        }
        return PacketType.code(ConnectionPacket.type(this));
    }

    int getUnsignedShort(int position) {
        return this.buffer.getShort(position) & 0xFFFF;
    }

    void putUnsignedShort(int position, int value) {
        this.buffer.putShort(position, (short)value);
    }

    String getString(int start, int length) {
        byte[] holding = new byte[length];
        this.buffer.position(start);
        this.buffer.get(holding);
        return new String(holding);
    }

    String getNullTerminatedString(int start) {
        this.buffer.position(start);
        int remLen = this.buffer.remaining();
        byte[] holding = new byte[remLen];
        this.buffer.get(holding);
        int i = 0;
        while (i < holding.length && holding[i] != 0) {
            ++i;
            --remLen;
        }
        return new String(holding, 0, holding.length - remLen);
    }

    void putString(int start, int length, String value) {
        byte[] str;
        int valueLength = value.length();
        if (valueLength > length) {
            valueLength = length;
        }
        try {
            str = value.substring(0, valueLength).getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        this.buffer.position(start);
        this.buffer.put(str);
        if (value.length() < length) {
            byte[] filler = new byte[length - value.length()];
            Arrays.fill(filler, 0, filler.length, (byte)0);
            this.buffer.put(filler);
        }
    }

    private void checkPacket() throws IOException {
        if (this.isConnectionPacket()) {
            if (this.buffer.limit() < 8) {
                throw new InvalidPacketException("Buffer limit < 8");
            }
            if (PacketType.code(ConnectionPacket.type(this)) == null) {
                throw new InvalidPacketException("Unknown packet type: " + ConnectionPacket.type(this));
            }
            return;
        }
        short b = (short)(this.buffer.get(0) & 0xFF);
        TransportType type = TransportType.code(b);
        if (type == null) {
            throw new InvalidPacketException("Unknown transport type: " + b);
        }
        if (this.buffer.limit() < type.minimumSize()) {
            throw new InvalidPacketException("Limit " + this.buffer.limit() + " < " + type.minimumSize());
        }
    }

    public void setAcknowledgement(int sendNumber, int totalBytes, AcknowledgeFeedback feedback) {
        this.callback = new Callback(sendNumber, totalBytes, feedback);
    }

    public void trigger() {
        if (this.callback != null) {
            this.callback.trigger();
        }
    }

    public long getReadAtTime() {
        return this.sentReadAtTime;
    }

    public int getBufferId() {
        return this.bufferId;
    }

    private static class Callback {
        private final int id;
        private final int amount;
        private final AcknowledgeFeedback callback;

        public Callback(int sendNumber, int totalBytes, AcknowledgeFeedback feedback) {
            this.id = sendNumber;
            this.amount = totalBytes;
            this.callback = feedback;
        }

        public void trigger() {
            this.callback.acknowledged(this.id, this.amount);
        }
    }
}

