/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp.packets;

import com.signiant.mobilize.ddsclient.connection.udp.packets.DatagramBuffer;
import java.nio.ByteBuffer;

public class ConnectionPacket {
    public static final byte CPKT_INITIAL_MEASUREMENT_START = 1;
    public static final byte CPKT_INITIAL_MEASUREMENT_STOP = 2;
    public static final byte CPKT_INITIAL_MEASUREMENT_PKT = 4;
    public static final int HEADER_LEN = 8;

    public static int sequence(DatagramBuffer dgb) {
        return dgb.buffer.getInt(0);
    }

    public static void sequence(DatagramBuffer dgb, int value) {
        dgb.buffer.putInt(0, value);
    }

    public static byte type(DatagramBuffer dgb) {
        return dgb.buffer.get(4);
    }

    public static void type(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(4, value);
    }

    public static byte flags(DatagramBuffer dgb) {
        return dgb.buffer.get(5);
    }

    public static void flags(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(5, value);
    }

    public static byte src_id(DatagramBuffer dgb) {
        return dgb.buffer.get(6);
    }

    public static void src_id(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(6, value);
    }

    public static byte tgt_id(DatagramBuffer dgb) {
        return dgb.buffer.get(7);
    }

    public static void tgt_id(DatagramBuffer dgb, byte value) {
        dgb.buffer.put(7, value);
    }

    public static int payloadLength(DatagramBuffer dgb) {
        if (dgb.buffer.position() > 0) {
            return dgb.buffer.limit() - dgb.buffer.position();
        }
        return dgb.buffer.limit() - 8;
    }

    public static void setPayload(DatagramBuffer dgb) {
        dgb.buffer.position(8);
    }

    public static void setPayload(DatagramBuffer dgb, ByteBuffer src, int len) {
        dgb.buffer.position(8);
        dgb.buffer.put(src.array(), src.position(), len);
        src.position(src.position() + len);
    }

    public static void getPayload(DatagramBuffer dgb, ByteBuffer dest, int len) {
        if (dgb.buffer.position() == 0) {
            dgb.buffer.position(8);
        }
        dgb.buffer.get(dest.array(), dest.position(), len);
        dest.position(dest.position() + len);
    }
}

