/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp;

import com.signiant.mobilize.ddsclient.connection.udp.MicrosecondTimer;
import com.signiant.mobilize.ddsclient.connection.udp.packets.PacketType;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportType;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class UdpTrace {
    static final int TRACE_API = 1;
    static final int TRACE_TIMERS = 2;
    static final int TRACE_TRANSPORT_PKTS = 4;
    static final int TRACE_CPKTS = 8;
    static final int TRACE_RATE_CONTROL = 16;
    static final int TRACE_LOCKING = 32;
    static final int TRACE_STATE = 64;
    static final int TRACE_PROFILING = 128;
    static final int TRACE_DG_BUFFERS = 256;
    static final int TRACE_RECV_EVENTS = 512;
    static final int TRACE_SEND_EVENTS = 1024;
    static final int TRACE_THREADS = 2048;
    static final int TRACE_QUEUE_LIMITS = 4096;
    static final int TRACE_ERRORS = 8192;
    static final int TRACE_CNCT_BLOCKS = 16384;
    static final int TRACE_STATISTICS = 32768;
    static final int TRACE_ALL = -1;
    static final int TRACE_NONE = 0;
    public static final int MIN_TRACE_BUFFER_SIZE = 100;
    public static final int MAX_TRACE_BUFFER_SIZE = 10000000;
    int trc_mask;
    int[] trc_classTable;
    int trc_bufferIdx;
    int trc_bufferSize;
    int trc_entryCount;
    MicrosecondTimer trc_usTimer;
    long trc_startSystemTime;
    long trc_startUsTime;
    TraceRecord[] trc_buffer;

    UdpTrace(int traceMask, int traceBufferSize) {
        this.setTraceMask(traceMask);
        this.trc_bufferSize = 0;
        this.trc_bufferIdx = 0;
        this.trc_entryCount = 0;
        this.resizeTraceBuffer(traceBufferSize);
        this.initTypeClassMappingTable();
        this.trc_usTimer = MicrosecondTimer.getInstance();
        this.trc_startSystemTime = System.currentTimeMillis() * 1000L;
        this.trc_startUsTime = this.trc_usTimer.get();
    }

    void setTraceMask(int traceMask) {
        this.trc_mask = traceMask;
    }

    void resizeTraceBuffer(int newBufferSize) {
        int endCount;
        if (newBufferSize < 100) {
            newBufferSize = 100;
        } else if (newBufferSize > 10000000) {
            newBufferSize = 10000000;
        }
        if (newBufferSize == this.trc_bufferSize) {
            return;
        }
        TraceRecord[] newTraceBuffer = new TraceRecord[newBufferSize];
        int minBuffSize = Math.min(this.trc_bufferSize, newBufferSize);
        if (this.trc_entryCount <= minBuffSize) {
            if (this.trc_entryCount > 0) {
                System.arraycopy(this.trc_buffer, 0, newTraceBuffer, 0, this.trc_entryCount);
            }
        } else if (newBufferSize > this.trc_bufferSize) {
            endCount = this.trc_bufferSize - this.trc_bufferIdx;
            System.arraycopy(this.trc_buffer, this.trc_bufferIdx, newTraceBuffer, 0, endCount);
            System.arraycopy(this.trc_buffer, 0, newTraceBuffer, endCount, this.trc_bufferIdx);
            this.trc_entryCount = this.trc_bufferSize;
        } else {
            endCount = newBufferSize - this.trc_bufferIdx;
            if (endCount <= 0) {
                System.arraycopy(this.trc_buffer, this.trc_bufferIdx - newBufferSize, newTraceBuffer, 0, newBufferSize);
            } else {
                System.arraycopy(this.trc_buffer, this.trc_bufferSize - endCount, newTraceBuffer, 0, endCount);
                System.arraycopy(this.trc_buffer, 0, newTraceBuffer, endCount, newBufferSize - endCount);
            }
            this.trc_entryCount = newBufferSize;
        }
        for (int i = this.trc_bufferSize; i < newBufferSize; ++i) {
            newTraceBuffer[i] = new TraceRecord();
        }
        this.trc_buffer = newTraceBuffer;
        this.trc_bufferSize = newBufferSize;
        this.trc_bufferIdx = this.trc_entryCount % this.trc_bufferSize;
    }

    private void initTypeClassMappingTable() {
        TRACE_RECORD_TYPES[] types = TRACE_RECORD_TYPES.values();
        this.trc_classTable = new int[types.length];
        block84: for (TRACE_RECORD_TYPES type : types) {
            switch (type) {
                case TRACE_INITIALIZED: {
                    this.trc_classTable[type.ordinal()] = -1;
                    continue block84;
                }
                case ACK_TIMER_SET: {
                    this.trc_classTable[type.ordinal()] = 2;
                    continue block84;
                }
                case NEW_WINDOW_SIZE: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case UDP_SOCKET_BUFFER_SIZE: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case SEND_RATE_CAPTURE: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case DGB_ALLOCATED: {
                    this.trc_classTable[type.ordinal()] = 256;
                    continue block84;
                }
                case DGB_ALLOCATION_FAILURE: {
                    this.trc_classTable[type.ordinal()] = 8448;
                    continue block84;
                }
                case DGB_RELEASED: {
                    this.trc_classTable[type.ordinal()] = 256;
                    continue block84;
                }
                case DGB_ENQUEUED_SEND: {
                    this.trc_classTable[type.ordinal()] = 256;
                    continue block84;
                }
                case DGB_PKT_RECEIVED: {
                    this.trc_classTable[type.ordinal()] = 256;
                    continue block84;
                }
                case DGB_PKT_SENT: {
                    this.trc_classTable[type.ordinal()] = 256;
                    continue block84;
                }
                case LOCK_WAIT: {
                    this.trc_classTable[type.ordinal()] = 32;
                    continue block84;
                }
                case LOCK_OBTAINED: {
                    this.trc_classTable[type.ordinal()] = 32;
                    continue block84;
                }
                case LOCK_ERROR: {
                    this.trc_classTable[type.ordinal()] = 32;
                    continue block84;
                }
                case LOCK_RELEASED: {
                    this.trc_classTable[type.ordinal()] = 32;
                    continue block84;
                }
                case POSTING_RECV_EVENT: {
                    this.trc_classTable[type.ordinal()] = 512;
                    continue block84;
                }
                case POSTING_SEND_EVENT: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case POSTING_SHUTDOWN_EVENT: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case TRANSPORT_PKT_RECEIVED: {
                    this.trc_classTable[type.ordinal()] = 260;
                    continue block84;
                }
                case TRANSPORT_PKT_SENT: {
                    this.trc_classTable[type.ordinal()] = 260;
                    continue block84;
                }
                case CPKT_RECEIVED: {
                    this.trc_classTable[type.ordinal()] = 264;
                    continue block84;
                }
                case CPKT_RECEIVED_GAP: {
                    this.trc_classTable[type.ordinal()] = 264;
                    continue block84;
                }
                case CPKT_SENT: {
                    this.trc_classTable[type.ordinal()] = 264;
                    continue block84;
                }
                case CPKT_RESENT: {
                    this.trc_classTable[type.ordinal()] = 264;
                    continue block84;
                }
                case CPKT_SEND_NO_BUFFER: {
                    this.trc_classTable[type.ordinal()] = 8200;
                    continue block84;
                }
                case CPKT_DEMUXED: {
                    this.trc_classTable[type.ordinal()] = 264;
                    continue block84;
                }
                case ADDITIONAL_TRANSPORT_PKT_INFO: {
                    this.trc_classTable[type.ordinal()] = 4;
                    continue block84;
                }
                case DISCARDING_RECEIVED_PKT: {
                    this.trc_classTable[type.ordinal()] = 8204;
                    continue block84;
                }
                case DISCARDING_RECEIVED_CPKT: {
                    this.trc_classTable[type.ordinal()] = 8200;
                    continue block84;
                }
                case DISCARDING_RECEIVED_TRANSPORT_PKT: {
                    this.trc_classTable[type.ordinal()] = 8196;
                    continue block84;
                }
                case RECEIVE_WINDOW_FULL: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case THREAD_TERM_WAIT: {
                    this.trc_classTable[type.ordinal()] = 2050;
                    continue block84;
                }
                case THREAD_TERM_WAIT_COMPLETE: {
                    this.trc_classTable[type.ordinal()] = 2;
                    continue block84;
                }
                case NEW_CONNECTION_STATE: {
                    this.trc_classTable[type.ordinal()] = 64;
                    continue block84;
                }
                case NEW_SESSION_STATE: {
                    this.trc_classTable[type.ordinal()] = 64;
                    continue block84;
                }
                case THREAD_START_STOP: {
                    this.trc_classTable[type.ordinal()] = 2050;
                    continue block84;
                }
                case ACCEPT_TIMEOUT: {
                    this.trc_classTable[type.ordinal()] = 2;
                    continue block84;
                }
                case CONNECTION_RESET: {
                    this.trc_classTable[type.ordinal()] = 8192;
                    continue block84;
                }
                case UDP_SOCKET_EMPTY: {
                    this.trc_classTable[type.ordinal()] = 512;
                    continue block84;
                }
                case UDP_SOCKET_FULL: {
                    this.trc_classTable[type.ordinal()] = 1036;
                    continue block84;
                }
                case UDP_SOCKET_WRITE_ERROR: {
                    this.trc_classTable[type.ordinal()] = 9216;
                    continue block84;
                }
                case UDP_SOCKET_READ_ERROR: {
                    this.trc_classTable[type.ordinal()] = 8704;
                    continue block84;
                }
                case SEND_FLOW_WINDOW_FULL: {
                    this.trc_classTable[type.ordinal()] = 32784;
                    continue block84;
                }
                case SEND_QUEUE_EMPTY: {
                    this.trc_classTable[type.ordinal()] = 4104;
                    continue block84;
                }
                case RECV_QUEUE_FULL: {
                    this.trc_classTable[type.ordinal()] = 4104;
                    continue block84;
                }
                case THREAD_PAUSE: {
                    this.trc_classTable[type.ordinal()] = 2050;
                    continue block84;
                }
                case THREAD_RESUME: {
                    this.trc_classTable[type.ordinal()] = 2050;
                    continue block84;
                }
                case RECV_EVENT_WAIT: {
                    this.trc_classTable[type.ordinal()] = 512;
                    continue block84;
                }
                case RECV_EVENT_WAIT_DONE: {
                    this.trc_classTable[type.ordinal()] = 512;
                    continue block84;
                }
                case SEND_EVENT_WAIT: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case SEND_EVENT_WAIT_DONE: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case SHUTDOWN_EVENT_WAIT: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case SHUTDOWN_EVENT_WAIT_DONE: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case API_ENTRY: {
                    this.trc_classTable[type.ordinal()] = 1;
                    continue block84;
                }
                case API_EXIT: {
                    this.trc_classTable[type.ordinal()] = 1;
                    continue block84;
                }
                case SELECT_ERROR: {
                    this.trc_classTable[type.ordinal()] = 8192;
                    continue block84;
                }
                case CONNECTION_ALLOCATED: {
                    this.trc_classTable[type.ordinal()] = 16384;
                    continue block84;
                }
                case CONNECTION_RELEASED: {
                    this.trc_classTable[type.ordinal()] = 16384;
                    continue block84;
                }
                case FAKED_NAK: {
                    this.trc_classTable[type.ordinal()] = 6;
                    continue block84;
                }
                case SELECT_RETURN: {
                    this.trc_classTable[type.ordinal()] = 1;
                    continue block84;
                }
                case SELECT_TIMEOUT_VALUE: {
                    this.trc_classTable[type.ordinal()] = 1;
                    continue block84;
                }
                case SELECT_API_ERROR: {
                    this.trc_classTable[type.ordinal()] = 8193;
                    continue block84;
                }
                case PACKET_RETRANSMISSION_COUNT_EXCEEDED: {
                    this.trc_classTable[type.ordinal()] = -1;
                    continue block84;
                }
                case CHECK_RECEIVE_RATE: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case SEND_PAUSE: {
                    this.trc_classTable[type.ordinal()] = 2;
                    continue block84;
                }
                case SEND_RESUME: {
                    this.trc_classTable[type.ordinal()] = 2;
                    continue block84;
                }
                case UDP_ABORT: {
                    this.trc_classTable[type.ordinal()] = -1;
                    continue block84;
                }
                case RECV_LOOP_EXIT: {
                    this.trc_classTable[type.ordinal()] = 512;
                    continue block84;
                }
                case SEND_LOOP_EXIT: {
                    this.trc_classTable[type.ordinal()] = 1024;
                    continue block84;
                }
                case RATE_PARAMETER_SET: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case STATS_REPORT: {
                    this.trc_classTable[type.ordinal()] = 32768;
                    continue block84;
                }
                case SENDING_RESUMES: {
                    this.trc_classTable[type.ordinal()] = 32784;
                    continue block84;
                }
                case OUT_OF_MEMORY: {
                    this.trc_classTable[type.ordinal()] = 8192;
                    continue block84;
                }
                case PATH_MTU_DETERMINATION: {
                    this.trc_classTable[type.ordinal()] = 20;
                    continue block84;
                }
                case DATAGRAM_BUFFER_PAYLOAD: {
                    this.trc_classTable[type.ordinal()] = 20;
                    continue block84;
                }
                case TICKLE_PROBE: {
                    this.trc_classTable[type.ordinal()] = 32784;
                    continue block84;
                }
                case BUFFER_BLOCK_ALLOCATION: {
                    this.trc_classTable[type.ordinal()] = 32784;
                    continue block84;
                }
                case MEMORY_USAGE: {
                    this.trc_classTable[type.ordinal()] = 32768;
                    continue block84;
                }
                case TIMER_PERFORMANCE: {
                    this.trc_classTable[type.ordinal()] = 32768;
                    continue block84;
                }
                case JAVA_WAIT_METHOD: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case JAVA_BURST_PERFORMANCE: {
                    this.trc_classTable[type.ordinal()] = 16;
                    continue block84;
                }
                case GP_TRACE_ENTRY: {
                    this.trc_classTable[type.ordinal()] = -1;
                }
            }
        }
    }

    private String datagramType(short typeCode) {
        if ((typeCode & 0x80) == 0) {
            PacketType pktType = PacketType.code((byte)typeCode);
            if (pktType == null) {
                return "unknown data packet type " + typeCode;
            }
            return pktType.toString().toLowerCase();
        }
        TransportType pktType = TransportType.code(typeCode);
        if (pktType == null) {
            return "unknown transport packet type " + typeCode;
        }
        return pktType.toString().toLowerCase();
    }

    private String pktDiscardReason(int reasonCode) {
        String strReason;
        PKT_DISCARD_REASONS reason = PKT_DISCARD_REASONS.convert(reasonCode);
        switch (reason) {
            case PKT_DISCARD_INVALID: {
                strReason = "Invalid or malformed packet";
                break;
            }
            case PKT_DISCARD_LISTEN_QUEUE_FULL: {
                strReason = "The listen queue is full";
                break;
            }
            case PKT_DISCARD_NO_AVAILABLE_CONNECTIONS: {
                strReason = "No available connection blocks";
                break;
            }
            case PKT_DISCARD_WRONG_STATE: {
                strReason = "The connection is not in the correct state";
                break;
            }
            case PKT_DISCARD_DUPLICATE: {
                strReason = "The packet is a duplicate";
                break;
            }
            case PKT_DISCARD_LEFT_OF_RECV_WINDOW: {
                strReason = "The packet sequence is left of the receive window";
                break;
            }
            case PKT_DISCARD_RIGHT_OF_RECV_WINDOW: {
                strReason = "The packet sequence is right of the receive window";
                break;
            }
            case PKT_DISCARD_SHORT_HEADER: {
                strReason = "The packet header is incomplete";
                break;
            }
            case PKT_DISCARD_BAD_CONNECTION_TARGET_ID: {
                strReason = "Invalid target connection ID";
                break;
            }
            case PKT_DISCARD_BAD_CONNECTION_SOURCE_ID: {
                strReason = "Invalid source connection ID";
                break;
            }
            case PKT_DISCARD_BAD_PKT_SOURCE_ADDRESS: {
                strReason = "Invalid packet source IP address";
                break;
            }
            case PKT_DISCARD_UNSUPPORTED_VERSION: {
                strReason = "Unsupported protocol version requested";
                break;
            }
            default: {
                strReason = "Reason unknown";
            }
        }
        return strReason;
    }

    private String sessionState(int stateCode) {
        String state;
        SESSION_STATES sesState = SESSION_STATES.convert(stateCode);
        switch (sesState) {
            case IDLE: {
                state = "idle";
                break;
            }
            case ACCEPTING: {
                state = "accepting";
                break;
            }
            case ACCEPT_CMPLT_WAIT: {
                state = "waiting accept complete";
                break;
            }
            case CONNECTING: {
                state = "connecting";
                break;
            }
            case CONNECT_CMPLT_WAIT: {
                state = "waiting connection completion";
                break;
            }
            case PMTU_DETERMINATION_SERVER: {
                state = "determining path MTU (server)";
                break;
            }
            case PMTU_DETERMINATION_CLIENT: {
                state = "determining path MTU (client)";
                break;
            }
            case PMTU_RESULT_WAIT_CLIENT: {
                state = "waiting results of path MTU determination (client)";
                break;
            }
            case CONNECTED: {
                state = "connected";
                break;
            }
            case CLOSE_PENDING: {
                state = "close pending";
                break;
            }
            case CLOSING: {
                state = "closing";
                break;
            }
            case CLOSE_WAIT: {
                state = "close wait";
                break;
            }
            case TERMINATING: {
                state = "terminating";
                break;
            }
            default: {
                state = "unknown";
            }
        }
        return state;
    }

    private String connectionState(int stateCode) {
        String state;
        CONNECTION_STATES conState = CONNECTION_STATES.convert(stateCode);
        switch (conState) {
            case IDLE: {
                state = "idle";
                break;
            }
            case INITIALIZING: {
                state = "initializing";
                break;
            }
            case LISTENING: {
                state = "listening";
                break;
            }
            case CONNECTING: {
                state = "connecting";
                break;
            }
            case CONNECTED: {
                state = "connected";
                break;
            }
            case CLOSING: {
                state = "closing";
                break;
            }
            case CLOSE_WAIT: {
                state = "close wait";
                break;
            }
            case CLOSED: {
                state = "closed";
                break;
            }
            default: {
                state = "unknown";
            }
        }
        return state;
    }

    private String getErrorMsg(int errorCode) {
        return String.format("error code %d", errorCode);
    }

    protected String cvtIntToDotIpAddr(int binAddr) {
        int b0 = (binAddr & 0xFF000000) >> 24 & 0xFF;
        int b1 = (binAddr & 0xFF0000) >> 16;
        int b2 = (binAddr & 0xFF00) >> 8;
        int b3 = binAddr & 0xFF;
        return String.format("%d.%d.%d.%d", b0, b1, b2, b3);
    }

    private String apiName(int apiCode) {
        String apiName;
        API_RTN_CODES apiRtnType = API_RTN_CODES.convert(apiCode);
        switch (apiRtnType) {
            case UDP_SESSION_CONNECT: {
                apiName = "udptrans_session_connect";
                break;
            }
            case UDP_SESSION_ACCEPT: {
                apiName = "udptrans_session_accept";
                break;
            }
            case UDP_SESSION_WAIT_CONNECTED: {
                apiName = "udptrans_session_wait_connected";
                break;
            }
            case UDP_SESSION_DISCONNECT: {
                apiName = "udptrans_session_disconnect";
                break;
            }
            case UDP_CONTROL: {
                apiName = "udptrans_cntrl";
                break;
            }
            case UDP_CREATE: {
                apiName = "udptrans_create";
                break;
            }
            case UDP_ACCEPT: {
                apiName = "udptrans_accept";
                break;
            }
            case UDP_CONNECT: {
                apiName = "udptrans_connect";
                break;
            }
            case UDP_LISTEN: {
                apiName = "udptrans_listen";
                break;
            }
            case UDP_RECEIVE: {
                apiName = "udptrans_recv";
                break;
            }
            case UDP_DUMMY_RECEIVE: {
                apiName = "udptrans_dummy_recv";
                break;
            }
            case UDP_SEND: {
                apiName = "udptrans_send";
                break;
            }
            case UDP_DUMMY_SEND: {
                apiName = "udptrans_dummy_send";
                break;
            }
            case UDP_SELECT: {
                apiName = "udptrans_select";
                break;
            }
            case UDP_SELECT_INTERRUPT: {
                apiName = "udptrans_select_interrupt";
                break;
            }
            case UDP_SHUTDOWN: {
                apiName = "udptrans_shutdown";
                break;
            }
            case UDP_GET_SESSION_STATS: {
                apiName = "udptrans_get_session_stats";
                break;
            }
            case UDP_GET_CONNECTION_STATS: {
                apiName = "udptrans_get_session_stats";
                break;
            }
            case UDP_SET_CONNECTION_MODE: {
                apiName = "udptrans_set_connection_mode";
                break;
            }
            case UDP_GET_CONNECTION_ERROR_STATUS: {
                apiName = "udptrans_get_connection_error_status";
                break;
            }
            case UDP_GET_CONNECTION_PENDING: {
                apiName = "udptrans_get_connection_pending";
                break;
            }
            case UDP_DESTROY: {
                apiName = "udptrans_destroy";
                break;
            }
            case UDP_TERM: {
                apiName = "udptrans_term";
                break;
            }
            default: {
                apiName = "undefined API name";
            }
        }
        return apiName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void udp_trace(TRACE_RECORD_TYPES type, short lclId, short rmtId, short pktType, long par1, int par2, int par3) {
        if ((this.trc_mask & this.trc_classTable[type.ordinal()]) == 0) return;
        TraceRecord[] traceRecordArray = this.trc_buffer;
        synchronized (this.trc_buffer) {
            TraceRecord trcRec = this.trc_buffer[this.trc_bufferIdx];
            trcRec.trc_time = this.trc_usTimer.get();
            trcRec.trc_thread = Thread.currentThread().getId();
            trcRec.trc_type = type;
            trcRec.trc_lclid = lclId;
            trcRec.trc_rmtid = rmtId;
            trcRec.trc_pkt_type = pktType;
            trcRec.trc_par1 = par1;
            trcRec.trc_par2 = par2;
            trcRec.trc_par3 = par3;
            if (++this.trc_bufferIdx == this.trc_bufferSize) {
                this.trc_bufferIdx = 0;
            }
            ++this.trc_entryCount;
            // ** MonitorExit[var10_8] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void udp_trace_print(int payloadSize, String idTag, FileWriter trcOutput) throws IOException {
        TraceRecord[] traceRecordArray = this.trc_buffer;
        synchronized (this.trc_buffer) {
            int oldestIdx;
            if (this.trc_entryCount <= this.trc_bufferSize) {
                oldestIdx = 0;
            } else {
                this.trc_entryCount = this.trc_bufferSize;
                oldestIdx = this.trc_bufferIdx;
            }
            String traceLine = new String("\n>>> BEGIN (" + idTag + ") UDP trace ---------------------------------------------------------------\n\n");
            trcOutput.write(traceLine);
            int i = oldestIdx;
            for (int outputCount = 0; outputCount < this.trc_entryCount; ++outputCount) {
                TraceRecord trcRec = this.trc_buffer[i];
                try {
                    traceLine = this.format_trace_line(trcRec, payloadSize);
                }
                catch (Exception e) {
                    traceLine = "*** The attempt to format trace record type %d causes: " + e.toString() + "\n";
                }
                trcOutput.write(traceLine);
                i = (i + 1) % this.trc_bufferSize;
            }
            traceLine = new String("\n<<< END   (" + idTag + ") UDP trace ---------------------------------------------------------------\n\n");
            trcOutput.write(traceLine);
            this.trc_bufferIdx = 0;
            this.trc_entryCount = 0;
            // ** MonitorExit[var8_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void udp_trace_print(int payloadSize, String idTag, OutputStream trcOutput) throws IOException {
        TraceRecord[] traceRecordArray = this.trc_buffer;
        synchronized (this.trc_buffer) {
            int oldestIdx;
            if (this.trc_entryCount <= this.trc_bufferSize) {
                oldestIdx = 0;
            } else {
                this.trc_entryCount = this.trc_bufferSize;
                oldestIdx = this.trc_bufferIdx;
            }
            String traceLine = new String("\n>>> BEGIN (" + idTag + ") UDP trace ---------------------------------------------------------------\n\n");
            trcOutput.write(traceLine.getBytes());
            int i = oldestIdx;
            for (int outputCount = 0; outputCount < this.trc_entryCount; ++outputCount) {
                TraceRecord trcRec = this.trc_buffer[i];
                try {
                    traceLine = this.format_trace_line(trcRec, payloadSize);
                }
                catch (Exception e) {
                    traceLine = "*** The attempt to format trace record type %d causes: " + e.toString() + "\n";
                }
                trcOutput.write(traceLine.getBytes());
                i = (i + 1) % this.trc_bufferSize;
            }
            traceLine = new String("\n<<< END   (" + idTag + ") UDP trace ---------------------------------------------------------------\n\n");
            trcOutput.write(traceLine.getBytes());
            this.trc_bufferIdx = 0;
            this.trc_entryCount = 0;
            // ** MonitorExit[var8_4] (shouldn't be in output)
            return;
        }
    }

    private String format_trace_line(TraceRecord trcRec, int payloadSize) {
        double trcTime = (double)(trcRec.trc_time - this.trc_startUsTime) / 1000000.0;
        int pktSize = payloadSize + 28;
        String traceLine = String.format("%.6f (%d) ", trcTime, trcRec.trc_thread);
        String reason = "?";
        String lockName = "?";
        String threadName = "?";
        block0 : switch (trcRec.trc_type) {
            case TRACE_INITIALIZED: {
                traceLine = traceLine + String.format("UDP tracing has been initialized with trace mask 0x%08x\n", trcRec.trc_par1);
                break;
            }
            case ACK_TIMER_SET: {
                traceLine = traceLine + String.format("Resetting the ack timer for %d microsecnds hence\n", trcRec.trc_par1);
                break;
            }
            case NEW_WINDOW_SIZE: {
                if (trcRec.trc_pkt_type == 0) {
                    switch (RECV_WINDOW_CHANGE_TYPES.convert(trcRec.trc_lclid)) {
                        case RWC_CONNECT: {
                            reason = "connect";
                            break;
                        }
                        case RWC_CONNECT_COMPLETE: {
                            reason = "initial negotiated";
                            break;
                        }
                        case RWC_PMTU_COMPLETE: {
                            reason = "path MTU determination complete";
                            break;
                        }
                        case RWC_MEASURE_START: {
                            reason = "quickstart measure begin";
                            break;
                        }
                        case RWC_MEASURE_COMPLETE: {
                            reason = "quickstart measure complete";
                            break;
                        }
                        case RWC_NORMAL: {
                            reason = "normal flow control";
                            break;
                        }
                        case RWC_IDLE: {
                            reason = "idle";
                        }
                    }
                    traceLine = traceLine + String.format("New %s receive window size is %d, long term avg rtt=%d, recv_bandwidth=%d\n", reason, (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                    break;
                }
                switch (SEND_WINDOW_CHANGE_TYPES.convert(trcRec.trc_lclid)) {
                    case SWC_CONNECT: {
                        reason = "connect";
                        break;
                    }
                    case SWC_CONNECT_COMPLETE: {
                        reason = "initial negotiated";
                        break;
                    }
                    case SWC_PMTU_COMPLETE: {
                        reason = "path MTU determination complete";
                        break;
                    }
                    case SWC_MEASURE_START: {
                        reason = "quickstart measure begin";
                        break;
                    }
                    case SWC_NORMAL: {
                        reason = "normal flow control";
                    }
                }
                traceLine = traceLine + String.format("New %s send window size is %d\n", reason, trcRec.trc_par2);
                break;
            }
            case SEND_RATE_CAPTURE: {
                switch (SEND_RATE_CHANGE_REASONS.convert(trcRec.trc_pkt_type)) {
                    case INITIAL_NEGOTIATED_RATE: {
                        traceLine = traceLine + String.format("SR capture: Initial send rate is %d bytes/second, previous rate was %d bytes/second\n", (long)(1000000 * pktSize) / trcRec.trc_par1, 1000000 * pktSize / trcRec.trc_par2);
                        break block0;
                    }
                    case CAPTURE_INTERVAL_RATE: {
                        traceLine = traceLine + String.format("SR capture: For this send rate interval the send interval will be %d which is approximately %d bytes/second\n", trcRec.trc_par1, (long)(1000000 * pktSize) / trcRec.trc_par1);
                        break block0;
                    }
                    case RESTART_MEASUREMENT_INTERVAL: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                traceLine = traceLine + String.format("SR capture: Will restart the measurement rate capture interval with a smaller quick start burst because of packet loss\n", new Object[0]);
                                break;
                            }
                            case 1: {
                                traceLine = traceLine + String.format("SR capture: Will restart the measurement rate capture interval because sending stalled on the previous attempt\n", new Object[0]);
                            }
                        }
                        break block0;
                    }
                    case START_CAPTURE_INTERVAL: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                reason = "measurement";
                                break;
                            }
                            case 1: {
                                reason = "probe";
                                break;
                            }
                            case 2: {
                                reason = "regular";
                                break;
                            }
                            default: {
                                reason = "(unknown type)";
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: Starting %s rate capture interval %d at seq %d, packet send count is %d, interval length is %d microseconds\n", reason, trcRec.trc_rmtid, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                        break block0;
                    }
                    case START_CAPTURE_DELAY: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                reason = "measurement";
                                break;
                            }
                            case 1: {
                                reason = "probe";
                                break;
                            }
                            case 2: {
                                reason = "regular";
                                break;
                            }
                            default: {
                                reason = "(unknown type)";
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: Delaying start of %s rate capture interval %d - awaiting teh completion of previous activity\n", reason, trcRec.trc_rmtid);
                        break block0;
                    }
                    case END_CAPTURE_INTERVAL: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                reason = "measurement";
                                break;
                            }
                            case 1: {
                                reason = "probe";
                                break;
                            }
                            case 2: {
                                reason = "regular";
                                break;
                            }
                            default: {
                                reason = "(unknown type)";
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: Sending complete for %s rate capture interval %d, ending seq was %d, packet sent count was %d, rate was %d packets/second\n", reason, (int)trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                        break block0;
                    }
                    case RATE_PROBE_SUPRESSED: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                traceLine = traceLine + String.format("SR capture: The next rate probe will be supressed, there are still %d probe intervals left for settling\n", trcRec.trc_par1);
                                break block0;
                            }
                            case 1: {
                                traceLine = traceLine + String.format("SR capture: The next rate probe will be supressed, there are no results from the last probe yet\n", new Object[0]);
                                break block0;
                            }
                            case 2: {
                                traceLine = traceLine + String.format("SR capture: The next rate probe will be supressed, we are already sending at the maximum rate\n", new Object[0]);
                                break block0;
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: The next rate probe will be supressed, reason unknown\n", new Object[0]);
                        break block0;
                    }
                    case RATE_PROBE_OVER: {
                        traceLine = traceLine + String.format("SR capture: Rate probe over. Reverting to the current rate of %d bytes/second\n", (long)(1000000 * pktSize) / trcRec.trc_par1);
                        break block0;
                    }
                    case RATE_PROBE_FAILS: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                traceLine = traceLine + String.format("SR capture: Rate probe of %d bytes/seconds was unsuccessful (low bandwidth %d%%) - the next %d probe attempts will be supressed\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                                break;
                            }
                            case 1: {
                                traceLine = traceLine + String.format("SR capture: Rate probe of %d bytes/seconds was unsuccessful (excessive packet loss of %d packets/1000) - the next %d probe attempts will be supressed\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            }
                        }
                        break block0;
                    }
                    case RATE_INCREMENT: {
                        traceLine = traceLine + String.format("SR capture: Confirmed rate probe, increasing send rate to %d bytes/second, recv/send=%d%%, packet_loss=%d packets/1000\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                        break block0;
                    }
                    case RATE_UNCHANGED: {
                        switch (RATE_UNCHANGED_REASONS.convert(trcRec.trc_lclid)) {
                            case PROBE_SENDING_STALLED: {
                                reason = "sending stalled during the interval";
                                break;
                            }
                            case PROBE_SENDING_UNSUSTAINABLE: {
                                reason = "unsustainable send rate";
                                break;
                            }
                            case PROBE_ALREADY_DECREASED: {
                                reason = "the rate was decreased before the probe results were available";
                                break;
                            }
                            case REGULAR_ACCEPTABLE: {
                                reason = "the interval performance was acceptable";
                                break;
                            }
                            case REGULAR_ALREADY_DECREASED: {
                                reason = "the rate has already been reduced below the interval send rate";
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: The send rate will remain at %d bytes/second (interval rate was %d bytes/second) - %s\n", (long)(1000000 * pktSize) / trcRec.trc_par1, 1000000 * pktSize / trcRec.trc_par2, reason);
                        break block0;
                    }
                    case RATE_DECREMENT: {
                        if (trcRec.trc_rmtid == 0) {
                            switch (RATE_DECREMENT_REASONS.convert(trcRec.trc_lclid)) {
                                case LOW_BANDWIDTH: {
                                    traceLine = traceLine + String.format("SR capture: Decreasing the initial send rate to %d bytes/second, (low bandwidth %d%%)\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2);
                                    break;
                                }
                                case PACKET_LOSS: {
                                    traceLine = traceLine + String.format("SR capture: Decreasing the initial send rate to %d bytes/second, (excessive packet loss of %d packets/1000)\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2);
                                }
                            }
                            break block0;
                        }
                        switch (RATE_DECREMENT_REASONS.convert(trcRec.trc_lclid)) {
                            case LOW_BANDWIDTH: {
                                traceLine = traceLine + String.format("SR capture: Decreasing the send rate to %d bytes/second, (low bandwidth %d%%) - the next %d probe attempts will be supressed\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                                break;
                            }
                            case PACKET_LOSS: {
                                traceLine = traceLine + String.format("SR capture: Decreasing the send rate to %d bytes/second, (excessive packet loss of %d packets/1000) - the next %d probe attempts will be supressed\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                                break;
                            }
                            case UNSUSTAINABLE_SEND_RATE: {
                                traceLine = traceLine + String.format("SR capture: Decreasing the send rate to %d bytes/second, (unsustainable send rate %d%% of nominal) - the next %d probe attempts will be supressed\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            }
                        }
                        break block0;
                    }
                    case RATE_MEASURED: {
                        traceLine = traceLine + String.format("SR capture: The measured link rate was %d bytes/second, %d packets/second\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2);
                        break block0;
                    }
                    case RATE_MEASUREMENT: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                traceLine = traceLine + String.format("SR capture: The next interval will be a special rate measurement interval of %d packets at a maximum rate of %d bytes/second\n", trcRec.trc_par2, (long)(1000000 * pktSize) / trcRec.trc_par1);
                                break;
                            }
                            case 1: {
                                traceLine = traceLine + String.format("SR capture: The special rate measurement interval of %d packets postponed: insufficient queued data available\n", trcRec.trc_par2);
                            }
                        }
                        break block0;
                    }
                    case CAPTURE_INTERVAL_COMPLETE: {
                        switch (trcRec.trc_lclid) {
                            case 0: {
                                reason = "measurement";
                                break;
                            }
                            case 1: {
                                reason = "probe";
                                break;
                            }
                            case 2: {
                                reason = "regular";
                                break;
                            }
                            default: {
                                reason = "(unknown type)";
                            }
                        }
                        traceLine = traceLine + String.format("SR capture: Information complete for %s rate capture interval %d ending seq %d, recv/send=%d%%, packet_loss %d packets/1000\n", reason, (int)trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                        break block0;
                    }
                }
                traceLine = traceLine + String.format("SR capture: Unknown send rate capture subtype %d, p1=%d, p2=%d, p3=%d\n", trcRec.trc_pkt_type, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case DGB_ALLOCATED: {
                traceLine = traceLine + String.format("Allocated dgb number %d\n", (int)trcRec.trc_par1);
                break;
            }
            case DGB_RELEASED: {
                traceLine = traceLine + String.format("Released dgb number %d\n", (int)trcRec.trc_par1);
                break;
            }
            case DGB_ENQUEUED_SEND: {
                traceLine = traceLine + String.format("Enqueing dgb number %d: %d->%d on session send queue\n", (int)trcRec.trc_par1, (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid);
                break;
            }
            case DGB_ALLOCATION_FAILURE: {
                traceLine = traceLine + String.format("Datagram buffer allocation failure\n", new Object[0]);
                break;
            }
            case DGB_PKT_SENT: {
                traceLine = traceLine + String.format("Sent a %s packet from dgb number %d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_par1);
                break;
            }
            case DGB_PKT_RECEIVED: {
                traceLine = traceLine + String.format("Received a %s packet into dgb number %d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_par1);
                break;
            }
            case LOCK_WAIT: {
                switch (LOCK_IDENTIFIERS.convert(trcRec.trc_lclid)) {
                    case SESSION_LOCK: {
                        lockName = "session";
                        break;
                    }
                    case FRAMEWORK_LOCK: {
                        lockName = "framework";
                        break;
                    }
                    case CONNECTION_TABLE_LOCK: {
                        lockName = "connection table";
                    }
                }
                traceLine = traceLine + String.format("Waiting for the %s lock\n", lockName);
                break;
            }
            case LOCK_OBTAINED: {
                switch (LOCK_IDENTIFIERS.convert(trcRec.trc_lclid)) {
                    case SESSION_LOCK: {
                        lockName = "session";
                        break;
                    }
                    case FRAMEWORK_LOCK: {
                        lockName = "framework";
                        break;
                    }
                    case CONNECTION_TABLE_LOCK: {
                        lockName = "connection table";
                    }
                }
                traceLine = traceLine + String.format("Obtained the %s lock\n", lockName);
                break;
            }
            case LOCK_RELEASED: {
                switch (LOCK_IDENTIFIERS.convert(trcRec.trc_lclid)) {
                    case SESSION_LOCK: {
                        lockName = "session";
                        break;
                    }
                    case FRAMEWORK_LOCK: {
                        lockName = "framework";
                        break;
                    }
                    case CONNECTION_TABLE_LOCK: {
                        lockName = "connection table";
                    }
                }
                traceLine = traceLine + String.format("Released the %s lock\n", lockName);
                break;
            }
            case LOCK_ERROR: {
                switch (LOCK_IDENTIFIERS.convert(trcRec.trc_lclid)) {
                    case SESSION_LOCK: {
                        lockName = "session";
                        break;
                    }
                    case FRAMEWORK_LOCK: {
                        lockName = "framework";
                        break;
                    }
                    case CONNECTION_TABLE_LOCK: {
                        lockName = "connection table";
                    }
                }
                traceLine = traceLine + String.format("The wait for the %s lock was aborted\n", lockName);
                break;
            }
            case POSTING_RECV_EVENT: {
                traceLine = traceLine + String.format("Posting the cid %d receive event\n", trcRec.trc_lclid);
                break;
            }
            case POSTING_SEND_EVENT: {
                traceLine = traceLine + String.format("Posting the cid %d send event\n", trcRec.trc_lclid);
                break;
            }
            case DISCARDING_RECEIVED_PKT: {
                traceLine = traceLine + String.format("Discarding received %s packet: %s\n", this.datagramType(trcRec.trc_pkt_type), this.pktDiscardReason((int)trcRec.trc_par1));
                break;
            }
            case DISCARDING_RECEIVED_CPKT: {
                traceLine = traceLine + String.format("Discarding received %s packet %d<-%d, seq=%d, win_left=%d: %s\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid, trcRec.trc_par2, trcRec.trc_par3, this.pktDiscardReason((int)trcRec.trc_par1));
                break;
            }
            case DISCARDING_RECEIVED_TRANSPORT_PKT: {
                traceLine = traceLine + String.format("Discarding received %s packet: %s, subcode=%d, subcode_info=%d\n", this.datagramType(trcRec.trc_pkt_type), this.pktDiscardReason((int)trcRec.trc_par1), trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case TRANSPORT_PKT_RECEIVED: 
            case CPKT_RECEIVED: 
            case CPKT_RECEIVED_GAP: {
                if ((trcRec.trc_pkt_type & 0x80) != 0) {
                    TransportType transportPktType = TransportType.code(trcRec.trc_pkt_type);
                    switch (transportPktType) {
                        case CONNECT: {
                            traceLine = traceLine + String.format("Received a transport connect packet: cnct_sq=%d flags=0x%04x protocol_vers=%d bandwidth=%d initial_sq=%d\n", trcRec.trc_lclid, trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case ACK: {
                            traceLine = traceLine + String.format("Received a transport ack packet: ack_sq=%d data_sq=%d, rtt=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case ACK2: {
                            traceLine = traceLine + String.format("Received a transport ack2 packet: ack_sq=%d, next_data_sq=%d, rtt=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case KEEPALIVE: {
                            traceLine = traceLine + String.format("Received a transport keepalive packet\n", new Object[0]);
                            break;
                        }
                        case NAK: {
                            traceLine = traceLine + String.format("Received a transport nak packet: lost_count=%d, first_lost_sq=%d, last_lost_sq=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case PMTU: {
                            traceLine = traceLine + String.format("Received a transport pmtu packet: pmtu_sq=%d, payload_size=%d, conf=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case SHUTDOWN: {
                            traceLine = traceLine + String.format("Received a transport shutdown packet\n", new Object[0]);
                            break;
                        }
                        case REDIRECT: {
                            traceLine = traceLine + String.format("Received a transport redirect packet: cnct_sq=%d, redirected_port=%d, original_tgt_port=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case RESET: {
                            traceLine = traceLine + String.format("Received a transport reset packet\n", new Object[0]);
                        }
                    }
                    break;
                }
                PacketType dataPktType = PacketType.code((byte)trcRec.trc_pkt_type);
                switch (dataPktType) {
                    case CONNECT: 
                    case DATA: 
                    case SHUTDOWN: 
                    case RESET: {
                        traceLine = traceLine + String.format("Received a %s packet %d<-%d: sq=%d len=%d, gap from last received=%d\n", this.datagramType(trcRec.trc_pkt_type), trcRec.trc_lclid, trcRec.trc_rmtid, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                    }
                }
                break;
            }
            case ADDITIONAL_TRANSPORT_PKT_INFO: {
                TransportType transportPktType = TransportType.code(trcRec.trc_pkt_type);
                switch (transportPktType) {
                    case CONNECT: {
                        String internetAddr = this.cvtIntToDotIpAddr(trcRec.trc_par2);
                        traceLine = traceLine + String.format("Additional connect packet info: win_size=%d, Ipv4=%s port=%d, payload=%d\n", trcRec.trc_par1, internetAddr, trcRec.trc_par3, trcRec.trc_lclid);
                        break;
                    }
                    case ACK: {
                        reason = trcRec.trc_rmtid == 0 ? "sent" : "received";
                        traceLine = trcRec.trc_lclid == 65535 ? traceLine + String.format("Additional %s ack packet info: win_size=%d, bandwidth=%d, acked_count=%d\n", reason, trcRec.trc_par2, trcRec.trc_par3, trcRec.trc_par1) : traceLine + String.format("Additional %s ack packet info: win_size=%d, bandwidth=%d, removed=%d, unacked_count=%d\n", reason, trcRec.trc_par2, trcRec.trc_par3, trcRec.trc_lclid, trcRec.trc_par1);
                    }
                }
                break;
            }
            case CPKT_DEMUXED: {
                traceLine = traceLine + String.format("Demuxed a %s packet %d<-%d: dgb number %d, sq=%d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2);
                break;
            }
            case RECEIVE_WINDOW_FULL: {
                traceLine = traceLine + String.format("The receive window of %d is filled\n", (int)trcRec.trc_par1);
                break;
            }
            case THREAD_TERM_WAIT: {
                switch (THREAD_TYPES.convert(trcRec.trc_pkt_type)) {
                    case UDP_THREAD: {
                        threadName = "UDP";
                        break;
                    }
                    case TIMER_THREAD: {
                        threadName = "timer";
                    }
                }
                traceLine = traceLine + String.format("Waiting for the termination of the %s thread\n", threadName);
                break;
            }
            case TRANSPORT_PKT_SENT: {
                TransportType transportPktType = TransportType.code(trcRec.trc_pkt_type);
                String blocked = "";
                if (trcRec.trc_lclid == 1) {
                    blocked = " (send blocked)";
                }
                switch (transportPktType) {
                    case ACK: {
                        traceLine = traceLine + String.format("Sent a transport ack packet: ack_sq=%d data_sq=%d, rtt=%d%s\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3, blocked);
                        break;
                    }
                    case ACK2: {
                        traceLine = traceLine + String.format("Sent a transport ack2 packet: ack_sq=%d, next_data_sq=%d, unacked_count=%d%s\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3, blocked);
                        break;
                    }
                    case CONNECT: {
                        traceLine = traceLine + String.format("Sent a transport connect packet: cnct_sq=%d flags=0x%04x protocol_vers=%d bandwidth=%d initial_sq=%d\n", trcRec.trc_lclid, trcRec.trc_rmtid, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                        break;
                    }
                    case KEEPALIVE: {
                        traceLine = traceLine + String.format("Sent a transport keepalive packet%s\n", blocked);
                        break;
                    }
                    case NAK: {
                        traceLine = traceLine + String.format("Sent a transport nak packet: lost_count=%d, first_lost_sq=%d, last_lost_sq=%d%s\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3, blocked);
                        break;
                    }
                    case PMTU: {
                        traceLine = traceLine + String.format("Sent a transport pmtu packet: pmtu_sq=%d, payload_size=%d, conf=%d%s\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3, blocked);
                        break;
                    }
                    case REDIRECT: {
                        traceLine = traceLine + String.format("Sent a transport redirect packet: cnct_sq=%d, redirected_tgt_port=%d, original_tgt_port=%d%s\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3, blocked);
                        break;
                    }
                    case RESET: {
                        traceLine = traceLine + String.format("Sent a transport reset packet%s\n", blocked);
                        break;
                    }
                    case SHUTDOWN: {
                        traceLine = traceLine + String.format("Sent a transport shutdown packet%s\n", blocked);
                    }
                }
                break;
            }
            case CPKT_SENT: {
                traceLine = traceLine + String.format("Sent a %s packet %d->%d: sq=%d, len=%d, unacked_count=%d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case CPKT_RESENT: {
                traceLine = traceLine + String.format("Resent a %s packet %d->%d: sq=%d len=%d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid, (int)trcRec.trc_par1, trcRec.trc_par2);
                break;
            }
            case CPKT_SEND_NO_BUFFER: {
                traceLine = traceLine + String.format("No datagram buffer available to send a %s packet %d->%d\n", this.datagramType(trcRec.trc_pkt_type), (int)trcRec.trc_lclid, (int)trcRec.trc_rmtid);
                break;
            }
            case NEW_CONNECTION_STATE: {
                traceLine = traceLine + String.format("The cid %d state is now %s\n", trcRec.trc_lclid, this.connectionState((int)trcRec.trc_par1));
                break;
            }
            case NEW_SESSION_STATE: {
                traceLine = traceLine + String.format("The session state is now %s\n", this.sessionState((int)trcRec.trc_par1));
                break;
            }
            case THREAD_START_STOP: {
                switch (THREAD_TYPES.convert(trcRec.trc_pkt_type)) {
                    case UDP_THREAD: {
                        threadName = "UDP";
                        break;
                    }
                    case TIMER_THREAD: {
                        threadName = "timer";
                    }
                }
                traceLine = traceLine + String.format("The %s thread (tid=%d), %s\n", threadName, trcRec.trc_par1, trcRec.trc_lclid == 0 ? "starts" : "terminates");
                break;
            }
            case ACCEPT_TIMEOUT: {
                traceLine = traceLine + String.format("Accepting of connection %d<-%d failed: Timed out\n", trcRec.trc_lclid, (int)trcRec.trc_rmtid);
                break;
            }
            case CONNECTION_RESET: {
                String internetAddr = this.cvtIntToDotIpAddr(trcRec.trc_par2);
                traceLine = traceLine + String.format("Received a connection reset for peer port %d at %s\n", (int)trcRec.trc_par1, internetAddr);
                break;
            }
            case UDP_SOCKET_EMPTY: {
                traceLine = traceLine + String.format("The udp socket is empty after receipt of %d packets, total data packets received %d\n", trcRec.trc_par2, trcRec.trc_par1);
                break;
            }
            case SEND_FLOW_WINDOW_FULL: {
                if (trcRec.trc_pkt_type == 0) {
                    traceLine = traceLine + String.format("The send flow window of %d is full, next_send_sq=%d, unacked_count=%d\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                    break;
                }
                traceLine = traceLine + String.format("The send flow window of %d is still full - receiver unable to accept more data, next_send_sq=%d, unacked_count=%d\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case SEND_QUEUE_EMPTY: {
                traceLine = traceLine + String.format("The send queue is empty\n", new Object[0]);
                break;
            }
            case RECV_QUEUE_FULL: {
                traceLine = traceLine + String.format("The %d<-%d receive queue is full at %d packets\n", trcRec.trc_lclid, trcRec.trc_rmtid, trcRec.trc_par1);
                break;
            }
            case UDP_SOCKET_FULL: {
                traceLine = traceLine + String.format("The UDP socket is full\n", new Object[0]);
                break;
            }
            case UDP_SOCKET_WRITE_ERROR: {
                traceLine = traceLine + String.format("Error writing to the UDP socket: %s\n", this.getErrorMsg(trcRec.trc_par2));
                break;
            }
            case UDP_SOCKET_READ_ERROR: {
                traceLine = traceLine + String.format("Error reading from the UDP socket: %s\n", this.getErrorMsg(trcRec.trc_par2));
                break;
            }
            case UDP_SOCKET_BUFFER_SIZE: {
                if (trcRec.trc_pkt_type != 0) {
                    traceLine = traceLine + String.format("Using UDP socket send buffer of %d bytes\n", trcRec.trc_par1);
                    break;
                }
                traceLine = traceLine + String.format("Using UDP socket receive buffer of %d bytes\n", trcRec.trc_par1);
                break;
            }
            case THREAD_PAUSE: {
                traceLine = traceLine + String.format("The UDP thread pauses for up to %d microseconds\n", trcRec.trc_par1);
                break;
            }
            case THREAD_RESUME: {
                switch (trcRec.trc_par2) {
                    case 1: {
                        reason = "Select wait timed out";
                        break;
                    }
                    case 2: {
                        reason = "Thread notification";
                        break;
                    }
                    case 3: {
                        reason = "Data pending on UDP socket";
                        break;
                    }
                    default: {
                        reason = "?";
                    }
                }
                traceLine = traceLine + String.format("The UDP thread resumes after %d microseconds: %s\n", trcRec.trc_par1, reason);
                break;
            }
            case RECV_EVENT_WAIT: {
                traceLine = traceLine + String.format("Waiting for the posting of the cid %d receive event\n", trcRec.trc_lclid);
                break;
            }
            case RECV_EVENT_WAIT_DONE: {
                switch (WAIT_RESULT_CODES.convert((int)trcRec.trc_par1)) {
                    case WAIT_SUCCESS: {
                        traceLine = traceLine + String.format("The cid %d receive event has been posted, flg=%d\n", trcRec.trc_lclid, trcRec.trc_par2);
                        break block0;
                    }
                    case WAIT_TIMED_OUT: {
                        traceLine = traceLine + String.format("The cid %d receive event wait has timed out\n", trcRec.trc_lclid);
                        break block0;
                    }
                }
                traceLine = traceLine + String.format("The cid %d receive event wait was aborted\n", trcRec.trc_lclid);
                break;
            }
            case SEND_EVENT_WAIT: {
                traceLine = traceLine + String.format("Waiting for the posting of the cid %d send event\n", trcRec.trc_lclid);
                break;
            }
            case SEND_EVENT_WAIT_DONE: {
                switch (WAIT_RESULT_CODES.convert((int)trcRec.trc_par1)) {
                    case WAIT_SUCCESS: {
                        traceLine = traceLine + String.format("The cid %d send event has been posted\n", trcRec.trc_lclid);
                        break block0;
                    }
                    case WAIT_TIMED_OUT: {
                        traceLine = traceLine + String.format("The cid %d send event wait has timed out\n", trcRec.trc_lclid);
                        break block0;
                    }
                }
                traceLine = traceLine + String.format("The cid %d send event wait was aborted\n", trcRec.trc_lclid);
                break;
            }
            case API_ENTRY: {
                traceLine = traceLine + String.format("API entry: %s, p2=%x, p3=%x\n", this.apiName((int)trcRec.trc_par1), trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case API_EXIT: {
                traceLine = traceLine + String.format("API exit: %s - rv=%x, errno=%d\n", this.apiName((int)trcRec.trc_par1), trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case SELECT_ERROR: {
                traceLine = traceLine + String.format("Error from select: %s\n", this.getErrorMsg((int)trcRec.trc_par1));
                break;
            }
            case PACKET_RETRANSMISSION_COUNT_EXCEEDED: {
                traceLine = traceLine + String.format("Single packet retransmission count exceeded for packet seq %d: aborting the UDP transport session\n", trcRec.trc_par2);
                break;
            }
            case CHECK_RECEIVE_RATE: {
                switch (RECV_RATE_CHANGE_REASONS.convert(trcRec.trc_pkt_type)) {
                    case QUICKSTART_MEASURE_INTERVAL_START: {
                        reason = (trcRec.trc_par3 & 1) != 0 ? "measurement start" : ((trcRec.trc_par3 & 2) != 0 ? "measurement stop" : "measurement intermediate");
                        traceLine = traceLine + String.format("Quickstart receive rate measurement interval starts with a %s packet, sequence %d, received at %d\n", reason, trcRec.trc_par2, trcRec.trc_par1);
                        break;
                    }
                    case QUICKSTART_MEASURE_START: {
                        traceLine = traceLine + String.format("Quickstart receive rate measurement start packet, sequence %d, received at %d\n", trcRec.trc_par2, trcRec.trc_par1);
                        break;
                    }
                    case QUICKSTART_MEASURE_STOP: {
                        traceLine = traceLine + String.format("Quickstart receive rate measurement stop packet, sequence %d, received at %d\n", trcRec.trc_par2, trcRec.trc_par1);
                        break;
                    }
                    case QUICKSTART_MEASURE_COMPLETE: {
                        traceLine = traceLine + String.format("Quickstart receive rate measurement completes with a receive rate of %d packets/sec (%d bytes/sec),  measurement time %d us, packet count %d\n", trcRec.trc_par3, trcRec.trc_par3 * pktSize, trcRec.trc_par1, trcRec.trc_par2);
                        break;
                    }
                    case NORMAL_INTERVAL: {
                        traceLine = traceLine + String.format("Normal receive rate interval completes at with receive rate of %d packets/sec (%d bytes/sec),  measurement time %d us, packet count %d\n", trcRec.trc_par3, trcRec.trc_par3 * pktSize, trcRec.trc_par1, trcRec.trc_par2);
                    }
                }
                break;
            }
            case SEND_PAUSE: {
                traceLine = traceLine + String.format("The UDP thread pauses for %d us, the next send time is %d us hence, next ack time %d us hence\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case SEND_RESUME: {
                switch (trcRec.trc_pkt_type) {
                    case 0: {
                        reason = "timed out";
                        break;
                    }
                    case 1: {
                        reason = "send resume posted";
                        break;
                    }
                    case 2: {
                        reason = "data on UDP socket";
                        break;
                    }
                    default: {
                        reason = "unkbown";
                    }
                }
                traceLine = traceLine + String.format("The UDP thread resumes after %d us (%s), the send queue length is %d packets, total of %d packets sent\n", trcRec.trc_par2, reason, trcRec.trc_par3, trcRec.trc_par1);
                break;
            }
            case RECV_LOOP_EXIT: {
                traceLine = traceLine + String.format("Exit from the receive loop after receipt of %d packets, total data packets received %d\n", trcRec.trc_par2, trcRec.trc_par1);
                break;
            }
            case SEND_LOOP_EXIT: {
                traceLine = traceLine + String.format("Exit from the send loop after sending of %d packets, total data packets sent %d\n", trcRec.trc_par2, trcRec.trc_par1);
                break;
            }
            case RATE_PARAMETER_SET: {
                switch (RATE_PARAMETER_TYPES.convert(trcRec.trc_pkt_type)) {
                    case CEILING: {
                        traceLine = traceLine + String.format("The transport rate ceiling has been set to %d bytes/sec (minimum send interval will be %d which is approx %d bytes/sec for a payload size of %d)\n", trcRec.trc_par2, trcRec.trc_par1, 1000000L / trcRec.trc_par1 * (long)trcRec.trc_par3, trcRec.trc_par3);
                        break;
                    }
                    case FLOOR: {
                        traceLine = traceLine + String.format("The transport rate floor has been set to %d bytes/sec (maximum send interval will be %d which is approx %d bytes/sec for a payload size of %d)\n", trcRec.trc_par2, trcRec.trc_par1, 1000000L / trcRec.trc_par1 * (long)trcRec.trc_par3, trcRec.trc_par3);
                        break;
                    }
                    case AGGRESSIVENESS: {
                        String aggressivness;
                        switch ((short)trcRec.trc_par1) {
                            case 0: {
                                aggressivness = "low";
                                break;
                            }
                            case 1: {
                                aggressivness = "medium";
                                break;
                            }
                            case 2: {
                                aggressivness = "high";
                                break;
                            }
                            default: {
                                aggressivness = "invalid";
                            }
                        }
                        traceLine = traceLine + String.format("The transport aggressivness has been set to %s\n", aggressivness);
                        break;
                    }
                    case BURST_QUANTUM_MS: {
                        traceLine = traceLine + String.format("The send burst qauntum has been set to %d milliseconds\n", trcRec.trc_par1);
                        break;
                    }
                    case LOSS_TOLERANCE: {
                        traceLine = traceLine + String.format("The packet loss tolerance has been set to %d packets/1000\n", trcRec.trc_par1);
                    }
                }
                break;
            }
            case STATS_REPORT: {
                if (trcRec.trc_lclid == 0) {
                    switch (STATS_REPORT_TYPES.convert(trcRec.trc_pkt_type)) {
                        case STATS_REPORT_1: {
                            traceLine = traceLine + String.format("Send stats report: Elapsed time=%d, unacked pkts=%d, send queue length=%d\n", (int)trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                            break;
                        }
                        case STATS_REPORT_2: {
                            traceLine = traceLine + String.format("Send stats report: Stalls=%d, stalled time=%d, current send window size=%d\n", trcRec.trc_par2, trcRec.trc_par1, trcRec.trc_par3);
                            break;
                        }
                        case STATS_REPORT_3: {
                            traceLine = traceLine + String.format("Send stats report: send rate=%d bytes/second, application rate=%d butes/second, loss rate=%.1f%%\n", trcRec.trc_par1, trcRec.trc_par2, (double)trcRec.trc_par3 / 10.0);
                            break;
                        }
                        case STATS_REPORT_4: {
                            traceLine = traceLine + String.format("Send stats report: running send rate=%d bytes/second, running application rate=%d bytes/second, running loss rate=%.1f%%\n", trcRec.trc_par1, trcRec.trc_par2, (double)trcRec.trc_par3 / 10.0);
                        }
                    }
                    break;
                }
                switch (STATS_REPORT_TYPES.convert(trcRec.trc_pkt_type)) {
                    case STATS_REPORT_1: {
                        traceLine = traceLine + String.format("Receive stats report: Elapsed time=%d, packets received=%d, recv rate=%d, window count=%d\n", trcRec.trc_par1, trcRec.trc_par2, (long)(trcRec.trc_par2 * 1000000) / trcRec.trc_par1, trcRec.trc_par3);
                        break;
                    }
                    case STATS_REPORT_2: {
                        traceLine = traceLine + String.format("Receive stats report: Packets delivered to application=%d, application received rate=%d, receive queue length=%d\n", trcRec.trc_par2, (long)(trcRec.trc_par2 * 1000000) / trcRec.trc_par1, trcRec.trc_par3);
                        break;
                    }
                    case STATS_REPORT_3: {
                        traceLine = traceLine + String.format("Receive stats report: Receive queued filled=%d, current recv window size=%d\n", trcRec.trc_par2, trcRec.trc_par3);
                    }
                }
                break;
            }
            case SENDING_RESUMES: {
                traceLine = traceLine + String.format("Send flow window space available: rate=%d bytes/second, winsize=%d, unacked=%d\n", (long)(1000000 * pktSize) / trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case PATH_MTU_DETERMINATION: {
                switch (PATH_MTU_CODES.convert(trcRec.trc_pkt_type)) {
                    case PMTU_STARTING: {
                        traceLine = traceLine + String.format("Starting path MTU determination\n", new Object[0]);
                        break;
                    }
                    case PMTU_DF_FAILED: {
                        traceLine = traceLine + String.format("Unable to supress UDP packet fragmentation for path MTU determination\n", new Object[0]);
                        break;
                    }
                    case PMTU_COMPLETE: {
                        traceLine = traceLine + String.format("Path MTU determination complete: max payload=%d bytes link_speed=%d bytes/sec\n", trcRec.trc_par2, 1000000 / (int)trcRec.trc_par1 * trcRec.trc_par2);
                    }
                }
                break;
            }
            case DATAGRAM_BUFFER_PAYLOAD: {
                traceLine = traceLine + String.format("New datagram buffer payload size set at %d bytes\n", trcRec.trc_par1);
                break;
            }
            case TICKLE_PROBE: {
                traceLine = traceLine + String.format("Running below the tickle threshold of %d Kbits/second for %d seconds - will remeasure the bandwidth\n", trcRec.trc_par3, trcRec.trc_par2);
                break;
            }
            case TIMER_PERFORMANCE: {
                traceLine = traceLine + String.format("Wait timer performance for the last %d short waits: average desired wait time %d, average actual wait time %d, ratio actual/desired %.1f\n", trcRec.trc_lclid, trcRec.trc_par1, trcRec.trc_par2, (double)trcRec.trc_par3 / 10.0);
                break;
            }
            case JAVA_WAIT_METHOD: {
                traceLine = traceLine + String.format("Java wait method will be %s, the average one millisecond wait resolution was %d microseconds\n", trcRec.trc_lclid == 0 ? "lock support" : "thread sleep", trcRec.trc_par1 / 1000L);
                break;
            }
            case JAVA_BURST_PERFORMANCE: {
                traceLine = traceLine + String.format("Current burst performance: burst count: %d, average burst time: %s microseconds, average burst packets %d\n", trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            case GP_TRACE_ENTRY: {
                traceLine = traceLine + String.format("General purpose trace entry: lclCid=%d, rmtCid=%d, dgType=%d, p1=%d, p2=%d, p3=%d\n", trcRec.trc_lclid, trcRec.trc_rmtid, trcRec.trc_pkt_type, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
                break;
            }
            default: {
                traceLine = traceLine + String.format("Unspecified trace entry: type=%d, lclCid=%d, rmtCid=%d, dgType=%d, p1=%d, p2=%d, p3=%d\n", trcRec.trc_type.ordinal(), trcRec.trc_lclid, trcRec.trc_rmtid, trcRec.trc_pkt_type, trcRec.trc_par1, trcRec.trc_par2, trcRec.trc_par3);
            }
        }
        return traceLine;
    }

    public static void main(String[] args) {
        UdpTrace trcCtx = new UdpTrace(41055, 10000);
        for (int i = 0; i < 100; ++i) {
            trcCtx.udp_trace(TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)i, (byte)SEND_RATE_CHANGE_REASONS.END_CAPTURE_INTERVAL.ordinal(), 1000L + (long)i, 1, 1000);
        }
        trcCtx.udp_trace(TRACE_RECORD_TYPES.CPKT_RECEIVED, (short)23, (short)37, PacketType.CONNECT.code(), 809436L, 1472, 1);
        trcCtx.udp_trace(TRACE_RECORD_TYPES.CPKT_RECEIVED, (short)23, (short)37, PacketType.CONNECT.code(), 809437L, 1472, 1);
        long currTime = System.currentTimeMillis();
        trcCtx.udp_trace(TRACE_RECORD_TYPES.CPKT_RECEIVED, (short)23, (short)37, PacketType.CONNECT.code(), currTime, 1472, 1);
        trcCtx.udp_trace(TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)1472, (short)-1, TransportType.CONNECT.code(), 128L, 1110452103, 49221);
        try {
            trcCtx.udp_trace_print(1460, "TEST", System.out);
        }
        catch (Exception e) {
            System.out.println("udp_trace_print failure");
        }
    }

    protected class TraceRecord {
        long trc_time;
        long trc_thread;
        TRACE_RECORD_TYPES trc_type;
        short trc_pkt_type;
        short trc_lclid;
        short trc_rmtid;
        long trc_par1;
        int trc_par2;
        int trc_par3;

        protected TraceRecord() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RATE_PARAMETER_TYPES {
        AGGRESSIVENESS,
        CEILING,
        FLOOR,
        BURST_QUANTUM_MS,
        LOSS_TOLERANCE,
        UNDEFINED;


        static RATE_PARAMETER_TYPES convert(int intValue) {
            try {
                return RATE_PARAMETER_TYPES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum STATS_REPORT_TYPES {
        STATS_REPORT_1,
        STATS_REPORT_2,
        STATS_REPORT_3,
        STATS_REPORT_4,
        UNDEFINED;


        static STATS_REPORT_TYPES convert(int intValue) {
            try {
                return STATS_REPORT_TYPES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PATH_MTU_CODES {
        PMTU_STARTING,
        PMTU_DF_FAILED,
        PMTU_COMPLETE,
        UNDEFINED;


        static PATH_MTU_CODES convert(int intValue) {
            try {
                return PATH_MTU_CODES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum API_RTN_CODES {
        UDP_SESSION_CONNECT,
        UDP_SESSION_ACCEPT,
        UDP_SESSION_WAIT_CONNECTED,
        UDP_SESSION_DISCONNECT,
        UDP_CONTROL,
        UDP_CREATE,
        UDP_ACCEPT,
        UDP_CONNECT,
        UDP_LISTEN,
        UDP_RECEIVE,
        UDP_DUMMY_RECEIVE,
        UDP_SEND,
        UDP_DUMMY_SEND,
        UDP_SELECT,
        UDP_SELECT_INTERRUPT,
        UDP_SHUTDOWN,
        UDP_SET_CONNECTION_MODE,
        UDP_GET_CONNECTION_ERROR_STATUS,
        UDP_GET_CONNECTION_PENDING,
        UDP_GET_SESSION_STATS,
        UDP_GET_CONNECTION_STATS,
        UDP_DESTROY,
        UDP_TERM,
        UNDEFINED;


        static API_RTN_CODES convert(int intValue) {
            try {
                return API_RTN_CODES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum WAIT_RESULT_CODES {
        WAIT_SUCCESS,
        WAIT_TIMED_OUT,
        WAIT_ERROR,
        UNDEFINED;


        static WAIT_RESULT_CODES convert(int intValue) {
            try {
                return WAIT_RESULT_CODES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CONNECTION_STATES {
        IDLE,
        INITIALIZING,
        LISTENING,
        CONNECTING,
        CONNECTED,
        CLOSING,
        CLOSE_WAIT,
        CLOSED,
        UNDEFINED;


        static CONNECTION_STATES convert(int intValue) {
            try {
                return CONNECTION_STATES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SESSION_STATES {
        IDLE,
        CONNECTING,
        CONNECT_CMPLT_WAIT,
        ACCEPTING,
        ACCEPT_CMPLT_WAIT,
        PMTU_DETERMINATION_SERVER,
        PMTU_DETERMINATION_CLIENT,
        PMTU_RESULT_WAIT_CLIENT,
        CONNECTED,
        CLOSE_PENDING,
        CLOSING,
        CLOSE_WAIT,
        TERMINATING,
        UNDEFINED;


        static SESSION_STATES convert(int intValue) {
            try {
                return SESSION_STATES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PKT_DISCARD_REASONS {
        PKT_DISCARD_INVALID,
        PKT_DISCARD_LISTEN_QUEUE_FULL,
        PKT_DISCARD_NO_AVAILABLE_CONNECTIONS,
        PKT_DISCARD_WRONG_STATE,
        PKT_DISCARD_DUPLICATE,
        PKT_DISCARD_LEFT_OF_RECV_WINDOW,
        PKT_DISCARD_RIGHT_OF_RECV_WINDOW,
        PKT_DISCARD_SHORT_HEADER,
        PKT_DISCARD_BAD_CONNECTION_TARGET_ID,
        PKT_DISCARD_BAD_CONNECTION_SOURCE_ID,
        PKT_DISCARD_BAD_PKT_SOURCE_ADDRESS,
        PKT_DISCARD_UNSUPPORTED_VERSION,
        PKT_DISCARD_MEASUREMENT,
        UNDEFINED;


        static PKT_DISCARD_REASONS convert(int intValue) {
            try {
                return PKT_DISCARD_REASONS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }

        static int convert(PKT_DISCARD_REASONS reason) {
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum LOCK_IDENTIFIERS {
        SESSION_LOCK,
        FRAMEWORK_LOCK,
        CONNECTION_TABLE_LOCK,
        UNDEFINED;


        static LOCK_IDENTIFIERS convert(int intValue) {
            try {
                return LOCK_IDENTIFIERS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RATE_DECREMENT_REASONS {
        LOW_BANDWIDTH,
        PACKET_LOSS,
        UNSUSTAINABLE_SEND_RATE,
        UNDEFINED;


        static RATE_DECREMENT_REASONS convert(int intValue) {
            try {
                return RATE_DECREMENT_REASONS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RATE_UNCHANGED_REASONS {
        PROBE_SENDING_STALLED,
        PROBE_SENDING_UNSUSTAINABLE,
        PROBE_ALREADY_DECREASED,
        REGULAR_ACCEPTABLE,
        REGULAR_ALREADY_DECREASED,
        UNDEFINED;


        static RATE_UNCHANGED_REASONS convert(int intValue) {
            try {
                return RATE_UNCHANGED_REASONS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RECV_RATE_CHANGE_REASONS {
        QUICKSTART_MEASURE_INTERVAL_START,
        QUICKSTART_MEASURE_START,
        QUICKSTART_MEASURE_STOP,
        QUICKSTART_MEASURE_COMPLETE,
        NORMAL_INTERVAL,
        UNDEFINED;


        static RECV_RATE_CHANGE_REASONS convert(int intValue) {
            try {
                return RECV_RATE_CHANGE_REASONS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SEND_RATE_CHANGE_REASONS {
        INITIAL_NEGOTIATED_RATE,
        CAPTURE_INTERVAL_RATE,
        START_CAPTURE_INTERVAL,
        RESTART_MEASUREMENT_INTERVAL,
        START_CAPTURE_DELAY,
        END_CAPTURE_INTERVAL,
        CAPTURE_INTERVAL_COMPLETE,
        RATE_PROBE_SUPRESSED,
        RATE_PROBE_OVER,
        RATE_INCREMENT,
        RATE_PROBE_FAILS,
        RATE_DECREMENT,
        RATE_UNCHANGED,
        RATE_MEASURED,
        RATE_MEASUREMENT,
        RATE_MEASUREMENT_FAILED,
        UNDEFINED;


        static SEND_RATE_CHANGE_REASONS convert(int intValue) {
            try {
                return SEND_RATE_CHANGE_REASONS.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SEND_WINDOW_CHANGE_TYPES {
        SWC_CONNECT,
        SWC_CONNECT_COMPLETE,
        SWC_PMTU_COMPLETE,
        SWC_MEASURE_START,
        SWC_MEASURE_COMPLETE,
        SWC_NORMAL,
        UNDEFINED;


        static SEND_WINDOW_CHANGE_TYPES convert(int intValue) {
            try {
                return SEND_WINDOW_CHANGE_TYPES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RECV_WINDOW_CHANGE_TYPES {
        RWC_CONNECT,
        RWC_PMTU_COMPLETE,
        RWC_CONNECT_COMPLETE,
        RWC_MEASURE_START,
        RWC_MEASURE_COMPLETE,
        RWC_NORMAL,
        RWC_IDLE,
        UNDEFINED;


        static RECV_WINDOW_CHANGE_TYPES convert(int intValue) {
            try {
                return RECV_WINDOW_CHANGE_TYPES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum THREAD_TYPES {
        UDP_THREAD,
        TIMER_THREAD,
        UNDEFINED;


        static THREAD_TYPES convert(int intValue) {
            try {
                return THREAD_TYPES.values()[intValue];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return UNDEFINED;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum TRACE_RECORD_TYPES {
        TRACE_INITIALIZED,
        ACK_TIMER_SET,
        NEW_WINDOW_SIZE,
        SEND_RATE_CAPTURE,
        DGB_ALLOCATED,
        DGB_ALLOCATION_FAILURE,
        DGB_RELEASED,
        DGB_ENQUEUED_SEND,
        DGB_PKT_SENT,
        DGB_PKT_RECEIVED,
        LOCK_WAIT,
        LOCK_OBTAINED,
        LOCK_ERROR,
        LOCK_RELEASED,
        POSTING_RECV_EVENT,
        POSTING_SEND_EVENT,
        POSTING_SHUTDOWN_EVENT,
        DISCARDING_RECEIVED_PKT,
        DISCARDING_RECEIVED_CPKT,
        DISCARDING_RECEIVED_TRANSPORT_PKT,
        RECEIVE_WINDOW_FULL,
        THREAD_TERM_WAIT,
        THREAD_TERM_WAIT_COMPLETE,
        TRANSPORT_PKT_RECEIVED,
        TRANSPORT_PKT_SENT,
        ADDITIONAL_TRANSPORT_PKT_INFO,
        CPKT_RECEIVED,
        CPKT_RECEIVED_GAP,
        CPKT_DEMUXED,
        CPKT_SENT,
        CPKT_RESENT,
        CPKT_SEND_NO_BUFFER,
        NEW_CONNECTION_STATE,
        NEW_SESSION_STATE,
        ACCEPT_TIMEOUT,
        CONNECTION_RESET,
        UDP_SOCKET_EMPTY,
        UDP_SOCKET_FULL,
        UDP_SOCKET_WRITE_ERROR,
        UDP_SOCKET_READ_ERROR,
        UDP_SOCKET_BUFFER_SIZE,
        SEND_FLOW_WINDOW_FULL,
        SEND_QUEUE_EMPTY,
        RECV_QUEUE_FULL,
        THREAD_PAUSE,
        THREAD_RESUME,
        THREAD_START_STOP,
        RECV_EVENT_WAIT,
        RECV_EVENT_WAIT_DONE,
        SEND_EVENT_WAIT,
        SEND_EVENT_WAIT_DONE,
        SHUTDOWN_EVENT_WAIT,
        SHUTDOWN_EVENT_WAIT_DONE,
        API_ENTRY,
        API_EXIT,
        SELECT_ERROR,
        CONNECTION_ALLOCATED,
        CONNECTION_RELEASED,
        FAKED_NAK,
        SELECT_RETURN,
        SELECT_TIMEOUT_VALUE,
        SELECT_API_ERROR,
        PACKET_RETRANSMISSION_COUNT_EXCEEDED,
        CHECK_RECEIVE_RATE,
        SEND_PAUSE,
        SEND_RESUME,
        UDP_ABORT,
        RECV_LOOP_EXIT,
        SEND_LOOP_EXIT,
        RATE_PARAMETER_SET,
        STATS_REPORT,
        SENDING_RESUMES,
        OUT_OF_MEMORY,
        PATH_MTU_DETERMINATION,
        DATAGRAM_BUFFER_PAYLOAD,
        TICKLE_PROBE,
        BUFFER_BLOCK_ALLOCATION,
        MEMORY_USAGE,
        TIMER_PERFORMANCE,
        JAVA_WAIT_METHOD,
        JAVA_BURST_PERFORMANCE,
        GP_TRACE_ENTRY;

    }
}

