/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp;

import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionAbortedException;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionRefusedException;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionResetException;
import com.signiant.interactivetransfer.engine.udp.exceptions.InvalidPacketException;
import com.signiant.interactivetransfer.engine.udp.exceptions.PacketResentCountExceededException;
import com.signiant.interactivetransfer.engine.udp.exceptions.TimedOutException;
import com.signiant.interactivetransfer.engine.udp.exceptions.UdpBaseException;
import com.signiant.interactivetransfer.engine.udp.exceptions.WouldBlockException;
import com.signiant.mobilize.ddsclient.connection.udp.MicrosecondTimer;
import com.signiant.mobilize.ddsclient.connection.udp.SessionStatistics;
import com.signiant.mobilize.ddsclient.connection.udp.UdpConnection;
import com.signiant.mobilize.ddsclient.connection.udp.UdpTrace;
import com.signiant.mobilize.ddsclient.connection.udp.packets.ConnectionPacket;
import com.signiant.mobilize.ddsclient.connection.udp.packets.DatagramBuffer;
import com.signiant.mobilize.ddsclient.connection.udp.packets.PacketType;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportAck;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportAck2;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportConnect;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportNak;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportPmtu;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportRedirect;
import com.signiant.mobilize.ddsclient.connection.udp.packets.TransportType;
import com.signiant.mobilize.ddsclient.util.DCLoggerWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.FileWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ProtocolException;
import java.net.SocketException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UdpSession {
    public static final int TRACE_BUFFER_SIZE = 50000;
    public static final String UDP_EXCEPTION = "exception";
    static final int PRF_PRTCL_VERSION = 6;
    static final int MIN_PRTCL_VERSION = 3;
    static final int MAX_PRTCL_VERSION = 6;
    static final int PRTCL_SANE = 5;
    static final int PRTCL_PMTU = 6;
    static final int UDP_MAX_BUFF_SIZE = 0x1000000;
    static final int UDP_MIN_BUFF_SIZE = 32768;
    static final int MAX_UDP_CONNECTIONS = 32;
    static final int MAX_AGGRESSIVENESS = 2;
    static final int DEF_AGGRESSIVENESS = 1;
    static final int MAX_BANDWIDTH = 100000;
    static final int DEF_MAX_BANDWIDTH = 0;
    static final int MIN_BANDWIDTH = 1;
    static final int DEF_MIN_BANDWIDTH = 0;
    static final int MIN_SEND_INTERVAL = 1;
    static final int MAX_SEND_INTERVAL = 200000;
    static final int MIN_ROUND_TRIP_TIME = 20000;
    static final long BASIC_INTERVAL = 10000L;
    static final long INITIAL_SEND_INTERVAL = 250L;
    static final long CONNECT_INTERVAL = 3000000L;
    static final long CONNECT_TIMEOUT = 18000000L;
    static final int SEQ_NUM_MAXIMUM = 0x40000000;
    static final int SEQ_NUM_THRESHOLD = 0x20000000;
    static final int ACK_SEQ_NUM_MAX = 65536;
    static final int ACK_SEQ_NUM_THRESHOLD = 32768;
    static final int MAX_FLOW_WIN_SIZE = 100000;
    static final int MIN_FLOW_WIN_SIZE = 32;
    static final int INITIAL_RECV_WIN_SIZE = 128;
    static final int INITIAL_PAYLOAD = 1024;
    public static final int MAX_V5_PAYLOAD = 1430;
    public static final int MAX_PAYLOAD = 1480;
    public static final int MIN_PAYLOAD = 300;
    private int requestedPayloadSize;
    public static final int DEF_TICKLE_INTERVAL = 16;
    public static final int MIN_TICKLE_INTERVAL = 5;
    public static final int MAX_TICKLE_INTERVAL = 60;
    public static final int DEF_TICKLE_THRESHOLD = 5000;
    public static final int MIN_TICKLE_THRESHOLD = 1;
    public static final int MAX_TICKLE_THRESHOLD = 10000;
    public static final int DEF_BURST_QUANTUM = 2000;
    public static final int MAX_BURST_QUANTUM = 10000;
    static final int DEFAULT_REPORT_INTERVAL = 1000000;
    static final int DEFAULT_RUNNING_INTERVALS = 10;
    public static final int MAX_SEND_COUNT = 500;
    static final int QUICKSTART_BURST = 32;
    static final int MIN_QUICKSTART_BURST = 4;
    static final int FAILED_QUCIKSTART_INTERVAL = 100000;
    static final int MIN_PKTS_PER_SR_CAPTURE_EXP = 100;
    static final int MIN_SR_CAPTURE_INTERVAL = 100000;
    static final int MAX_SR_CAPTURE_INTERVAL = 1000000;
    static final int SEND_RATE_INFO_ARRAY_SIZE = 1000;
    static final int DEFAULT_PROBE_INTERVAL = 5;
    static final int MIN_PROBE_INTERVAL = 2;
    static final int PACKET_LOSS_AVERAGING_INTERVALS = 10;
    static final int RTT_INFO_ARRAY_SIZE = 1024;
    static final int DEFAULT_NAK_DELAY = 10000;
    static final int MIN_RECV_QUEUE = 1;
    static final int MAX_RECV_QUEUE = 70;
    static final int DEFAULT_RECV_QUEUE = 35;
    static final int MIN_SEND_QUEUE = 1;
    static final int MAX_SEND_QUEUE = 35;
    static final int DEFAULT_SEND_QUEUE = 35;
    static final int MAX_RECV_QUEUE_LEN = 47297;
    static final int MAX_SEND_QUEUE_LEN = 23648;
    static final int DGBS_PER_ALLOCATION = 1000;
    static final int MAX_DGB_ALLOCATIONS = 341890;
    private int recvQueueSize = 47297;
    private int sendQueueSize = 23648;
    static final long IDLE_ACK_TIMER = 3000000L;
    static final int CNCT_RESPONSE = 1;
    static final int CNCT_MAX_PAYLOAD = 2;
    static final int CNCT_PORT_CHANGE_OK = 4;
    static final int ACK_RECV_STALLED = 1;
    static final int PMTU_PROBE = 1;
    static final int PMTU_RESPONSE = 2;
    static final int PMTU_CONFIRMATION = 4;
    static int[] pathMtuCheckSizeTable = new int[]{528, 1024, 1352, 1430, 1464};
    static int pathMtuCheckSizeTableSize = pathMtuCheckSizeTable.length;
    static int pathMtuDefault = 1024;
    static double[] rateIncrementFactor = new double[]{1.03, 1.04, 1.05};
    static int[] probeDelay = new int[]{8, 4, 2};
    static double[] rateDecrementFactor = new double[]{0.91, 0.93, 0.94};
    static double[] oldReceiveRateDegradationTolerance = new double[]{0.8, 0.75, 0.7};
    static double[] newReceiveRateDegradationTolerance = new double[]{0.9, 0.85, 0.8};
    static double[] packetLossTolerance = new double[]{0.01, 0.02, 0.03};
    static double[] sustainableSendRateThreshold = new double[]{0.95, 0.925, 0.9};
    private long finestParkNanos = 0L;
    private long finestSleepNanos = 0L;
    private boolean useLockSupport = false;
    private boolean useInterpacketDelay = false;
    private int eventWaitCount = 0;
    private long eventWaitCummulativeTimeActual = 0L;
    private long eventWaitCummulativeTimeRequested = 0L;
    private long desiredWaitTimeAccumulator = 0L;
    private long actualWaitTimeAccumulator = 0L;
    private int waitTimeCounter = 0;
    private long burstCountAccumulator = 0L;
    private long burstPacketsAccumulator = 0L;
    private long burstTimeAccumulator = 0L;
    private int timerTraceCounter = 0;
    private final Object bufferLock = new Object();
    protected static int SRI_ENTRY_VALID = 1;
    protected static int SRI_MEASUREMENT_ENTRY = 2;
    protected static int SRI_RATE_PROBE = 4;
    protected static int SRI_SENDS_COMPLETE = 8;
    UdpTrace traceCtx;
    ReentrantLock lock;
    Condition event;
    IOException lastError;
    InetSocketAddress remoteAddress;
    InetSocketAddress relayAddress;
    DatagramSocket socket;
    DatagramChannel channel;
    private final DatagramBuffer ackPkt;
    private final DatagramBuffer ack2Pkt;
    private final DatagramBuffer nakPkt;
    private final DatagramBuffer cnctPkt;
    private final DatagramBuffer kpalvPkt;
    private final DatagramBuffer shtdnPkt;
    private final DatagramBuffer rstPkt;
    private final DatagramBuffer pmtuPkt;
    private boolean memoryCapReached;
    boolean relayedConnection;
    boolean sendEnableSignalled;
    State state;
    boolean udpTerminating;
    boolean allowCnctPortChange;
    UdpConnection[] connectionTable;
    int cnctScanStartIdx;
    UdpThread udpThread;
    Logger sessionLog;
    Logger protocolLog;
    Logger connectionLog;
    int udpAggressiveness;
    long udpMinBandwidth;
    long udpMaxBandwidth;
    int tickleCounter;
    int tickleInterval;
    double tickleThreshold;
    int localUdpPortNumber;
    int localUdpPortRange;
    int protocolVersion;
    int payloadSize;
    boolean negotiateMaxPayload;
    int recvBandwidth;
    int curr_ack_seq;
    int curr_cnct_seq;
    int last_ack_seq;
    long cpktsReceived;
    long cpktBytesReceived;
    long cpktsSent;
    long cpktBytesSent;
    long cpktsResent;
    long cpktBytesResent;
    long cpktsLost;
    long cpktsRejectedDuplicate;
    long cpktsRejectedLeft;
    long cpktsRejectedRight;
    int transportPktsReceived;
    int transportPktsSent;
    int ackPktsReceived;
    int ackPktsSent;
    int ack2PktsReceived;
    int ack2PktsSent;
    int cnctPktsReceived;
    int cnctPktsSent;
    int nakPktsReceived;
    int nakPktsSent;
    int kpalvPktsReceived;
    int kpalvPktsSent;
    int shtdnPktsReceived;
    int shtdnPktsSent;
    int rstPktsReceived;
    int rstPktsSent;
    int pmtuPktsReceived;
    int pmtuPktsSent;
    int pmtuBytesTransferred;
    long pmtuStartTime;
    long pmtuEndTime;
    int pmtuSequence;
    int pmtuMaxSequence;
    LinkedList<select_wait_blk> udpSelectWaitList;
    int recvWindowSize;
    AtomicInteger recvCpktQueueCount;
    int recvWindowHighWaterMark;
    int recvMissingCount;
    boolean sendStalled;
    boolean sendsPaused;
    boolean recvStalled;
    boolean remoteRecvStalled;
    boolean tracedSocketFull;
    int recvQueueFilledCount;
    DatagramBuffer[] recvWindow;
    int recvWindowArraySize;
    int recvWindowLeftIndex;
    int recvWindowLeftSeq;
    int recvWindowCount;
    int recvInitialSeq;
    int recvCurrentSeq;
    int lastAckSentSeq;
    int lastAckRecvdSeq;
    int lastAckRecvdSeqCount;
    int lastAckAcknowlegedSeq;
    int nextSenderSeq;
    LinkedList<DatagramBuffer> sendCpktQueue;
    int sendCpktQueueCount;
    boolean sendQueueWasEmptied;
    DatagramBuffer blockedResendPacket;
    boolean quickstartRecvRateMeasurement;
    int quickstartStartWindowIdx;
    int quickstartEndWindowIdx;
    int quickstartBurstSize;
    int udpNegotiatedFlowWindowSize;
    int sendWindowSize;
    int sendWindowHighWaterMark;
    int sendWindowFilledCount;
    long sendStalledStartTime;
    long sendWindowStalledTime;
    int unackedPktCount;
    long cpktsAcked;
    long cpktsAckedStats;
    long cpktBytesAcked;
    long cpktBytesAckedStats;
    long cpktsFromApplication;
    long cpktsToApplication;
    DatagramBuffer[] sendWindow;
    int sendWindowArraySize;
    int sendWindowLeftIndex;
    int sendWindowLeftSeq;
    int sendInitialSeq;
    int sendCurrentSeq;
    long nakDelay;
    int pktsInLastAckInterval;
    int lastAckRecvSeq;
    loss_report lossReportList;
    loss_report lossReportListEnd;
    loss_report freeLossReports;
    nak_descriptor nakDescriptorList;
    nak_descriptor nakDescriptorListEnd;
    nak_descriptor freeNakDescriptors;
    long nextAckTime;
    long nextAckExpTime;
    long nextSendTime;
    long resumeSendTime;
    long maxSendInterval;
    long minSendInterval;
    long bestSustainedInterval;
    long minProbedInterval;
    long reportInterval;
    int runningReportIntervals;
    long nextRecvReportTime;
    long lastRecvReportTime;
    long lastRecvPktCount;
    long lastRecvAppCount;
    int lastRecvQueueFilledCount;
    long nextSendReportTime;
    long lastSendReportTime;
    long lastSendPktCount;
    long lastResendPktCount;
    long lastSendAppCount;
    long lastSendsStalledTime;
    int lastSendsStalledCount;
    int runningIdx;
    double[] runningRate;
    double[] runningApplRate;
    double[] runningLossRate;
    long ackInterval;
    long sendInterval;
    int shutdownAttemptCount;
    int connectRoundTripTime;
    int baseRoundTripTime;
    int averageRoundTripTime;
    int shortRoundTripTimeCounter;
    int shortRoundTripTimeAccumulator;
    int longRoundTripTimeCounter;
    int longRoundTripTimeAccumulator;
    long packetsSentBaseline;
    int packetsSentCounter;
    long packetsSentAverage;
    long packetsReceivedBaseline;
    int packetsReceivedCounter;
    long packetsReceivedAverage;
    int remoteReceiveRate;
    long packetsAckedBaseline;
    long packetsLostBaseline;
    long recvRateBaseTime;
    long recvRateBaseCpktCount;
    long lastCpktRecvTime;
    int recvRate;
    double[] runningIntervalLossRate;
    int runningIntervalLossCount;
    protected send_rate_info[] sri_array;
    int sri_array_idx;
    int sri_array_size;
    int sri_last_acked_idx;
    int probeSupressCount;
    int sendRateCaptureInterval;
    boolean probesPaused;
    int probeInterval;
    boolean bandwidthMeasured;
    int burstQuantum;
    int pktLossTolerance;
    long cummulativeRtt;
    int rttCount;
    int receiverRoundTripTime;
    rtt_info[] rtt_info_array;
    int rtt_info_array_idx;
    int rtt_info_array_size;
    Buffers buffers;
    MicrosecondTimer usTimer;
    String id;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public int getCurrentPayloadSize() {
        return this.payloadSize;
    }

    public int getMaxRecvQueue() {
        return this.recvQueueSize;
    }

    public int getMaxSendQueue() {
        return this.sendQueueSize;
    }

    protected void setRecvWindowSize(int size, short changeTypeCode) {
        int roundTripTime = this.baseRoundTripTime;
        if (roundTripTime < 20000) {
            roundTripTime = 20000;
        }
        if ((this.recvWindowSize = size) >= 100000) {
            this.recvWindowSize = 99999;
        } else if (this.recvWindowSize < 32) {
            this.recvWindowSize = 32;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.NEW_WINDOW_SIZE, changeTypeCode, (short)-1, (short)0, this.recvWindowSize, roundTripTime, this.recvRate);
        if (this.recvWindowSize > this.recvWindowHighWaterMark) {
            this.recvWindowHighWaterMark = this.recvWindowSize;
        }
    }

    protected void setSendWindowSize(int size, short changeTypeCode) {
        if (size != this.sendWindowSize) {
            this.sendWindowSize = size;
            if (this.sendWindowSize >= 100000) {
                this.sendWindowSize = 99999;
            } else if (this.sendWindowSize < 32) {
                this.sendWindowSize = 32;
            }
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.NEW_WINDOW_SIZE, changeTypeCode, (short)-1, (short)1, 0L, this.sendWindowSize, 0);
            if (this.sendWindowSize > this.sendWindowHighWaterMark) {
                this.sendWindowHighWaterMark = this.sendWindowSize;
            }
        }
    }

    UdpSession(int maxConnections, String logInstance, String id, int traceMask) throws UdpBaseException {
        int i;
        this.id = id;
        this.lock = new ReentrantLock(true);
        this.event = this.lock.newCondition();
        this.lastError = null;
        this.remoteAddress = null;
        this.socket = null;
        this.channel = null;
        this.relayedConnection = false;
        this.allowCnctPortChange = false;
        this.sendEnableSignalled = false;
        this.state = State.IDLE;
        this.udpTerminating = false;
        this.useLockSupport = false;
        this.connectionTable = new UdpConnection[maxConnections];
        this.cnctScanStartIdx = 0;
        this.traceCtx = new UdpTrace(traceMask, 50000);
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRACE_INITIALIZED, (short)-1, (short)-1, (short)-1, traceMask, 0, 0);
        this.udpThread = null;
        if (logInstance == "DCLogger") {
            DCLoggerWrapper dcLoggerWrapper = new DCLoggerWrapper();
            this.sessionLog = dcLoggerWrapper;
            this.protocolLog = dcLoggerWrapper;
            this.connectionLog = dcLoggerWrapper;
        } else {
            String logBase = "com.signiant.interactivetransfer.engine";
            this.sessionLog = Logger.getLogger(logBase + logInstance + ".session");
            this.protocolLog = Logger.getLogger(logBase + logInstance + ".protocol");
            this.connectionLog = Logger.getLogger(logBase + logInstance + ".connection");
        }
        this.usTimer = MicrosecondTimer.getInstance();
        this.udpAggressiveness = 1;
        this.protocolVersion = 0;
        this.payloadSize = 1024;
        this.requestedPayloadSize = 1024;
        this.recvBandwidth = 0;
        this.sendInterval = 250L;
        this.tickleInterval = 16;
        this.tickleThreshold = 5000.0;
        this.negotiateMaxPayload = true;
        this.quickstartRecvRateMeasurement = false;
        this.ackInterval = 10000L;
        this.quickstartBurstSize = 32;
        this.ackPkt = new DatagramBuffer(this, TransportType.ACK);
        this.ack2Pkt = new DatagramBuffer(this, TransportType.ACK2);
        this.nakPkt = new DatagramBuffer(this, TransportType.NAK);
        this.cnctPkt = new DatagramBuffer(this, TransportType.CONNECT);
        this.kpalvPkt = new DatagramBuffer(this, TransportType.KEEPALIVE);
        this.shtdnPkt = new DatagramBuffer(this, TransportType.SHUTDOWN);
        this.rstPkt = new DatagramBuffer(this, TransportType.RESET);
        this.pmtuPkt = new DatagramBuffer(this, TransportType.PMTU);
        this.memoryCapReached = false;
        this.curr_ack_seq = 0;
        this.curr_cnct_seq = 0;
        this.last_ack_seq = 0;
        this.cpktsReceived = 0L;
        this.cpktsSent = 0L;
        this.cpktsResent = 0L;
        this.cpktsRejectedDuplicate = 0L;
        this.cpktsRejectedLeft = 0L;
        this.cpktsRejectedRight = 0L;
        this.cpktBytesReceived = 0L;
        this.cpktBytesSent = 0L;
        this.cpktBytesResent = 0L;
        this.cpktsAcked = 0L;
        this.cpktsAckedStats = 0L;
        this.cpktBytesAcked = 0L;
        this.cpktBytesAckedStats = 0L;
        this.transportPktsReceived = 0;
        this.transportPktsSent = 0;
        this.ackPktsReceived = 0;
        this.ackPktsSent = 0;
        this.ack2PktsReceived = 0;
        this.ack2PktsSent = 0;
        this.cnctPktsReceived = 0;
        this.cnctPktsSent = 0;
        this.nakPktsReceived = 0;
        this.nakPktsSent = 0;
        this.kpalvPktsReceived = 0;
        this.kpalvPktsSent = 0;
        this.shtdnPktsReceived = 0;
        this.shtdnPktsSent = 0;
        this.rstPktsReceived = 0;
        this.rstPktsSent = 0;
        this.udpSelectWaitList = new LinkedList();
        this.recvWindowHighWaterMark = 0;
        this.sendStalled = false;
        this.recvWindow = new DatagramBuffer[100000];
        this.recvWindowArraySize = 100000;
        this.recvWindowLeftIndex = 0;
        this.recvWindowLeftSeq = 0;
        this.recvInitialSeq = 0;
        this.recvCurrentSeq = 0;
        this.lastAckSentSeq = 0;
        this.lastAckRecvdSeq = 0;
        this.lastAckAcknowlegedSeq = 0;
        this.nextSenderSeq = 0;
        this.recvCpktQueueCount = new AtomicInteger();
        this.recvCpktQueueCount.set(0);
        this.minSendInterval = 1L;
        this.maxSendInterval = 200000L;
        this.udpNegotiatedFlowWindowSize = 0;
        this.sendWindowFilledCount = 0;
        this.unackedPktCount = 0;
        this.burstQuantum = 2000;
        this.sendWindow = new DatagramBuffer[100000];
        this.sendWindowArraySize = 100000;
        this.sendWindowLeftIndex = 0;
        this.sendWindowLeftSeq = 0;
        this.sendInitialSeq = 0;
        this.sendCurrentSeq = 0;
        this.buffers = new Buffers();
        this.sendWindowSize = 0;
        this.recvWindowSize = 0;
        this.sendCpktQueue = new LinkedList();
        this.sendCpktQueueCount = 0;
        this.blockedResendPacket = null;
        this.lossReportList = null;
        this.lossReportListEnd = null;
        this.nextAckExpTime = this.nextAckTime = this.usTimer.get() + 3000000L;
        this.nextSendTime = this.nextAckTime;
        this.resumeSendTime = 0L;
        this.nakDelay = 10000L;
        this.reportInterval = 1000000L;
        this.runningReportIntervals = 10;
        this.lastSendReportTime = this.usTimer.get();
        this.nextSendReportTime = this.lastSendReportTime + this.reportInterval;
        this.lastSendPktCount = 0L;
        this.lastSendsStalledTime = 0L;
        this.lastSendsStalledCount = 0;
        this.lastRecvReportTime = this.usTimer.get();
        this.nextRecvReportTime = this.lastRecvReportTime + this.reportInterval;
        this.lastRecvPktCount = 0L;
        this.lastRecvQueueFilledCount = 0;
        this.recvQueueFilledCount = 0;
        this.runningIdx = 0;
        this.runningRate = new double[10];
        this.runningApplRate = new double[10];
        this.runningLossRate = new double[10];
        this.runningIntervalLossRate = new double[10];
        this.runningIntervalLossCount = 0;
        this.ackInterval = 10000L;
        if (this.udpMaxBandwidth > 0L) {
            this.sendInterval = 1000000L / this.udpMaxBandwidth;
        }
        this.shutdownAttemptCount = 0;
        this.baseRoundTripTime = 0;
        this.averageRoundTripTime = 20000;
        this.cummulativeRtt = 0L;
        this.rttCount = 0;
        this.rtt_info_array = new rtt_info[1024];
        this.rtt_info_array_idx = 0;
        this.rtt_info_array_size = 1024;
        for (i = 0; i < this.rtt_info_array.length; ++i) {
            this.rtt_info_array[i] = new rtt_info();
        }
        this.sri_array = new send_rate_info[1000];
        this.sri_array_idx = 0;
        this.sri_array_size = 1000;
        for (i = 0; i < this.sri_array.length; ++i) {
            this.sri_array[i] = new send_rate_info();
        }
        this.sri_array[0].sri_send_interval = this.sendInterval;
    }

    void increment_recv_queue_count() {
        this.recvCpktQueueCount.incrementAndGet();
    }

    void decrement_recv_queue_count() {
        this.recvCpktQueueCount.decrementAndGet();
    }

    void decrement_recv_queue_count(int count) {
        this.recvCpktQueueCount.addAndGet(-count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dgb_enqueue(DatagramBuffer dgb) {
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DGB_ENQUEUED_SEND, ConnectionPacket.src_id(dgb), ConnectionPacket.tgt_id(dgb), ConnectionPacket.type(dgb), dgb.getBufferId(), dgb.length(), 0);
        LinkedList<DatagramBuffer> linkedList = this.sendCpktQueue;
        synchronized (linkedList) {
            boolean kickSender = false;
            if (this.sendCpktQueue.isEmpty()) {
                kickSender = true;
            }
            this.sendCpktQueue.offer(dgb);
            ++this.sendCpktQueueCount;
            if (dgb.packetType() == PacketType.DATA) {
                ++this.cpktsFromApplication;
            }
            if (!this.sendsPaused && (this.state == State.CONNECTED || this.state == State.CLOSE_PENDING) && kickSender) {
                long currTime = this.usTimer.get();
                this.nextSendTime = currTime > this.resumeSendTime ? currTime : this.resumeSendTime;
                this.resumeSendTime = 0L;
                this.enable_udp_send_without_send_time_change();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dgb_enqueue(Queue<DatagramBuffer> dgbList) {
        if (dgbList.size() > 0) {
            LinkedList<DatagramBuffer> linkedList = this.sendCpktQueue;
            synchronized (linkedList) {
                DatagramBuffer dgb;
                boolean kickSender = false;
                if (this.sendCpktQueue.isEmpty()) {
                    kickSender = true;
                }
                while ((dgb = dgbList.poll()) != null) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DGB_ENQUEUED_SEND, ConnectionPacket.src_id(dgb), ConnectionPacket.tgt_id(dgb), ConnectionPacket.type(dgb), dgb.getBufferId(), dgb.length(), 0);
                    if (dgb.packetType() == PacketType.DATA) {
                        ++this.cpktsFromApplication;
                    }
                    this.sendCpktQueue.offer(dgb);
                    ++this.sendCpktQueueCount;
                }
                if (!this.sendsPaused && (this.state == State.CONNECTED || this.state == State.CLOSE_PENDING) && kickSender) {
                    long currTime = this.usTimer.get();
                    this.nextSendTime = currTime > this.resumeSendTime ? currTime : this.resumeSendTime;
                    this.resumeSendTime = 0L;
                    this.enable_udp_send_without_send_time_change();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DatagramBuffer dgb_pop() {
        DatagramBuffer dgb = null;
        LinkedList<DatagramBuffer> linkedList = this.sendCpktQueue;
        synchronized (linkedList) {
            dgb = this.sendCpktQueue.poll();
            if (dgb != null) {
                --this.sendCpktQueueCount;
            }
        }
        return dgb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dgb_push(DatagramBuffer dgb) {
        LinkedList<DatagramBuffer> linkedList = this.sendCpktQueue;
        synchronized (linkedList) {
            if (ConnectionPacket.type(dgb) == PacketType.MEASUREMENT.code()) {
                this.buffers.putback(dgb);
            } else {
                this.sendCpktQueue.addFirst(dgb);
                ++this.sendCpktQueueCount;
            }
        }
    }

    int send_data_pkt(DatagramBuffer dgb) {
        int writeLen;
        try {
            writeLen = dgb.write(this.channel);
            this.tracedSocketFull = false;
        }
        catch (WouldBlockException e) {
            if (!this.tracedSocketFull) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_FULL, (short)-1, (short)-1, (short)0, 0L, 0, 0);
                this.tracedSocketFull = true;
            }
            writeLen = 0;
        }
        catch (PacketResentCountExceededException e) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.PACKET_RETRANSMISSION_COUNT_EXCEEDED, (short)-1, (short)-1, (short)0, 0L, ConnectionPacket.sequence(dgb), 0);
            this.sessionLog.severe("Retransmisstion count exceeded for packet sequence " + ConnectionPacket.sequence(dgb));
            this.abort(e);
            writeLen = -1;
        }
        catch (IOException e) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_WRITE_ERROR, (short)-1, (short)-1, ConnectionPacket.type(dgb), 0L, 0, 0);
            this.sessionLog.severe("Socket send error: " + e.getMessage());
            this.abort(e);
            writeLen = -1;
        }
        return writeLen;
    }

    int udp_send_check() throws IOException, UdpBaseException {
        UdpConnection cnp = null;
        send_rate_info srip = this.sri_array[this.sri_array_idx];
        int actualSentCount = 0;
        long maxAckExpDelay = (long)this.receiverRoundTripTime + 20000L;
        long dataPktsSent = 0L;
        long burstCount = (srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0 ? (long)srip.sri_pkts_remaining : (this.burstQuantum == 0 ? 1L : (long)this.burstQuantum / srip.sri_send_interval + 1L);
        if (this.sendInterval > maxAckExpDelay) {
            maxAckExpDelay = this.sendInterval;
        }
        long burstStartTime = this.usTimer.get();
        while (burstCount > 0L) {
            long currTime = this.usTimer.get();
            if (this.useInterpacketDelay) {
                long elapsedUs = currTime - burstStartTime;
                if (actualSentCount > 0 && elapsedUs > 0L) {
                    long packetsSentPerMilliSecond = (long)(actualSentCount * 1000) / elapsedUs;
                    long packetsWantedPerMilliSecond = 1000L / this.sendInterval;
                    while (packetsSentPerMilliSecond > packetsWantedPerMilliSecond * 2L) {
                        if (packetsSentPerMilliSecond > packetsWantedPerMilliSecond * 10L) {
                            try {
                                Thread.sleep(0L, 100);
                            }
                            catch (InterruptedException discard) {
                                // empty catch block
                            }
                        }
                        Thread.yield();
                        currTime = this.usTimer.get();
                        elapsedUs = currTime - burstStartTime;
                        packetsSentPerMilliSecond = (long)(actualSentCount * 1000) / elapsedUs;
                    }
                }
            }
            switch (this.state) {
                case IDLE: 
                case ACCEPTING: 
                case TERMINATING: 
                case CLOSE_WAIT: {
                    this.nextSendTime = currTime + 3000000L;
                    burstCount = 0L;
                    break;
                }
                case CONNECTING: {
                    this.send_transport_connect();
                    ++actualSentCount;
                    burstCount = 0L;
                    break;
                }
                case ACCEPT_CMPLT_WAIT: {
                    this.send_transport_connect();
                    ++actualSentCount;
                    burstCount = 0L;
                    break;
                }
                case CONNECT_CMPLT_WAIT: {
                    if (this.nextAckTime - currTime <= 0L) {
                        this.send_transport_ack();
                    }
                    burstCount = 0L;
                    break;
                }
                case PMTU_DETERMINATION_SERVER: {
                    int rtt = (int)((long)this.connectRoundTripTime - 10000L);
                    if (rtt < 0) {
                        rtt = 0;
                    }
                    long elapsedTime = this.pmtuEndTime - this.pmtuStartTime - (long)rtt;
                    double speedBytesPerSec = (double)this.pmtuBytesTransferred * 1000000.0 / (double)elapsedTime;
                    this.recvRate = (int)Math.ceil(speedBytesPerSec / (double)(this.payloadSize + 8));
                    this.sendInterval = (long)Math.ceil(1000000.0 / (double)this.recvRate);
                    if (this.sendInterval < 250L) {
                        this.sendInterval = 250L;
                        this.recvRate = (int)Math.ceil(1000000.0 / (double)this.sendInterval);
                    }
                    this.recompute_send_interval_limits();
                    this.send_transport_pmtu(4, this.pmtuSequence++, this.payloadSize);
                    this.nextAckTime = this.nextSendTime = currTime + (long)this.baseRoundTripTime + 200000L;
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
                    burstCount = 0L;
                    break;
                }
                case PMTU_DETERMINATION_CLIENT: 
                case PMTU_RESULT_WAIT_CLIENT: {
                    this.send_transport_pmtu(4, this.pmtuSequence++, this.payloadSize);
                    this.nextSendTime = currTime + (long)this.baseRoundTripTime + 200000L;
                    burstCount = 0L;
                    break;
                }
                case CONNECTED: 
                case CLOSE_PENDING: 
                case CLOSING: {
                    int seqNum;
                    DatagramBuffer dgbp = this.get_next_lost_packet();
                    if (dgbp != null) {
                        seqNum = ConnectionPacket.sequence(dgbp);
                        if (this.send_data_pkt(dgbp) <= 0) {
                            this.blockedResendPacket = dgbp;
                            burstCount = 0L;
                            break;
                        }
                        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_RESENT, ConnectionPacket.src_id(dgbp), ConnectionPacket.tgt_id(dgbp), ConnectionPacket.type(dgbp), ConnectionPacket.sequence(dgbp), dgbp.length(), 0);
                        ++this.cpktsResent;
                        this.cpktBytesResent += (long)dgbp.length();
                        this.update_send_rate_loss_info(seqNum);
                        srip = this.capture_send_rate_info(SEND_RATE_INFO_TYPES.PACKET_RESENT, seqNum);
                        --burstCount;
                        ++actualSentCount;
                        ++dataPktsSent;
                        this.nextSendTime += srip.sri_send_interval;
                        this.nextAckExpTime = currTime + maxAckExpDelay;
                        break;
                    }
                    if (this.unackedPktCount >= this.sendWindowSize) {
                        if (!this.sendStalled) {
                            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_FLOW_WINDOW_FULL, (short)-1, (short)-1, (short)0, this.sendWindowSize, this.sendCurrentSeq, this.unackedPktCount);
                            ++this.sendWindowFilledCount;
                            this.sendStalledStartTime = currTime;
                            this.sendStalled = true;
                        } else if (currTime >= this.nextAckExpTime) {
                            if (this.remoteRecvStalled) {
                                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_FLOW_WINDOW_FULL, (short)-1, (short)-1, (short)1, this.sendWindowSize, this.sendCurrentSeq, this.unackedPktCount);
                            } else if (this.resend_last_packet_in_window() == 1) {
                                ++actualSentCount;
                                ++dataPktsSent;
                            }
                        }
                        burstCount = 0L;
                        this.nextSendTime = this.nextAckExpTime = currTime + maxAckExpDelay;
                        srip = this.capture_send_rate_info(SEND_RATE_INFO_TYPES.SENDS_STALLED, -1);
                        break;
                    }
                    if (this.unackedPktCount > 0 && currTime >= this.nextAckExpTime && (this.sendCpktQueueCount == 0 || this.sendStalled || this.sendsPaused)) {
                        if (this.resend_last_packet_in_window() == 1) {
                            ++actualSentCount;
                            ++dataPktsSent;
                        }
                        burstCount = 0L;
                        this.nextSendTime = this.nextAckExpTime = currTime + maxAckExpDelay;
                        srip = this.capture_send_rate_info(SEND_RATE_INFO_TYPES.SENDS_STALLED, -1);
                        break;
                    }
                    boolean cpktSent = false;
                    dgbp = null;
                    if (!this.sendsPaused && !this.sendStalled) {
                        srip = this.sri_array[this.sri_array_idx];
                        dgbp = this.dgb_pop();
                        if (dgbp != null) {
                            seqNum = this.sendCurrentSeq;
                            ConnectionPacket.sequence(dgbp, seqNum);
                            if ((srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0) {
                                ConnectionPacket.flags(dgbp, (byte)4);
                                if (srip.sri_pkts_send_count == srip.sri_pkts_remaining) {
                                    ConnectionPacket.flags(dgbp, (byte)1);
                                } else if (srip.sri_pkts_remaining == 1) {
                                    ConnectionPacket.flags(dgbp, (byte)2);
                                }
                            }
                            if (this.send_data_pkt(dgbp) <= 0) {
                                this.dgb_push(dgbp);
                                burstCount = 0L;
                                break;
                            }
                            this.sendCurrentSeq = (this.sendCurrentSeq + 1) % 0x40000000;
                            ++this.unackedPktCount;
                            ++this.cpktsSent;
                            this.cpktBytesSent += (long)dgbp.length();
                            ++actualSentCount;
                            --burstCount;
                            ++dataPktsSent;
                            cpktSent = true;
                            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_SENT, ConnectionPacket.src_id(dgbp), ConnectionPacket.tgt_id(dgbp), ConnectionPacket.type(dgbp), seqNum, dgbp.length(), this.unackedPktCount);
                            srip = this.capture_send_rate_info(SEND_RATE_INFO_TYPES.PACKET_SENT, seqNum);
                            int seqGap = seqNum - this.sendWindowLeftSeq;
                            if (seqGap < 0) {
                                seqGap += 0x40000000;
                            }
                            int winIdx = (this.sendWindowLeftIndex + seqGap) % this.sendWindowArraySize;
                            this.sendWindow[winIdx] = dgbp;
                            if (dgbp.packetType() == PacketType.DATA || dgbp.packetType() == PacketType.SHUTDOWN) {
                                cnp = this.connectionTable[ConnectionPacket.src_id(dgbp)];
                                if (dgbp.packetType() == PacketType.DATA) {
                                    ++cnp.data_pkts_sent;
                                    cnp.bytes_sent += (long)(dgbp.length() - 8);
                                }
                                switch (cnp.state) {
                                    case CONNECTED: 
                                    case CLOSE_WAIT: {
                                        if (cnp.send_event_posted || this.sendCpktQueueCount >= this.getMaxSendQueue() / 2) break;
                                        cnp.post_send_event();
                                        break;
                                    }
                                    case CLOSED: 
                                    case CLOSING: {
                                        if (dgbp.packetType() != PacketType.SHUTDOWN) break;
                                        cnp.post_shutdown_event();
                                        if (!cnp.destroy_when_send_empty) break;
                                        cnp.release_resources();
                                    }
                                }
                            }
                        }
                    }
                    if (cpktSent) {
                        this.nextAckExpTime = currTime + maxAckExpDelay;
                        this.nextSendTime += srip.sri_send_interval;
                        this.sendQueueWasEmptied = false;
                    } else {
                        burstCount = 0L;
                        if (!(this.sendQueueWasEmptied || this.sendsPaused || this.sendStalled)) {
                            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_QUEUE_EMPTY, (short)-1, (short)-1, (short)-1, 0L, 0, 0);
                            this.sendQueueWasEmptied = true;
                            this.resumeSendTime = this.nextSendTime + srip.sri_send_interval;
                        }
                        this.nextSendTime = this.unackedPktCount == 0 ? currTime + 3000000L : (this.nextAckExpTime = currTime + maxAckExpDelay);
                        srip = this.capture_send_rate_info(SEND_RATE_INFO_TYPES.SENDS_STALLED, -1);
                    }
                    if (this.state == State.CLOSE_PENDING) {
                        if (this.sendCpktQueueCount != 0 || this.unackedPktCount != 0) break;
                        this.setState(State.CLOSING);
                        this.send_transport_shutdown();
                        --this.shutdownAttemptCount;
                        burstCount = 0L;
                        this.nextSendTime = currTime + maxAckExpDelay;
                        break;
                    }
                    if (this.state != State.CLOSING) break;
                    if (this.shutdownAttemptCount > 0) {
                        this.send_transport_shutdown();
                        --this.shutdownAttemptCount;
                        this.nextSendTime = currTime + maxAckExpDelay;
                    } else {
                        this.lastError = new TimedOutException();
                        this.setState(State.TERMINATING);
                        this.event.signalAll();
                        this.nextSendTime = currTime + maxAckExpDelay;
                    }
                    burstCount = 0L;
                }
            }
        }
        if (dataPktsSent > 0L) {
            long burstEndTime = this.usTimer.get();
            ++this.burstCountAccumulator;
            this.burstPacketsAccumulator += dataPktsSent;
            this.burstTimeAccumulator += burstEndTime - burstStartTime;
        }
        return actualSentCount;
    }

    int resend_last_packet_in_window() {
        int seqGap = this.sendCurrentSeq - 1 - this.sendWindowLeftSeq;
        if (seqGap < 0) {
            seqGap += 0x40000000;
        }
        if (seqGap < 0x20000000) {
            int winIdx = (this.sendWindowLeftIndex + seqGap) % this.sendWindowArraySize;
            DatagramBuffer dgbp = this.sendWindow[winIdx];
            int seqNum = ConnectionPacket.sequence(dgbp);
            if (this.send_data_pkt(dgbp) <= 0) {
                return 0;
            }
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_RESENT, ConnectionPacket.src_id(dgbp), ConnectionPacket.tgt_id(dgbp), ConnectionPacket.type(dgbp), ConnectionPacket.sequence(dgbp), dgbp.length(), 0);
            ++this.cpktsResent;
            this.cpktBytesResent += (long)dgbp.length();
            this.capture_send_rate_info(SEND_RATE_INFO_TYPES.PACKET_RESENT, seqNum);
            return 1;
        }
        return 0;
    }

    void send_transport_connect() throws IOException {
        int addr;
        int maxConnectSeq = 6;
        if (this.curr_cnct_seq > maxConnectSeq) {
            this.abort(new TimedOutException());
            return;
        }
        this.curr_ack_seq = 0;
        DatagramSocket sock = this.channel.socket();
        InetSocketAddress local = new InetSocketAddress(sock.getLocalAddress(), sock.getLocalPort());
        this.cnctPkt.rewind();
        TransportConnect.protocol_version(this.cnctPkt, (byte)this.protocolVersion);
        TransportConnect.max_payload(this.cnctPkt, (short)this.payloadSize);
        TransportConnect.initial_sequence(this.cnctPkt, this.sendInitialSeq);
        TransportConnect.flow_window_size(this.cnctPkt, this.recvWindowSize);
        TransportConnect.seq_number(this.cnctPkt, this.curr_cnct_seq);
        TransportConnect.bandwidth(this.cnctPkt, 4000);
        TransportConnect.flags(this.cnctPkt, 0);
        if (this.negotiateMaxPayload) {
            TransportConnect.flags(this.cnctPkt, TransportConnect.flags(this.cnctPkt) | 2);
        }
        if (this.state != State.CONNECTING) {
            TransportConnect.flags(this.cnctPkt, TransportConnect.flags(this.cnctPkt) | 1);
        }
        TransportConnect.src(this.cnctPkt, local);
        TransportConnect.tgt(this.cnctPkt, this.remoteAddress);
        long currTime = this.usTimer.get();
        this.cnctPkt.write(this.channel);
        ++this.transportPktsSent;
        ++this.cnctPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, (short)this.curr_cnct_seq, (short)TransportConnect.flags(this.cnctPkt), TransportType.CONNECT.code(), this.protocolVersion, this.recvRate, this.sendInitialSeq);
        InetAddress inetAddress = this.remoteAddress.getAddress();
        if (inetAddress != null) {
            byte[] byteAddr = inetAddress.getAddress();
            addr = byteAddr[0] << 24 | byteAddr[1] << 16 & 0xFF0000 | byteAddr[2] << 8 & 0xFF00 | byteAddr[3] & 0xFF;
        } else {
            addr = 0;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)this.payloadSize, (short)-1, TransportType.CONNECT.code(), this.recvWindowSize, addr, this.remoteAddress.getPort());
        if (this.state == State.CONNECTING) {
            rtt_info rttip = this.rtt_info_array[this.curr_ack_seq];
            ++this.curr_cnct_seq;
            rttip.entry_valid = true;
            rttip.sequence = this.sendInitialSeq;
            rttip.ack_sequence = 0;
            rttip.send_time = currTime;
        }
        this.nextAckTime = this.nextSendTime = currTime + 3000000L;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, 3000000L, 0, 0);
    }

    void send_transport_ack() throws IOException {
        rtt_info rttip;
        int ackSequence;
        boolean lostPackets = false;
        boolean recvQueueFull = false;
        short pktBlocked = 0;
        int ackedCount = 0;
        byte ackFlags = 0;
        long currTime = this.usTimer.get();
        switch (this.state) {
            case CONNECTING: {
                return;
            }
            case CONNECT_CMPLT_WAIT: {
                if (this.protocolVersion < 5) {
                    ackSequence = this.recvCurrentSeq;
                    break;
                }
                ackSequence = this.recvInitialSeq;
                break;
            }
            case CLOSE_WAIT: 
            case CONNECTED: 
            case CLOSE_PENDING: 
            case CLOSING: {
                DatagramBuffer dgbp;
                int seqGap = this.recvCurrentSeq - this.lastAckSentSeq;
                if (seqGap < 0) {
                    seqGap += 0x40000000;
                }
                if ((this.pktsInLastAckInterval = this.recvCurrentSeq - this.lastAckRecvSeq) < 0) {
                    this.pktsInLastAckInterval += 0x40000000;
                }
                this.lastAckRecvSeq = this.recvCurrentSeq;
                int lastAckAckSeq = this.curr_ack_seq - 1;
                if (lastAckAckSeq < 0) {
                    lastAckAckSeq += 65536;
                }
                rttip = this.rtt_info_array[lastAckAckSeq % this.rtt_info_array_size];
                ackSequence = this.recvWindowLeftSeq - 1;
                if (ackSequence < 0) {
                    ackSequence += 0x40000000;
                }
                if (seqGap == 0 && this.lastAckSentSeq == this.recvCurrentSeq && !rttip.entry_valid) {
                    this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_IDLE);
                    break;
                }
                while ((dgbp = this.recvWindow[this.recvWindowLeftIndex]) != null) {
                    if (!this.demux_received_connection_packet(dgbp)) {
                        recvQueueFull = true;
                        ++this.recvQueueFilledCount;
                        seqGap = this.recvCurrentSeq + 1 - this.recvWindowLeftSeq;
                        if (seqGap < 0) {
                            seqGap += 0x40000000;
                        }
                        if (seqGap < this.recvWindowSize) break;
                        ackFlags = (byte)(ackFlags | 1);
                        break;
                    }
                    ++ackedCount;
                    this.recvWindow[this.recvWindowLeftIndex] = null;
                    --this.recvWindowCount;
                    ackSequence = this.recvWindowLeftSeq;
                    if (this.quickstartRecvRateMeasurement && this.recvWindowLeftIndex == this.quickstartStartWindowIdx) {
                        this.quickstartStartWindowIdx = (this.quickstartStartWindowIdx + 1) % this.recvWindowArraySize;
                    }
                    this.recvWindowLeftIndex = (this.recvWindowLeftIndex + 1) % this.recvWindowArraySize;
                    this.recvWindowLeftSeq = (this.recvWindowLeftSeq + 1) % 0x40000000;
                }
                if (ackSequence == this.recvCurrentSeq || recvQueueFull) break;
                lostPackets = true;
                break;
            }
            default: {
                ackSequence = this.recvCurrentSeq;
            }
        }
        this.ackPkt.rewind();
        TransportAck.flags(this.ackPkt, ackFlags);
        TransportAck.ack_seq(this.ackPkt, this.curr_ack_seq);
        TransportAck.cpkt_sequence(this.ackPkt, ackSequence);
        if (this.state == State.CONNECT_CMPLT_WAIT) {
            TransportAck.round_trip_time(this.ackPkt, this.connectRoundTripTime);
        } else {
            TransportAck.round_trip_time(this.ackPkt, this.averageRoundTripTime);
        }
        TransportAck.bandwidth(this.ackPkt, this.recvRate);
        TransportAck.window_size(this.ackPkt, this.recvWindowSize);
        if (this.state != State.CONNECT_CMPLT_WAIT) {
            this.lastAckSentSeq = ackSequence;
        }
        rttip = this.rtt_info_array[this.curr_ack_seq % this.rtt_info_array_size];
        rttip.entry_valid = true;
        rttip.sequence = ackSequence;
        rttip.ack_sequence = this.curr_ack_seq;
        rttip.send_time = this.usTimer.get();
        if (this.ackPkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        ++this.transportPktsSent;
        ++this.ackPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.ACK.code(), this.curr_ack_seq, ackSequence, this.averageRoundTripTime);
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)-1, (short)0, TransportType.ACK.code(), ackedCount, this.recvWindowSize, this.recvRate);
        this.curr_ack_seq = (this.curr_ack_seq + 1) % 65536;
        if (currTime > this.nextRecvReportTime) {
            long elapsedTime = currTime - this.lastRecvReportTime;
            long pktsToApp = this.cpktsToApplication - this.lastRecvAppCount;
            long pktsRcvd = this.cpktsReceived - this.lastRecvPktCount;
            int recvQueueFilled = this.recvQueueFilledCount - this.lastRecvQueueFilledCount;
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)1, (short)-1, (short)0, elapsedTime, (int)pktsRcvd, this.recvWindowCount);
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)1, (short)-1, (short)1, elapsedTime, (int)pktsToApp, this.recvCpktQueueCount.get());
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)1, (short)-1, (short)2, 0L, recvQueueFilled, this.recvWindowSize);
            this.lastRecvReportTime = currTime;
            this.nextRecvReportTime = currTime + this.reportInterval;
            this.lastRecvPktCount = this.cpktsReceived;
            this.lastRecvAppCount = this.cpktsToApplication;
            this.lastRecvQueueFilledCount = this.recvQueueFilledCount;
        }
        if (lostPackets) {
            this.send_transport_nak();
        }
        for (int i = 0; i < this.connectionTable.length; ++i) {
            UdpConnection cnp = this.connectionTable[i];
            if (cnp == null || !cnp.isInternalConnected()) continue;
            cnp.post_recv_event();
        }
        currTime = this.usTimer.get();
        if (this.state == State.CONNECT_CMPLT_WAIT) {
            this.ackInterval = 3000000L;
            this.nextAckTime = currTime + this.ackInterval;
            this.recvStalled = true;
        } else if (this.lastAckSentSeq == this.recvCurrentSeq) {
            this.ackInterval = 3000000L;
            this.nextAckTime = currTime + this.ackInterval;
            this.recvStalled = true;
        } else {
            this.ackInterval = 10000L;
            this.nextAckTime = currTime + this.ackInterval;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
    }

    void send_transport_ack2(int ackSeq) throws IOException {
        this.ack2Pkt.rewind();
        TransportAck2.ack_seq(this.ack2Pkt, ackSeq);
        TransportAck2.next_cnct_seq(this.ack2Pkt, this.sendCurrentSeq);
        short pktBlocked = 0;
        this.last_ack_seq = ackSeq;
        if (this.ack2Pkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        ++this.transportPktsSent;
        ++this.ack2PktsSent;
        int ackedGap = this.sendCurrentSeq - this.sendWindowLeftSeq;
        if (ackedGap < 0) {
            ackedGap += 0x40000000;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.ACK2.code(), ackSeq, this.sendCurrentSeq, ackedGap);
    }

    void send_transport_pmtu(int pktFlags, int sequence, int payloadSize) throws IOException {
        this.pmtuPkt.rewind();
        TransportPmtu.flags(this.pmtuPkt, (byte)pktFlags);
        TransportPmtu.sequence(this.pmtuPkt, sequence);
        TransportPmtu.payload_len(this.pmtuPkt, payloadSize);
        short pktBlocked = 0;
        if (this.pmtuPkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        if ((pktFlags & 4) == 0) {
            this.pmtuBytesTransferred += payloadSize + 8;
        }
        ++this.transportPktsSent;
        ++this.pmtuPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.PMTU.code(), sequence, payloadSize, (pktFlags & 4) != 0 ? 1 : 0);
    }

    void send_transport_nak() throws IOException {
        AtomicInteger lostPktCount = new AtomicInteger(0);
        short pktBlocked = 0;
        int[] sequences = this.get_lost_packet_sequences(Math.min(250, this.payloadSize / 4), lostPktCount);
        if (sequences != null && sequences.length > 0) {
            this.nakPkt.rewind();
            TransportNak.sequences(this.nakPkt, sequences);
            if (this.nakPkt.write(this.channel) == 0) {
                pktBlocked = 1;
            }
            ++this.transportPktsSent;
            ++this.nakPktsSent;
            int firstLost = sequences[0] & Integer.MAX_VALUE;
            int lastLost = sequences[sequences.length - 1];
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.NAK.code(), lostPktCount.get(), firstLost, lastLost);
        }
    }

    void send_transport_keepalive() throws IOException {
        short pktBlocked = 0;
        this.kpalvPkt.rewind();
        if (this.kpalvPkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        ++this.transportPktsSent;
        ++this.kpalvPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.KEEPALIVE.code(), 0L, 0, 0);
    }

    void send_transport_shutdown() throws IOException {
        short pktBlocked = 0;
        this.shtdnPkt.rewind();
        if (this.shtdnPkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        ++this.transportPktsSent;
        ++this.shtdnPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.SHUTDOWN.code(), 0L, 0, 0);
    }

    void send_transport_rejection() throws IOException {
        short pktBlocked = 0;
        this.rstPkt.rewind();
        if (this.rstPkt.write(this.channel) == 0) {
            pktBlocked = 1;
        }
        ++this.transportPktsSent;
        ++this.rstPktsSent;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_SENT, pktBlocked, (short)-1, TransportType.RESET.code(), 0L, 0, 0);
    }

    UdpConnection find_free_connection(byte handle) {
        UdpConnection cnp = null;
        if (this.connectionTable[handle] != null) {
            cnp = this.connectionTable[handle];
        }
        if (cnp == null) {
            cnp = new UdpConnection(this);
        }
        this.connectionTable[handle] = cnp;
        cnp.lclCid = handle;
        cnp.state = UdpConnection.State.IDLE;
        if (this.connectionLog.isLoggable(Level.FINER)) {
            this.connectionLog.finer("Connection " + cnp.lclCid + " has been allocated");
        }
        return cnp;
    }

    private void setState(State newState) {
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.NEW_SESSION_STATE, (short)-1, (short)-1, (short)-1, newState.ordinal(), 0, 0);
        this.state = newState;
        if (newState == State.CONNECTED) {
            this.recvRateBaseTime = this.usTimer.get();
            this.recvRateBaseCpktCount = this.cpktsReceived;
        }
    }

    public int getRequestedPayload() {
        return this.requestedPayloadSize;
    }

    public void setRequestedPayload(int requestedPayload) {
        if (requestedPayload <= 1480 && requestedPayload >= 300) {
            this.requestedPayloadSize = requestedPayload;
        }
    }

    private DatagramBuffer process_received_datagram(DatagramBuffer dgb) throws IOException {
        if (dgb.isTransportPacket()) {
            this.process_received_transport_packet(dgb);
        } else if (dgb.length() < 8) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, (short)-1, (short)-1, (short)-1, UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_SHORT_HEADER.ordinal(), 0, 0);
        } else {
            switch (this.state) {
                case IDLE: 
                case CONNECTING: 
                case ACCEPTING: 
                case TERMINATING: 
                case CLOSE_WAIT: 
                case ACCEPT_CMPLT_WAIT: {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), ConnectionPacket.sequence(dgb), 0);
                    return dgb;
                }
            }
            return this.process_received_cpkt(dgb);
        }
        return dgb;
    }

    DatagramBuffer process_received_cpkt(DatagramBuffer dgb) throws IOException {
        int seqGap;
        DatagramBuffer returnBuf = dgb;
        int sequence = ConnectionPacket.sequence(dgb);
        this.lastCpktRecvTime = dgb.getReadAtTime();
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DGB_PKT_RECEIVED, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), dgb.getBufferId(), sequence, this.recvWindowSize);
        if (this.state == State.CONNECT_CMPLT_WAIT) {
            this.lastError = null;
            if (this.protocolVersion >= 6) {
                this.start_pmtu_determination(State.PMTU_DETERMINATION_CLIENT);
            } else {
                this.sessionLog.info("WAN Accelerated " + this.id + " Channel using UDP packet size of " + (this.payloadSize + 8) + " bytes");
                this.setState(State.CONNECTED);
                this.event.signalAll();
                this.enable_udp_send();
            }
        }
        if (this.recvStalled) {
            long currTime = this.usTimer.get();
            this.ackInterval = 10000L;
            this.nextAckTime = dgb.getReadAtTime() + this.ackInterval;
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
            this.recvStalled = false;
        }
        if ((seqGap = sequence - this.recvWindowLeftSeq) < 0) {
            seqGap += 0x40000000;
        }
        if (seqGap < this.recvWindowSize) {
            int windowIdx;
            int currentGap = sequence - this.recvCurrentSeq;
            if (currentGap < 0) {
                currentGap += 0x40000000;
            }
            if (currentGap < 0x20000000) {
                this.recvCurrentSeq = sequence;
            }
            if (this.recvWindow[windowIdx = (this.recvWindowLeftIndex + seqGap) % this.recvWindowArraySize] != null) {
                ++this.cpktsRejectedDuplicate;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_DUPLICATE.ordinal(), sequence, this.recvWindowLeftSeq);
                this.check_recv_rate(0, dgb.getReadAtTime(), sequence, windowIdx);
            } else {
                this.cpktBytesReceived += (long)dgb.length();
                this.recvWindow[windowIdx] = dgb;
                ++this.recvWindowCount;
                if (currentGap > 0x20000000) {
                    currentGap -= 0x40000000;
                }
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_RECEIVED, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), sequence, dgb.length(), currentGap);
                if (currentGap > 1) {
                    this.recvMissingCount += currentGap - 1;
                } else if (currentGap != 1) {
                    --this.recvMissingCount;
                }
                this.check_recv_rate(ConnectionPacket.flags(dgb), dgb.getReadAtTime(), sequence, windowIdx);
                returnBuf = null;
            }
            if (seqGap == this.recvWindowSize - 1) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.RECEIVE_WINDOW_FULL, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), this.recvWindowSize, 0, 0);
                this.send_transport_ack();
            }
        } else {
            long currTime;
            if (seqGap > 0x20000000) {
                ++this.cpktsRejectedLeft;
                this.check_recv_rate(0, dgb.getReadAtTime(), sequence, -1);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_LEFT_OF_RECV_WINDOW.ordinal(), sequence, this.recvWindowLeftSeq);
                currTime = this.usTimer.get();
                if (this.nextAckTime - currTime > 10000L) {
                    this.send_transport_ack();
                }
            } else if (seqGap < this.recvWindowArraySize) {
                int windowIdx;
                int currentGap = sequence - this.recvCurrentSeq;
                if (currentGap < 0) {
                    currentGap += 0x40000000;
                }
                if (currentGap < 0x20000000) {
                    this.recvCurrentSeq = sequence;
                }
                if (this.recvWindow[windowIdx = (this.recvWindowLeftIndex + seqGap) % this.recvWindowArraySize] != null) {
                    ++this.cpktsRejectedDuplicate;
                    this.check_recv_rate(0, dgb.getReadAtTime(), sequence, -1);
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_DUPLICATE.ordinal(), sequence, this.recvWindowLeftSeq);
                } else {
                    this.cpktBytesReceived += (long)dgb.length();
                    this.recvWindow[windowIdx] = dgb;
                    ++this.recvWindowCount;
                    this.check_recv_rate(ConnectionPacket.flags(dgb), dgb.getReadAtTime(), sequence, windowIdx);
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_RECEIVED, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), sequence, dgb.length(), currentGap);
                    returnBuf = null;
                }
            } else {
                ++this.cpktsRejectedRight;
                this.check_recv_rate(0, dgb.getReadAtTime(), sequence, -1);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, ConnectionPacket.tgt_id(dgb), ConnectionPacket.src_id(dgb), ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_RIGHT_OF_RECV_WINDOW.ordinal(), sequence, this.recvWindowLeftSeq);
            }
            if (this.ackInterval > 10000L) {
                currTime = this.usTimer.get();
                this.ackInterval = 10000L;
                this.nextAckTime = dgb.getReadAtTime() + this.ackInterval;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
            }
        }
        return returnBuf;
    }

    private void process_received_transport_packet(DatagramBuffer dgb) throws IOException {
        TransportType transportPktType;
        ++this.transportPktsReceived;
        try {
            transportPktType = dgb.transportType();
        }
        catch (InvalidPacketException discard) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, (short)-1, UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DGB_PKT_RECEIVED, (short)-1, (short)-1, dgb.transportType().code(), dgb.getBufferId(), 0, 0);
        switch (transportPktType) {
            case CONNECT: {
                this.process_transport_connect(dgb);
                break;
            }
            case ACK: {
                this.process_transport_ack(dgb);
                break;
            }
            case ACK2: {
                this.process_transport_ack2(dgb);
                break;
            }
            case NAK: {
                this.process_transport_nak(dgb);
                break;
            }
            case KEEPALIVE: {
                this.process_transport_keepalive(dgb);
                break;
            }
            case SHUTDOWN: {
                this.process_transport_shutdown(dgb);
                break;
            }
            case REDIRECT: {
                this.process_transport_redirect(dgb);
                break;
            }
            case RESET: {
                this.process_transport_reset(dgb);
                break;
            }
            case PMTU: {
                this.process_transport_pmtu(dgb);
            }
        }
    }

    void process_transport_connect(DatagramBuffer dgb) throws IOException {
        int addr;
        switch (this.state) {
            case IDLE: 
            case TERMINATING: 
            case CLOSE_WAIT: 
            case CONNECT_CMPLT_WAIT: 
            case CONNECTED: 
            case CLOSE_PENDING: 
            case CLOSING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.CONNECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgb.length() > 2 && TransportConnect.protocol_version(dgb) < 3) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.CONNECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_UNSUPPORTED_VERSION.ordinal(), 0, 0);
            this.send_transport_rejection();
            return;
        }
        if (dgb.length() < TransportConnect.SIZE) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.CONNECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        long currTime = this.usTimer.get();
        if (this.negotiateMaxPayload) {
            if ((TransportConnect.flags(dgb) & 2) != 0) {
                TransportConnect.max_payload(dgb, (short)1430);
            } else {
                this.negotiateMaxPayload = false;
            }
        } else if ((TransportConnect.flags(dgb) & 2) != 0 && this.payloadSize > TransportConnect.max_payload(dgb)) {
            TransportConnect.max_payload(dgb, (short)this.payloadSize);
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)TransportConnect.seq_number(dgb), (short)TransportConnect.flags(dgb), TransportType.CONNECT.code(), TransportConnect.protocol_version(dgb), TransportConnect.initial_sequence(dgb), TransportConnect.bandwidth(dgb));
        InetAddress inetAddress = TransportConnect.tgt(dgb).getAddress();
        if (inetAddress != null) {
            byte[] byteAddr = inetAddress.getAddress();
            addr = byteAddr[0] << 24 | byteAddr[1] << 16 & 0xFF0000 | byteAddr[2] << 8 & 0xFF00 | byteAddr[3] & 0xFF;
        } else {
            addr = 0;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, TransportConnect.max_payload(dgb), (short)-1, TransportType.CONNECT.code(), TransportConnect.flow_window_size(dgb), addr, TransportConnect.src_port(dgb));
        switch (this.state) {
            case CONNECTING: {
                int rtt;
                if (!this.set_negotiated_parameters(TransportConnect.protocol_version(dgb), TransportConnect.max_payload(dgb), TransportConnect.flow_window_size(dgb), TransportConnect.initial_sequence(dgb))) {
                    this.send_transport_rejection();
                    this.abort(new ConnectionAbortedException());
                    break;
                }
                rtt_info rttip = this.rtt_info_array[TransportConnect.seq_number(dgb)];
                this.connectRoundTripTime = rtt = (int)(currTime - rttip.send_time);
                if (rtt < 20000) {
                    rtt = 20000;
                }
                this.baseRoundTripTime = rtt;
                this.averageRoundTripTime = rtt;
                this.cummulativeRtt = rtt;
                this.rttCount = 1;
                this.shortRoundTripTimeAccumulator = rtt;
                this.shortRoundTripTimeCounter = 1;
                this.longRoundTripTimeAccumulator = rtt;
                this.longRoundTripTimeCounter = 1;
                rttip.entry_valid = false;
                this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT);
                this.setState(State.CONNECT_CMPLT_WAIT);
                this.send_transport_ack();
            }
        }
    }

    void process_acked_sequence(int ackedSequence, int ackedBandwidth) {
        int idx = this.find_appropriate_sri_block(ackedSequence);
        if (idx >= 0) {
            send_rate_info srip;
            int idxGap = idx - this.sri_last_acked_idx;
            if (idxGap < 0) {
                idxGap += this.sri_array_size;
            }
            while (idxGap > 0) {
                srip = this.sri_array[this.sri_last_acked_idx];
                if ((srip.sri_flags & SRI_ENTRY_VALID) != 0) {
                    srip.sri_recv_bandwidth_accumulator += ackedBandwidth;
                    ++srip.sri_recv_bandwidth_counter;
                    this.check_send_rate(this.sri_last_acked_idx);
                }
                this.sri_last_acked_idx = (this.sri_last_acked_idx + 1) % this.sri_array_size;
                --idxGap;
            }
            this.sri_last_acked_idx = idx;
            srip = this.sri_array[idx];
            srip.sri_recv_bandwidth_accumulator += ackedBandwidth;
            ++srip.sri_recv_bandwidth_counter;
            if ((srip.sri_flags & SRI_SENDS_COMPLETE) != 0 && ackedSequence == srip.sri_last_sequence) {
                this.check_send_rate(this.sri_last_acked_idx);
            }
        }
    }

    void perform_tickle_check(double byteRate) {
        double kilobitRate = byteRate * 8.0 / 1000.0;
        double kilobitThreshold = this.tickleThreshold;
        if (this.udpMaxBandwidth > 0L) {
            double d;
            double kilobitCeiling = (double)this.udpMaxBandwidth * 8.0 / 1000.0;
            if (d < kilobitThreshold) {
                kilobitThreshold = kilobitCeiling;
            }
        }
        if (kilobitRate < kilobitThreshold) {
            if (++this.tickleCounter % this.tickleInterval == 0) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TICKLE_PROBE, (short)-1, (short)-1, (short)-1, (long)kilobitRate, this.tickleInterval, (int)kilobitThreshold);
                this.recompute_send_interval_limits();
            }
        } else {
            this.tickleCounter = 0;
        }
    }

    void process_transport_ack(DatagramBuffer ackPktp) throws IOException {
        boolean windowExpanded = false;
        switch (this.state) {
            case IDLE: 
            case CONNECTING: 
            case ACCEPTING: 
            case TERMINATING: 
            case CONNECT_CMPLT_WAIT: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.ACK.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (ackPktp.length() < TransportType.ACK.minimumSize()) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.ACK.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        ++this.ackPktsReceived;
        int seqGap = TransportAck.cpkt_sequence(ackPktp) - this.sendWindowLeftSeq;
        if (seqGap < 0) {
            seqGap += 0x40000000;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.ACK.code(), TransportAck.ack_seq(ackPktp), TransportAck.cpkt_sequence(ackPktp), TransportAck.round_trip_time(ackPktp));
        long currTime = this.usTimer.get();
        switch (this.state) {
            case ACCEPT_CMPLT_WAIT: {
                int ack_rtt;
                int ackGap;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)-1, (short)-1, TransportType.ACK.code(), seqGap, TransportAck.window_size(ackPktp), TransportAck.bandwidth(ackPktp));
                if (this.protocolVersion < 5) {
                    int testSeq = this.sendCurrentSeq - 1;
                    if (testSeq < 0) {
                        testSeq += 0x40000000;
                    }
                    ackGap = TransportAck.cpkt_sequence(ackPktp) - testSeq;
                } else {
                    ackGap = TransportAck.cpkt_sequence(ackPktp) - this.sendCurrentSeq;
                }
                if (ackGap != 0) break;
                this.connectRoundTripTime = ack_rtt = TransportAck.round_trip_time(ackPktp);
                if (ack_rtt < 20000) {
                    ack_rtt = 20000;
                }
                this.baseRoundTripTime = ack_rtt;
                this.averageRoundTripTime = ack_rtt;
                this.cummulativeRtt = ack_rtt;
                this.rttCount = 1;
                this.shortRoundTripTimeAccumulator = ack_rtt;
                this.shortRoundTripTimeCounter = 1;
                this.longRoundTripTimeAccumulator = ack_rtt;
                this.longRoundTripTimeCounter = 1;
                this.udpNegotiatedFlowWindowSize = TransportAck.window_size(ackPktp);
                this.setSendWindowSize(this.udpNegotiatedFlowWindowSize, (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_CONNECT_COMPLETE.ordinal());
                this.setRecvWindowSize(this.udpNegotiatedFlowWindowSize, (short)UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT_COMPLETE.ordinal());
                this.recvStalled = true;
                this.ackInterval = 3000000L;
                this.nextAckTime = currTime + this.ackInterval;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
                this.recvRateBaseTime = 0L;
                this.lastCpktRecvTime = 0L;
                this.recvRateBaseCpktCount = 0L;
                this.recvRate = 0;
                this.send_transport_ack2(TransportAck.ack_seq(ackPktp));
                this.lastAckRecvdSeq = TransportAck.cpkt_sequence(ackPktp);
                if (this.protocolVersion >= 6) {
                    this.start_pmtu_determination(State.PMTU_DETERMINATION_SERVER);
                    break;
                }
                this.sessionLog.info("WAN Accelerated " + this.id + " Channel using UDP packet size of " + (this.payloadSize + 8) + " bytes");
                this.setState(State.CONNECTED);
                this.event.signalAll();
                this.enable_udp_send();
                break;
            }
            case PMTU_RESULT_WAIT_CLIENT: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)-1, (short)-1, TransportType.ACK.code(), seqGap, TransportAck.window_size(ackPktp), TransportAck.bandwidth(ackPktp));
                this.send_transport_ack2(TransportAck.ack_seq(ackPktp));
                this.recvRate = TransportAck.bandwidth(ackPktp);
                if (this.recvRate == 0) {
                    this.recvRate = 1;
                }
                this.sendInterval = (long)Math.ceil(1000000.0 / (double)this.recvRate);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.PATH_MTU_DETERMINATION, (short)-1, (short)-1, (short)UdpTrace.PATH_MTU_CODES.PMTU_COMPLETE.ordinal(), this.sendInterval, this.payloadSize, 0);
                this.recompute_send_interval_limits();
                this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_PMTU_COMPLETE);
                this.setSendWindowSize(TransportAck.window_size(ackPktp), (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_PMTU_COMPLETE.ordinal());
                this.setState(State.CONNECTED);
                this.event.signalAll();
                this.sri_array_idx = 0;
                this.initialize_send_rate_info();
                this.enable_udp_send();
                break;
            }
            case CONNECTED: 
            case CLOSE_PENDING: 
            case CLOSING: {
                this.remoteRecvStalled = (TransportAck.flags(ackPktp) & 1) != 0;
                int ackSeqGap = TransportAck.ack_seq(ackPktp) - this.last_ack_seq;
                if (ackSeqGap < 0) {
                    ackSeqGap += 65536;
                }
                if (ackSeqGap < 1 || ackSeqGap > 32768) {
                    return;
                }
                if (this.lastAckRecvdSeq == TransportAck.cpkt_sequence(ackPktp)) {
                    ++this.lastAckRecvdSeqCount;
                } else {
                    this.lastAckRecvdSeq = TransportAck.cpkt_sequence(ackPktp);
                    this.lastAckRecvdSeqCount = 1;
                }
                this.process_acked_sequence(TransportAck.cpkt_sequence(ackPktp), TransportAck.bandwidth(ackPktp));
                if (this.sendWindowSize != TransportAck.window_size(ackPktp)) {
                    if (TransportAck.window_size(ackPktp) > this.sendWindowSize) {
                        windowExpanded = true;
                    }
                    this.setSendWindowSize(TransportAck.window_size(ackPktp), (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_NORMAL.ordinal());
                }
                this.send_transport_ack2(TransportAck.ack_seq(ackPktp));
                this.receiverRoundTripTime = TransportAck.round_trip_time(ackPktp);
                int idx = 0;
                int removedCount = 0;
                if (seqGap < this.sendWindowArraySize) {
                    for (idx = 0; idx <= seqGap; ++idx) {
                        DatagramBuffer dgbp = this.sendWindow[this.sendWindowLeftIndex];
                        this.sendWindow[this.sendWindowLeftIndex] = null;
                        if (dgbp.isAcked()) {
                            ++this.cpktsAckedStats;
                            this.cpktBytesAckedStats += (long)dgbp.length();
                        } else {
                            dgbp.doAck(false);
                        }
                        ++this.cpktsAcked;
                        this.cpktBytesAcked += (long)dgbp.length();
                        this.buffers.putback(dgbp);
                        ++removedCount;
                        this.sendWindowLeftSeq = (this.sendWindowLeftSeq + 1) % 0x40000000;
                        this.sendWindowLeftIndex = (this.sendWindowLeftIndex + 1) % this.sendWindowArraySize;
                    }
                    this.unackedPktCount -= removedCount;
                }
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)idx, (short)-1, TransportType.ACK.code(), this.unackedPktCount, TransportAck.window_size(ackPktp), TransportAck.bandwidth(ackPktp));
                long maxExpAckDelay = (long)this.receiverRoundTripTime + 20000L;
                if (this.sendInterval > maxExpAckDelay) {
                    maxExpAckDelay = this.sendInterval;
                }
                currTime = this.usTimer.get();
                this.nextAckExpTime = currTime + maxExpAckDelay;
                if (this.sendStalled && (idx > 0 || windowExpanded)) {
                    this.sendStalled = false;
                    this.sendWindowStalledTime += currTime - this.sendStalledStartTime;
                    this.enable_udp_send();
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SENDING_RESUMES, (short)-1, (short)-1, (short)0, this.sendInterval, this.sendWindowSize, this.unackedPktCount);
                }
                if (currTime <= this.nextSendReportTime) break;
                long elapsedTime = this.usTimer.get() - this.lastSendReportTime;
                double pktsFromApp = this.cpktsFromApplication - this.lastSendAppCount;
                double pktsSent = this.cpktsSent - this.lastSendPktCount;
                double pktsResent = this.cpktsResent - this.lastResendPktCount;
                long stalledTime = this.sendWindowStalledTime - this.lastSendsStalledTime;
                int stalledCount = this.sendWindowFilledCount - this.lastSendsStalledCount;
                double runningRate = 0.0;
                double runningApplRate = 0.0;
                double runningLossRate = 0.0;
                double rate = pktsSent * (double)this.payloadSize * 1000000.0 / (double)elapsedTime;
                double applRate = pktsFromApp * (double)this.payloadSize * 1000000.0 / (double)elapsedTime;
                double lossRate = pktsResent * 100.0 / (pktsSent + pktsResent);
                for (int i = 0; i < this.runningReportIntervals; ++i) {
                    runningRate += this.runningRate[i];
                    runningApplRate += this.runningApplRate[i];
                    runningLossRate = this.runningLossRate[i];
                }
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)0, (short)-1, (short)UdpTrace.STATS_REPORT_TYPES.STATS_REPORT_1.ordinal(), elapsedTime, this.unackedPktCount, this.sendCpktQueueCount);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)0, (short)-1, (short)UdpTrace.STATS_REPORT_TYPES.STATS_REPORT_2.ordinal(), stalledTime, stalledCount, this.sendWindowSize);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)0, (short)-1, (short)UdpTrace.STATS_REPORT_TYPES.STATS_REPORT_3.ordinal(), (long)rate, (int)applRate, (int)lossRate);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.STATS_REPORT, (short)0, (short)-1, (short)UdpTrace.STATS_REPORT_TYPES.STATS_REPORT_4.ordinal(), (long)(runningRate /= (double)this.runningReportIntervals), (int)(runningApplRate /= (double)this.runningReportIntervals), (int)(runningLossRate /= (double)this.runningReportIntervals));
                this.lastSendReportTime = currTime;
                this.nextSendReportTime = currTime + this.reportInterval;
                this.lastSendPktCount = this.cpktsSent;
                this.lastResendPktCount = this.cpktsResent;
                this.lastSendAppCount = this.cpktsFromApplication;
                this.lastSendsStalledTime = this.sendWindowStalledTime;
                this.lastSendsStalledCount = this.sendWindowFilledCount;
                this.runningRate[this.runningIdx] = rate;
                this.runningApplRate[this.runningIdx] = applRate;
                this.runningLossRate[this.runningIdx] = lossRate;
                this.runningIdx = (this.runningIdx + 1) % this.runningReportIntervals;
                this.perform_tickle_check(rate);
                break;
            }
            default: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ADDITIONAL_TRANSPORT_PKT_INFO, (short)-1, (short)-1, TransportType.ACK.code(), seqGap, TransportAck.window_size(ackPktp), TransportAck.bandwidth(ackPktp));
                this.send_transport_ack2(TransportAck.ack_seq(ackPktp));
            }
        }
    }

    void process_transport_ack2(DatagramBuffer dgbp) throws IOException {
        int rtt = -1;
        switch (this.state) {
            case IDLE: 
            case CONNECTING: 
            case ACCEPTING: 
            case TERMINATING: 
            case CLOSE_WAIT: 
            case ACCEPT_CMPLT_WAIT: 
            case CLOSING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.ACK2.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgbp.length() < TransportType.ACK2.minimumSize()) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.ACK2.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        ++this.ack2PktsReceived;
        switch (this.state) {
            case CONNECT_CMPLT_WAIT: 
            case CONNECTED: 
            case CLOSE_PENDING: {
                if (TransportAck2.next_cnct_seq(dgbp) == this.nextSenderSeq && this.recvWindowLeftSeq != this.nextSenderSeq) {
                    this.send_transport_nak();
                }
                this.nextSenderSeq = TransportAck2.next_cnct_seq(dgbp);
                rtt_info rttip = this.rtt_info_array[TransportAck2.ack_seq(dgbp) % this.rtt_info_array_size];
                if (rttip.entry_valid) {
                    rtt = (int)(dgbp.getReadAtTime() - rttip.send_time);
                    this.compute_moving_averages(rtt);
                    rttip.entry_valid = false;
                    this.lastAckAcknowlegedSeq = rttip.sequence;
                }
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.ACK2.code(), TransportAck2.ack_seq(dgbp), TransportAck2.next_cnct_seq(dgbp), rtt);
                if (this.state != State.CONNECT_CMPLT_WAIT) break;
                if (this.protocolVersion >= 6) {
                    this.start_pmtu_determination(State.PMTU_DETERMINATION_CLIENT);
                    break;
                }
                this.sessionLog.info("WAN Accelerated " + this.id + " Channel using UDP packet size of " + (this.payloadSize + 8) + " bytes");
                this.setState(State.CONNECTED);
                this.event.signalAll();
                this.enable_udp_send();
            }
        }
    }

    void process_transport_nak(DatagramBuffer dgb) {
        int nakRangeStart = 0;
        int lostCount = 0;
        boolean releaseOldReports = false;
        switch (this.state) {
            case IDLE: 
            case CONNECTING: 
            case ACCEPTING: 
            case TERMINATING: 
            case CLOSE_WAIT: 
            case ACCEPT_CMPLT_WAIT: 
            case CONNECT_CMPLT_WAIT: 
            case CLOSING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.NAK.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        int len = TransportNak.entry_count(dgb) * 4;
        if (dgb.length() < 8 || len > this.payloadSize || len + TransportType.NAK.minimumSize() != dgb.length()) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.NAK.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        ++this.nakPktsReceived;
        int nakCount = TransportNak.entry_count(dgb);
        boolean nakRange = false;
        loss_report newLrptp = this.freeLossReports;
        if (newLrptp == null) {
            newLrptp = new loss_report();
        }
        int[] nak_sequences = TransportNak.sequences(dgb);
        for (int i = 0; i < nakCount; ++i) {
            newLrptp.lrpt_entries[i] = nak_sequences[i];
            if (nakRange) {
                if ((newLrptp.lrpt_entries[i] & Integer.MIN_VALUE) != 0) {
                    int n = i - 1;
                    newLrptp.lrpt_entries[n] = newLrptp.lrpt_entries[n] & Integer.MAX_VALUE;
                    nakRangeStart = newLrptp.lrpt_entries[i] & Integer.MAX_VALUE;
                    ++lostCount;
                    continue;
                }
                int rangeCount = newLrptp.lrpt_entries[i] - nakRangeStart;
                rangeCount = rangeCount < 0 ? rangeCount + 0x40000000 + 1 : ++rangeCount;
                nakRange = false;
                lostCount += rangeCount;
                continue;
            }
            if ((newLrptp.lrpt_entries[i] & Integer.MIN_VALUE) != 0) {
                nakRangeStart = newLrptp.lrpt_entries[i] & Integer.MAX_VALUE;
                nakRange = true;
                continue;
            }
            ++lostCount;
        }
        newLrptp.lrpt_count = nakCount;
        newLrptp.lrpt_idx = 0;
        newLrptp.lrpt_offset = 0;
        int firstLost = newLrptp.lrpt_entries[0] & Integer.MAX_VALUE;
        int lastLost = newLrptp.lrpt_entries[newLrptp.lrpt_count - 1];
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.NAK.code(), lostCount, firstLost, lastLost);
        loss_report lrptp = this.lossReportList;
        while (lrptp != null) {
            int seqGap = lrptp.lrpt_entries[lrptp.lrpt_count - 1] - firstLost;
            if (seqGap < 0) {
                seqGap += 0x40000000;
            }
            if (seqGap < 0x20000000) {
                releaseOldReports = true;
                break;
            }
            lrptp = lrptp.lrpt_next;
        }
        if (releaseOldReports) {
            while ((lrptp = this.lossReportList) != null) {
                this.lossReportList = lrptp.lrpt_next;
                if (this.lossReportList == null) {
                    this.lossReportListEnd = null;
                }
                lrptp.lrpt_next = this.freeLossReports;
                this.freeLossReports = lrptp;
            }
        }
        newLrptp.lrpt_next = null;
        if (this.lossReportListEnd == null) {
            this.lossReportList = newLrptp;
        } else {
            this.lossReportListEnd.lrpt_next = newLrptp;
        }
        long currTime = this.usTimer.get();
        if (this.nextSendTime - currTime > (long)this.burstQuantum) {
            this.enable_udp_send();
        } else {
            this.enable_udp_send_without_send_time_change();
        }
    }

    void process_transport_keepalive(DatagramBuffer dgb) throws IOException {
        switch (this.state) {
            case IDLE: 
            case ACCEPTING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.KEEPALIVE.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgb.length() != 1) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.KEEPALIVE.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.KEEPALIVE.code(), 0L, 0, 0);
        ++this.kpalvPktsReceived;
        this.send_transport_keepalive();
    }

    void process_transport_shutdown(DatagramBuffer dgb) throws IOException {
        switch (this.state) {
            case IDLE: 
            case TERMINATING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.SHUTDOWN.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgb.length() != 1) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.SHUTDOWN.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.SHUTDOWN.code(), 0L, 0, 0);
        ++this.shtdnPktsReceived;
        switch (this.state) {
            case CONNECTING: {
                this.lastError = new ConnectionRefusedException();
                this.setState(State.TERMINATING);
                this.event.signalAll();
                break;
            }
            case ACCEPT_CMPLT_WAIT: 
            case CONNECT_CMPLT_WAIT: {
                this.lastError = new ConnectionResetException();
                this.setState(State.TERMINATING);
                this.event.signalAll();
                break;
            }
            case CONNECTED: {
                this.lastError = new ConnectionResetException();
                this.setState(State.CLOSE_WAIT);
                this.send_transport_shutdown();
                break;
            }
            case CLOSE_PENDING: {
                this.setState(State.TERMINATING);
                this.send_transport_shutdown();
                this.event.signalAll();
                break;
            }
            case CLOSING: {
                this.setState(State.TERMINATING);
                this.event.signalAll();
            }
        }
    }

    void process_transport_redirect(DatagramBuffer dgb) {
        switch (this.state) {
            case IDLE: 
            case ACCEPTING: 
            case TERMINATING: 
            case CLOSE_WAIT: 
            case ACCEPT_CMPLT_WAIT: 
            case CONNECT_CMPLT_WAIT: 
            case CONNECTED: 
            case CLOSE_PENDING: 
            case CLOSING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.REDIRECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgb.length() < TransportRedirect.SIZE) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.REDIRECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        long currTime = this.usTimer.get();
        if (TransportRedirect.original_tgt_port(dgb) != this.remoteAddress.getPort() || !this.allowCnctPortChange) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.REDIRECT.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.REDIRECT.code(), TransportRedirect.cnct_seq(dgb), TransportRedirect.redirected_port(dgb), TransportRedirect.original_tgt_port(dgb));
        this.remoteAddress = new InetSocketAddress(this.remoteAddress.getHostName(), TransportRedirect.original_tgt_port(dgb));
        rtt_info rttip = this.rtt_info_array[TransportRedirect.cnct_seq(dgb)];
        int rtt = (int)(currTime - rttip.send_time);
        if (rtt < 20000) {
            rtt = 20000;
        }
        this.baseRoundTripTime = rtt;
        this.averageRoundTripTime = rtt;
        this.cummulativeRtt = rtt;
        this.rttCount = 1;
        this.shortRoundTripTimeAccumulator = rtt;
        this.shortRoundTripTimeCounter = 1;
        this.longRoundTripTimeAccumulator = rtt;
        this.longRoundTripTimeCounter = 1;
        rttip.entry_valid = false;
        this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT);
        this.enable_udp_send();
    }

    void process_transport_reset(DatagramBuffer dgb) {
        switch (this.state) {
            case IDLE: 
            case ACCEPTING: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.RESET.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
        if (dgb.length() != 1) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.RESET.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
            return;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.RESET.code(), 0L, 0, 0);
        ++this.rstPktsReceived;
        switch (this.state) {
            case CONNECTING: {
                this.lastError = new ConnectionResetException();
                this.setState(State.TERMINATING);
                this.event.signalAll();
                break;
            }
            case TERMINATING: 
            case CLOSE_WAIT: {
                break;
            }
            case ACCEPT_CMPLT_WAIT: 
            case CONNECT_CMPLT_WAIT: {
                this.lastError = new ConnectionResetException();
                this.setState(State.TERMINATING);
                this.event.signalAll();
                break;
            }
            case CONNECTED: {
                this.lastError = new ConnectionResetException();
                this.setState(State.CLOSE_WAIT);
                break;
            }
            case CLOSE_PENDING: {
                this.setState(State.TERMINATING);
                break;
            }
            case CLOSING: {
                this.setState(State.TERMINATING);
                this.event.signalAll();
            }
        }
        if (this.state == State.CONNECTING) {
            this.abort(new ConnectionRefusedException());
        } else {
            this.abort(new ConnectionResetException());
        }
    }

    void process_transport_pmtu(DatagramBuffer dgb) throws IOException {
        switch (this.state) {
            case PMTU_DETERMINATION_SERVER: {
                if ((TransportPmtu.flags(dgb) & 2) != 0) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.PMTU.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
                    return;
                }
                int payload = TransportPmtu.payload_len(dgb);
                int sequence = TransportPmtu.sequence(dgb);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.PMTU.code(), TransportPmtu.sequence(dgb), TransportPmtu.payload_len(dgb), (TransportPmtu.flags(dgb) & 4) != 0 ? 1 : 0);
                long currTime = this.usTimer.get();
                if (payload > this.payloadSize) {
                    this.payloadSize = payload;
                }
                if ((TransportPmtu.flags(dgb) & 4) != 0) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.PATH_MTU_DETERMINATION, (short)-1, (short)-1, (short)UdpTrace.PATH_MTU_CODES.PMTU_COMPLETE.ordinal(), this.sendInterval, payload, 0);
                    this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_PMTU_COMPLETE);
                    this.setSendWindowSize(this.recvWindowSize, (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_PMTU_COMPLETE.ordinal());
                    this.send_transport_ack();
                    this.setState(State.CONNECTED);
                    this.set_payload_size(payload);
                    this.sri_array_idx = 0;
                    this.initialize_send_rate_info();
                    this.event.signalAll();
                    this.enable_udp_send();
                    break;
                }
                this.nextAckTime = this.nextSendTime = currTime + 200000L;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, 200000L, 0, 0);
                this.pmtuEndTime = dgb.getReadAtTime();
                ++this.pmtuPktsReceived;
                if (sequence == this.pmtuMaxSequence && this.pmtuPktsReceived == this.pmtuPktsSent) {
                    this.enable_udp_send();
                    break;
                }
                this.nextSendTime = currTime + 200000L;
                break;
            }
            case CONNECTED: {
                if ((TransportPmtu.flags(dgb) & 4) != 0) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.PMTU.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
                    return;
                }
                this.send_transport_ack();
                break;
            }
            case CONNECT_CMPLT_WAIT: {
                this.start_pmtu_determination(State.PMTU_DETERMINATION_CLIENT);
            }
            case PMTU_DETERMINATION_CLIENT: {
                if ((TransportPmtu.flags(dgb) & 5) == 0) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.PMTU.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_INVALID.ordinal(), 0, 0);
                    return;
                }
                int payload = TransportPmtu.payload_len(dgb);
                int sequence = TransportPmtu.sequence(dgb);
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TRANSPORT_PKT_RECEIVED, (short)-1, (short)-1, TransportType.PMTU.code(), TransportPmtu.sequence(dgb), TransportPmtu.payload_len(dgb), (TransportPmtu.flags(dgb) & 4) != 0 ? 1 : 0);
                int responseFlags = 2;
                if (payload > this.payloadSize) {
                    this.set_payload_size(payload);
                }
                if ((TransportPmtu.flags(dgb) & 4) != 0) {
                    this.payloadSize = payload;
                    responseFlags |= 4;
                    long currTime = this.usTimer.get();
                    this.nextSendTime = currTime + (long)this.baseRoundTripTime + 200000L;
                    this.setState(State.PMTU_RESULT_WAIT_CLIENT);
                }
                this.send_transport_pmtu(responseFlags, sequence, payload);
                break;
            }
            default: {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_TRANSPORT_PKT, (short)-1, (short)-1, TransportType.PMTU.code(), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), 0, 0);
                return;
            }
        }
    }

    boolean demux_received_connection_packet(DatagramBuffer dgb) {
        UdpConnection cnp = this.connectionTable[ConnectionPacket.tgt_id(dgb)];
        if (cnp != null && cnp.isActive()) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CPKT_DEMUXED, ConnectionPacket.tgt_id(dgb), ConnectionPacket.tgt_id(dgb), ConnectionPacket.type(dgb), dgb.getBufferId(), ConnectionPacket.sequence(dgb), 0);
            switch (dgb.packetType()) {
                case CONNECT: {
                    return cnp.process_cpkt_connect(dgb);
                }
                case DATA: {
                    return cnp.process_cpkt_data(dgb);
                }
                case SHUTDOWN: {
                    return cnp.process_cpkt_shutdown(dgb);
                }
                case RESET: {
                    return cnp.process_cpkt_reset(dgb);
                }
            }
        } else {
            switch (dgb.packetType()) {
                case MEASUREMENT: {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, (short)-1, (short)-1, ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_MEASUREMENT.ordinal(), ConnectionPacket.sequence(dgb), this.recvWindowLeftSeq);
                    break;
                }
                case CONNECT: {
                    try {
                        cnp.send_rejection();
                    }
                    catch (UdpBaseException udpBaseException) {
                        // empty catch block
                    }
                }
                default: {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DISCARDING_RECEIVED_CPKT, (short)-1, (short)-1, ConnectionPacket.type(dgb), UdpTrace.PKT_DISCARD_REASONS.PKT_DISCARD_WRONG_STATE.ordinal(), ConnectionPacket.sequence(dgb), this.recvWindowLeftSeq);
                }
            }
        }
        this.buffers.putback(dgb);
        return true;
    }

    private DatagramBuffer get_next_lost_packet() {
        DatagramBuffer dgb = this.blockedResendPacket;
        if (dgb != null) {
            this.blockedResendPacket = null;
            return dgb;
        }
        loss_report lrptp = this.lossReportList;
        if (lrptp == null) {
            return null;
        }
        while (lrptp.lrpt_idx < lrptp.lrpt_count) {
            int seqGap;
            int lossSeq = lrptp.lrpt_entries[lrptp.lrpt_idx];
            if (lossSeq < 0) {
                lossSeq &= Integer.MAX_VALUE;
                int nextLossInRange = ((lossSeq = (lossSeq + lrptp.lrpt_offset) % 0x40000000) + 1) % 0x40000000;
                if (nextLossInRange == lrptp.lrpt_entries[lrptp.lrpt_idx + 1]) {
                    lrptp.lrpt_offset = 0;
                    ++lrptp.lrpt_idx;
                } else {
                    ++lrptp.lrpt_offset;
                }
            } else {
                lrptp.lrpt_offset = 0;
                ++lrptp.lrpt_idx;
            }
            if (lrptp.lrpt_idx == lrptp.lrpt_count) {
                this.lossReportList = lrptp.lrpt_next;
                if (this.lossReportList == null) {
                    this.lossReportListEnd = null;
                }
                lrptp.lrpt_next = this.freeLossReports;
                this.freeLossReports = lrptp;
            }
            if ((seqGap = lossSeq - this.sendWindowLeftSeq) < 0) {
                seqGap += 0x40000000;
            }
            if (seqGap >= 0x20000000) continue;
            int winIdx = (this.sendWindowLeftIndex + seqGap) % this.sendWindowArraySize;
            dgb = this.sendWindow[winIdx];
            break;
        }
        return dgb;
    }

    void lock() {
        if (this.sessionLog.isLoggable(Level.FINEST)) {
            this.sessionLog.finest("Waiting for the session lock: " + Thread.currentThread().getStackTrace()[2]);
        }
        try {
            this.lock.lockInterruptibly();
        }
        catch (IllegalMonitorStateException imse) {
            imse.printStackTrace();
            throw imse;
        }
        catch (InterruptedException e) {
            this.sessionLog.fine("The wait for the session lock was interrupted.");
            return;
        }
        if (this.sessionLog.isLoggable(Level.FINEST)) {
            this.sessionLog.finest("Obtained the session lock: " + Thread.currentThread().getStackTrace()[2]);
        }
    }

    void unlock() {
        if (this.sessionLog.isLoggable(Level.FINEST)) {
            this.sessionLog.finest("Released the session lock: " + Thread.currentThread().getStackTrace()[2]);
        }
        this.lock.unlock();
    }

    void enable_udp_send() {
        this.nextSendTime = this.usTimer.get();
        this.enable_udp_send_without_send_time_change();
    }

    void enable_udp_send_without_send_time_change() {
        if (this.udpThread != null && this.udpThread.isAlive()) {
            this.udpThread.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort(IOException e) {
        boolean needUnlock = false;
        try {
            if (!this.lock.isHeldByCurrentThread()) {
                this.lock();
                needUnlock = true;
            }
            State currentState = this.state;
            this.lastError = e;
            this.udpTerminating = true;
            if (this.state != State.IDLE) {
                this.setState(State.TERMINATING);
            }
            this.event.signal();
            LinkedList<select_wait_blk> linkedList = this.udpSelectWaitList;
            synchronized (linkedList) {
                for (select_wait_blk b : (LinkedList)this.udpSelectWaitList.clone()) {
                    b.posted = true;
                    b.event.signal();
                }
                this.udpSelectWaitList.clear();
            }
            if (currentState != State.CLOSE_PENDING && currentState != State.CLOSE_WAIT && currentState != State.CLOSING && currentState != State.TERMINATING && currentState != State.IDLE && e != null) {
                final IOException error = e;
                Thread errorHandler = new Thread(){

                    public void run() {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, UdpSession.UDP_EXCEPTION, null, error);
                        UdpSession.this.pcs.firePropertyChange(propertyChangeEvent);
                    }
                };
                errorHandler.start();
            }
            Object var9_8 = null;
            if (needUnlock) {
                this.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (needUnlock) {
                this.unlock();
            }
            throw throwable;
        }
    }

    boolean set_negotiated_parameters(int protocolVers, int maxPayload, int windowSize, int initialSequence) {
        if (protocolVers < 3) {
            this.lastError = new ProtocolException("Protocol version too low: " + protocolVers);
            return false;
        }
        switch (this.state) {
            case CONNECTING: {
                if (protocolVers <= 6 && maxPayload <= 1480) break;
                this.lastError = new ProtocolException("Protocol version too high: " + protocolVers);
                return false;
            }
            case ACCEPT_CMPLT_WAIT: {
                if (protocolVers > 6) {
                    protocolVers = 6;
                }
                if (maxPayload <= this.requestedPayloadSize) break;
                maxPayload = this.requestedPayloadSize;
            }
        }
        if (this.state == State.CONNECT_CMPLT_WAIT) {
            protocolVers = 6;
        }
        this.protocolVersion = protocolVers;
        this.payloadSize = maxPayload;
        this.recompute_send_interval_limits();
        this.udpNegotiatedFlowWindowSize = windowSize;
        this.setRecvWindowSize(windowSize, (short)UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT_COMPLETE.ordinal());
        this.setSendWindowSize(windowSize, (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_CONNECT_COMPLETE.ordinal());
        this.recvInitialSeq = initialSequence;
        this.recvCurrentSeq = initialSequence - 1;
        if (this.recvCurrentSeq < 0) {
            this.recvCurrentSeq += 0x40000000;
        }
        this.lastAckRecvSeq = this.recvCurrentSeq;
        this.lastAckAcknowlegedSeq = this.recvCurrentSeq;
        this.recvWindowLeftSeq = initialSequence;
        this.lastAckSentSeq = this.recvCurrentSeq;
        this.nextSenderSeq = initialSequence;
        this.bestSustainedInterval = 200000L;
        this.minProbedInterval = 200000L;
        this.sendRateCaptureInterval = 100000;
        this.probeInterval = 5;
        this.sri_array_idx = 0;
        this.sri_last_acked_idx = 0;
        if (this.protocolVersion < 6) {
            this.initialize_send_rate_info();
        }
        return true;
    }

    int[] get_lost_packet_sequences(int maxCount, AtomicInteger lostPktCount) {
        int seqGap;
        nak_descriptor nakdp;
        int[] sequenceNumVector = new int[maxCount];
        int lostEntryCount = 0;
        int lostCount = 0;
        int startSeq = this.recvWindowLeftSeq;
        long currTime = this.usTimer.get();
        if (this.protocolVersion < 5) {
            while ((nakdp = this.nakDescriptorList) != null) {
                this.nakDescriptorList = nakdp.nakd_next;
                nakdp.nakd_next = this.freeNakDescriptors;
                this.freeNakDescriptors = nakdp;
            }
            this.nakDescriptorListEnd = null;
            startSeq = this.recvWindowLeftSeq;
        } else {
            int rate;
            int rtt = this.averageRoundTripTime;
            if (rtt == 0) {
                rtt = this.baseRoundTripTime;
            }
            if ((rate = this.recvRate) == 0) {
                long elapsedTime = currTime - this.recvRateBaseTime;
                long pktCount = this.cpktsReceived - this.recvRateBaseCpktCount;
                rate = pktCount > 0L ? (int)Math.ceil((double)pktCount * 1000000.0 / (double)elapsedTime) : 100;
            }
            while ((nakdp = this.nakDescriptorList) != null) {
                startSeq = nakdp.nakd_lastSequence;
                seqGap = startSeq - this.recvWindowLeftSeq;
                if (seqGap < 0) {
                    seqGap += 0x40000000;
                }
                if (seqGap > 0x20000000) {
                    this.nakDescriptorList = nakdp.nakd_next;
                    if (this.nakDescriptorList == null) {
                        this.nakDescriptorListEnd = null;
                        startSeq = this.recvWindowLeftSeq;
                    }
                    nakdp.nakd_next = this.freeNakDescriptors;
                    this.freeNakDescriptors = nakdp;
                    continue;
                }
                if (currTime - nakdp.nakd_sendTime > (long)(rtt + 1000000 / rate) + 10000L) {
                    while ((nakdp = this.nakDescriptorList) != null) {
                        this.nakDescriptorList = nakdp.nakd_next;
                        nakdp.nakd_next = this.freeNakDescriptors;
                        this.freeNakDescriptors = nakdp;
                    }
                    this.nakDescriptorListEnd = null;
                    startSeq = this.recvWindowLeftSeq;
                    continue;
                }
                nakdp = this.nakDescriptorListEnd;
                startSeq = (nakdp.nakd_lastSequence + 1) % 0x40000000;
                break;
            }
        }
        int maxNakSequence = this.recvCurrentSeq - (int)Math.floor((double)this.pktsInLastAckInterval * (double)this.nakDelay / 10000.0);
        if (maxNakSequence < 0) {
            maxNakSequence += 0x40000000;
        }
        if ((seqGap = maxNakSequence + 1 - startSeq) < 0) {
            seqGap += 0x40000000;
        }
        if (seqGap > 0 && seqGap < 0x20000000) {
            int rangeIdx = -1;
            int lostSeq = startSeq;
            int startOffset = startSeq - this.recvWindowLeftSeq;
            if (startOffset < 0) {
                startOffset += 0x40000000;
            }
            int winIdx = (this.recvWindowLeftIndex + startOffset) % this.recvWindowArraySize;
            for (int winCount = 0; winCount < seqGap && lostEntryCount < maxCount; ++winCount) {
                if (this.recvWindow[winIdx] == null) {
                    if (rangeIdx == -1) {
                        sequenceNumVector[lostEntryCount] = lostSeq;
                        rangeIdx = lostEntryCount++;
                        ++lostCount;
                    } else {
                        int n = rangeIdx;
                        sequenceNumVector[n] = sequenceNumVector[n] | Integer.MIN_VALUE;
                        sequenceNumVector[lostEntryCount] = lostSeq;
                        ++lostCount;
                    }
                } else if (rangeIdx != -1) {
                    if ((sequenceNumVector[rangeIdx] & Integer.MIN_VALUE) != 0) {
                        ++lostEntryCount;
                    }
                    rangeIdx = -1;
                }
                lostSeq = (lostSeq + 1) % 0x40000000;
                winIdx = (winIdx + 1) % this.recvWindowArraySize;
            }
            if (rangeIdx != -1 && (sequenceNumVector[rangeIdx] & Integer.MIN_VALUE) != 0) {
                ++lostEntryCount;
            }
        }
        lostPktCount.set(lostCount);
        if (lostEntryCount > 0) {
            nakdp = this.freeNakDescriptors;
            if (nakdp != null) {
                this.freeNakDescriptors = nakdp.nakd_next;
            } else {
                nakdp = new nak_descriptor();
            }
            nakdp.nakd_firstSequence = sequenceNumVector[0] & Integer.MAX_VALUE;
            nakdp.nakd_lastSequence = sequenceNumVector[lostEntryCount - 1];
            nakdp.nakd_sendTime = currTime;
            nakdp.nakd_next = null;
            if (this.nakDescriptorListEnd == null) {
                this.nakDescriptorList = nakdp;
            } else {
                this.nakDescriptorListEnd.nakd_next = nakdp;
            }
            this.nakDescriptorListEnd = nakdp;
        }
        int[] returnVector = new int[lostEntryCount];
        System.arraycopy(sequenceNumVector, 0, returnVector, 0, lostEntryCount);
        return returnVector;
    }

    void check_recv_rate(int pktFlags, long pktRecvTime, int pktSequence, int pktWindowIdx) throws IOException {
        ++this.cpktsReceived;
        if ((pktFlags & 7) != 0) {
            if (!this.quickstartRecvRateMeasurement) {
                this.recvRateBaseTime = pktRecvTime;
                this.recvRateBaseCpktCount = this.cpktsReceived;
                this.quickstartRecvRateMeasurement = true;
                this.quickstartStartWindowIdx = -1;
                this.quickstartEndWindowIdx = -1;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CHECK_RECEIVE_RATE, (short)0, (short)-1, (short)UdpTrace.RECV_RATE_CHANGE_REASONS.QUICKSTART_MEASURE_INTERVAL_START.ordinal(), pktRecvTime, pktSequence, pktFlags);
                this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_MEASURE_START);
            }
            if ((pktFlags & 1) != 0) {
                this.quickstartStartWindowIdx = pktWindowIdx;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CHECK_RECEIVE_RATE, (short)0, (short)-1, (short)UdpTrace.RECV_RATE_CHANGE_REASONS.QUICKSTART_MEASURE_START.ordinal(), pktRecvTime, pktSequence, 0);
            } else if ((pktFlags & 2) != 0) {
                this.quickstartEndWindowIdx = pktWindowIdx;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CHECK_RECEIVE_RATE, (short)0, (short)-1, (short)UdpTrace.RECV_RATE_CHANGE_REASONS.QUICKSTART_MEASURE_STOP.ordinal(), pktRecvTime, pktSequence, 0);
            }
            long pktCount = this.cpktsReceived - this.recvRateBaseCpktCount;
            long elapsedTime = pktRecvTime - this.recvRateBaseTime;
            if (pktCount > 0L) {
                this.recvRate = (int)Math.ceil((double)pktCount * 1000000.0 / (double)elapsedTime);
            }
            if (this.quickstartStartWindowIdx != -1 && this.quickstartEndWindowIdx != -1) {
                int winIdx = this.recvWindowLeftIndex;
                while (winIdx != this.quickstartEndWindowIdx) {
                    if (this.recvWindow[winIdx] == null) {
                        return;
                    }
                    winIdx = (winIdx + 1) % this.recvWindowArraySize;
                }
                this.quickstartRecvRateMeasurement = false;
                this.recvRateBaseTime = pktRecvTime;
                this.recvRateBaseCpktCount = this.cpktsReceived;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CHECK_RECEIVE_RATE, (short)0, (short)-1, (short)UdpTrace.RECV_RATE_CHANGE_REASONS.QUICKSTART_MEASURE_COMPLETE.ordinal(), elapsedTime, (int)pktCount, this.recvRate);
                this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_MEASURE_COMPLETE);
                this.send_transport_ack();
            }
        } else if (!this.quickstartRecvRateMeasurement) {
            if (this.recvRateBaseTime == 0L) {
                this.recvRateBaseTime = pktRecvTime;
                this.recvRateBaseCpktCount = this.cpktsReceived;
            } else {
                long elapsedTime = pktRecvTime - this.recvRateBaseTime;
                long pktCount = this.cpktsReceived - this.recvRateBaseCpktCount;
                if (elapsedTime > 10000L) {
                    int intervalRecvRate = pktCount > 0L ? (int)Math.ceil((double)pktCount * 1000000.0 / (double)elapsedTime) : 0;
                    this.recvRate = (this.recvRate + intervalRecvRate) / 2;
                    this.compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_NORMAL);
                    this.recvRateBaseTime = pktRecvTime;
                    this.recvRateBaseCpktCount = this.cpktsReceived;
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.CHECK_RECEIVE_RATE, (short)-1, (short)-1, (short)UdpTrace.RECV_RATE_CHANGE_REASONS.NORMAL_INTERVAL.ordinal(), elapsedTime, (int)pktCount, intervalRecvRate);
                }
            }
        }
    }

    void compute_moving_averages(int currentRtt) {
        int stAvg = 0;
        if (currentRtt < 20000) {
            currentRtt = 20000;
        }
        if (currentRtt < this.baseRoundTripTime) {
            this.baseRoundTripTime = currentRtt;
        }
        this.cummulativeRtt += (long)currentRtt;
        ++this.rttCount;
        this.shortRoundTripTimeAccumulator += currentRtt;
        ++this.shortRoundTripTimeCounter;
        stAvg = this.shortRoundTripTimeAccumulator / this.shortRoundTripTimeCounter;
        if (this.shortRoundTripTimeCounter >= 32) {
            this.longRoundTripTimeAccumulator += stAvg;
            ++this.longRoundTripTimeCounter;
            this.averageRoundTripTime = this.longRoundTripTimeAccumulator / this.longRoundTripTimeCounter;
            this.shortRoundTripTimeAccumulator = stAvg;
            this.shortRoundTripTimeCounter = 1;
            if (this.longRoundTripTimeCounter >= 8) {
                this.longRoundTripTimeAccumulator = this.averageRoundTripTime;
                this.longRoundTripTimeCounter = 1;
            }
        }
    }

    void compute_new_recv_window_size(UdpTrace.RECV_WINDOW_CHANGE_TYPES changeType) {
        long reqWinSize;
        int minRate;
        int recvRate;
        int recvWindowSize = this.recvWindowSize;
        long roundTripTime = this.baseRoundTripTime;
        if (roundTripTime < 20000L) {
            roundTripTime = 20000L;
        }
        if ((recvRate = this.recvRate) == 0) {
            recvRate = 4000;
        }
        if (recvRate < (minRate = 1000000 / (int)this.maxSendInterval)) {
            recvRate = minRate;
        }
        if ((reqWinSize = (long)((int)Math.ceil(((double)roundTripTime + (double)this.nakDelay + 10000.0) * (double)recvRate * 3.0 / 1000000.0))) == 0L) {
            reqWinSize = 1L;
        }
        switch (changeType) {
            case RWC_CONNECT: {
                recvWindowSize = 128;
                break;
            }
            case RWC_MEASURE_START: {
                if ((recvWindowSize += 32) < 100000) break;
                recvWindowSize = 99999;
                break;
            }
            case RWC_MEASURE_COMPLETE: 
            case RWC_PMTU_COMPLETE: {
                recvWindowSize = (int)((long)recvWindowSize + reqWinSize);
                if (recvWindowSize >= 100000) {
                    recvWindowSize = 99999;
                }
                if (recvWindowSize >= 32) break;
                recvWindowSize = 32;
                break;
            }
            case RWC_NORMAL: {
                if (reqWinSize >= (long)recvWindowSize) {
                    if (reqWinSize >= 100000L) {
                        reqWinSize = 99999L;
                    }
                    recvWindowSize = (int)reqWinSize;
                    break;
                }
                int maxDecrement = (int)Math.ceil((double)recvWindowSize * 0.1);
                if ((long)recvWindowSize - reqWinSize > (long)maxDecrement) {
                    recvWindowSize -= maxDecrement;
                }
                if (recvWindowSize >= 32) break;
                recvWindowSize = 32;
                break;
            }
            case RWC_IDLE: {
                int maxDecrement = (int)Math.floor((double)recvWindowSize * 0.1);
                recvWindowSize = recvWindowSize - (int)reqWinSize > maxDecrement ? (recvWindowSize -= maxDecrement) : (int)reqWinSize;
                if (recvWindowSize >= 128) break;
                recvWindowSize = 128;
            }
        }
        this.setRecvWindowSize(recvWindowSize, (short)changeType.ordinal());
    }

    void recompute_send_interval_limits() {
        long origInterval = this.minSendInterval;
        this.minSendInterval = this.udpMaxBandwidth == 0L ? 1L : (long)Math.ceil(1000000.0 / ((double)this.udpMaxBandwidth / (double)this.payloadSize));
        if (this.minSendInterval != origInterval) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.RATE_PARAMETER_SET, (short)-1, (short)-1, (short)UdpTrace.RATE_PARAMETER_TYPES.CEILING.ordinal(), this.minSendInterval, (int)this.udpMaxBandwidth, this.payloadSize);
        }
        origInterval = this.maxSendInterval;
        this.maxSendInterval = this.udpMinBandwidth == 0L ? 200000L : (long)Math.ceil(1000000.0 / ((double)this.udpMinBandwidth / (double)this.payloadSize));
        if (this.maxSendInterval != origInterval) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.RATE_PARAMETER_SET, (short)-1, (short)-1, (short)UdpTrace.RATE_PARAMETER_TYPES.FLOOR.ordinal(), this.maxSendInterval, (int)this.udpMinBandwidth, this.payloadSize);
        }
        origInterval = this.sendInterval;
        this.bandwidthMeasured = false;
        if (this.sendInterval < this.minSendInterval) {
            this.sendInterval = this.minSendInterval;
        } else if (this.sendInterval > this.maxSendInterval) {
            this.sendInterval = this.maxSendInterval;
        }
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)-1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.INITIAL_NEGOTIATED_RATE.ordinal(), this.sendInterval, (int)origInterval, 0);
    }

    void set_payload_size(int newPayloadSize) {
        this.payloadSize = newPayloadSize;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.DATAGRAM_BUFFER_PAYLOAD, (short)-1, (short)-1, (short)-1, newPayloadSize, 0, 0);
        this.sessionLog.info("WAN Accelerated " + this.id + " Channel using UDP packet size of " + (this.payloadSize + 8) + " bytes");
    }

    void set_send_rate_packet_counts(send_rate_info srip) {
        if ((srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0 || !this.bandwidthMeasured) {
            srip.sri_pkts_send_count = this.quickstartBurstSize;
        } else {
            srip.sri_pkts_send_count = (int)((long)this.sendRateCaptureInterval / srip.sri_send_interval);
            if (srip.sri_pkts_send_count < 100) {
                while ((srip.sri_pkts_send_count = (int)((long)this.sendRateCaptureInterval / srip.sri_send_interval)) < 100 && this.sendRateCaptureInterval < 1000000) {
                    this.sendRateCaptureInterval += 100000;
                }
                if (this.sendRateCaptureInterval > 100000) {
                    this.probeInterval = 2;
                }
            } else if (srip.sri_pkts_send_count >= 200) {
                while ((srip.sri_pkts_send_count = (int)((long)this.sendRateCaptureInterval / srip.sri_send_interval)) >= 100 && this.sendRateCaptureInterval > 100000) {
                    this.sendRateCaptureInterval -= 100000;
                }
                if (this.sendRateCaptureInterval == 100000) {
                    this.probeInterval = 5;
                }
            }
        }
        srip.sri_pkts_remaining = srip.sri_pkts_send_count;
        srip.sri_pkts_resent_count = 0;
        srip.sri_pkts_lost_count = 0;
        srip.sri_stalled_count = 0;
    }

    void initialize_send_rate_info() {
        send_rate_info srip = this.sri_array[this.sri_array_idx];
        short startType = 2;
        long currTime = this.usTimer.get();
        boolean probeCheck = this.sri_array_idx % this.probeInterval == 0;
        srip.sri_flags = SRI_ENTRY_VALID;
        srip.sri_first_sequence = this.sendCurrentSeq;
        srip.sri_last_sequence = 0;
        srip.sri_start_time = currTime;
        srip.sri_capture_time = 0L;
        srip.sri_send_interval = this.sendInterval;
        srip.sri_recv_bandwidth_accumulator = 0;
        srip.sri_recv_bandwidth_counter = 0;
        if (this.sendsPaused) {
            return;
        }
        if (!this.bandwidthMeasured) {
            if (this.sendCpktQueueCount >= this.quickstartBurstSize) {
                int lastSentSeq = this.sendCurrentSeq - 1;
                if (lastSentSeq < 0) {
                    lastSentSeq += 0x40000000;
                }
                if (lastSentSeq == this.lastAckRecvdSeq) {
                    srip.sri_flags |= SRI_MEASUREMENT_ENTRY;
                    srip.sri_send_interval = this.minSendInterval;
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_MEASUREMENT.ordinal(), srip.sri_send_interval, this.quickstartBurstSize, 0);
                    startType = 0;
                } else {
                    this.sendsPaused = true;
                }
            } else {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_MEASUREMENT.ordinal(), 0L, this.quickstartBurstSize, 0);
            }
        } else if (!probeCheck) {
            if (--this.probeSupressCount >= 0) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_SUPRESSED.ordinal(), this.probeSupressCount + 1, 0, 0);
            } else if (this.probesPaused) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_SUPRESSED.ordinal(), 0L, 0, 0);
            } else {
                long proposedInterval = (long)Math.floor((double)this.sendInterval / rateIncrementFactor[this.udpAggressiveness]);
                if (proposedInterval < this.minSendInterval) {
                    proposedInterval = this.minSendInterval;
                }
                if (proposedInterval < this.sendInterval) {
                    double newSendRate = 1000000.0 / (double)proposedInterval;
                    double oldSendRate = 1000000.0 / (double)this.sendInterval;
                    if (newSendRate - oldSendRate < 1.0) {
                        proposedInterval = (long)(1000000.0 / (oldSendRate + 1.0));
                    }
                    srip.sri_send_interval = proposedInterval;
                    srip.sri_flags |= SRI_RATE_PROBE;
                    startType = 1;
                    if (srip.sri_send_interval < this.minProbedInterval) {
                        this.minProbedInterval = srip.sri_send_interval;
                    }
                    this.probesPaused = true;
                } else {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)2, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_SUPRESSED.ordinal(), 0L, 0, 0);
                }
            }
        }
        this.set_send_rate_packet_counts(srip);
        if (this.sendsPaused) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, startType, (short)this.sri_array_idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.START_CAPTURE_DELAY.ordinal(), srip.sri_first_sequence, srip.sri_pkts_send_count, this.sendRateCaptureInterval);
        } else {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, startType, (short)this.sri_array_idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.START_CAPTURE_INTERVAL.ordinal(), srip.sri_first_sequence, srip.sri_pkts_send_count, this.sendRateCaptureInterval);
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)-1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.CAPTURE_INTERVAL_RATE.ordinal(), srip.sri_send_interval, 0, 0);
        }
    }

    void start_pmtu_determination(State state) throws IOException {
        long currTime = this.usTimer.get();
        this.nextAckTime = this.nextSendTime = currTime + 18000000L;
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.ACK_TIMER_SET, (short)-1, (short)-1, (short)-1, this.nextAckTime - currTime, 0, 0);
        this.sendInterval = 200000L;
        this.setState(state);
        this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.PATH_MTU_DETERMINATION, (short)-1, (short)-1, (short)UdpTrace.PATH_MTU_CODES.PMTU_STARTING.ordinal(), 0L, 0, 0);
        this.pmtuBytesTransferred = 0;
        this.pmtuStartTime = currTime;
        if (state == State.PMTU_DETERMINATION_SERVER) {
            if (this.negotiateMaxPayload) {
                this.payloadSize = pathMtuCheckSizeTable[0];
                for (int i = 0; i < pathMtuCheckSizeTableSize; ++i) {
                    this.send_transport_pmtu(1, this.pmtuSequence++, pathMtuCheckSizeTable[i]);
                    this.send_transport_pmtu(1, this.pmtuSequence++, pathMtuCheckSizeTable[i]);
                }
            } else {
                for (int i = 0; i < pathMtuCheckSizeTableSize; ++i) {
                    this.send_transport_pmtu(1, this.pmtuSequence++, this.payloadSize);
                    this.send_transport_pmtu(1, this.pmtuSequence++, this.payloadSize);
                }
            }
            this.pmtuMaxSequence = this.pmtuSequence - 1;
        }
    }

    send_rate_info capture_send_rate_info(SEND_RATE_INFO_TYPES infoType, int seqNumber) {
        send_rate_info srip = this.sri_array[this.sri_array_idx];
        switch (infoType) {
            case PACKET_SENT: {
                if (--srip.sri_pkts_remaining <= 0) break;
                return srip;
            }
            case PACKET_RESENT: {
                ++srip.sri_pkts_resent_count;
                return srip;
            }
            case SENDS_STALLED: {
                ++srip.sri_stalled_count;
                return srip;
            }
            default: {
                return srip;
            }
        }
        srip.sri_last_sequence = seqNumber;
        srip.sri_capture_time = this.usTimer.get();
        srip.sri_flags |= SRI_SENDS_COMPLETE;
        long elapsedUs = srip.sri_capture_time - srip.sri_start_time;
        double sendRate = ((double)srip.sri_pkts_send_count + (double)srip.sri_pkts_resent_count) * 1000000.0 / (double)elapsedUs;
        double nominalSendRate = 1000000.0 / (double)srip.sri_send_interval;
        if ((srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0) {
            this.sendsPaused = true;
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)this.sri_array_idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.END_CAPTURE_INTERVAL.ordinal(), srip.sri_last_sequence, srip.sri_pkts_send_count, (int)sendRate);
        } else {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)((srip.sri_flags & SRI_RATE_PROBE) != 0 ? 1 : 2), (short)this.sri_array_idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.END_CAPTURE_INTERVAL.ordinal(), srip.sri_last_sequence, srip.sri_pkts_send_count, (int)sendRate);
        }
        if ((srip.sri_flags & SRI_RATE_PROBE) != 0) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)-1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_OVER.ordinal(), this.sendInterval, 0, 0);
        }
        if (++this.sri_array_idx == this.sri_array_size) {
            this.sri_array_idx = 0;
        }
        this.initialize_send_rate_info();
        return this.sri_array[this.sri_array_idx];
    }

    protected void decrement_send_rate(int sriIdx, UdpTrace.RATE_DECREMENT_REASONS reason, double reasonParm) {
        send_rate_info srip = this.sri_array[sriIdx];
        int traceValue = 0;
        long proposedInterval = (int)Math.ceil((double)srip.sri_send_interval / rateDecrementFactor[this.udpAggressiveness]);
        switch (reason) {
            case UNSUSTAINABLE_SEND_RATE: 
            case LOW_BANDWIDTH: {
                traceValue = (int)Math.ceil(reasonParm * 100.0);
                break;
            }
            case PACKET_LOSS: {
                traceValue = (int)Math.ceil(reasonParm * 1000.0);
            }
        }
        if (proposedInterval > this.maxSendInterval) {
            proposedInterval = this.maxSendInterval;
        }
        if (proposedInterval > this.sendInterval) {
            if (this.probeSupressCount <= 0 && (this.probeSupressCount = probeDelay[this.udpAggressiveness] / (this.sendRateCaptureInterval / 100000)) == 0) {
                this.probeSupressCount = 1;
            }
            this.sendInterval = proposedInterval;
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)reason.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_DECREMENT.ordinal(), this.sendInterval, traceValue, this.probeSupressCount);
        } else {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_UNCHANGED_REASONS.REGULAR_ALREADY_DECREASED.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_UNCHANGED.ordinal(), this.sendInterval, (int)srip.sri_send_interval, 0);
        }
    }

    void check_send_rate(int idx) {
        long nominalAcks;
        send_rate_info srip = this.sri_array[idx];
        if ((srip.sri_flags & SRI_ENTRY_VALID) == 0) {
            return;
        }
        double lossTolerance = this.pktLossTolerance == 0 ? packetLossTolerance[this.udpAggressiveness] : (double)this.pktLossTolerance / 100.0;
        long elapsedUs = srip.sri_capture_time - srip.sri_start_time;
        double sendRate = ((double)srip.sri_pkts_send_count + (double)srip.sri_pkts_resent_count) * 1000000.0 / (double)elapsedUs;
        double nominalSendRate = 1000000.0 / (double)srip.sri_send_interval;
        double lossRate = (double)srip.sri_pkts_lost_count / ((double)srip.sri_pkts_send_count + (double)srip.sri_pkts_lost_count);
        double recvRate = this.protocolVersion >= 5 && srip.sri_recv_bandwidth_accumulator != 0 ? (double)srip.sri_recv_bandwidth_accumulator / (double)srip.sri_recv_bandwidth_counter : ((nominalAcks = (long)this.sendRateCaptureInterval / 10000L) > (long)srip.sri_pkts_send_count ? nominalSendRate : (double)nominalAcks / (double)srip.sri_recv_bandwidth_counter * nominalSendRate);
        double lowRecvRateTolerance = this.protocolVersion < 5 ? oldReceiveRateDegradationTolerance[this.udpAggressiveness] : newReceiveRateDegradationTolerance[this.udpAggressiveness];
        if ((srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0) {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.CAPTURE_INTERVAL_COMPLETE.ordinal(), srip.sri_last_sequence, (int)Math.ceil(recvRate * 100.0 / sendRate), (int)Math.ceil(lossRate * 1000.0));
            if (srip.sri_pkts_lost_count > 0) {
                if ((this.quickstartBurstSize >>= 1) < 4) {
                    this.quickstartBurstSize = 32;
                    this.sendInterval = 100000L;
                    if (100000L > this.maxSendInterval) {
                        this.sendInterval = this.maxSendInterval;
                    }
                    this.bandwidthMeasured = true;
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_DECREMENT_REASONS.PACKET_LOSS.ordinal(), (short)0, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_DECREMENT.ordinal(), this.sendInterval, (int)Math.ceil(lossRate * 1000.0), 0);
                } else {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RESTART_MEASUREMENT_INTERVAL.ordinal(), 0L, 0, 0);
                }
            } else if (this.protocolVersion < 6 && srip.sri_stalled_count > 0) {
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RESTART_MEASUREMENT_INTERVAL.ordinal(), 0L, 0, 0);
            } else {
                this.quickstartBurstSize = 32;
                long proposedInterval = (long)Math.ceil(1000000.0 / recvRate);
                if (proposedInterval > this.maxSendInterval) {
                    proposedInterval = this.maxSendInterval;
                } else if (proposedInterval < this.minSendInterval) {
                    proposedInterval = this.minSendInterval;
                }
                this.sendInterval = proposedInterval;
                this.bandwidthMeasured = true;
                this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_MEASURED.ordinal(), this.sendInterval, 0, 0);
            }
            this.probeSupressCount = 1;
            this.sendsPaused = false;
            this.initialize_send_rate_info();
            this.enable_udp_send();
        } else {
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)((srip.sri_flags & SRI_RATE_PROBE) != 0 ? 1 : 2), (short)idx, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.CAPTURE_INTERVAL_COMPLETE.ordinal(), srip.sri_last_sequence, (int)Math.ceil(recvRate * 100.0 / sendRate), (int)Math.ceil(lossRate * 1000.0));
            if ((srip.sri_flags & SRI_RATE_PROBE) != 0) {
                if (srip.sri_stalled_count > 0 && recvRate / sendRate < lowRecvRateTolerance) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_UNCHANGED_REASONS.PROBE_SENDING_STALLED.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_UNCHANGED.ordinal(), this.sendInterval, (int)srip.sri_send_interval, 0);
                } else if (sendRate / nominalSendRate < sustainableSendRateThreshold[this.udpAggressiveness]) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_UNCHANGED_REASONS.PROBE_SENDING_UNSUSTAINABLE.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_UNCHANGED.ordinal(), this.sendInterval, (int)srip.sri_send_interval, 0);
                } else if (recvRate / sendRate < lowRecvRateTolerance) {
                    this.probeSupressCount = probeDelay[this.udpAggressiveness] / (this.sendRateCaptureInterval / 100000);
                    if (this.probeSupressCount == 0) {
                        this.probeSupressCount = 1;
                    }
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)0, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_FAILS.ordinal(), srip.sri_send_interval, (int)Math.ceil(recvRate * 100.0 / sendRate), this.probeSupressCount);
                } else if (lossRate > lossTolerance) {
                    this.probeSupressCount = probeDelay[this.udpAggressiveness] / (this.sendRateCaptureInterval / 100000);
                    if (this.probeSupressCount == 0) {
                        this.probeSupressCount = 1;
                    }
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_PROBE_FAILS.ordinal(), srip.sri_send_interval, (int)Math.ceil(recvRate * 100.0 / sendRate), this.probeSupressCount);
                } else if (this.probeSupressCount > 0) {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_UNCHANGED_REASONS.PROBE_ALREADY_DECREASED.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_UNCHANGED.ordinal(), this.sendInterval, (int)srip.sri_send_interval, 0);
                } else {
                    this.sendInterval = srip.sri_send_interval;
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)-1, (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_INCREMENT.ordinal(), srip.sri_send_interval, (int)Math.ceil(recvRate * 100.0 / sendRate), (int)Math.ceil(lossRate * 1000.0));
                }
                this.probesPaused = false;
            } else {
                double runningLossRate = lossRate;
                int lossIntervalCount = 1000000 / this.sendRateCaptureInterval;
                int index = this.runningIntervalLossCount % 10;
                int itemCount = 1;
                this.runningIntervalLossRate[index] = lossRate;
                ++this.runningIntervalLossCount;
                int startCount = this.runningIntervalLossCount - lossIntervalCount;
                if (startCount <= 0) {
                    startCount = 0;
                }
                int i = startCount % 10;
                while (i != index) {
                    runningLossRate += this.runningIntervalLossRate[i];
                    ++itemCount;
                    i = (i + 1) % 10;
                }
                runningLossRate /= (double)itemCount;
                if (sendRate / nominalSendRate < sustainableSendRateThreshold[this.udpAggressiveness]) {
                    this.decrement_send_rate(idx, UdpTrace.RATE_DECREMENT_REASONS.UNSUSTAINABLE_SEND_RATE, sendRate / nominalSendRate);
                } else if (recvRate / sendRate < lowRecvRateTolerance) {
                    this.decrement_send_rate(idx, UdpTrace.RATE_DECREMENT_REASONS.LOW_BANDWIDTH, recvRate / sendRate);
                } else if (runningLossRate > lossTolerance) {
                    this.decrement_send_rate(idx, UdpTrace.RATE_DECREMENT_REASONS.PACKET_LOSS, runningLossRate);
                    this.runningIntervalLossCount = 0;
                } else {
                    this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RATE_CAPTURE, (short)UdpTrace.RATE_UNCHANGED_REASONS.REGULAR_ACCEPTABLE.ordinal(), (short)-1, (short)UdpTrace.SEND_RATE_CHANGE_REASONS.RATE_UNCHANGED.ordinal(), this.sendInterval, (int)srip.sri_send_interval, 0);
                    if (srip.sri_send_interval < this.bestSustainedInterval) {
                        this.bestSustainedInterval = srip.sri_send_interval;
                    }
                }
            }
            if (this.sendsPaused) {
                this.sendsPaused = false;
                this.initialize_send_rate_info();
                this.enable_udp_send();
            }
        }
        srip.sri_flags &= ~SRI_ENTRY_VALID;
    }

    int find_appropriate_sri_block(int sequence) {
        int diff;
        int scanIdx = this.sri_last_acked_idx;
        send_rate_info srip = this.sri_array[scanIdx];
        if ((srip.sri_flags & SRI_MEASUREMENT_ENTRY) != 0) {
            diff = sequence - srip.sri_first_sequence;
            if (diff < 0) {
                diff += 0x40000000;
            }
            if (diff > 0x20000000) {
                return -1;
            }
        }
        while (scanIdx != this.sri_array_idx && (srip.sri_flags & SRI_SENDS_COMPLETE) != 0) {
            diff = srip.sri_last_sequence - sequence;
            if (diff < 0) {
                diff += 0x40000000;
            }
            if (diff < 0x20000000) break;
            if (++scanIdx == this.sri_array_size) {
                scanIdx = 0;
            }
            srip = this.sri_array[scanIdx];
        }
        return scanIdx;
    }

    void update_send_rate_loss_info(int lostSeq) {
        int sribIdx = this.find_appropriate_sri_block(lostSeq);
        if (sribIdx < 0) {
            return;
        }
        ++this.sri_array[sribIdx].sri_pkts_lost_count;
    }

    public void shutdown() throws IOException {
        switch (this.state) {
            case IDLE: 
            case TERMINATING: {
                break;
            }
            case CONNECTING: {
                this.send_transport_rejection();
                this.relayedConnection = false;
            }
            case ACCEPTING: {
                this.reset();
                break;
            }
            case ACCEPT_CMPLT_WAIT: 
            case CONNECT_CMPLT_WAIT: 
            case CONNECTED: {
                this.setState(State.CLOSE_PENDING);
                this.enable_udp_send();
                break;
            }
            case CLOSE_WAIT: {
                this.setState(State.TERMINATING);
                break;
            }
        }
    }

    void reset() throws IOException {
        if (this.sessionLog.isLoggable(Level.FINEST)) {
            this.sessionLog.finest("Invoked UdpSession 'reset()' method for address: " + this.getAgentAddress());
        }
        this.udpTerminating = true;
        if (this.udpThread != null && this.udpThread.isAlive() && Thread.currentThread() != this.udpThread) {
            this.enable_udp_send();
            this.sessionLog.finer("Joining the UDP thread.");
            this.unlock();
            this.udpThread.terminate();
            try {
                this.udpThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.lock();
        }
        this.sessionLog.finer("The UDP thread has joined the main thread.");
        this.udpThread = null;
        this.udpTerminating = false;
        this.sendCurrentSeq = 0;
        this.sendWindowLeftSeq = 0;
        this.recvCurrentSeq = 0;
        this.nextSenderSeq = 0;
        this.lastAckAcknowlegedSeq = 0;
        this.curr_ack_seq = 0;
        this.last_ack_seq = 0;
        this.protocolVersion = 6;
        this.payloadSize = 1024;
        this.setRecvWindowSize(128, (short)UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT.ordinal());
        this.setSendWindowSize(128, (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_CONNECT.ordinal());
        this.ackInterval = 10000L;
        this.curr_cnct_seq = 0;
        this.lastError = null;
        this.send_transport_rejection();
        this.remoteAddress = null;
        this.relayAddress = null;
        this.relayedConnection = false;
        this.setState(State.IDLE);
        this.terminate_connections();
        this.drainBuffers();
        this.unlock();
    }

    void terminate_connections() {
        if (this.connectionTable == null) {
            return;
        }
        block6: for (int i = 0; i < this.connectionTable.length; ++i) {
            UdpConnection cnp = this.connectionTable[i];
            if (cnp == null) continue;
            switch (cnp.state) {
                case IDLE: {
                    continue block6;
                }
                case CLOSED: 
                case LISTENING: {
                    cnp.release_resources();
                    continue block6;
                }
                default: {
                    cnp.release_resources();
                    try {
                        cnp.send_rejection();
                        continue block6;
                    }
                    catch (UdpBaseException udpBaseException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static UdpSession initialize(int maxConnections, String logInstance, String id, int traceMask) throws UdpBaseException {
        if (maxConnections < 1 || maxConnections > 32) {
            return null;
        }
        return new UdpSession(maxConnections, logInstance, id, traceMask);
    }

    public static boolean isThisMyIpAddress(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (SocketException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(InetSocketAddress address, int timeout) throws IOException {
        try {
            int i;
            this.lock();
            if (this.state != State.IDLE) {
                throw new IOException("Session has already been connected.");
            }
            this.remoteAddress = address;
            if (this.relayAddress != null) {
                address = this.relayAddress;
            }
            try {
                this.channel = DatagramChannel.open();
                this.channel.connect(address);
                this.socket = this.channel.socket();
                if (this.localUdpPortNumber > 0) {
                    this.channel.disconnect();
                    this.socket.close();
                    this.channel = DatagramChannel.open();
                    this.socket = this.channel.socket();
                    InetAddress localAddress = this.socket.getLocalAddress();
                    if (UdpSession.isThisMyIpAddress(address.getAddress())) {
                        try {
                            this.sessionLog.finer("Trying to bind to " + localAddress.getHostAddress() + ":0");
                            this.socket.setReuseAddress(false);
                            this.socket.bind(new InetSocketAddress(localAddress, 0));
                            this.channel.connect(address);
                            this.sessionLog.finer("Bound to " + this.socket.getLocalPort());
                        }
                        catch (BindException e) {
                            this.socket.close();
                            throw new IOException("Cannot bind to a free UDP ephemeral port");
                        }
                    } else {
                        int i2 = this.localUdpPortNumber;
                        while (true) {
                            try {
                                this.sessionLog.finer("Trying to bind to " + localAddress.getHostAddress() + ":" + i2);
                                this.socket.setReuseAddress(false);
                                this.socket.bind(new InetSocketAddress(localAddress, i2));
                                this.channel.connect(address);
                                this.sessionLog.finer("Bound to " + i2);
                            }
                            catch (BindException e) {
                                this.socket.close();
                                if (++i2 > this.localUdpPortNumber + this.localUdpPortRange) {
                                    throw new IOException("Cannot find a free UDP port in the range " + this.localUdpPortNumber + "-" + (this.localUdpPortNumber + this.localUdpPortRange));
                                }
                                this.channel = DatagramChannel.open();
                                this.socket = this.channel.socket();
                                continue;
                            }
                            break;
                        }
                    }
                }
                this.channel.configureBlocking(false);
            }
            catch (IOException e) {
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
                if (this.channel != null && this.channel.isOpen()) {
                    this.channel.close();
                }
                this.sessionLog.severe("Unable to initialize datagram socket:  " + e.getMessage());
                throw e;
            }
            int sampleSize = 20;
            long[] samples = new long[sampleSize];
            long lockSupportTime = 0L;
            long sleepTime = 0L;
            for (i = 0; i < sampleSize; ++i) {
                long start = this.usTimer.get();
                LockSupport.parkNanos(1000L);
                long end = this.usTimer.get();
                samples[i] = end - start;
            }
            lockSupportTime = this.getStatisticallyValidAverageTime(samples);
            for (i = 0; i < sampleSize; ++i) {
                long start = this.usTimer.get();
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                }
                long end = this.usTimer.get();
                samples[i] = end - start;
            }
            sleepTime = this.getStatisticallyValidAverageTime(samples);
            if (sleepTime < lockSupportTime) {
                this.finestParkNanos = sleepTime * 1000L;
                this.useLockSupport = false;
            } else {
                this.finestParkNanos = lockSupportTime * 1000L;
                this.useLockSupport = true;
            }
            this.finestSleepNanos = sleepTime * 1000L;
            this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.JAVA_WAIT_METHOD, this.useLockSupport ? (short)0 : 1, (short)-1, (short)-1, this.finestParkNanos, 0, 0);
            this.udpThread = new UdpThread();
            this.udpThread.start();
            while (this.sendInitialSeq == 0) {
                long currTime = this.usTimer.get();
                this.sendInitialSeq = (int)((currTime & 0xFFL) * 0x40000000L >> 8);
            }
            this.sendCurrentSeq = this.sendInitialSeq;
            this.sendWindowLeftSeq = this.sendInitialSeq;
            this.recvCurrentSeq = -1;
            this.nextSenderSeq = -1;
            this.lastAckAcknowlegedSeq = -1;
            this.curr_ack_seq = 0;
            this.last_ack_seq = -1;
            this.protocolVersion = 6;
            this.payloadSize = this.requestedPayloadSize;
            this.setRecvWindowSize(128, (short)UdpTrace.RECV_WINDOW_CHANGE_TYPES.RWC_CONNECT.ordinal());
            this.setSendWindowSize(128, (short)UdpTrace.SEND_WINDOW_CHANGE_TYPES.SWC_CONNECT.ordinal());
            this.nextSendTime = this.usTimer.get();
            this.curr_cnct_seq = 0;
            this.lastError = null;
            this.setState(State.CONNECTING);
            this.enable_udp_send();
            if (timeout != 0) {
                try {
                    if (timeout < 0) {
                        this.event.await();
                    } else if (!this.event.await(timeout, TimeUnit.MICROSECONDS)) {
                        this.reset();
                        throw new TimedOutException();
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.state != State.CONNECTED && this.lastError != null) {
                    IOException e = this.lastError;
                    this.reset();
                    throw e;
                }
            }
            Object var16_21 = null;
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            try {
                this.unlock();
            }
            catch (IllegalMonitorStateException discard) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.unlock();
        }
        catch (IllegalMonitorStateException discard) {}
    }

    public void dumpTrace(FileWriter fileWriter, String idTag) {
        try {
            this.traceCtx.udp_trace_print(this.payloadSize, idTag, fileWriter);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private long getStatisticallyValidAverageTime(long[] sample) {
        long sum = 0L;
        long squaredSum = 0L;
        int sampleSize = sample.length;
        for (int i = 0; i < sampleSize; ++i) {
            sum += sample[i];
            squaredSum += sample[i] * sample[i];
        }
        long average = sum / (long)sampleSize;
        long stdDev = (long)Math.sqrt(squaredSum / (long)sampleSize - average * average);
        int validSamples = 0;
        sum = 0L;
        squaredSum = 0L;
        for (int i = 0; i < sampleSize; ++i) {
            if (sample[i] >= average + stdDev) continue;
            sum += sample[i];
            squaredSum += sample[i] * sample[i];
            ++validSamples;
        }
        if (validSamples > 0) {
            average = sum / (long)validSamples;
        }
        return average;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishConnect(int timeout) throws IOException {
        try {
            this.lock();
            if (this.state == State.IDLE) {
                throw new IOException("The session is not in the correct state.");
            }
            switch (this.state) {
                case CONNECTING: 
                case CONNECT_CMPLT_WAIT: {
                    try {
                        if (timeout < 0) {
                            this.event.await();
                            break;
                        }
                        if (!this.event.await(timeout, TimeUnit.MICROSECONDS)) {
                            throw new TimedOutException();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                case CONNECTED: {
                    this.lastError = null;
                    break;
                }
                default: {
                    throw new ConnectionAbortedException();
                }
            }
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public InetSocketAddress getAgentAddress() {
        this.lock();
        InetSocketAddress result = this.remoteAddress;
        this.unlock();
        return result;
    }

    public int getMaximumBandwidth() {
        this.lock();
        int result = 0;
        result = this.udpMaxBandwidth != 0L ? (int)(this.udpMaxBandwidth * (long)this.payloadSize) : (int)Math.ceil(1000000.0 * (double)this.payloadSize / 1.0);
        this.unlock();
        return result;
    }

    public void setMaximumBandwidth(long value) {
        this.lock();
        if (value <= 0L) {
            this.udpMaxBandwidth = 0L;
        } else {
            this.udpMaxBandwidth = value / (long)this.payloadSize;
            if (this.udpMaxBandwidth < 1L) {
                this.udpMaxBandwidth = 1L;
            }
            if (this.udpMaxBandwidth > 100000L) {
                this.udpMaxBandwidth = 100000L;
            }
            if (this.udpMaxBandwidth < this.udpMinBandwidth) {
                this.udpMinBandwidth = this.udpMaxBandwidth;
            }
            int maxBandwidth = (int)Math.ceil(1.48E9);
            int minBandwidth = (int)Math.ceil(7400.0);
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)maxBandwidth) {
                value = maxBandwidth;
            } else if (value < (long)minBandwidth) {
                value = minBandwidth;
            }
            this.udpMaxBandwidth = value;
            if (this.udpMaxBandwidth != 0L && this.udpMinBandwidth != 0L && this.udpMaxBandwidth < this.udpMinBandwidth) {
                this.udpMinBandwidth = this.udpMaxBandwidth;
            }
            this.minSendInterval = 0L;
        }
        this.recompute_send_interval_limits();
        this.unlock();
    }

    public long getMinimumBandwidth() {
        this.lock();
        int result = 0;
        result = this.udpMinBandwidth != 0L ? (int)(this.udpMinBandwidth * (long)this.payloadSize) : (int)Math.ceil(1000000.0 * (double)this.payloadSize / 200000.0);
        this.unlock();
        return result;
    }

    public void setMinimumBandwidth(long intCmdArg) {
        this.lock();
        int minBandwidth = (int)Math.ceil(7400.0);
        int maxBandwidth = (int)Math.ceil(1.48E9);
        if (intCmdArg < 0L) {
            intCmdArg = 0L;
        } else if (intCmdArg < (long)minBandwidth) {
            intCmdArg = minBandwidth;
        } else if (intCmdArg > (long)maxBandwidth) {
            intCmdArg = maxBandwidth;
        }
        this.udpMinBandwidth = intCmdArg;
        if (this.udpMinBandwidth != 0L && this.udpMaxBandwidth != 0L && this.udpMinBandwidth > this.udpMaxBandwidth) {
            this.udpMaxBandwidth = this.udpMinBandwidth;
        }
        this.maxSendInterval = 0L;
        this.recompute_send_interval_limits();
        this.unlock();
    }

    public void setLocalUdpPortNumber(int portNumber) {
        this.localUdpPortNumber = portNumber;
    }

    public void setLocalUdpPortRange(int portRange) {
        this.localUdpPortRange = portRange;
    }

    public int getAggressiveness() {
        this.lock();
        int result = this.udpAggressiveness;
        this.unlock();
        return result;
    }

    public void setAggressiveness(int value) {
        this.lock();
        this.udpAggressiveness = value;
        if (this.udpAggressiveness < 0) {
            this.udpAggressiveness = 0;
        } else if (this.udpAggressiveness > 2) {
            this.udpAggressiveness = 2;
        }
        this.unlock();
    }

    public int getTickleInterval() {
        this.lock();
        int result = this.tickleInterval;
        this.unlock();
        return result;
    }

    public void setTickleInterval(int value) {
        this.lock();
        this.tickleInterval = value;
        if (this.tickleInterval < 5) {
            this.tickleInterval = 5;
        } else if (this.tickleInterval > 60) {
            this.tickleInterval = 60;
        }
        this.unlock();
    }

    public double getTickleThreshold() {
        this.lock();
        double result = this.tickleThreshold;
        this.unlock();
        return result;
    }

    public void setTickleThreshold(int value) {
        this.lock();
        this.tickleThreshold = value;
        if (this.tickleInterval < 1) {
            this.tickleInterval = 1;
        } else if (this.tickleInterval > 10000) {
            this.tickleInterval = 10000;
        }
        this.unlock();
    }

    public int getBurstQuantum() {
        this.lock();
        int result = this.burstQuantum;
        this.unlock();
        return result;
    }

    public void setBurstQuantum(int value) {
        this.lock();
        this.burstQuantum = value < 0 ? 2000 : (value > 10000 ? 10000 : value);
        this.unlock();
    }

    public InetSocketAddress getRelay() {
        this.lock();
        InetSocketAddress result = this.relayAddress;
        this.unlock();
        return result;
    }

    public void setRelay(InetSocketAddress address) {
        this.lock();
        this.relayAddress = address;
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UdpConnection create(byte handle) throws IOException {
        UdpConnection cnp = null;
        try {
            this.lock.lock();
            if (this.state == State.IDLE || this.state.ordinal() > State.CONNECTED.ordinal()) {
                throw new IOException("Session has not been established yet.");
            }
            cnp = this.find_free_connection(handle);
            cnp.setState(UdpConnection.State.INITIALIZING);
            Object var4_3 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        return cnp;
    }

    public SessionStatistics getStatistics() {
        this.lock();
        SessionStatistics stats = new SessionStatistics();
        stats.pkts_received = this.cpktsReceived;
        stats.pkts_rejected_dup = this.cpktsRejectedDuplicate;
        stats.pkts_rejected_left = this.cpktsRejectedLeft;
        stats.pkts_rejected_right = this.cpktsRejectedRight;
        stats.pkts_resent = this.cpktsResent;
        stats.pkts_sent = this.cpktsSent;
        stats.pkts_acked = this.cpktsAcked;
        stats.send_window_filled_count = this.sendWindowFilledCount;
        stats.recv_window_hwm = this.recvWindowHighWaterMark;
        stats.send_window_hwm = this.sendWindowHighWaterMark;
        stats.bytes_received = this.cpktBytesReceived;
        stats.bytes_sent = this.cpktBytesSent;
        stats.bytes_resent = this.cpktBytesResent;
        stats.bytes_acked = this.cpktBytesAcked;
        this.unlock();
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(int timeout) throws IOException {
        try {
            this.lock();
            if (timeout < 0) {
                this.shutdownAttemptCount = 10;
            } else {
                this.shutdownAttemptCount = (int)((long)timeout * 1000L / ((long)this.averageRoundTripTime + 20000L));
                if (this.shutdownAttemptCount < 1) {
                    this.shutdownAttemptCount = 2;
                } else if (this.shutdownAttemptCount > 10) {
                    this.shutdownAttemptCount = 10;
                }
            }
            switch (this.state) {
                case IDLE: {
                    throw new IOException("Session not connected.");
                }
                case CONNECTING: 
                case CLOSE_WAIT: 
                case CONNECT_CMPLT_WAIT: 
                case CONNECTED: {
                    this.lastError = null;
                    this.shutdown();
                    try {
                        while (this.state == State.CLOSE_PENDING || this.state == State.CLOSING) {
                            if (this.event.await(10000L, TimeUnit.MICROSECONDS)) continue;
                            this.lastError = new TimedOutException();
                            throw this.lastError;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.reset();
                }
            }
            Object var4_3 = null;
            this.unlock();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws IOException {
        int i;
        if (this.sessionLog.isLoggable(Level.FINEST)) {
            this.sessionLog.finest("Invoked UdpSession 'terminate()' method for address: " + this.getAgentAddress());
        }
        try {
            this.lock();
            this.udpTerminating = true;
            if (this.udpThread != null && this.udpThread.isAlive()) {
                this.reset();
            }
            Object var2_1 = null;
            if (this.lock.isHeldByCurrentThread()) {
                this.unlock();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.lock.isHeldByCurrentThread()) {
                this.unlock();
            }
            throw throwable;
        }
        this.abort(null);
        if (this.connectionTable != null) {
            for (i = 0; i < this.connectionTable.length; ++i) {
                UdpConnection cnp = this.connectionTable[i];
                if (cnp == null || cnp.state == UdpConnection.State.IDLE) continue;
                cnp.post_recv_event();
                cnp.destroy();
            }
        }
        this.drainBuffers();
        this.rtt_info_array = null;
        this.connectionTable = null;
        for (i = 0; i < this.sendWindow.length; ++i) {
            if (this.sendWindow[i] == null) continue;
            this.sendWindow[i].release();
            this.sendWindow[i] = null;
        }
        for (i = 0; i < this.recvWindow.length; ++i) {
            if (this.recvWindow[i] == null) continue;
            this.recvWindow[i].release();
            this.recvWindow[i] = null;
        }
        try {
            this.channel.disconnect();
        }
        catch (Exception discard) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drainBuffers() {
        Object object = this.bufferLock;
        synchronized (object) {
            if (this.buffers != null) {
                this.buffers.drain();
                this.buffers = null;
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected send_rate_info[] getSendRateInfoArray() {
        return this.sri_array;
    }

    public Logger getSessionLog() {
        return this.sessionLog;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Buffers {
        private int totalCount = 0;
        private int in = 0;
        private int out = 0;
        private static final int reservedFreeMemory = 0x1000000;
        private final Queue<DatagramBuffer> freeDgbs = new LinkedList<DatagramBuffer>();

        public int expandFreeList(int size) {
            int i = 0;
            long memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
            if (!UdpSession.this.memoryCapReached && this.totalCount < 341890) {
                try {
                    for (i = 0; i < size; ++i) {
                        memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
                        if (memory < 0x1000000L) {
                            throw new OutOfMemoryError();
                        }
                        DatagramBuffer b = new DatagramBuffer(UdpSession.this);
                        this.freeDgbs.offer(b);
                        ++this.totalCount;
                    }
                    if (UdpSession.this.connectionLog.isLoggable(Level.FINE)) {
                        UdpSession.this.sessionLog.info(" Allocated " + size + " datagram buffers for a total of " + this.totalCount + ". Send queue max: " + UdpSession.this.sendQueueSize + ", receive queue max: " + UdpSession.this.recvQueueSize + ", Send queue length: " + UdpSession.this.sendCpktQueueCount + ", Unacked count: " + UdpSession.this.unackedPktCount);
                    }
                }
                catch (OutOfMemoryError e) {
                    UdpSession.this.memoryCapReached = true;
                    UdpSession.this.sessionLog.info("Memory cap reached at " + this.totalCount + " datagram buffers," + " current free count=" + this.freeDgbs.size() + " memory " + memory);
                }
            }
            return i;
        }

        public Buffers() throws UdpBaseException {
            this.expandFreeList(1000);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DatagramBuffer take() throws UdpBaseException {
            DatagramBuffer dgb = null;
            Buffers buffers = this;
            synchronized (buffers) {
                dgb = this.freeDgbs.poll();
                if (dgb == null) {
                    this.expandFreeList(1000);
                    dgb = this.freeDgbs.poll();
                }
            }
            ++this.out;
            return dgb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Queue<DatagramBuffer> take(int count) throws UdpBaseException {
            LinkedList<DatagramBuffer> allocList = null;
            Buffers buffers = this;
            synchronized (buffers) {
                for (int i = 0; i < count; ++i) {
                    DatagramBuffer dgb = this.freeDgbs.poll();
                    if (dgb == null) {
                        this.expandFreeList(1000);
                        dgb = this.freeDgbs.poll();
                    }
                    if (allocList == null) {
                        try {
                            allocList = new LinkedList<DatagramBuffer>();
                            allocList.offer(dgb);
                            ++this.out;
                            continue;
                        }
                        catch (OutOfMemoryError e) {
                            UdpSession.this.memoryCapReached = true;
                            this.freeDgbs.offer(dgb);
                            UdpSession.this.sessionLog.info("Memory cap reached at " + count + " datagram buffers," + " current free count=" + this.freeDgbs.size());
                            break;
                        }
                    }
                    allocList.offer(dgb);
                    ++this.out;
                }
            }
            return allocList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putback(DatagramBuffer dgb) {
            dgb.reset();
            Buffers buffers = this;
            synchronized (buffers) {
                this.freeDgbs.offer(dgb);
                ++this.in;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void putback(Queue<DatagramBuffer> dgbList) {
            Buffers buffers = this;
            synchronized (buffers) {
                DatagramBuffer dgb;
                while ((dgb = dgbList.poll()) != null) {
                    dgb.reset();
                    this.freeDgbs.offer(dgb);
                    ++this.in;
                }
            }
        }

        public int getCount() {
            return this.totalCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drain() {
            Buffers buffers = this;
            synchronized (buffers) {
                DatagramBuffer dgb;
                while (this.freeDgbs.size() > 0 && (dgb = this.freeDgbs.poll()) != null) {
                    dgb.release();
                }
            }
        }
    }

    class rtt_info {
        boolean entry_valid;
        int ack_sequence;
        int sequence;
        long send_time;

        rtt_info() {
        }

        public void reset() {
            this.entry_valid = false;
            this.ack_sequence = 0;
            this.sequence = 0;
            this.send_time = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RATE_PARAMETER_TYPES {
        AGGRESSIVENESS,
        CEILING,
        FLOOR,
        BURST_QUANTUM_MS,
        LOSS_TOLERANCE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SEND_RATE_INFO_TYPES {
        PACKET_SENT,
        PACKET_RESENT,
        SENDS_STALLED;

    }

    protected class send_rate_info {
        long sri_start_time;
        long sri_capture_time;
        long sri_send_interval;
        int sri_flags;
        int sri_first_sequence;
        int sri_last_sequence;
        int sri_pkts_resent_count;
        int sri_pkts_send_count;
        int sri_pkts_lost_count;
        int sri_pkts_remaining;
        int sri_stalled_count;
        int sri_recv_bandwidth_counter;
        int sri_recv_bandwidth_accumulator;

        protected send_rate_info() {
        }

        public void reset() {
            this.sri_start_time = 0L;
            this.sri_capture_time = 0L;
            this.sri_send_interval = 0L;
            this.sri_flags = 0;
            this.sri_first_sequence = 0;
            this.sri_last_sequence = 0;
            this.sri_pkts_resent_count = 0;
            this.sri_pkts_send_count = 0;
            this.sri_pkts_lost_count = 0;
            this.sri_pkts_remaining = 0;
            this.sri_stalled_count = 0;
            this.sri_recv_bandwidth_counter = 0;
            this.sri_recv_bandwidth_accumulator = 0;
        }
    }

    private class nak_descriptor {
        nak_descriptor nakd_next;
        long nakd_sendTime;
        int nakd_firstSequence;
        int nakd_lastSequence;

        private nak_descriptor() {
        }
    }

    private class loss_report {
        loss_report lrpt_next;
        int lrpt_idx;
        int lrpt_offset;
        long lrpt_time;
        int lrpt_count;
        int[] lrpt_entries = new int[370];

        loss_report() {
        }
    }

    class select_wait_blk {
        Thread thread = Thread.currentThread();
        Condition event;
        cnct_set rdMask;
        cnct_set wrMask;
        cnct_set shMask;
        boolean posted;

        public select_wait_blk() {
            this.event = UdpSession.this.lock.newCondition();
            this.rdMask = new cnct_set();
            this.wrMask = new cnct_set();
            this.shMask = new cnct_set();
            this.posted = false;
        }
    }

    class cnct_set {
        static final int _NCNCTBITS = 32;
        int[] cncts_bits = new int[this._intcnt(32, 32)];

        int _intcnt(int x, int y) {
            return (x + y - 1) / y;
        }

        cnct_set() {
        }

        void SET(int n) {
            int n2 = n / 32;
            this.cncts_bits[n2] = this.cncts_bits[n2] | 1 << n % 32;
        }

        void CLR(int n) {
            int n2 = n / 32;
            this.cncts_bits[n2] = this.cncts_bits[n2] & ~(1 << n % 32);
        }

        boolean ISSET(int n) {
            return (this.cncts_bits[n / 32] & 1 << n % 32) != 0;
        }

        void ZERO() {
            Arrays.fill(this.cncts_bits, 0);
        }
    }

    protected class UdpThread
    extends Thread {
        private Selector readSelector;
        private SelectionKey selectionKey;
        private boolean terminating = false;
        private boolean wakeup = false;
        boolean windows = System.getProperty("os.name").toLowerCase().startsWith("windows");

        public UdpThread() throws IOException {
            try {
                this.readSelector = Selector.open();
            }
            catch (IOException e) {
                UdpSession.this.sessionLog.severe("Unable to create selector: " + e.getMessage());
                throw e;
            }
        }

        protected void udp_event_wait() {
            long nextSendDelay;
            int nFound = 0;
            long endTime = UdpSession.this.usTimer.get();
            long startTime = endTime;
            long nextAckDelay = UdpSession.this.nextAckTime - startTime;
            long waitTime = nextAckDelay < (nextSendDelay = UdpSession.this.nextSendTime - startTime) ? nextAckDelay : nextSendDelay;
            if (this.terminating) {
                return;
            }
            UdpSession.this.unlock();
            int threshold = (int)(UdpSession.this.finestSleepNanos / 1500L);
            UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_PAUSE, (short)-1, (short)-1, (short)0, waitTime, (int)nextSendDelay, (int)nextAckDelay);
            if (waitTime <= 0L) {
                Thread.yield();
                endTime = UdpSession.this.usTimer.get();
                UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RESUME, (short)-1, (short)-1, (short)0, UdpSession.this.cpktsSent, (int)(endTime - startTime), UdpSession.this.sendCpktQueueCount);
                waitTime = 0L;
            } else {
                nFound = 0;
                while (endTime - startTime < waitTime) {
                    if (UdpSession.this.burstQuantum > 0 && waitTime >= 1000L && waitTime > (long)threshold) {
                        try {
                            long wait = TimeUnit.MILLISECONDS.convert(waitTime, TimeUnit.MICROSECONDS);
                            nFound = this.readSelector.select(wait);
                        }
                        catch (IOException e) {
                            UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SELECT_ERROR, (short)-1, (short)-1, (short)-1, 0L, 0, 0);
                            UdpSession.this.sessionLog.severe("Error from select:  " + e.getMessage());
                            UdpSession.this.abort(e);
                            nFound = -1;
                        }
                        endTime = UdpSession.this.usTimer.get();
                        break;
                    }
                    if (UdpSession.this.useLockSupport && waitTime * 1000L > UdpSession.this.finestParkNanos) {
                        LockSupport.parkNanos(1000L);
                    } else {
                        Thread.yield();
                    }
                    endTime = UdpSession.this.usTimer.get();
                }
                if (nFound > 0) {
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RESUME, (short)-1, (short)-1, (short)2, UdpSession.this.cpktsSent, (int)(endTime - startTime), UdpSession.this.sendCpktQueueCount);
                } else {
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_RESUME, (short)-1, (short)-1, (short)0, UdpSession.this.cpktsSent, (int)(endTime - startTime), UdpSession.this.sendCpktQueueCount);
                }
            }
            if (UdpSession.this.burstQuantum != 0 && waitTime < 10000L) {
                UdpSession.this.desiredWaitTimeAccumulator += waitTime;
                UdpSession.this.actualWaitTimeAccumulator += endTime - startTime;
                if (++UdpSession.this.waitTimeCounter >= 100) {
                    if (UdpSession.this.desiredWaitTimeAccumulator == 0L) {
                        UdpSession.this.desiredWaitTimeAccumulator = 1L;
                    }
                    double ratio = (double)UdpSession.this.actualWaitTimeAccumulator / (double)UdpSession.this.desiredWaitTimeAccumulator * 10.0;
                    UdpSession.this.timerTraceCounter++;
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.TIMER_PERFORMANCE, (short)UdpSession.this.waitTimeCounter, (short)-1, (short)-1, UdpSession.this.desiredWaitTimeAccumulator / (long)UdpSession.this.waitTimeCounter, (int)(UdpSession.this.actualWaitTimeAccumulator / (long)UdpSession.this.waitTimeCounter), (int)Math.ceil(ratio));
                    UdpSession.this.desiredWaitTimeAccumulator = 0L;
                    UdpSession.this.actualWaitTimeAccumulator = 0L;
                    UdpSession.this.waitTimeCounter = 0;
                    if (UdpSession.this.burstCountAccumulator > 0L) {
                        long avgBurstTime = UdpSession.this.burstTimeAccumulator / UdpSession.this.burstCountAccumulator;
                        long avgPktsPerBurst = UdpSession.this.burstPacketsAccumulator / UdpSession.this.burstCountAccumulator;
                        UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.JAVA_BURST_PERFORMANCE, (short)-1, (short)-1, (short)-1, UdpSession.this.burstCountAccumulator, (int)avgBurstTime, (int)avgPktsPerBurst);
                    }
                }
            }
            if (waitTime < 20000L && nFound == 0) {
                UdpSession.this.eventWaitCount++;
                UdpSession.this.eventWaitCummulativeTimeActual += endTime - startTime;
                UdpSession.this.eventWaitCummulativeTimeRequested += waitTime;
            }
            UdpSession.this.lock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block61: {
                DatagramBuffer dgbp = null;
                long currTime = UdpSession.this.usTimer.get();
                boolean tracedEmpty = false;
                UdpSession.this.tracedSocketFull = false;
                int socksize = 0;
                UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)0, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                try {
                    socksize = UdpSession.this.socket.getReceiveBufferSize();
                    while (socksize < 0x1000000) {
                        UdpSession.this.socket.setReceiveBufferSize(socksize *= 2);
                        if (socksize == UdpSession.this.socket.getReceiveBufferSize()) continue;
                    }
                    socksize = UdpSession.this.socket.getSendBufferSize();
                    while (socksize < 0x1000000) {
                        UdpSession.this.socket.setSendBufferSize(socksize *= 2);
                        if (socksize == UdpSession.this.socket.getSendBufferSize()) continue;
                    }
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_BUFFER_SIZE, (short)-1, (short)-1, (short)0, UdpSession.this.socket.getReceiveBufferSize(), 0, 0);
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_BUFFER_SIZE, (short)-1, (short)-1, (short)1, UdpSession.this.socket.getSendBufferSize(), 0, 0);
                }
                catch (SocketException e) {
                    UdpSession.this.sessionLog.warning("Unable to set socket buffer sizes: " + e.getMessage());
                }
                try {
                    this.selectionKey = UdpSession.this.channel.register(this.readSelector, 1);
                }
                catch (IOException e) {
                    UdpSession.this.sessionLog.severe("Unable to register selector with UDP channel: " + e.getMessage());
                    UdpSession.this.abort(e);
                    return;
                }
                UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)0, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                Thread t = Thread.currentThread();
                t.setName("UDP Processing");
                UdpSession.this.udpThread = this;
                UdpSession.this.lock();
                while (!this.terminating) {
                    boolean socketEmpty = false;
                    int packetsCounter = 0;
                    while (!this.terminating && !socketEmpty) {
                        int n;
                        if (dgbp == null && (dgbp = UdpSession.this.buffers.take()) == null) {
                            UdpSession.this.sessionLog.severe("Disabling the UDP socket receive events:  No available datagram buffers.");
                            UdpSession.this.abort(new IOException("No available datagram buffers"));
                            this.terminating = true;
                            break;
                        }
                        try {
                            n = dgbp.read(UdpSession.this.channel);
                        }
                        catch (IOException e) {
                            UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_READ_ERROR, (short)-1, (short)-1, (short)-1, 0L, 0, 0);
                            UdpSession.this.sessionLog.severe("Socket receive error: " + e.getMessage());
                            UdpSession.this.abort(e);
                            this.terminating = true;
                            break;
                        }
                        if (n > 0) {
                            tracedEmpty = false;
                            ++packetsCounter;
                            dgbp = UdpSession.this.process_received_datagram(dgbp);
                        } else {
                            if (dgbp.length() == 0 && !tracedEmpty) {
                                UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.UDP_SOCKET_EMPTY, (short)-1, (short)-1, (short)-1, UdpSession.this.cpktsReceived, packetsCounter, 0);
                                tracedEmpty = true;
                            }
                            socketEmpty = true;
                        }
                        currTime = UdpSession.this.usTimer.get();
                        if (currTime >= UdpSession.this.nextAckTime) {
                            switch (UdpSession.this.state) {
                                case IDLE: 
                                case CONNECTING: 
                                case ACCEPTING: 
                                case TERMINATING: 
                                case PMTU_DETERMINATION_SERVER: {
                                    UdpSession.this.nextAckTime = currTime + UdpSession.this.ackInterval;
                                    break;
                                }
                                default: {
                                    UdpSession.this.send_transport_ack();
                                    currTime = UdpSession.this.usTimer.get();
                                }
                            }
                        }
                        if (currTime < UdpSession.this.nextSendTime) continue;
                        UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.RECV_LOOP_EXIT, (short)-1, (short)-1, (short)-1, UdpSession.this.cpktsReceived, packetsCounter, 0);
                        break;
                    }
                    if (this.terminating) continue;
                    if (currTime - UdpSession.this.nextSendTime >= 0L) {
                        packetsCounter = UdpSession.this.udp_send_check();
                        UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.SEND_LOOP_EXIT, (short)-1, (short)-1, (short)-1, UdpSession.this.cpktsSent, packetsCounter, 0);
                    }
                    this.udp_event_wait();
                }
                Object var12_14 = null;
                this.selectionKey.cancel();
                try {
                    this.readSelector.close();
                }
                catch (IOException discard) {
                    // empty catch block
                }
                try {
                    UdpSession.this.unlock();
                }
                catch (IllegalMonitorStateException discard) {
                    // empty catch block
                }
                discard = UdpSession.this.udpSelectWaitList;
                synchronized (discard) {
                    for (select_wait_blk b : (LinkedList)UdpSession.this.udpSelectWaitList.clone()) {
                        UdpSession.this.lock();
                        b.posted = true;
                        b.event.signal();
                        UdpSession.this.unlock();
                    }
                    UdpSession.this.udpSelectWaitList.clear();
                }
                if (UdpSession.this.eventWaitCount > 0) {
                    long averageActWaitTime = UdpSession.this.eventWaitCummulativeTimeActual / (long)UdpSession.this.eventWaitCount;
                    long averageReqWaitTime = UdpSession.this.eventWaitCummulativeTimeRequested / (long)UdpSession.this.eventWaitCount;
                    UdpSession.this.sessionLog.fine("Average event short wait times: count=" + UdpSession.this.eventWaitCount + ", requested=" + averageReqWaitTime + ", actual=" + averageActWaitTime);
                }
                UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)1, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                {
                    break block61;
                    catch (IOException oops) {
                        UdpSession.this.abort(oops);
                        Object var12_15 = null;
                        this.selectionKey.cancel();
                        try {
                            this.readSelector.close();
                        }
                        catch (IOException discard) {
                            // empty catch block
                        }
                        try {
                            UdpSession.this.unlock();
                        }
                        catch (IllegalMonitorStateException discard) {
                            // empty catch block
                        }
                        discard = UdpSession.this.udpSelectWaitList;
                        synchronized (discard) {
                            for (select_wait_blk b : (LinkedList)UdpSession.this.udpSelectWaitList.clone()) {
                                UdpSession.this.lock();
                                b.posted = true;
                                b.event.signal();
                                UdpSession.this.unlock();
                            }
                            UdpSession.this.udpSelectWaitList.clear();
                        }
                        if (UdpSession.this.eventWaitCount > 0) {
                            long averageActWaitTime = UdpSession.this.eventWaitCummulativeTimeActual / (long)UdpSession.this.eventWaitCount;
                            long averageReqWaitTime = UdpSession.this.eventWaitCummulativeTimeRequested / (long)UdpSession.this.eventWaitCount;
                            UdpSession.this.sessionLog.fine("Average event short wait times: count=" + UdpSession.this.eventWaitCount + ", requested=" + averageReqWaitTime + ", actual=" + averageActWaitTime);
                        }
                        UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)1, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                        break block61;
                    }
                    catch (Throwable oops) {
                        block72: {
                            block71: {
                                if (this.terminating || UdpSession.this.state == State.CLOSE_PENDING || UdpSession.this.state == State.CLOSE_WAIT || UdpSession.this.state == State.CLOSING) break block71;
                                if (UdpSession.this.state != State.TERMINATING) break block72;
                            }
                            Object var12_16 = null;
                            this.selectionKey.cancel();
                            try {
                                this.readSelector.close();
                            }
                            catch (IOException discard) {
                                // empty catch block
                            }
                            try {
                                UdpSession.this.unlock();
                            }
                            catch (IllegalMonitorStateException discard) {
                                // empty catch block
                            }
                            discard = UdpSession.this.udpSelectWaitList;
                            synchronized (discard) {
                                for (select_wait_blk b : (LinkedList)UdpSession.this.udpSelectWaitList.clone()) {
                                    UdpSession.this.lock();
                                    b.posted = true;
                                    b.event.signal();
                                    UdpSession.this.unlock();
                                }
                                UdpSession.this.udpSelectWaitList.clear();
                            }
                            if (UdpSession.this.eventWaitCount > 0) {
                                long averageActWaitTime = UdpSession.this.eventWaitCummulativeTimeActual / (long)UdpSession.this.eventWaitCount;
                                long averageReqWaitTime = UdpSession.this.eventWaitCummulativeTimeRequested / (long)UdpSession.this.eventWaitCount;
                                UdpSession.this.sessionLog.fine("Average event short wait times: count=" + UdpSession.this.eventWaitCount + ", requested=" + averageReqWaitTime + ", actual=" + averageActWaitTime);
                            }
                            UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)1, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                            return;
                        }
                        oops.printStackTrace();
                        UdpSession.this.abort(new IOException(oops.getMessage()));
                        Object var12_17 = null;
                        this.selectionKey.cancel();
                        try {
                            this.readSelector.close();
                        }
                        catch (IOException discard) {
                            // empty catch block
                        }
                        try {
                            UdpSession.this.unlock();
                        }
                        catch (IllegalMonitorStateException discard) {
                            // empty catch block
                        }
                        discard = UdpSession.this.udpSelectWaitList;
                        synchronized (discard) {
                            for (select_wait_blk b : (LinkedList)UdpSession.this.udpSelectWaitList.clone()) {
                                UdpSession.this.lock();
                                b.posted = true;
                                b.event.signal();
                                UdpSession.this.unlock();
                            }
                            UdpSession.this.udpSelectWaitList.clear();
                        }
                        if (UdpSession.this.eventWaitCount > 0) {
                            long averageActWaitTime = UdpSession.this.eventWaitCummulativeTimeActual / (long)UdpSession.this.eventWaitCount;
                            long averageReqWaitTime = UdpSession.this.eventWaitCummulativeTimeRequested / (long)UdpSession.this.eventWaitCount;
                            UdpSession.this.sessionLog.fine("Average event short wait times: count=" + UdpSession.this.eventWaitCount + ", requested=" + averageReqWaitTime + ", actual=" + averageActWaitTime);
                        }
                        UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)1, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                    }
                }
                catch (Throwable throwable) {
                    Object var12_18 = null;
                    this.selectionKey.cancel();
                    try {
                        this.readSelector.close();
                    }
                    catch (IOException discard) {
                        // empty catch block
                    }
                    try {
                        UdpSession.this.unlock();
                    }
                    catch (IllegalMonitorStateException discard) {
                        // empty catch block
                    }
                    discard = UdpSession.this.udpSelectWaitList;
                    synchronized (discard) {
                        for (select_wait_blk b : (LinkedList)UdpSession.this.udpSelectWaitList.clone()) {
                            UdpSession.this.lock();
                            b.posted = true;
                            b.event.signal();
                            UdpSession.this.unlock();
                        }
                        UdpSession.this.udpSelectWaitList.clear();
                    }
                    if (UdpSession.this.eventWaitCount > 0) {
                        long averageActWaitTime = UdpSession.this.eventWaitCummulativeTimeActual / (long)UdpSession.this.eventWaitCount;
                        long averageReqWaitTime = UdpSession.this.eventWaitCummulativeTimeRequested / (long)UdpSession.this.eventWaitCount;
                        UdpSession.this.sessionLog.fine("Average event short wait times: count=" + UdpSession.this.eventWaitCount + ", requested=" + averageReqWaitTime + ", actual=" + averageActWaitTime);
                    }
                    UdpSession.this.traceCtx.udp_trace(UdpTrace.TRACE_RECORD_TYPES.THREAD_START_STOP, (short)1, (short)-1, (short)UdpTrace.THREAD_TYPES.UDP_THREAD.ordinal(), Thread.currentThread().getId(), 0, 0);
                    throw throwable;
                }
            }
        }

        public void terminate() {
            this.terminating = true;
            this.readSelector.wakeup();
        }

        public void wakeup() {
            this.wakeup = true;
            this.readSelector.wakeup();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        IDLE,
        CONNECTING,
        CONNECT_CMPLT_WAIT,
        ACCEPTING,
        ACCEPT_CMPLT_WAIT,
        PMTU_DETERMINATION_SERVER,
        PMTU_DETERMINATION_CLIENT,
        PMTU_RESULT_WAIT_CLIENT,
        CONNECTED,
        CLOSE_PENDING,
        CLOSING,
        CLOSE_WAIT,
        TERMINATING;

    }
}

