/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp;

import com.signiant.mobilize.ddsclient.connection.Udp;
import com.signiant.mobilize.ddsclient.connection.udp.SessionConfig;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import java.io.IOException;
import java.net.InetSocketAddress;

public class UdpFactory {
    public static Udp createUdp(String host, int port) throws IOException {
        return UdpFactory.createUdp(new SessionConfig(), host, port);
    }

    public static Udp createUdp(SessionConfig config, String host, int port) throws IOException {
        int timeoutInMS = 30000000;
        UdpSession udpSession = UdpFactory.newUdpSession(config, host, port, timeoutInMS);
        Udp udp = new Udp(0, 0, "DCLogger", udpSession);
        return udp;
    }

    private static UdpSession newUdpSession(SessionConfig config, String host, int port, int timeout) throws IOException {
        int globalRelayPort;
        int streamCount = config.getStreamCount();
        int agressiveness = config.getAggressiveness();
        long maxBW = config.getMaxBandwidth();
        long minBW = config.getMinBandwidth();
        UdpSession session = UdpSession.initialize(streamCount, "DCLogger", "control", 0);
        session.setAggressiveness(agressiveness);
        session.setMaximumBandwidth(maxBW);
        session.setMinimumBandwidth(minBW);
        String udpRelayAddress = host;
        int udpRelayPort = port;
        String globalRelayAddress = System.getenv("SIGNIANT_RELAY_ADDRESS");
        String strGlobalRelayPort = System.getenv("SIGNIANT_RELAY_PORT");
        int n = globalRelayPort = strGlobalRelayPort == null ? -1 : Integer.parseInt(strGlobalRelayPort);
        if (globalRelayAddress != null && globalRelayPort != -1) {
            udpRelayAddress = globalRelayAddress;
            udpRelayPort = globalRelayPort;
        }
        session.setRelay(new InetSocketAddress(udpRelayAddress, udpRelayPort));
        session.connect(new InetSocketAddress(host, port), timeout);
        return session;
    }
}

