/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp;

import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionAbortedException;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionRefusedException;
import com.signiant.interactivetransfer.engine.udp.exceptions.ConnectionResetException;
import com.signiant.interactivetransfer.engine.udp.exceptions.InProgressException;
import com.signiant.interactivetransfer.engine.udp.exceptions.UdpBaseException;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.udp.ConnectionStatistics;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import com.signiant.mobilize.ddsclient.connection.udp.packets.ConnectionPacket;
import com.signiant.mobilize.ddsclient.connection.udp.packets.DatagramBuffer;
import com.signiant.mobilize.ddsclient.connection.udp.packets.PacketType;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UdpConnection {
    UdpSession session;
    int lclCid;
    int rmtCid;
    State state;
    boolean send_event_posted;
    boolean recv_event_posted;
    boolean shut_event_posted;
    boolean destroy_when_send_empty;
    long timeout;
    long data_pkts_received;
    long data_pkts_sent;
    long bytes_received;
    long bytes_sent;
    int bytesPending;
    ByteBuffer overlap;
    Queue<DatagramBuffer> recv_queue;
    int recv_queue_len;
    boolean interrupted;
    TransferException last_error;
    Logger sessionLog;
    Logger protocolLog;
    Logger connectionLog;

    UdpConnection(UdpSession session) {
        this.session = session;
        this.sessionLog = session.sessionLog;
        this.protocolLog = session.protocolLog;
        this.connectionLog = session.connectionLog;
        this.lclCid = -1;
        this.rmtCid = -1;
        this.last_error = null;
        this.recv_queue = new LinkedList<DatagramBuffer>();
        this.interrupted = false;
    }

    void setState(State newState) {
        if (this.state != newState) {
            if (this.connectionLog.isLoggable(Level.FINER)) {
                this.connectionLog.finer("The cid " + this.lclCid + " state is changing from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
            }
            this.state = newState;
        }
    }

    boolean isActive() {
        return this.state.ordinal() > State.INITIALIZING.ordinal() && this.state.ordinal() < State.CLOSED.ordinal();
    }

    boolean isInternalConnected() {
        return this.state.ordinal() >= State.CONNECTED.ordinal() && this.state.ordinal() <= State.CLOSED.ordinal();
    }

    boolean process_cpkt_connect(DatagramBuffer dgb) {
        switch (this.state) {
            case CONNECTING: {
                this.rmtCid = ConnectionPacket.src_id(dgb);
                this.last_error = null;
                this.setState(State.CONNECTED);
                this.post_send_event();
                break;
            }
            default: {
                if (!this.protocolLog.isLoggable(Level.FINER)) break;
                this.protocolLog.finer("Discarding received connection packet " + ConnectionPacket.tgt_id(dgb) + "<-" + ConnectionPacket.src_id(dgb) + ":  " + "seq=" + ConnectionPacket.sequence(dgb) + ", " + "The connection is not in the correct state");
            }
        }
        this.session.buffers.putback(dgb);
        return true;
    }

    boolean process_cpkt_data(DatagramBuffer dgb) {
        boolean result;
        int payload = ConnectionPacket.payloadLength(dgb);
        switch (this.state) {
            case CONNECTED: 
            case CLOSING: {
                if (this.recv_queue_len < this.session.getMaxRecvQueue()) {
                    ++this.data_pkts_received;
                    this.bytes_received += (long)payload;
                    this.recv_queue.offer(dgb);
                    ++this.recv_queue_len;
                    this.session.increment_recv_queue_count();
                    this.bytesPending += payload;
                    result = true;
                    this.post_recv_event();
                    break;
                }
                if (this.protocolLog.isLoggable(Level.FINER)) {
                    this.protocolLog.finer("The " + this.lclCid + "<-" + ConnectionPacket.src_id(dgb) + " " + "receive queue is full.");
                }
                result = false;
                break;
            }
            default: {
                if (this.protocolLog.isLoggable(Level.FINER)) {
                    this.protocolLog.finer("Discarding received connection packet " + ConnectionPacket.tgt_id(dgb) + "<-" + ConnectionPacket.src_id(dgb) + ":  " + "seq=" + ConnectionPacket.sequence(dgb) + ", " + "The connection is not in the correct state");
                }
                this.session.buffers.putback(dgb);
                result = true;
            }
        }
        return result;
    }

    boolean process_cpkt_shutdown(DatagramBuffer dgb) {
        switch (this.state) {
            case CONNECTING: {
                this.last_error = new ConnectionRefusedException();
                this.setState(State.CLOSE_WAIT);
                this.post_send_event();
                break;
            }
            case CONNECTED: {
                this.setState(State.CLOSE_WAIT);
                this.post_recv_event();
                break;
            }
            case CLOSING: {
                this.setState(State.CLOSED);
                this.post_recv_event();
                break;
            }
            default: {
                if (!this.protocolLog.isLoggable(Level.FINER)) break;
                this.protocolLog.finer("Discarding received connection packet " + ConnectionPacket.tgt_id(dgb) + "<-" + ConnectionPacket.src_id(dgb) + ":  " + "The connection is not in the correct state");
            }
        }
        this.session.buffers.putback(dgb);
        return true;
    }

    boolean process_cpkt_reset(DatagramBuffer dgb) {
        switch (this.state) {
            case CONNECTING: {
                this.last_error = new ConnectionRefusedException();
                this.setState(State.CLOSED);
                this.post_send_event();
                break;
            }
            case CONNECTED: {
                this.setState(State.CLOSE_WAIT);
                this.last_error = new ConnectionResetException();
                this.post_recv_event();
                break;
            }
            case CLOSING: {
                this.release_resources();
                break;
            }
            default: {
                if (!this.protocolLog.isLoggable(Level.FINER)) break;
                this.protocolLog.finer("Discarding received connection packet " + ConnectionPacket.tgt_id(dgb) + "<-" + ConnectionPacket.src_id(dgb) + ":  " + "The connection is not in the correct state");
            }
        }
        this.session.buffers.putback(dgb);
        return true;
    }

    void send_connect() throws UdpBaseException {
        DatagramBuffer connect = this.session.buffers.take();
        ConnectionPacket.type(connect, PacketType.CONNECT.code());
        ConnectionPacket.flags(connect, (byte)0);
        ConnectionPacket.src_id(connect, (byte)this.lclCid);
        ConnectionPacket.tgt_id(connect, (byte)this.rmtCid);
        ConnectionPacket.setPayload(connect);
        this.session.dgb_enqueue(connect);
        this.session.enable_udp_send();
    }

    void send_shutdown() throws UdpBaseException {
        DatagramBuffer shutdown = this.session.buffers.take();
        ConnectionPacket.type(shutdown, PacketType.SHUTDOWN.code());
        ConnectionPacket.flags(shutdown, (byte)0);
        ConnectionPacket.src_id(shutdown, (byte)this.lclCid);
        ConnectionPacket.tgt_id(shutdown, (byte)this.rmtCid);
        ConnectionPacket.setPayload(shutdown);
        this.session.dgb_enqueue(shutdown);
        this.session.enable_udp_send();
    }

    void send_rejection() throws UdpBaseException {
        DatagramBuffer rejection = this.session.buffers.take();
        ConnectionPacket.type(rejection, PacketType.RESET.code());
        ConnectionPacket.flags(rejection, (byte)0);
        ConnectionPacket.src_id(rejection, (byte)this.lclCid);
        ConnectionPacket.tgt_id(rejection, (byte)this.rmtCid);
        ConnectionPacket.setPayload(rejection);
        this.session.dgb_enqueue(rejection);
        this.session.enable_udp_send();
    }

    boolean wait_for_recv_event() throws IOException {
        return this.wait_for_recv_event(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wait_for_recv_event(int timeout) throws IOException {
        boolean result = true;
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            if (timeout <= 0) {
                this.connectionLog.finest("Waiting for the posting of the cid " + this.lclCid + " receive event.");
            } else {
                this.connectionLog.finest("Waiting up to " + timeout + " microseconds for the posting of the cid " + this.lclCid + " receive event.");
            }
        }
        if (!this.recv_event_posted) {
            UdpSession.select_wait_blk swb = new UdpSession.select_wait_blk(this.session);
            swb.rdMask.SET(this.lclCid);
            LinkedList<UdpSession.select_wait_blk> linkedList = this.session.udpSelectWaitList;
            synchronized (linkedList) {
                this.session.udpSelectWaitList.offer(swb);
            }
            try {
                if (timeout <= 0) {
                    swb.event.await();
                } else {
                    result = swb.event.await(timeout, TimeUnit.MICROSECONDS);
                }
            }
            catch (InterruptedException e) {
                result = false;
                this.connectionLog.warning("The cid " + this.lclCid + " receive event wait was aborted.");
            }
            this.session.udpSelectWaitList.remove(swb);
        } else {
            this.recv_event_posted = false;
        }
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            if (result) {
                this.connectionLog.finest("The cid " + this.lclCid + " receive event has been posted.");
            } else {
                this.connectionLog.finest("The cid " + this.lclCid + " receive event has not been posted.");
            }
        }
        if (this.session.lastError != null) {
            throw this.session.lastError;
        }
        return result;
    }

    boolean wait_for_send_event() throws IOException {
        return this.wait_for_send_event(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wait_for_send_event(int timeout) throws IOException {
        boolean result = true;
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            if (timeout <= 0) {
                this.connectionLog.finest("Waiting for the posting of the cid " + this.lclCid + " send event.");
            } else {
                this.connectionLog.finest("Waiting up to " + timeout + " microseconds for the posting of the cid " + this.lclCid + " send event.");
            }
        }
        if (!this.send_event_posted) {
            UdpSession.select_wait_blk swb = new UdpSession.select_wait_blk(this.session);
            swb.wrMask.SET(this.lclCid);
            LinkedList<UdpSession.select_wait_blk> linkedList = this.session.udpSelectWaitList;
            synchronized (linkedList) {
                if (this.session.state == UdpSession.State.TERMINATING) {
                    return false;
                }
                this.session.udpSelectWaitList.offer(swb);
            }
            try {
                if (timeout <= 0) {
                    swb.event.await();
                } else {
                    result = swb.event.await(timeout, TimeUnit.MICROSECONDS);
                }
            }
            catch (InterruptedException e) {
                result = false;
                this.connectionLog.warning("The cid " + this.lclCid + " send event wait was aborted.");
            }
            this.session.udpSelectWaitList.remove(swb);
        } else {
            this.send_event_posted = false;
        }
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            if (result) {
                this.connectionLog.finest("The cid " + this.lclCid + " send event has been posted.");
            } else {
                this.connectionLog.finest("The cid " + this.lclCid + " send event has not been posted.");
            }
        }
        if (this.session.lastError != null) {
            throw this.session.lastError;
        }
        return result;
    }

    boolean wait_for_shutdown_event() {
        return this.wait_for_shutdown_event(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean wait_for_shutdown_event(int timeout) {
        boolean result = true;
        if (this.connectionLog.isLoggable(Level.FINER)) {
            if (timeout <= 0) {
                this.connectionLog.finer("Waiting for the posting of the cid " + this.lclCid + " shutdown event.");
            } else {
                this.connectionLog.finer("Waiting up to " + timeout + " microseconds for the posting of the cid " + this.lclCid + " shutdown event.");
            }
        }
        if (!this.shut_event_posted) {
            UdpSession.select_wait_blk swb = new UdpSession.select_wait_blk(this.session);
            swb.shMask.SET(this.lclCid);
            LinkedList<UdpSession.select_wait_blk> linkedList = this.session.udpSelectWaitList;
            synchronized (linkedList) {
                this.session.udpSelectWaitList.offer(swb);
            }
            try {
                if (timeout <= 0) {
                    swb.event.await();
                } else {
                    result = swb.event.await(timeout, TimeUnit.MICROSECONDS);
                }
            }
            catch (InterruptedException e) {
                result = false;
                this.connectionLog.warning("The cid " + this.lclCid + " shutdown event wait was aborted.");
            }
            this.session.udpSelectWaitList.remove(swb);
        } else {
            this.shut_event_posted = false;
        }
        if (this.connectionLog.isLoggable(Level.FINER)) {
            if (result) {
                this.connectionLog.finer("The cid " + this.lclCid + " shutdown event has been posted.");
            } else {
                this.connectionLog.finer("The cid " + this.lclCid + " shutdown event has not been posted.");
            }
        }
        return result;
    }

    void post_recv_event() {
        this.recv_event_posted = true;
        for (UdpSession.select_wait_blk swb : (LinkedList)this.session.udpSelectWaitList.clone()) {
            if (swb.posted || !swb.rdMask.ISSET(this.lclCid)) continue;
            if (this.connectionLog.isLoggable(Level.FINEST)) {
                this.connectionLog.finest("Posting the cid " + this.lclCid + " receive event.");
            }
            swb.posted = true;
            this.recv_event_posted = false;
            swb.event.signal();
        }
    }

    void post_send_event() {
        this.send_event_posted = true;
        for (UdpSession.select_wait_blk swb : (LinkedList)this.session.udpSelectWaitList.clone()) {
            if (swb.posted || !swb.wrMask.ISSET(this.lclCid)) continue;
            if (this.connectionLog.isLoggable(Level.FINEST)) {
                this.connectionLog.finest("Posting the cid " + this.lclCid + " send event.");
            }
            swb.posted = true;
            this.send_event_posted = false;
            swb.event.signal();
        }
    }

    void post_shutdown_event() {
        this.shut_event_posted = true;
        for (UdpSession.select_wait_blk swb : (LinkedList)this.session.udpSelectWaitList.clone()) {
            if (swb.posted || !swb.shMask.ISSET(this.lclCid)) continue;
            if (this.connectionLog.isLoggable(Level.FINER)) {
                this.connectionLog.finer("Posting the cid " + this.lclCid + " shutdown event.");
            }
            swb.posted = true;
            this.shut_event_posted = false;
            swb.event.signal();
        }
    }

    private void shutdown(boolean destroyWhenClosed) throws UdpBaseException {
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            this.connectionLog.finest("Invoked internal UdpConnection 'shutdown(" + destroyWhenClosed + ")' method [state = " + (Object)((Object)this.state) + "] for address: " + this.session.getAgentAddress());
        }
        switch (this.state) {
            case INITIALIZING: 
            case LISTENING: {
                if (destroyWhenClosed) {
                    this.release_resources();
                    break;
                }
                this.setState(State.CLOSED);
                break;
            }
            case CONNECTING: 
            case CONNECTED: {
                this.send_shutdown();
                this.setState(State.CLOSING);
                break;
            }
            case CLOSE_WAIT: {
                this.send_shutdown();
                if (destroyWhenClosed) {
                    this.destroy_when_send_empty = true;
                }
                this.setState(State.CLOSED);
                break;
            }
            case CLOSING: 
            case CLOSED: {
                if (!destroyWhenClosed) break;
                this.release_resources();
            }
        }
    }

    void release_resources() {
        DatagramBuffer dgb;
        while ((dgb = this.recv_queue.poll()) != null) {
            this.session.buffers.putback(dgb);
        }
        this.session.decrement_recv_queue_count(this.recv_queue_len);
        this.recv_queue_len = 0;
        this.setState(State.IDLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(byte remote) throws IOException, UdpBaseException {
        block8: {
            if (this.lclCid < 0 || this.lclCid >= this.session.connectionTable.length) {
                throw new IOException("Invalid connection parameters.");
            }
            try {
                this.session.lock();
                if (this.session.state == UdpSession.State.IDLE || this.session.state.ordinal() > UdpSession.State.CONNECTED.ordinal()) {
                    throw new IOException("Session has not been established yet.");
                }
                if (this.state != State.INITIALIZING) {
                    Object var3_2 = null;
                    this.session.unlock();
                    return;
                }
                this.rmtCid = remote;
                this.setState(State.CONNECTING);
                this.send_connect();
                this.last_error = new InProgressException();
                while (this.wait_for_send_event(35000000)) {
                    if (this.state != State.CONNECTED) {
                        if (this.state.ordinal() > State.CONNECTED.ordinal()) {
                            throw new ConnectionAbortedException();
                        }
                        if (this.last_error instanceof InProgressException) continue;
                        this.setState(State.CLOSING);
                    }
                    break block8;
                }
                this.setState(State.CLOSING);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.session.unlock();
                throw throwable;
            }
        }
        Object var3_3 = null;
        this.session.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        boolean connected;
        try {
            this.session.lock();
            connected = this.state.ordinal() >= State.CONNECTED.ordinal() && this.state.ordinal() <= State.CLOSED.ordinal();
            Object var3_2 = null;
            this.session.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.session.unlock();
            throw throwable;
        }
        return connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int receive(ByteBuffer buffer, int amount) throws InterruptedException, IOException {
        int n;
        LinkedList<DatagramBuffer> dgbList;
        block21: {
            int n2;
            block20: {
                int n3;
                block19: {
                    dgbList = null;
                    try {
                        this.session.lock();
                        if (this.session.state == UdpSession.State.IDLE) throw new ConnectionAbortedException();
                        if (this.session.state.ordinal() > UdpSession.State.CONNECTED.ordinal() && this.session.state != UdpSession.State.CLOSE_WAIT) {
                            throw new ConnectionAbortedException();
                        }
                        switch (this.state) {
                            case CONNECTED: 
                            case CLOSE_WAIT: {
                                break;
                            }
                            case CLOSING: 
                            case CLOSED: {
                                if (!this.destroy_when_send_empty) break;
                                int n4 = 0;
                                Object var9_7 = null;
                                if (dgbList != null) {
                                    this.session.buffers.putback(dgbList);
                                }
                                this.session.unlock();
                                return n4;
                            }
                            default: {
                                n3 = 0;
                                break block19;
                            }
                        }
                        this.interrupted = false;
                        int remaining = amount;
                        while (remaining > 0) {
                            if (this.interrupted) {
                                throw new InterruptedException();
                            }
                            DatagramBuffer dgb = this.recv_queue.peek();
                            if (dgb != null) {
                                boolean completePacket = true;
                                int len = ConnectionPacket.payloadLength(dgb);
                                if (remaining < len) {
                                    len = remaining;
                                    completePacket = false;
                                }
                                ConnectionPacket.getPayload(dgb, buffer, len);
                                this.bytesPending -= len;
                                if (completePacket) {
                                    if (dgbList == null) {
                                        dgbList = new LinkedList<DatagramBuffer>();
                                    }
                                    this.recv_queue.remove();
                                    --this.recv_queue_len;
                                    this.session.decrement_recv_queue_count();
                                    dgbList.offer(dgb);
                                }
                                remaining -= len;
                                continue;
                            }
                            if (remaining != amount || this.state.ordinal() > State.CLOSE_WAIT.ordinal()) break;
                            if (this.state.ordinal() >= State.CLOSE_WAIT.ordinal() || this.state == State.IDLE) {
                                n2 = 0;
                                break block20;
                            }
                            if (this.wait_for_recv_event()) continue;
                            throw new ConnectionAbortedException();
                        }
                        n = amount - remaining;
                        break block21;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (dgbList != null) {
                            this.session.buffers.putback(dgbList);
                        }
                        this.session.unlock();
                        throw throwable;
                    }
                }
                Object var9_8 = null;
                if (dgbList != null) {
                    this.session.buffers.putback(dgbList);
                }
                this.session.unlock();
                return n3;
            }
            Object var9_9 = null;
            if (dgbList != null) {
                this.session.buffers.putback(dgbList);
            }
            this.session.unlock();
            return n2;
        }
        Object var9_10 = null;
        if (dgbList != null) {
            this.session.buffers.putback(dgbList);
        }
        this.session.unlock();
        return n;
    }

    public int send(ByteBuffer buffer) throws IOException, InterruptedException {
        return this.send(buffer, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int send(ByteBuffer buffer, AcknowledgeFeedback feedback) throws IOException, InterruptedException {
        int n;
        boolean sessionLocked;
        DatagramBuffer dgb;
        LinkedList<DatagramBuffer> localList;
        Queue<DatagramBuffer> dgbList;
        block24: {
            int total;
            this.interrupted = false;
            dgbList = null;
            localList = new LinkedList<DatagramBuffer>();
            dgb = null;
            int remaining = total = buffer.remaining();
            sessionLocked = false;
            try {
                this.session.lock();
                sessionLocked = true;
                int payload = this.session.payloadSize;
                if (this.state == State.IDLE) throw new ConnectionAbortedException();
                if (this.state.ordinal() > State.CONNECTED.ordinal()) {
                    throw new ConnectionAbortedException();
                }
                switch (this.state) {
                    case CONNECTED: {
                        break;
                    }
                    case CLOSE_WAIT: {
                        throw new ConnectionResetException();
                    }
                    default: {
                        n = 0;
                        Object var14_12 = null;
                        break block24;
                    }
                }
                while (remaining > 0) {
                    if (this.interrupted) {
                        throw new InterruptedException();
                    }
                    if (this.state != State.CONNECTED) {
                        throw new ConnectionAbortedException();
                    }
                    int sendQueueSpace = this.session.getMaxSendQueue() - this.session.sendCpktQueueCount;
                    int dgbAllocCount = remaining / this.session.payloadSize;
                    if (remaining % this.session.payloadSize != 0) {
                        ++dgbAllocCount;
                    }
                    if (sendQueueSpace < dgbAllocCount) {
                        dgbAllocCount = sendQueueSpace;
                    }
                    dgbList = dgbAllocCount > 0 ? this.session.buffers.take(dgbAllocCount) : null;
                    sessionLocked = false;
                    this.session.unlock();
                    while (remaining > 0 && dgbList != null && (dgb = dgbList.poll()) != null) {
                        int len = Math.min(remaining, payload - 8);
                        ConnectionPacket.setPayload(dgb, buffer, len);
                        remaining -= len;
                        ConnectionPacket.type(dgb, PacketType.DATA.code());
                        ConnectionPacket.flags(dgb, (byte)0);
                        ConnectionPacket.src_id(dgb, (byte)this.lclCid);
                        ConnectionPacket.tgt_id(dgb, (byte)this.rmtCid);
                        localList.offer(dgb);
                    }
                    if (dgb != null && feedback != null && !this.interrupted) {
                        int sendNumber = feedback.getSendNumber();
                        dgb.setAcknowledgement(sendNumber, total, feedback);
                    }
                    this.session.lock();
                    sessionLocked = true;
                    if (dgbList != null && dgbList.size() > 0) {
                        this.session.buffers.putback(dgbList);
                    }
                    this.session.dgb_enqueue(localList);
                    if (remaining <= 0) break;
                    if (this.wait_for_send_event()) continue;
                    throw new ConnectionAbortedException();
                }
                Object var14_13 = null;
                if (localList.size() > 0) {
                    while ((dgb = (DatagramBuffer)localList.poll()) != null) {
                        remaining += dgb.length() - 8;
                        dgbList.offer(dgb);
                    }
                }
                if (dgbList != null) {
                    this.session.buffers.putback(dgbList);
                }
                if (!sessionLocked) return total - remaining;
                this.session.unlock();
                return total - remaining;
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                if (localList.size() > 0) {
                    while ((dgb = (DatagramBuffer)localList.poll()) != null) {
                        remaining += dgb.length() - 8;
                        dgbList.offer(dgb);
                    }
                }
                if (dgbList != null) {
                    this.session.buffers.putback(dgbList);
                }
                if (!sessionLocked) throw throwable;
                this.session.unlock();
                throw throwable;
            }
        }
        if (localList.size() > 0) {
            while ((dgb = (DatagramBuffer)localList.poll()) != null) {
                remaining += dgb.length() - 8;
                dgbList.offer(dgb);
            }
        }
        if (dgbList != null) {
            this.session.buffers.putback(dgbList);
        }
        if (!sessionLocked) return n;
        this.session.unlock();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        try {
            this.session.lock();
            this.interrupted = true;
            this.post_recv_event();
            this.post_send_event();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.session.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.session.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {}
    }

    public Exception get_error_status() {
        this.session.lock();
        TransferException result = this.last_error;
        this.session.unlock();
        return result;
    }

    public int getPending() {
        int result = 0;
        this.session.lock();
        switch (this.state) {
            case CONNECTED: 
            case CLOSING: 
            case CLOSE_WAIT: 
            case CLOSED: {
                result = this.bytesPending;
            }
        }
        this.session.unlock();
        return result;
    }

    public ConnectionStatistics getStatistics() {
        ConnectionStatistics result = null;
        this.session.lock();
        switch (this.state) {
            case CONNECTED: 
            case CLOSING: 
            case CLOSE_WAIT: 
            case CLOSED: {
                result = new ConnectionStatistics(this.data_pkts_received, this.data_pkts_sent);
            }
        }
        this.session.unlock();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException, UdpBaseException {
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            this.connectionLog.finest("Invoked public UdpConnection 'shutdown()' method [state = " + (Object)((Object)this.state) + "] for address: " + this.session.getAgentAddress());
        }
        try {
            this.session.lock();
            TransferException except = null;
            if (this.state == State.IDLE || this.state.ordinal() > State.CONNECTED.ordinal()) {
                except = new ConnectionAbortedException();
            } else {
                switch (this.state) {
                    case CLOSE_WAIT: {
                        if (this.last_error != null) {
                            except = this.last_error;
                            break;
                        }
                    }
                    case CONNECTED: {
                        this.shutdown(false);
                        except = null;
                        this.wait_for_shutdown_event(2000);
                    }
                }
            }
            if (except != null) {
                throw except;
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                this.session.unlock();
            }
            catch (IllegalMonitorStateException discard) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.session.unlock();
        }
        catch (IllegalMonitorStateException discard) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.connectionLog.isLoggable(Level.FINEST)) {
            this.connectionLog.finest("Invoked public UdpConnection 'destroy()' method [state = " + (Object)((Object)this.state) + "] for address: " + this.session.getAgentAddress());
        }
        try {
            this.session.lock();
            if (this.state != State.IDLE) {
                if (this.state.ordinal() > State.CONNECTED.ordinal()) {
                    this.release_resources();
                } else {
                    try {
                        this.shutdown(true);
                    }
                    catch (UdpBaseException udpBaseException) {
                    }
                }
            }
            Object var3_2 = null;
            this.session.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.session.unlock();
            throw throwable;
        }
    }

    public InetAddress getLocalInetAddress() {
        return this.session.channel.socket().getLocalAddress();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        IDLE,
        INITIALIZING,
        LISTENING,
        CONNECTING,
        CONNECTED,
        CLOSING,
        CLOSE_WAIT,
        CLOSED;

    }
}

