/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection.udp;

public class MicrosecondTimer {
    private static final MicrosecondTimer INSTANCE = new MicrosecondTimer();
    private long lastMillisecondTime = 0L;
    private long lastNanosecondTime = 0L;
    private long lastTimeValue = 0L;
    private boolean useSystemNano = true;

    public static MicrosecondTimer getInstance() {
        return INSTANCE;
    }

    private MicrosecondTimer() {
    }

    public void useSystemNanoTime(boolean yesNo) {
        this.useSystemNano = yesNo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long get() {
        long timeValue;
        long currentMillisecondTime = System.currentTimeMillis();
        if (this.useSystemNano) {
            MicrosecondTimer microsecondTimer = this;
            synchronized (microsecondTimer) {
                long currentNanosecondTime = System.nanoTime();
                if (currentMillisecondTime == this.lastMillisecondTime) {
                    long additionalNanos = currentNanosecondTime - this.lastNanosecondTime;
                    if (additionalNanos < 1000L) {
                        additionalNanos = 1000L;
                    } else if (additionalNanos > 100000L) {
                        additionalNanos = 100000L;
                    }
                    this.lastNanosecondTime = currentNanosecondTime;
                    timeValue = this.lastTimeValue + additionalNanos / 1000L;
                } else {
                    this.lastMillisecondTime = currentMillisecondTime;
                    this.lastNanosecondTime = currentNanosecondTime;
                    timeValue = currentMillisecondTime * 1000L;
                }
                this.lastTimeValue = timeValue;
            }
        } else {
            timeValue = currentMillisecondTime * 1000L;
        }
        return timeValue;
    }
}

