/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection;

import com.signiant.interactivetransfer.engine.udp.exceptions.UdpSessionTerminatedException;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Port;
import com.signiant.mobilize.ddsclient.connection.udp.UdpConnection;
import com.signiant.mobilize.ddsclient.connection.udp.UdpSession;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;

public class Udp
extends Port {
    private UdpConnection connection = null;
    private UdpSession session = null;

    public Udp(byte handle, int remote, String logInstance, UdpSession session) throws IOException {
        super(logInstance);
        if (remote > 255) {
            throw new IOException("Invalid remote connection - " + remote);
        }
        this.logger.finest("Creating UDP session connection for agent address: " + session.getAgentAddress());
        this.connection = session.create(handle);
        this.connection.connect((byte)remote);
        this.session = session;
    }

    public int readImpl(ByteBuffer buffer) throws IOException, InterruptedException {
        int bytesRead = this.connection.receive(buffer, buffer.remaining());
        if (bytesRead <= 0) {
            throw new UdpSessionTerminatedException("No more UDP data available");
        }
        return bytesRead;
    }

    public int writeImpl(ByteBuffer buffer, AcknowledgeFeedback feedback) throws IOException, InterruptedException {
        int written = 0;
        while (buffer.hasRemaining()) {
            written += this.connection.send(buffer, feedback);
        }
        this.logger.finest("bytes sent with UdpConnection.send: " + written);
        return written;
    }

    public void wakeupImpl() {
        this.connection.wakeup();
    }

    public void closeImpl() throws IOException {
        try {
            this.connection.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.destroy();
        if (this.session != null) {
            this.session.terminate();
        }
    }

    public InetAddress getLocalInetAddressImpl() {
        return this.connection.getLocalInetAddress();
    }
}

