/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection;

import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Port;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;

public class Tcp
extends Port {
    private SocketChannel channel;

    public Tcp(InetSocketAddress address, String logInstance) throws IOException {
        super(logInstance);
        this.address = address;
        this.type = Port.Type.TCP;
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        try {
            this.channel.connect(address);
            int attempts = 10;
            while (attempts-- > 0 && !this.channel.finishConnect()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                    break;
                }
            }
            if (attempts <= 0) {
                this.channel.close();
                throw new IOException("connection timeout");
            }
        }
        catch (Exception cannotConnect) {
            this.channel.close();
            throw new IOException(cannotConnect);
        }
        this.channel.configureBlocking(true);
        this.channel.socket().setTcpNoDelay(true);
        this.channel.socket().setSendBufferSize(65536);
        this.channel.socket().setReceiveBufferSize(65536);
    }

    public int readImpl(ByteBuffer buffer) throws IOException, InterruptedException {
        int size;
        try {
            size = this.channel.read(buffer);
        }
        catch (AsynchronousCloseException interrupted) {
            throw new InterruptedException("Wakeup on tcp port read");
        }
        if (size < 0) {
            throw new IOException("Connection lost on tcp port read");
        }
        return size;
    }

    public void closeImpl() throws IOException {
        this.channel.close();
    }

    public void wakeupImpl() {
        try {
            this.channel.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int writeImpl(ByteBuffer buffer, AcknowledgeFeedback feedback) throws IOException {
        int written = 0;
        while (buffer.hasRemaining()) {
            written += this.channel.write(buffer);
        }
        if (feedback != null) {
            feedback.acknowledged(feedback.getSendNumber(), written);
        }
        return written;
    }

    public InetAddress getLocalInetAddressImpl() {
        return this.channel.socket().getLocalAddress();
    }
}

