/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection;

import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.Base64;
import com.signiant.mobilize.ddsclient.connection.Port;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stream {
    public static final int FRED_PC_PRTCL_RAW_MSGS = 9;
    public static final int FRED_PC_PRTCL_TOD_BANDWIDTH = 10;
    public static final int FRED_PC_PRTCL_CNCT_BRKR = 11;
    public static final int FRED_PC_PRTCL_RESTART_LIMITS = 12;
    public static final int FRED_PC_PRTCL_UDP_TRANSPORT = 13;
    public static final int FRED_PC_PRTCL_NEW_VARVALUES = 14;
    public static final int FRED_PC_PRTCL_NEW_UDP = 15;
    public static final int FRED_PC_PRTCL_STREAM_MANIFESTS = 16;
    public static final int FRED_PC_PRTCL_LOAD_BALANCING = 17;
    public static final int FRED_PC_PRTCL_WORK_FLOW = 18;
    public static final int FRED_PC_PRTCL_MULTIMANAGER = 19;
    public static final int FRED_PC_PRTCL_SLAVE_STATS = 20;
    public static final int FRED_PC_PRTCL_BIG_DES = 21;
    public static final int FRED_PC_PRTCL_COMPONENT_WAIT = 22;
    public static final int FRED_PC_PRTCL_COMPONENT_WAIT_FEEDBACK = 23;
    public static final int FRED_PC_PRTCL_VERS = 23;
    public static final int MAX_AGENT_CMD_SIZE = 0x100000;
    public static final String SIMPLEMSG = "_simpleMsg";
    private Port port;
    protected ByteBuffer in;
    protected ByteBuffer inputLine;
    private ByteBuffer out;
    private CharsetEncoder encode;
    private CharsetDecoder decode;
    private boolean finished;
    private boolean shutdown;
    private boolean timedout;
    protected Logger logger;
    protected String logInstance;
    private static byte[] so = new byte[]{12, 15, 7, 10, 14, 13, 11, 0, 2, 6, 3, 1, 9, 4, 5, 8};
    private static byte[] sl = new byte[]{7, 2, 14, 9, 3, 11, 0, 4, 12, 13, 1, 10, 6, 15, 8, 5};
    private static byte[] x = new byte[]{5, 3, 2, 6, 7, 4, 1, 0};
    private static byte[] fp = new byte[]{1, 0, 4, 7, 6, 3, 5, 2};
    ByteBuffer putback;

    public Logger getLogger() {
        return this.logger;
    }

    public ByteBuffer get() throws IOException, InterruptedException {
        if (this.shutdown) {
            throw new InterruptedException("Stream has been aborted");
        }
        int result = this.port.read(this.in);
        if (result < 0) {
            throw new IOException("End of stream");
        }
        this.in.flip();
        return this.in;
    }

    public ByteBuffer get(int maxSize) throws IOException, InterruptedException {
        int remCount;
        if (this.shutdown) {
            throw new InterruptedException("Stream has been aborted");
        }
        if (!this.in.hasRemaining()) {
            this.in.clear();
            this.in.limit(maxSize);
            int result = this.port.read(this.in);
            if (result < 0) {
                throw new IOException("End of stream");
            }
            this.in.flip();
        }
        if ((remCount = this.in.remaining()) > maxSize) {
            remCount = maxSize;
        }
        ByteBuffer retBuff = this.in.slice();
        retBuff.limit(remCount);
        this.in.position(this.in.position() + remCount);
        return retBuff;
    }

    public void put(ByteBuffer buffer) throws Exception {
        this.put(buffer, null);
    }

    public void put(ByteBuffer buffer, AcknowledgeFeedback feedback) throws Exception {
        this.port.write(buffer, feedback);
    }

    public void shutdownStream() {
        this.shutdown = true;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public void wakeup() {
        this.port.wakeup();
    }

    public String getLogInstance() {
        return this.logInstance;
    }

    public Stream(Port port, String logInstance) {
        this(port, logInstance, 0x100000);
    }

    public Stream(Port port, String logInstance, int bufferSize) {
        this.logInstance = logInstance;
        if (logInstance == "DCLogger") {
            this.logger = Logger.getLogger(this.getClass().getPackage().getName() + "." + this.getClass().getSimpleName());
            this.logger.setLevel(Level.OFF);
        } else {
            String logBase = "com.signiant.interactivetransfer.engine";
            this.logger = Logger.getLogger(logBase + logInstance + "." + this.getClass().getSimpleName());
        }
        this.port = port;
        this.in = ByteBuffer.wrap(new byte[bufferSize]);
        this.inputLine = ByteBuffer.wrap(new byte[bufferSize]);
        this.out = ByteBuffer.wrap(new byte[bufferSize]);
        this.in.flip();
        this.inputLine.clear();
        Charset ch = Charset.forName("utf8");
        this.encode = ch.newEncoder();
        this.decode = ch.newDecoder();
        this.decode.onMalformedInput(CodingErrorAction.IGNORE);
        this.decode.onUnmappableCharacter(CodingErrorAction.IGNORE);
    }

    private int encrypt(byte[] buff, byte[] key, int len) {
        int rlen = 0;
        for (int n = 0; n < len; n += 16) {
            rlen += 16;
            int s = 0;
            for (int round = 0; round < 16; ++round) {
                int high = round % 2 * 8 + n;
                int low = (round + 1) % 2 * 8 + n;
                byte tc = key[s];
                int step = 0;
                while (step < 8) {
                    int p = (tc << step & 0x80) != 0 ? (sl[buff[high] >> 4 & 0xF] | so[buff[high] & 0xF] << 4) ^ key[s] : (so[buff[high] >> 4 & 0xF] << 4 | sl[buff[high] & 0xF]) ^ key[s];
                    for (int i = 0; i < 8; ++i) {
                        if (step + i < 8) {
                            int n2 = low + i;
                            buff[n2] = (byte)(buff[n2] ^ (p >> fp[i] & 1) << x[i]);
                            continue;
                        }
                        int n3 = low + i - 8;
                        buff[n3] = (byte)(buff[n3] ^ (p >> fp[i] & 1) << x[i]);
                    }
                    if (++s > 15) {
                        s = 0;
                    }
                    ++step;
                    ++high;
                    ++low;
                }
                if (--s >= 0) continue;
                s = 15;
            }
        }
        return rlen;
    }

    protected String pwdEncrypt(String pPlainPW, String pUser) {
        int i;
        byte[] pw_array = new byte[16];
        byte[] encrypt_pw_array = new byte[32];
        byte[] key_array = new byte[16];
        int initial_len = pPlainPW.length();
        char[] char_array = pPlainPW.toCharArray();
        for (i = 0; i < 16; ++i) {
            pw_array[i] = i < initial_len ? (int)char_array[i] : 32;
        }
        initial_len = pUser.length();
        char_array = pUser.toCharArray();
        for (i = 0; i < 16; ++i) {
            key_array[i] = i < initial_len ? (int)char_array[i] : 32;
        }
        this.encrypt(pw_array, key_array, 16);
        for (i = 0; i < 16; ++i) {
            encrypt_pw_array[i * 2] = (byte)((pw_array[i] >> 4 & 0xF) + 97);
            encrypt_pw_array[i * 2 + 1] = (byte)((pw_array[i] & 0xF) + 107);
        }
        return new String(encrypt_pw_array);
    }

    public String getUserData(char[] password, String user) throws IOException {
        return this.pwdEncrypt(new String(password), user);
    }

    public String getUserData(char[] password) throws IOException {
        byte[] result;
        block3: {
            SSLEngine engine = this.port.getSSLEngine();
            if (engine == null) {
                throw new IOException("Unable to encrypt password on unsecured channel.");
            }
            ByteBuffer buffer = this.encode.encode(CharBuffer.wrap(password));
            byte[] bytes = buffer.array();
            X509Certificate[] certs = (X509Certificate[])engine.getSession().getPeerCertificates();
            PublicKey key = certs[0].getPublicKey();
            result = null;
            try {
                Cipher encrypt = Cipher.getInstance("RSA");
                encrypt.init(1, key);
                result = encrypt.doFinal(bytes);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                this.logger.severe(e.toString());
            }
        }
        return Base64.encode(result);
    }

    public Port getPort() {
        return this.port;
    }

    protected void setPort(Port port) {
        this.port = port;
    }

    public synchronized void finish() {
        this.finished = true;
        this.wakeup();
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    protected boolean isReadAheadEmpty() {
        return this.in.hasRemaining();
    }

    public HashMap<String, String> readMsg(boolean useUtf8Decoding) throws Exception {
        return this.readMsg(60000L, useUtf8Decoding);
    }

    public HashMap<String, String> readMsg() throws Exception {
        return this.readMsg(60000L, false);
    }

    public HashMap<String, String> readMsg(long timeout) throws Exception {
        return this.readMsg(timeout, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> readMsg(long timeout, boolean useUtf8Decoding) throws Exception {
        Timer timer = null;
        if (timeout > 0L) {
            timer = new Timer();
            TimerTask timertask = new TimerTask(){

                public void run() {
                    Stream.this.timedout = true;
                    if (Stream.this.logger.isLoggable(Level.FINER)) {
                        Stream.this.logger.finer(" Waking up [" + Stream.this.port + "]");
                    }
                    Stream.this.port.wakeup();
                }
            };
            timer.schedule(timertask, timeout);
        }
        block5: while (true) {
            if (!this.in.hasRemaining()) {
                this.in.clear();
                try {
                    this.get();
                }
                catch (InterruptedException discard) {
                    if (this.timedout) {
                        throw new IOException("Timeout waiting for a response");
                    }
                    HashMap<String, String> hashMap = null;
                    return hashMap;
                }
                finally {
                    if (timer != null) {
                        timer.cancel();
                    }
                    timer = null;
                }
            }
            while (true) {
                if (!this.in.hasRemaining()) continue block5;
                byte c = this.in.get();
                if (c == 10 || c == 0) {
                    if (c == 0) {
                        c = 10;
                    }
                    this.inputLine.put(c);
                    this.in.compact();
                    this.in.flip();
                    this.inputLine.flip();
                    HashMap<String, String> formattedMsg = this.formatMsg(this.inputLine, useUtf8Decoding);
                    this.inputLine.clear();
                    if (timer != null) {
                        timer.cancel();
                    }
                    return formattedMsg;
                }
                this.inputLine.put(c);
            }
            break;
        }
    }

    public String read() throws Exception {
        return this.read(60000L, false);
    }

    public String read(long timeout) throws Exception {
        return this.read(timeout, false);
    }

    public String read(long timeout, boolean useUtf8Decoding) throws Exception {
        HashMap<String, String> keyedMsg;
        while (!(keyedMsg = this.readMsg(timeout, useUtf8Decoding)).containsKey(SIMPLEMSG)) {
            this.handleMessage(keyedMsg);
        }
        return keyedMsg.get(SIMPLEMSG);
    }

    public void handleMessage(HashMap<String, String> data) throws Exception {
    }

    protected HashMap<String, String> formatMsg(ByteBuffer data, boolean useUtf8Decode) throws UnsupportedEncodingException {
        boolean structuredMsg = false;
        boolean firstSegment = true;
        HashMap<String, String> messageData = new HashMap<String, String>();
        byte[] msgSegmentArray = new byte[0x100000];
        ByteBuffer msgSegment = ByteBuffer.wrap(msgSegmentArray);
        while (data.hasRemaining()) {
            msgSegment.clear();
            while (data.hasRemaining()) {
                byte c = data.get();
                if (c == -2) {
                    structuredMsg = true;
                    break;
                }
                msgSegment.put(c);
            }
            msgSegment.flip();
            String message = null;
            message = useUtf8Decode ? this.utf8Decode(msgSegmentArray, msgSegment.limit()) : new String(msgSegmentArray, 0, msgSegment.limit());
            if (structuredMsg) {
                int delim = message.indexOf("=");
                if (delim < 0) continue;
                String key = message.substring(0, delim);
                if (firstSegment && key.startsWith("dds_pc: ")) {
                    key = key.substring(8);
                }
                String value = message.substring(delim + 1);
                messageData.put(key, value);
                firstSegment = false;
                continue;
            }
            messageData.put(SIMPLEMSG, message);
        }
        return messageData;
    }

    private String utf8Decode(byte[] msgSegmentArray, int size) throws UnsupportedEncodingException {
        byte[] utf8ByteArray = new byte[size];
        for (int i = 0; i < size; ++i) {
            utf8ByteArray[i] = msgSegmentArray[i];
        }
        return new String(utf8ByteArray, "UTF-8");
    }

    public String expect(String value) throws Exception {
        String received = this.read();
        this.expectMatch(value, received);
        return received;
    }

    public void expectMatch(String value, String received) throws Exception {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Looking for " + value + " got " + received);
        }
        if (!Pattern.matches(value, received)) {
            throw new UnexpectedResponseException(received, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(String str) throws Exception {
        String masked = null;
        if (str.indexOf("password=") > 0) {
            masked = str.replaceAll("password=.*$", "password=********");
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Writing string-->" + masked);
            }
        } else if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Writing string-->" + str);
        }
        ByteBuffer byteBuffer = this.out;
        synchronized (byteBuffer) {
            this.out.clear();
            this.out.put(str.getBytes("UTF-8"));
            this.out.flip();
            this.port.write(this.out);
            if (this.logger.isLoggable(Level.FINE)) {
                if (masked != null) {
                    this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Wrote string: " + masked);
                } else {
                    this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Wrote string: " + str);
                }
            }
        }
    }

    public void println(String value) throws Exception {
        this.print(value + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMsgln(String value) throws Exception {
        StringBuffer msg = new StringBuffer();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Writing string: " + msg);
        }
        String[] lines = value.split("\n");
        ByteBuffer byteBuffer = this.out;
        synchronized (byteBuffer) {
            this.out.clear();
            boolean first = true;
            for (String line : lines) {
                this.out.put(line.getBytes("UTF-8"));
                if (!first) {
                    this.out.put((byte)-1);
                    msg.append("<nl>");
                }
                msg.append(line);
                first = false;
            }
            this.out.put((byte)10);
            this.out.flip();
            this.port.write(this.out);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(Thread.currentThread().getName() + " [" + this.port + "] Wrote string: " + msg);
        }
    }

    public ByteBuffer getIn() {
        return this.in;
    }

    public ByteBuffer getOut() {
        return this.out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resizeOut(int size) {
        ByteBuffer byteBuffer = this.out;
        synchronized (byteBuffer) {
            this.out = ByteBuffer.wrap(new byte[size]);
        }
    }

    public ByteBuffer getInputLine() {
        return this.inputLine;
    }

    public static class UnexpectedResponseException
    extends IOException {
        private static final long serialVersionUID = 0L;
        private String actual;
        private String expected;

        public UnexpectedResponseException(String actual, String expected) {
            super(actual);
            this.actual = actual;
            this.expected = expected;
        }

        public UnexpectedResponseException(String actual) {
            this(actual, "");
        }

        public UnexpectedResponseException() {
            this("Unexpected response", "");
        }

        public String toString() {
            return "Unexpected response [" + this.actual + "], expected [" + this.expected + "]";
        }

        public String getActual() {
            return this.actual;
        }

        public void setActual(String actual) {
            this.actual = actual;
        }

        public String getExpected() {
            return this.expected;
        }

        public void setExpected(String expected) {
            this.expected = expected;
        }
    }
}

