/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.ddsclient.connection;

import com.signiant.interactivetransfer.engine.exceptions.SecurityManagerInitializationException;
import com.signiant.interactivetransfer.engine.exceptions.TransferException;
import com.signiant.mobilize.ddsclient.connection.AcknowledgeFeedback;
import com.signiant.mobilize.ddsclient.connection.InvalidCertificateException;
import com.signiant.mobilize.ddsclient.core.security.validator.CertificateInvalidException;
import com.signiant.mobilize.ddsclient.core.security.validator.InvalidPeerException;
import com.signiant.mobilize.ddsclient.core.security.validator.SSLSessionValidator;
import com.signiant.mobilize.ddsclient.core.security.validator.SSLSessionValidatorFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import sun.security.provider.certpath.SunCertPathBuilderException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Port {
    private SSLEngine sslEngine;
    private ByteBuffer in;
    private ByteBuffer out;
    private ByteBuffer unread;
    protected InetSocketAddress address;
    protected Type type;
    private SSLMode sslmode;
    protected Logger logger;
    private AtomicLong sfsent;
    private AtomicLong sfrecvd;
    private AtomicLong nwsent;
    private AtomicLong nwrecvd;
    protected boolean validateCertificate = false;

    public Port(String logInstance) {
        if (logInstance == "DCLogger") {
            this.logger = Logger.getLogger(this.getClass().getPackage().getName() + "." + this.getClass().getSimpleName());
            this.logger.setLevel(Level.OFF);
        } else {
            String logBase = "com.signiant.interactivetransfer.engine";
            this.logger = Logger.getLogger(logBase + logInstance + "." + this.getClass().getSimpleName());
        }
        this.initStats();
    }

    private void initStats() {
        this.sfsent = new AtomicLong(0L);
        this.sfrecvd = new AtomicLong(0L);
        this.nwsent = new AtomicLong(0L);
        this.nwrecvd = new AtomicLong(0L);
    }

    public String toString() {
        return "Port [type=" + (Object)((Object)this.type) + " address=" + this.address + "]";
    }

    public HashMap<String, Long> getPortStatistics() {
        HashMap<String, Long> stats = new HashMap<String, Long>();
        if (this.sfsent.get() > 0L) {
            stats.put("sfsent", new Long(this.sfsent.get()));
        }
        if (this.sfrecvd.get() > 0L) {
            stats.put("sfrecvd", new Long(this.sfrecvd.get()));
        }
        if (this.nwsent.get() > 0L) {
            stats.put("nwsent", new Long(this.nwsent.get()));
        }
        if (this.nwrecvd.get() > 0L) {
            stats.put("nwrecvd", new Long(this.nwrecvd.get()));
        }
        return stats;
    }

    protected abstract int readImpl(ByteBuffer var1) throws IOException, InterruptedException;

    protected abstract int writeImpl(ByteBuffer var1, AcknowledgeFeedback var2) throws IOException, InterruptedException;

    protected abstract void closeImpl() throws IOException;

    protected abstract void wakeupImpl();

    protected abstract InetAddress getLocalInetAddressImpl();

    public void wakeup() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Waking up");
        }
        this.wakeupImpl();
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    private void initializeSSLEngine(String host, int port, SSLContext ctxt) throws IOException, InterruptedException {
        this.sslEngine = ctxt.createSSLEngine(host, port);
        this.sslEngine.setUseClientMode(true);
        String[] protocols = new String[]{"TLSv1"};
        this.sslEngine.setEnabledProtocols(protocols);
        int size = this.sslEngine.getSession().getPacketBufferSize();
        this.in = ByteBuffer.wrap(new byte[size]);
        this.out = ByteBuffer.wrap(new byte[size]);
        this.unread = ByteBuffer.wrap(new byte[size]);
        this.in.flip();
        this.unread.flip();
        this.handshake();
        if (this.validateCertificate) {
            try {
                this.validateSSLSession(host);
            }
            catch (InvalidCertificateException exception) {
                this.logger.severe("SSL Session validation " + exception.toString());
                throw exception;
            }
        }
    }

    protected void validateSSLSession(String host) throws InvalidCertificateException {
        if (this.sslEngine != null) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.toString() + ": Validate SSL Session with  " + host);
            }
            try {
                SSLSession session = this.getSSLSession();
                SSLSessionValidator validator = SSLSessionValidatorFactory.instance().getSSLSessionValidator();
                validator.validPeerCertificate(session);
                validator.validPeer(host, session);
            }
            catch (InvalidPeerException ipe) {
                this.logger.severe("Validation error, agent name not found in agent certificate - " + host);
                throw new InvalidCertificateException("Validation error, agent name not found in agent certificate");
            }
            catch (CertificateInvalidException cie) {
                this.logger.severe("Validation error, agent certificate expired or not yet valid - " + host);
                throw new InvalidCertificateException("Validation error, agent certificate expired or not yet valid");
            }
            catch (Exception exception) {
                this.logger.severe("Certificate validation error - " + host);
                throw new InvalidCertificateException("Certificate validation error");
            }
        }
    }

    protected SSLSession getSSLSession() {
        return this.sslEngine.getSession();
    }

    public void initializeSSL(String host, int port, SSLContext ctxt, SSLMode sslmode) throws Exception {
        this.sslmode = sslmode;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Initializing SSL session with " + (Object)((Object)sslmode));
        }
        this.initializeSSLEngine(host, port, ctxt);
    }

    public void initializeSSL(String host, int port, Certificate cert, SSLMode sslmode) throws IOException, InterruptedException, TransferException {
        SSLContext ctxt;
        this.sslmode = sslmode;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Initializing SSL session with " + (Object)((Object)sslmode));
        }
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null, "signiant".toCharArray());
            KeyStore.TrustedCertificateEntry tce = new KeyStore.TrustedCertificateEntry(cert);
            ks.setEntry("ca", tce, null);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            ctxt = SSLContext.getInstance("SSL");
            ctxt.init(null, tmf.getTrustManagers(), null);
        }
        catch (Throwable gse) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.severe(this.toString() + ": Caught " + gse);
            }
            SecurityManagerInitializationException e = new SecurityManagerInitializationException("Unable to initialize security manager for SSL connections", gse);
            e.initCause(gse);
            throw e;
        }
        this.initializeSSLEngine(host, port, ctxt);
    }

    private void handshake() throws IOException, InterruptedException {
        this.in.clear();
        this.out.clear();
        this.in.flip();
        String[] noEncryptionCiphers = new String[]{"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_SHA"};
        if (this.sslmode != SSLMode.STRONG) {
            this.sslEngine.setEnabledCipherSuites(noEncryptionCiphers);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Starting SSL handshake");
        }
        this.sslEngine.beginHandshake();
        try {
            boolean finished = false;
            while (!finished) {
                switch (this.sslEngine.getHandshakeStatus()) {
                    case NEED_WRAP: {
                        SSLEngineResult result = this.sslEngine.wrap(this.in, this.out);
                        if (result.getStatus() == SSLEngineResult.Status.OK && result.bytesProduced() > 0) {
                            this.out.flip();
                            this.writeImpl(this.out, null);
                            this.out.clear();
                            break;
                        }
                        if (!this.logger.isLoggable(Level.SEVERE)) break;
                        this.logger.severe(this.toString() + ": SSL wrap failed: " + result + " Handshake status: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
                        break;
                    }
                    case NEED_UNWRAP: {
                        SSLEngineResult result;
                        if (!this.in.hasRemaining()) {
                            this.in.clear();
                            this.readImpl(this.in);
                            this.in.flip();
                        }
                        if ((result = this.sslEngine.unwrap(this.in, this.out)).getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                            this.in.compact();
                            this.readImpl(this.in);
                            this.in.flip();
                            break;
                        }
                        if (result.getStatus() == SSLEngineResult.Status.OK) break;
                        if (this.logger.isLoggable(Level.SEVERE)) {
                            this.logger.severe(this.toString() + ": SSL unwrap failed: " + result + " Handshake status: " + (Object)((Object)this.sslEngine.getHandshakeStatus()));
                        }
                        throw new SSLException("SSL error: " + result.toString() + result);
                    }
                    case NEED_TASK: {
                        if (this.logger.isLoggable(Level.FINER)) {
                            this.logger.finer(this.toString() + ": Need SSL task");
                        }
                        this.sslEngine.getDelegatedTask().run();
                        break;
                    }
                    case NOT_HANDSHAKING: 
                    case FINISHED: {
                        finished = true;
                    }
                }
            }
        }
        catch (SSLException e) {
            String errorMessage;
            Throwable cause;
            Throwable oldCause = null;
            for (cause = e.getCause(); cause != oldCause && cause != null; cause = cause.getCause()) {
                if (this.logger.isLoggable(Level.WARNING)) {
                    this.logger.warning(this.toString() + ": SSL error: " + cause.getMessage());
                }
                oldCause = cause;
            }
            String string = oldCause == null ? (cause == null ? e.getMessage() : cause.getMessage()) : (errorMessage = oldCause.getMessage());
            if (oldCause != null && oldCause instanceof SunCertPathBuilderException) {
                errorMessage = "Invalid certificate for this transfer (" + errorMessage + ")";
            }
            throw new InvalidCertificateException("CA certificate verification failed: " + errorMessage, e);
        }
        SSLSession session = this.getSSLSession();
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Negotiated encryption using cipher: " + session.getCipherSuite());
        }
    }

    public void shutdownSSL() throws IOException, InterruptedException {
        SSLEngineResult result;
        if (this.sslmode == SSLMode.UNSIGNED || this.sslEngine == null) {
            this.sslEngine = null;
            this.in = null;
            this.out = null;
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": Shutting down SSL");
        }
        this.in.clear();
        this.out.clear();
        this.readImpl(this.in);
        this.in.flip();
        do {
            if ((result = this.sslEngine.unwrap(this.in, this.out)).getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
            this.in.clear();
            this.out.clear();
            this.readImpl(this.in);
            this.in.flip();
        } while (result.getStatus() != SSLEngineResult.Status.CLOSED);
        if (this.in.hasRemaining()) {
            this.unread.clear();
            this.unread.put(this.in);
            this.unread.flip();
        }
        this.sslEngine = null;
        this.in = null;
        this.out = null;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine(this.toString() + ": SSL shut down");
        }
    }

    public int read(ByteBuffer buffer) throws IOException, InterruptedException {
        if (this.unread != null && this.unread.hasRemaining()) {
            int result = Math.min(this.unread.remaining(), buffer.remaining());
            for (int i = 0; i < result; ++i) {
                buffer.put(this.unread.get());
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Handing back remaining: " + result);
            }
            this.sfrecvd.addAndGet(result);
            return result;
        }
        if (this.sslEngine == null || this.sslmode == SSLMode.UNSIGNED) {
            int read = this.readImpl(buffer);
            this.sfrecvd.addAndGet(read);
            this.nwrecvd.addAndGet(read);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Raw read: " + read);
            }
            return read;
        }
        if (!this.in.hasRemaining()) {
            this.in.clear();
            int read = this.readImpl(this.in);
            this.nwrecvd.addAndGet(read);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": No data, SSL read: " + read);
            }
            this.in.flip();
        }
        this.unread.clear();
        SSLEngineResult sslResult = this.sslEngine.unwrap(this.in, this.unread);
        boolean done = false;
        block6: while (!done) {
            switch (sslResult.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    this.in.compact();
                    int read = this.readImpl(this.in);
                    this.nwrecvd.addAndGet(read);
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Underflow, SSL read: " + read);
                    }
                    this.in.flip();
                    sslResult = this.sslEngine.unwrap(this.in, this.unread);
                    continue block6;
                }
                case CLOSED: {
                    this.sslEngine = null;
                    if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.finest(this.toString() + ": Closed, holding on to " + this.in.remaining());
                    }
                    if (this.in.hasRemaining()) {
                        this.unread.put(this.in);
                    }
                    done = true;
                    continue block6;
                }
                case OK: {
                    done = true;
                    continue block6;
                }
            }
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning(this.toString() + ": Unhandled SSL status: " + (Object)((Object)sslResult.getStatus()));
            }
            throw new IOException("Unhandled SSL result in Port.read: status = " + (Object)((Object)sslResult.getStatus()) + sslResult);
        }
        this.unread.flip();
        int result = Math.min(this.unread.remaining(), buffer.remaining());
        this.sfrecvd.addAndGet(result);
        for (int i = 0; i < result; ++i) {
            buffer.put(this.unread.get());
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest(this.toString() + ": After SSL decrypt, read: " + result);
        }
        return result;
    }

    public synchronized int write(ByteBuffer buffer) throws IOException {
        return this.write(buffer, null);
    }

    public synchronized int write(ByteBuffer buffer, AcknowledgeFeedback feedback) throws IOException {
        int written = 0;
        try {
            this.sfsent.addAndGet(buffer.remaining());
            if (this.sslEngine == null || this.sslmode == SSLMode.UNSIGNED) {
                written = this.writeImpl(buffer, feedback);
                this.nwsent.addAndGet(written);
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest(this.toString() + ": Raw write: " + written);
                }
                return written;
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": Before SSL encrypt, write: " + buffer.remaining());
            }
            while (buffer.hasRemaining()) {
                this.out.clear();
                this.sslEngine.wrap(buffer, this.out);
                this.out.flip();
                if (this.out.remaining() == 0) break;
                written += this.writeImpl(this.out, feedback);
            }
            this.nwsent.addAndGet(written);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.toString() + ": SSL wrapped write: " + written);
            }
        }
        catch (InterruptedException discard) {
            // empty catch block
        }
        return written;
    }

    public void close() throws IOException {
        this.sslEngine = null;
        this.closeImpl();
    }

    public InetAddress getLocalInetAddress() {
        return this.getLocalInetAddressImpl();
    }

    public Type getType() {
        return this.type;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public boolean validateCertificate() {
        return this.validateCertificate;
    }

    public void setValidateCertificate(boolean validateCertificate) {
        this.validateCertificate = validateCertificate;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SSLMode {
        UNSIGNED{

            public String toString() {
                return "no encryption - unsigned";
            }
        }
        ,
        NONE{

            public String toString() {
                return "no encryption - signed";
            }
        }
        ,
        STRONG{

            public String toString() {
                return "strong encryption";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        TCP,
        UDP,
        HTTP,
        Plain;

    }
}

