/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.mobilize.cryptoapi.impl;

import com.signiant.mobilize.cryptoapi.CryptoService;
import com.signiant.mobilize.ddsclient.connection.Base64;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AESCryptoServiceImpl
implements CryptoService {
    private Cipher cipher = null;

    public void initEncryption(String passPhrase, String salt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, UnsupportedEncodingException {
        this.initializeSaltedCipher(1, passPhrase, salt);
    }

    public void initEncryption(String passPhrase) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, UnsupportedEncodingException {
        this.initializeSaltedCipher(1, passPhrase, null);
    }

    public void initDecryption(String passPhrase, String salt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, UnsupportedEncodingException {
        this.initializeSaltedCipher(2, passPhrase, salt);
    }

    public void initDecryption(String passPhrase) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, UnsupportedEncodingException {
        this.initializeSaltedCipher(2, passPhrase, null);
    }

    public SecretKeySpec computeSecretKeySpec(String passPhrase) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
        String keySpecification = "AES";
        for (int i = 0; i < 10; ++i) {
            passPhrase = passPhrase + passPhrase;
        }
        int start = 7;
        String newPassPhrase = passPhrase.substring(start, start + 16);
        SecretKeySpec secretKey = new SecretKeySpec(newPassPhrase.getBytes(), keySpecification);
        return secretKey;
    }

    protected void initializeSaltedCipher(int cipherMode, String passPhrase, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, UnsupportedEncodingException {
        String cipherAlgorithm = "AES/CTR/NoPadding";
        byte[] ivBytes = "1234567812345678".getBytes();
        SecretKey secret = this.generateSecretKey(passPhrase, salt);
        this.cipher = Cipher.getInstance(cipherAlgorithm);
        this.cipher.init(cipherMode, (Key)secret, new IvParameterSpec(ivBytes));
    }

    protected SecretKey generateSecretKey(String passPhrase, String salt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, InvalidKeySpecException, UnsupportedEncodingException {
        PBEKeySpec pbeKeySpec;
        String keySpecification = "AES";
        int count = 1000;
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
        if (salt != null) {
            SecretKeySpec secretKeySpec = new SecretKeySpec(salt.getBytes(), keySpecification);
            pbeKeySpec = new PBEKeySpec(passPhrase.toCharArray(), secretKeySpec.getEncoded(), count, 128);
        } else {
            pbeKeySpec = new PBEKeySpec(passPhrase.toCharArray(), passPhrase.getBytes("UTF-8"), count, 128);
        }
        SecretKey tmp = factory.generateSecret(pbeKeySpec);
        SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), keySpecification);
        return secret;
    }

    public int decryptBuffer(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.processBuffer(inputBuffer, 0, inputBuffer.limit(), outputBuffer);
    }

    public int encryptBuffer(ByteBuffer inputBuffer, int inputOffset, int inputLength, ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.processBuffer(inputBuffer, inputOffset, inputLength, outputBuffer);
    }

    public int encryptBuffer(ByteBuffer inputBuffer, ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.processBuffer(inputBuffer, 0, inputBuffer.limit(), outputBuffer);
    }

    public int decryptBuffer(ByteBuffer inputBuffer, int inputOffset, int inputLength, ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.processBuffer(inputBuffer, inputOffset, inputLength, outputBuffer);
    }

    public int finalizeBuffer(ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    private int processBuffer(ByteBuffer inputBuffer, int inputOffset, int inputLength, ByteBuffer outputBuffer) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] outByte;
        byte[] inByte = inputBuffer.array();
        int byteWritten = this.cipher.doFinal(inByte, inputOffset, inputLength, outByte = outputBuffer.array());
        if (byteWritten > 0) {
            outputBuffer.position(byteWritten);
        }
        return byteWritten;
    }

    public String generateSalt() throws NoSuchAlgorithmException {
        byte[] salt = new byte[8];
        SecureRandom saltGen = SecureRandom.getInstance("SHA1PRNG");
        saltGen.nextBytes(salt);
        return new String(Base64.encode(salt));
    }

    public String encrypt(String textToEncrypt) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] encryptedValue = this.cipher.doFinal(textToEncrypt.getBytes("UTF-8"));
        return Base64.encode(encryptedValue);
    }

    public String decrypt(String textToDecrypt) throws IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        byte[] decryptedValue = this.cipher.doFinal(textToDecrypt.getBytes("UTF-8"));
        return Base64.encode(decryptedValue);
    }
}

