/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.serverconnection;

import com.signiant.jsf.services.Service;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DebugInfoEvent;
import com.signiant.jsf.services.event.events.InactivityTimeoutExpired;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.event.events.ThreadFinished;
import com.signiant.jsf.services.event.events.ThreadStarted;
import com.signiant.jsf.services.serverconnection.ServerConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Random;

public class ServerConnectionService
implements Service,
PropertyChangeListener {
    public static int SESSION_ID_LENGTH = 20;
    private HashMap<String, ServerConnection> connectionList;
    private boolean running;
    private Thread reaper;

    public void healthCheck() {
    }

    public void init() throws Exception {
        this.connectionList = new HashMap();
        this.reaper = new Thread("ServerConnectionService Reaper"){

            public void run() {
                EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
                try {
                    ServerConnectionService.this.reaper();
                }
                catch (Throwable fatal) {
                    EventService.publishEvent(PrivateError.class, fatal);
                }
                EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
            }
        };
    }

    public void pause() {
        this.running = false;
        this.reaper.interrupt();
    }

    public void start() {
        this.running = true;
        this.reaper.start();
    }

    public void stop() {
        this.pause();
        HashMap<String, ServerConnection> oldList = this.connectionList;
        this.connectionList = null;
        if (oldList != null) {
            for (ServerConnection connection : oldList.values()) {
                connection.terminate();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public synchronized ServerConnection getConnection() {
        if (this.running) {
            String sessionId = this.generateSessionId();
            ServerConnection pc = new ServerConnection(this, sessionId);
            this.connectionList.put(sessionId, pc);
            return pc;
        }
        return null;
    }

    public ServerConnection getConnection(String sessionId) {
        return this.connectionList.get(sessionId);
    }

    synchronized void removeConnection(ServerConnection connection) {
        EventService.publishEvent(DebugInfoEvent.class, "Removing session", connection, connection.getSessionId());
        if (this.connectionList != null) {
            this.connectionList.remove(connection.getSessionId());
        }
    }

    private synchronized String generateSessionId() {
        String sessionId = null;
        boolean unique = false;
        while (!unique) {
            Random r = new Random();
            byte[] raw = new byte[SESSION_ID_LENGTH];
            r.nextBytes(raw);
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = (byte)((raw[i] + 128) % 64 + 32);
            }
            sessionId = new String(raw);
            unique = this.connectionList.get(sessionId) == null;
        }
        return sessionId;
    }

    public synchronized boolean isSessionCurrent(String sessionId) {
        long now = System.currentTimeMillis();
        if (this.connectionList.values() != null) {
            for (ServerConnection connection : this.connectionList.values()) {
                if (!connection.getSessionId().equals(sessionId) || now - connection.getLastAccessTime() >= 15000L) continue;
                return true;
            }
        }
        return false;
    }

    private void reaper() {
        while (this.running) {
            try {
                long now = System.currentTimeMillis();
                if (this.connectionList.values() != null) {
                    for (ServerConnection connection : this.connectionList.values()) {
                        if (now - connection.getLastAccessTime() <= 15000L) continue;
                        EventService.publishEvent(InactivityTimeoutExpired.class, now, connection.getLastAccessTime(), connection.getSessionId());
                        connection.terminate();
                        break;
                    }
                }
                Thread.sleep(5000L);
            }
            catch (Throwable oops) {
                EventService.publishEvent(PrivateError.class, oops);
            }
        }
    }

    public String getAdvertisedCapability() {
        return this.getClass().getSimpleName();
    }
}

