/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.serverconnection;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DataTransmission;
import com.signiant.jsf.services.event.events.EndOfProtocolInputStream;
import com.signiant.jsf.services.event.events.IOExceptionEvent;
import com.signiant.jsf.services.serverconnection.ServerConnectionService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class ServerConnection {
    private SocketChannel channel;
    private String sessionId;
    private long lastAccessTime = System.currentTimeMillis();
    private long highestSequenceNumber;
    private ServerConnectionService serverConnectionService;
    private int sequenceNumber;
    private Selector readSelector;
    private Selector writeSelector;
    private SelectionKey selectionKey;

    protected ServerConnection(ServerConnectionService service, String sessionId) {
        this.serverConnectionService = service;
        this.sessionId = sessionId;
        this.sequenceNumber = 0;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber++;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void connect(String host, int port) throws IOException {
        InetSocketAddress peerAddress = host == null ? new InetSocketAddress(InetAddress.getLocalHost(), port) : new InetSocketAddress(host, port);
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        Socket socket = this.channel.socket();
        socket.setReceiveBufferSize(0x100000);
        socket.setSendBufferSize(0x100000);
        this.channel.connect(peerAddress);
        int attempts = 100;
        while (attempts-- > 0 && !this.channel.finishConnect()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException discard) {
                // empty catch block
                break;
            }
        }
        if (attempts <= 0) {
            throw new IOException("Timeout connecting to " + peerAddress);
        }
        this.readSelector = Selector.open();
        this.writeSelector = Selector.open();
        this.selectionKey = this.channel.register(this.readSelector, 1);
        this.selectionKey = this.channel.register(this.writeSelector, 4);
    }

    public SocketChannel getSocket() {
        return this.channel;
    }

    public int available() {
        return this.available(-1L);
    }

    public int available(long timeout) {
        this.lastAccessTime = System.currentTimeMillis();
        try {
            int avail = 0;
            avail = timeout < 0L ? this.readSelector.selectNow() : this.readSelector.select(timeout);
            Iterator<SelectionKey> iterator = this.readSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            return avail;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public void write(ByteBuffer buffer, long sequenceNumber) {
        try {
            this.lastAccessTime = System.currentTimeMillis();
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, buffer.remaining(), 0, buffer});
            if (sequenceNumber > this.highestSequenceNumber) {
                this.channel.write(buffer);
                while (buffer.hasRemaining()) {
                    this.writeSelector.select();
                    this.channel.write(buffer);
                    Iterator<SelectionKey> iterator = this.writeSelector.selectedKeys().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        iterator.remove();
                    }
                }
                this.highestSequenceNumber = sequenceNumber;
            }
        }
        catch (IOException e) {
            EventService.publishEvent(IOExceptionEvent.class, e);
            this.terminate();
        }
    }

    public int read(ByteBuffer buffer) throws IOException {
        this.lastAccessTime = System.currentTimeMillis();
        int read = this.channel.read(buffer);
        if (read == -1) {
            EventService.publishEvent(EndOfProtocolInputStream.class, this, this.sessionId);
            this.terminate();
        }
        return read;
    }

    public void terminate() {
        this.serverConnectionService.removeConnection(this);
        try {
            this.channel.close();
        }
        catch (Throwable discard) {
            // empty catch block
        }
        if (this.selectionKey != null) {
            this.selectionKey.cancel();
        }
        if (this.readSelector != null) {
            try {
                this.readSelector.close();
            }
            catch (IOException discard) {
                // empty catch block
            }
        }
        if (this.writeSelector != null) {
            try {
                this.writeSelector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

