/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.resourcepool;

import com.signiant.jsf.services.Service;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.HealthCheckEvent;
import com.signiant.jsf.services.resourcepool.ResourceFactory;
import com.signiant.jsf.services.resourcepool.ResourcePool;
import java.util.HashMap;

public class ResourcePoolService
implements Service {
    protected HashMap<String, ResourcePool> resourcePools;

    public void healthCheck() {
        EventService.publishEvent(HealthCheckEvent.class, "Current pool count", this.resourcePools.size());
    }

    public void init() throws Exception {
        this.resourcePools = new HashMap();
    }

    public void pause() {
    }

    public void start() {
    }

    public void stop() {
    }

    public String getAdvertisedCapability() {
        return this.getClass().getSimpleName();
    }

    public ResourcePool getResourcePool(String poolName) {
        return this.resourcePools.get(poolName);
    }

    public ResourcePool getResourcePool(String poolName, ResourceFactory factory) {
        ResourcePool pool = this.resourcePools.get(poolName);
        if (pool == null) {
            pool = new ResourcePool(factory);
            this.resourcePools.put(poolName, pool);
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseResourcePool(ResourcePool pool) {
        if (this.resourcePools.containsValue(pool)) {
            HashMap<String, ResourcePool> hashMap = this.resourcePools;
            synchronized (hashMap) {
                for (String poolName : this.resourcePools.keySet()) {
                    if (this.resourcePools.get(poolName) != pool) continue;
                    this.resourcePools.remove(poolName);
                    pool.releaseAllResources();
                    break;
                }
            }
        }
    }

    public void releaseResourcePool(String poolName) {
        ResourcePool pool = this.resourcePools.remove(poolName);
        pool.releaseAllResources();
    }
}

