/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.resourcepool;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.resourcepool.Resource;
import com.signiant.jsf.services.resourcepool.ResourceFactory;
import com.signiant.jsf.services.resourcepool.events.ResourcePoolMemoryCapacityReachedEvent;
import java.util.HashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ResourcePool {
    protected LinkedBlockingQueue<Resource> freeResources = new LinkedBlockingQueue();
    protected HashMap<Resource, StackTraceElement[]> allocatedResources = new HashMap();
    protected ResourceFactory factory;
    protected Object lock;
    protected boolean memoryCapacityReached;
    private static final int reservedFreeMemory = 0x1000000;
    static Object dumper = new Object();

    public ResourcePool(ResourceFactory factory) {
        this.factory = factory;
        this.lock = new Object();
        this.memoryCapacityReached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        Object object = this.lock;
        synchronized (object) {
            this.freeResources = new LinkedBlockingQueue();
            this.allocatedResources = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int ensureCapacity(int capacity) {
        int currentCapacity = 0;
        Object object = this.lock;
        synchronized (object) {
        }
        if (this.memoryCapacityReached) {
            return currentCapacity;
        }
        long memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        if (memory < 0x1000000L) {
            EventService.publishEvent(ResourcePoolMemoryCapacityReachedEvent.class, memory, capacity);
            this.memoryCapacityReached = true;
            return currentCapacity;
        }
        for (currentCapacity = this.getCapacity(); currentCapacity < capacity && memory > 0x1000000L; ++currentCapacity) {
            Resource resource = null;
            try {
                resource = this.factory.makeResource();
            }
            catch (OutOfMemoryError goneTooFar) {
                this.memoryCapacityReached = true;
                memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
                EventService.publishEvent(ResourcePoolMemoryCapacityReachedEvent.class, memory, capacity, goneTooFar);
                return currentCapacity;
            }
            Object object2 = this.lock;
            synchronized (object2) {
                this.freeResources.add(resource);
            }
            memory = Runtime.getRuntime().maxMemory() - Runtime.getRuntime().totalMemory() + Runtime.getRuntime().freeMemory();
        }
        return currentCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCapacity() {
        int currentCapacity = 0;
        Object object = this.lock;
        synchronized (object) {
            currentCapacity = this.freeResources.size() + this.allocatedResources.size();
        }
        return currentCapacity;
    }

    public int getFreeCount() {
        return this.freeResources.size();
    }

    public int getAllocatedCount() {
        return this.allocatedResources.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource allocate() throws InterruptedException {
        Resource resource = null;
        resource = this.freeResources.poll(5L, TimeUnit.SECONDS);
        if (resource == null) {
            Object object = dumper;
            synchronized (object) {
                EventService.publishEvent(PrivateError.class, "Timeout waiting for resource", this, Thread.currentThread().getName(), Thread.currentThread().getStackTrace());
                int max = this.allocatedResources.size();
                int cur = 0;
                for (Resource r : this.allocatedResources.keySet()) {
                    StackTraceElement[] backtrace = this.allocatedResources.get(r);
                    EventService.publishEvent(PrivateError.class, cur++ + "/" + max + ": " + backtrace[3]);
                }
            }
            throw new InterruptedException("Timeout waiting for a resource");
        }
        Object object = this.lock;
        synchronized (object) {
            this.allocatedResources.put(resource, Thread.currentThread().getStackTrace());
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource allocate(int timeoutMilliseconds) throws InterruptedException {
        Resource resource = null;
        resource = this.freeResources.poll(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        Object object = this.lock;
        synchronized (object) {
            if (resource != null) {
                this.allocatedResources.put(resource, Thread.currentThread().getStackTrace());
            }
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Resource freedResource) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allocatedResources.remove(freedResource) != null) {
                this.freeResources.add(freedResource);
            }
        }
    }
}

