/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DataTransmission;
import com.signiant.jsf.services.event.events.UnexpectedPacketTypeReceived;
import com.signiant.jsf.services.protocoltunnel.handlers.TunnelInputStream;
import com.signiant.jsf.services.protocoltunnel.handlers.TunnelOutputStream;
import com.signiant.jsf.services.protocoltunnel.versions.TunnelPacket;
import com.signiant.jsf.services.protocoltunnel.versions.TunnelPacketSequenceGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class Tunnel_V2 {
    private int bytesUploaded;
    private int bytesDownloaded;
    private String peerHost;
    private int peerPort;

    public Tunnel_V2(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    public void emitBurstPacket(TunnelOutputStream output, int burstSize, TunnelPacketSequenceGenerator sequenceGenerator) throws IOException {
        this.emitTunnelPacket(output, 4, Tunnel_V2.makeTwoByteArray(burstSize), 2, sequenceGenerator);
    }

    public void emitTunnelPacket(TunnelOutputStream output, int packetType, byte[] payload, int size, TunnelPacketSequenceGenerator sequenceGenerator) throws IOException {
        output.write(packetType);
        int transmitPacketSequenceNumber = sequenceGenerator.getNextSequenceNumber();
        byte[] sequence = Tunnel_V2.makeQuadByteArray(transmitPacketSequenceNumber);
        byte[] sizeinfo = Tunnel_V2.makeThreeByteArray(size);
        output.write(sequence);
        output.write(sizeinfo);
        if (size > 0) {
            output.write(payload, 0, size);
        }
        this.bytesUploaded += size + 8;
        EventService.publishEvent(DataTransmission.class, output, "TRANSMIT", size + 8, this.bytesUploaded, Tunnel_V2.prettyPrint(packetType, payload, size));
    }

    public TunnelPacket readTunnelPacket(InputStream input, int expectedPacketType, byte[] buffer) throws IOException {
        int packetType = input.read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.peerHost, this.peerPort, expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(input, sequence, sequence.length);
        this._readBuffer(input, sizeinfo, sizeinfo.length);
        this.bytesDownloaded += 8;
        TunnelPacket packet = new TunnelPacket();
        packet.setSequence(Tunnel_V2.getValue(sequence));
        int length = Tunnel_V2.getValue(sizeinfo);
        packet.setSize(length);
        packet.setBuffer(buffer);
        packet.setType((byte)packetType);
        if (buffer == null) {
            return packet;
        }
        int bytesRead = this._readBuffer(input, buffer, length);
        this.bytesDownloaded += bytesRead;
        EventService.publishEvent(DataTransmission.class, input, "RECEIVE", bytesRead, this.bytesDownloaded, Tunnel_V2.prettyPrint(packetType, buffer, bytesRead));
        return packet;
    }

    public TunnelPacket readTunnelPacket(TunnelInputStream input, int expectedPacketType, byte[] buffer) throws IOException {
        int packetType = input.read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.peerHost, this.peerPort, expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(input, sequence, sequence.length);
        this._readBuffer(input, sizeinfo, sizeinfo.length);
        this.bytesDownloaded += 8;
        TunnelPacket packet = new TunnelPacket();
        packet.setSequence(Tunnel_V2.getValue(sequence));
        int length = Tunnel_V2.getValue(sizeinfo);
        packet.setSize(length);
        packet.setBuffer(buffer);
        packet.setType((byte)packetType);
        if (buffer == null) {
            return packet;
        }
        int bytesRead = this._readBuffer(input, buffer, length);
        this.bytesDownloaded += bytesRead;
        EventService.publishEvent(DataTransmission.class, input, "RECEIVE", bytesRead, this.bytesDownloaded, Tunnel_V2.prettyPrint(packetType, buffer, bytesRead));
        return packet;
    }

    public TunnelPacket readTunnelPacket(InputStream input, int expectedPacketType) throws IOException {
        int packetType = input.read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.peerHost, this.peerPort, expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(input, sequence, sequence.length);
        this._readBuffer(input, sizeinfo, sizeinfo.length);
        TunnelPacket packet = new TunnelPacket();
        packet.setSequence(Tunnel_V2.getValue(sequence));
        int length = Tunnel_V2.getValue(sizeinfo);
        packet.setSize(length);
        this.bytesDownloaded += 8;
        byte[] buffer = new byte[length];
        packet.setBuffer(buffer);
        packet.setType((byte)packetType);
        int bytesRead = this._readBuffer(input, buffer, length);
        this.bytesDownloaded += bytesRead;
        EventService.publishEvent(DataTransmission.class, input, "RECEIVE", bytesRead, this.bytesDownloaded, Tunnel_V2.prettyPrint(packetType, buffer, bytesRead));
        return packet;
    }

    private int _readBuffer(InputStream input, byte[] buffer, int length) throws IOException {
        int bytesRead = 0;
        if (length > 0) {
            bytesRead = input.read(buffer, 0, length);
        }
        while (length <= buffer.length && bytesRead < length) {
            int newRead = input.read(buffer, bytesRead, length - bytesRead);
            if (newRead == -1) {
                return bytesRead;
            }
            bytesRead += newRead;
        }
        return bytesRead;
    }

    public TunnelPacket readTunnelPacketSlice(TunnelInputStream input, int expectedPacketType) throws IOException {
        int packetType = input.read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.peerHost, this.peerPort, expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        int seqRead = this._readBuffer(input, sequence, sequence.length);
        int sizeRead = this._readBuffer(input, sizeinfo, sizeinfo.length);
        if (seqRead < sequence.length || sizeRead < sizeinfo.length) {
            // empty if block
        }
        TunnelPacket packet = new TunnelPacket();
        packet.setSequence(Tunnel_V2.getValue(sequence));
        int length = Tunnel_V2.getValue(sizeinfo);
        packet.setSize(length);
        this.bytesDownloaded += 8;
        ByteBuffer slice = input.readSlice(length);
        packet.setByteBuffer(slice);
        this.bytesDownloaded += slice.remaining();
        byte[] buf = new byte[slice.remaining()];
        slice.mark();
        slice.get(buf);
        slice.rewind();
        EventService.publishEvent(DataTransmission.class, input, "RECEIVE", slice.remaining(), this.bytesDownloaded, Tunnel_V2.prettyPrint(packetType, buf, buf.length));
        return packet;
    }

    public TunnelPacket readTunnelPacket(TunnelInputStream input, int expectedPacketType) throws IOException {
        int packetType = input.read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.peerHost, this.peerPort, expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(input, sequence, sequence.length);
        this._readBuffer(input, sizeinfo, sizeinfo.length);
        TunnelPacket packet = new TunnelPacket();
        packet.setSequence(Tunnel_V2.getValue(sequence));
        int length = Tunnel_V2.getValue(sizeinfo);
        packet.setSize(length);
        this.bytesDownloaded += 8;
        byte[] buffer = new byte[length];
        packet.setBuffer(buffer);
        packet.setType((byte)packetType);
        int bytesRead = this._readBuffer(input, buffer, length);
        this.bytesDownloaded += bytesRead;
        EventService.publishEvent(DataTransmission.class, input, "RECEIVE", bytesRead, this.bytesDownloaded, Tunnel_V2.prettyPrint(packetType, buffer, bytesRead));
        return packet;
    }

    private int _readBuffer(TunnelInputStream input, byte[] buffer, int length) throws IOException {
        int bytesRead = 0;
        if (length > 0) {
            bytesRead = input.read(buffer, 0, length);
        }
        while (length <= buffer.length && bytesRead < length) {
            int newRead = input.read(buffer, bytesRead, length - bytesRead);
            if (newRead == -1) {
                return bytesRead;
            }
            bytesRead += newRead;
        }
        return bytesRead;
    }

    public int getBytesUploaded() {
        return this.bytesUploaded;
    }

    public int getBytesDownloaded() {
        return this.bytesDownloaded;
    }

    public static byte[] makeTwoByteArray(int value) {
        byte[] buffer = new byte[]{(byte)((value >> 8) % 256), (byte)(value % 256)};
        return buffer;
    }

    public static byte[] makeThreeByteArray(int value) {
        byte[] buffer = new byte[]{(byte)((value >> 16) % 256), (byte)((value >> 8) % 256), (byte)(value % 256)};
        return buffer;
    }

    public static byte[] makeQuadByteArray(int value) {
        byte[] buffer = new byte[]{(byte)(value >> 24), (byte)((value >> 16) % 256), (byte)((value >> 8) % 256), (byte)(value % 256)};
        return buffer;
    }

    public static int getValue(byte[] buffer) {
        int value = -1;
        switch (buffer.length) {
            case 1: {
                value = buffer[0] & 0xFF;
                break;
            }
            case 2: {
                value = (buffer[0] & 0xFF) * 256 + (buffer[1] & 0xFF);
                break;
            }
            case 3: {
                value = (buffer[0] & 0xFF) * 65536 + (buffer[1] & 0xFF) * 256 + (buffer[2] & 0xFF);
                break;
            }
            case 4: {
                value = (buffer[0] & 0xFF) * 0x1000000 + (buffer[1] & 0xFF) * 65536 + (buffer[2] & 0xFF) * 256 + (buffer[3] & 0xFF);
            }
        }
        return value;
    }

    public static String prettyPrint(int packetType, byte[] buffer, int size) {
        StringBuilder b = new StringBuilder();
        switch (packetType) {
            case 1: {
                b.append("Tunnel Open: ");
                b.append(new String(buffer));
                break;
            }
            case 2: {
                b.append("Tunnel Data: ");
                int length = size;
                if (length > 64) {
                    length = 64;
                }
                for (int i = 0; i < length; ++i) {
                    byte c = buffer[i];
                    if (c > 31 && c < 127) {
                        b.append((char)c);
                        continue;
                    }
                    b.append("<");
                    b.append(c);
                    b.append(">");
                }
                break;
            }
            case 3: {
                b.append("Tunnel Close: ");
                b.append(new String(buffer));
                break;
            }
            case 4: {
                b.append("Tunnel Burst: ");
                b.append(Tunnel_V2.getValue(buffer));
                break;
            }
            case 5: {
                b.append("Tunnel Request Version: ");
                b.append(buffer[0]);
                break;
            }
            case 6: {
                b.append("Tunnel Stats Duration: ");
                b.append(Tunnel_V2.getValue(buffer));
            }
        }
        return b.toString();
    }
}

