/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DataTransmissionRateInfo;
import com.signiant.jsf.services.event.events.DebugInfoEvent;
import com.signiant.jsf.services.event.events.InvalidHTTPSessionRequested;
import com.signiant.jsf.services.event.events.InvalidHandshakeReceived;
import com.signiant.jsf.services.event.events.PeerConnectException;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.event.events.ProtocolConnectionCreated;
import com.signiant.jsf.services.event.events.ProtocolConnectionTermination;
import com.signiant.jsf.services.event.events.ProtocolStateChanged;
import com.signiant.jsf.services.event.events.ProtocolVersionNegotiation;
import com.signiant.jsf.services.event.events.StartOfConnection;
import com.signiant.jsf.services.event.events.ThreadFinished;
import com.signiant.jsf.services.event.events.ThreadStarted;
import com.signiant.jsf.services.protocoltunnel.AcceptedConnection;
import com.signiant.jsf.services.protocoltunnel.BlockedOrderedQueue;
import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import com.signiant.jsf.services.protocoltunnel.handlers.ClientProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.ServerProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.versions.TunnelPacket;
import com.signiant.jsf.services.protocoltunnel.versions.TunnelPacketSequenceGenerator;
import com.signiant.jsf.services.protocoltunnel.versions.Tunnel_V2;
import com.signiant.jsf.services.resourcepool.Resource;
import com.signiant.jsf.services.resourcepool.ResourceFactory;
import com.signiant.jsf.services.resourcepool.ResourcePool;
import com.signiant.jsf.services.resourcepool.ResourcePoolService;
import com.signiant.jsf.services.serverconnection.ServerConnection;
import com.signiant.jsf.services.serverconnection.ServerConnectionService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProtocolConnection_V2
implements ProtocolConnection {
    private static int BUFFER_SIZE = 32000;
    private static final byte TUNNEL_VERSION = 2;
    private static final int MAX_SEND_BACKLOG = 24;
    private List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private String peerHost;
    private int peerPort;
    private ProtocolConnection.State state;
    private boolean client;
    private long lastAccessTime;
    private ByteBuffer transferBuffer;
    private String sessionId;
    private BlockedOrderedQueue clientReceiveQueue;
    private LinkedBlockingQueue<ByteBufferResource> clientTransmitQueue;
    private int optimalSendBurst;
    private int optimalReceiveBurst;
    private List<Thread> synchronousClientTransferThreads;
    private Thread serverTransferThread;
    private Thread decoderBlockedThread;
    private Tunnel_V2 tunnel;
    private IOException synchronousClientException;
    private ClientProtocolHandler clientProtocolHandler;
    private ServerProtocolHandler serverProtocolHandler;
    private long initialRtt;
    private long currentRtt;
    private long linkspeed;
    private long dataspeed;
    private TunnelPacketSequenceGenerator clientSequenceGenerator;
    protected ResourcePoolService poolService;
    protected ResourcePool resourcePool;
    protected ResourceFactory factory;
    protected HashMap<byte[], ByteBufferResource> resourceMap;
    private int holdingPosition;
    private TunnelPacket currentReceivePacket;
    int currentNumberOfTransferThreads = 1;

    protected void freeByteBuffer(byte[] buffer) {
        ByteBufferResource resource = this.resourceMap.get(buffer);
        this.resourcePool.release(resource);
    }

    protected ByteBufferResource allocateByteBuffer() throws InterruptedException {
        ByteBufferResource resource = (ByteBufferResource)this.resourcePool.allocate();
        this.resourceMap.put(resource.getBuffer(), resource);
        return resource;
    }

    public boolean setupClient() throws IOException {
        this.setState(ProtocolConnection.State.INITIALIZED);
        this.tunnel = new Tunnel_V2(this.getPeerHost(), this.getPeerPort());
        if (this.isSynchronous()) {
            this.clientReceiveQueue = new BlockedOrderedQueue();
            this.clientTransmitQueue = new LinkedBlockingQueue(24);
            this.optimalSendBurst = 10;
            this.optimalReceiveBurst = 10;
            this.synchronousClientTransferThreads = new LinkedList<Thread>();
            this.poolService = (ResourcePoolService)BootStrap.getInstance().getService(ResourcePoolService.class);
            this.factory = new ByteBufferResourceFactory();
            this.resourcePool = this.poolService.getResourcePool("RP: " + this.toString() + this.hashCode(), this.factory);
            this.resourceMap = new HashMap();
            this.resourcePool.ensureCapacity(this.optimalReceiveBurst);
        }
        this.setState(ProtocolConnection.State.CONNECTING);
        this.clientSequenceGenerator = new TunnelPacketSequenceGenerator(){
            private AtomicInteger sequenceNumber = new AtomicInteger(0);

            public int getNextSequenceNumber() {
                return this.sequenceNumber.getAndIncrement();
            }
        };
        if (!this.clientConnectToPeer()) {
            return false;
        }
        this.setState(ProtocolConnection.State.HANDSHAKING);
        this.clientProtocolHandler = this.getClientProtocolHandler();
        this.clientProtocolHandler.setPeer(this.getPeerHost(), this.getPeerPort());
        if (this.clientPerformHandshakeRequest((byte)2)) {
            EventService.publishEvent(ProtocolConnectionCreated.class, this.getPeerHost(), this.getPeerPort(), this.sessionId);
            if (this.isSynchronous()) {
                this.synchronousClientTransferThreads.add(new Thread("Synchronous client transfer thread 1: " + this.getSessionId()){

                    public void run() {
                        EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
                        ProtocolConnection_V2.this.synchronousClientTransferThread(ProtocolConnection_V2.this.clientProtocolHandler);
                        EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
                    }
                });
                this.synchronousClientTransferThreads.get(0).start();
            }
        } else {
            this.terminate();
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort());
            return false;
        }
        this.setState(ProtocolConnection.State.TUNNELLING);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setupServer(AcceptedConnection acceptedConnection, String streamId) throws IOException {
        ProtocolConnection_V2 protocolConnection_V2 = this;
        synchronized (protocolConnection_V2) {
            if (this.factory == null) {
                this.poolService = (ResourcePoolService)BootStrap.getInstance().getService(ResourcePoolService.class);
                this.factory = new ByteBufferResourceFactory();
                this.resourcePool = this.poolService.getResourcePool("RP: " + acceptedConnection, this.factory);
                this.resourceMap = new HashMap();
                this.resourcePool.ensureCapacity(100);
            }
        }
        this.setState(ProtocolConnection.State.INITIALIZED);
        this.tunnel = new Tunnel_V2(this.getPeerHost(), this.getPeerPort());
        this.serverProtocolHandler = this.getServerProtocolHandler();
        this.serverProtocolHandler.setAcceptedConnection(acceptedConnection);
        this.setState(ProtocolConnection.State.HANDSHAKING);
        if (!this.dealWithServerRequest()) {
            this.terminate();
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort());
            return false;
        }
        this.serverTransferThread = new Thread("Server transfer thread: " + streamId){

            public void run() {
                EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
                try {
                    while (ProtocolConnection_V2.this.dealWithServerRequest()) {
                    }
                }
                catch (Throwable over) {
                    EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName(), over);
                }
                ProtocolConnection_V2.this.terminate();
                EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
            }
        };
        this.serverTransferThread.start();
        this.setState(ProtocolConnection.State.TUNNELLING);
        return true;
    }

    protected boolean clientPerformHandshakeRequest(byte version) throws IOException {
        EventService.publishEvent(ProtocolVersionNegotiation.class, version & 0xFF);
        long start = System.currentTimeMillis();
        this.clientProtocolHandler.prepareRequestHeader(8);
        this.tunnel.emitTunnelPacket(this.clientProtocolHandler, 5, new byte[]{version}, 1, this.clientSequenceGenerator);
        this.clientProtocolHandler.finishRequest();
        this.clientProtocolHandler.acceptResponseHeader();
        long finish = System.currentTimeMillis();
        this.currentRtt = this.initialRtt = finish - start;
        int request = this.clientProtocolHandler.peek();
        switch (request) {
            case 1: {
                byte[] sessionBuffer;
                TunnelPacket packet = this.tunnel.readTunnelPacket(this.clientProtocolHandler, 1);
                if (packet != null && (sessionBuffer = packet.getBuffer()) != null) {
                    this.sessionId = new String(sessionBuffer);
                    this.clientProtocolHandler.setSessionId(this.sessionId);
                    return true;
                }
                return false;
            }
            case 5: {
                TunnelPacket packet = this.tunnel.readTunnelPacket(this.clientProtocolHandler, 5);
                if (packet != null) {
                    byte[] versionBuffer = packet.getBuffer();
                    EventService.publishEvent(ProtocolVersionNegotiation.class, version & 0xFF, versionBuffer[0] & 0xFF);
                    return this.clientPerformHandshakeRequest(versionBuffer[0]);
                }
                return false;
            }
            case 3: {
                TunnelPacket packet = this.tunnel.readTunnelPacket(this.clientProtocolHandler, 3);
                if (packet != null) {
                    byte[] abortReason = packet.getBuffer();
                    EventService.publishEvent(PeerConnectException.class, new String(abortReason));
                    throw new ConnectException(new String(abortReason));
                }
                throw new ConnectException(new String("Connection lost"));
            }
        }
        return false;
    }

    protected boolean clientConnectToPeer() {
        return true;
    }

    public boolean dealWithServerRequest() throws IOException {
        boolean acceptableRequest = false;
        this.touchLastAccessTime();
        if (this.serverProtocolHandler.acceptRequestHeader()) {
            int request = this.serverProtocolHandler.peek();
            switch (request) {
                case 1: {
                    acceptableRequest = this.serverReceiveTunnelData();
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    acceptableRequest = true;
                    this.terminate();
                    break;
                }
                case 5: {
                    acceptableRequest = this.acceptNewTunnel();
                }
            }
        }
        return acceptableRequest;
    }

    private boolean acceptNewTunnel() throws IOException {
        TunnelPacket packet = this.tunnel.readTunnelPacket(this.serverProtocolHandler, 5);
        if (packet == null) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this);
            return false;
        }
        byte[] version = packet.getBuffer();
        if (version == null) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this);
            return false;
        }
        if ((version[0] & 0xFF) > 2) {
            TunnelPacketSequenceGenerator seqGen = new TunnelPacketSequenceGenerator(){

                public int getNextSequenceNumber() {
                    return 0;
                }
            };
            EventService.publishEvent(ProtocolVersionNegotiation.class, version[0] & 0xFF, (byte)2);
            this.serverProtocolHandler.prepareResponseHeader(9);
            this.tunnel.emitTunnelPacket(this.serverProtocolHandler, 5, new byte[]{2}, 1, seqGen);
            this.serverProtocolHandler.finishResponse();
            return false;
        }
        EventService.publishEvent(ProtocolVersionNegotiation.class, version[0] & 0xFF);
        ServerConnectionService pcConnectionService = (ServerConnectionService)BootStrap.getInstance().getService(ServerConnectionService.class);
        final ServerConnection pcConnection = pcConnectionService.getConnection();
        this.setState(ProtocolConnection.State.CONNECTING);
        TunnelPacketSequenceGenerator seqGen = new TunnelPacketSequenceGenerator(){

            public int getNextSequenceNumber() {
                return pcConnection.getSequenceNumber();
            }
        };
        EventService.publishEvent(StartOfConnection.class, this.getPeerHost(), this.getPeerPort());
        try {
            pcConnection.connect(this.getPeerHost(), this.getPeerPort());
        }
        catch (IOException cannotConnect) {
            String host = this.getPeerHost();
            if (host == null) {
                host = "localhost";
            }
            String rejectionReason = cannotConnect.getLocalizedMessage() + " " + host + ":" + this.getPeerPort();
            this.serverProtocolHandler.prepareResponseHeader(8 + rejectionReason.getBytes().length);
            this.tunnel.emitTunnelPacket(this.serverProtocolHandler, 3, rejectionReason.getBytes(), rejectionReason.getBytes().length, seqGen);
            EventService.publishEvent(PeerConnectException.class, cannotConnect, host, this.getPeerPort());
            this.serverProtocolHandler.finishResponse();
            return false;
        }
        this.serverProtocolHandler.prepareResponseHeader(8 + ServerConnectionService.SESSION_ID_LENGTH);
        this.tunnel.emitTunnelPacket(this.serverProtocolHandler, 1, pcConnection.getSessionId().getBytes(), ServerConnectionService.SESSION_ID_LENGTH, seqGen);
        this.serverProtocolHandler.finishResponse();
        this.setState(ProtocolConnection.State.TUNNELLING);
        return true;
    }

    private boolean serverReceiveTunnelData() throws IOException {
        byte[] session = new byte[ServerConnectionService.SESSION_ID_LENGTH];
        TunnelPacket packet = this.tunnel.readTunnelPacket(this.serverProtocolHandler, 1, session);
        this.sessionId = new String(session);
        ServerConnectionService serverConnectionService = (ServerConnectionService)BootStrap.getInstance().getService(ServerConnectionService.class);
        ServerConnection pcConnection = serverConnectionService.getConnection(this.sessionId);
        if (pcConnection == null) {
            EventService.publishEvent(InvalidHTTPSessionRequested.class, this.getPeerHost(), this.getPeerPort(), this.sessionId);
            return false;
        }
        byte[] burstBuffer = new byte[2];
        this.tunnel.readTunnelPacket(this.serverProtocolHandler, 4, burstBuffer);
        int packetsToReceive = Tunnel_V2.getValue(burstBuffer);
        this.tunnel.readTunnelPacket(this.serverProtocolHandler, 4, burstBuffer);
        int optimalPacketsToSend = Tunnel_V2.getValue(burstBuffer);
        int packetsReceived = 0;
        while (packetsReceived++ < packetsToReceive) {
            this.touchLastAccessTime();
            packet = this.tunnel.readTunnelPacketSlice(this.serverProtocolHandler, 2);
            if (packet == null) {
                return false;
            }
            pcConnection.write(packet.getByteBuffer(), packet.getSequence());
        }
        if (this.isSynchronous()) {
            try {
                this.serverTransmitTunnelReply(pcConnection, optimalPacketsToSend);
            }
            catch (Throwable e) {
                EventService.publishEvent(PrivateError.class, e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean serverTransmitTunnelReply(ServerConnection pcConnection, int burstSize) throws Throwable {
        int bytesRead = 0;
        int burstCount = 0;
        Vector<ByteBufferResource> responses = new Vector<ByteBufferResource>();
        final Vector<Integer> sequences = new Vector<Integer>();
        if (this.transferBuffer == null) {
            this.transferBuffer = ByteBuffer.allocateDirect(BUFFER_SIZE);
        }
        int actualCapacity = this.resourcePool.ensureCapacity(burstSize);
        int currentReceiveBurstSize = Math.min(burstSize, actualCapacity);
        long start = System.currentTimeMillis();
        ServerConnection serverConnection = pcConnection;
        synchronized (serverConnection) {
            sequences.add(pcConnection.getSequenceNumber());
            try {
                while (pcConnection.available() > 0 && burstCount < currentReceiveBurstSize) {
                    this.touchLastAccessTime();
                    this.transferBuffer.clear();
                    int read = pcConnection.read(this.transferBuffer);
                    if (read != -1) {
                        this.transferBuffer.flip();
                        bytesRead += this.transferBuffer.remaining();
                        ByteBufferResource resource = this.allocateByteBuffer();
                        resource.setContentLength(this.transferBuffer.remaining());
                        byte[] response = resource.getBuffer();
                        this.transferBuffer.get(response, 0, resource.getContentLength());
                        responses.add(resource);
                        sequences.add(pcConnection.getSequenceNumber());
                        ++burstCount;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                if (responses != null && responses.size() > 0) {
                    for (ByteBufferResource response : responses) {
                        this.freeByteBuffer(response.getBuffer());
                    }
                }
                throw t;
            }
            sequences.add(pcConnection.getSequenceNumber());
        }
        TunnelPacketSequenceGenerator seqGen = new TunnelPacketSequenceGenerator(){
            private int index = 0;

            public int getNextSequenceNumber() {
                return (Integer)sequences.get(this.index++);
            }
        };
        this.serverProtocolHandler.prepareResponseHeader(22 + 8 * responses.size() + bytesRead);
        this.tunnel.emitBurstPacket(this.serverProtocolHandler, responses.size(), seqGen);
        long end = System.currentTimeMillis();
        int duration = (int)(end - start);
        EventService.publishEvent(DebugInfoEvent.class, "Server sent burst", responses.size(), burstSize, bytesRead);
        for (ByteBufferResource response : responses) {
            this.touchLastAccessTime();
            this.tunnel.emitTunnelPacket(this.serverProtocolHandler, 2, response.getBuffer(), response.getContentLength(), seqGen);
            this.freeByteBuffer(response.getBuffer());
        }
        this.tunnel.emitTunnelPacket(this.serverProtocolHandler, 6, Tunnel_V2.makeQuadByteArray(duration), 4, seqGen);
        this.serverProtocolHandler.finishResponse();
        return true;
    }

    public int decodeProtocolStream(byte[] buffer) throws IOException {
        this.touchLastAccessTime();
        this.decoderBlockedThread = Thread.currentThread();
        if (this.currentReceivePacket == null) {
            if (this.isSynchronous()) {
                try {
                    while (this.currentReceivePacket == null && this.getState() != ProtocolConnection.State.CLOSED) {
                        if (this.synchronousClientException != null) {
                            throw this.synchronousClientException;
                        }
                        this.currentReceivePacket = this.clientReceiveQueue.poll(500L);
                        if (this.currentReceivePacket != null && this.currentReceivePacket.getType() != 2) {
                            this.currentReceivePacket = null;
                        }
                        this.holdingPosition = 0;
                    }
                }
                catch (InterruptedException breakout) {
                    throw new IOException("Interrupted read");
                }
                if (this.getState() == ProtocolConnection.State.CLOSED) {
                    throw new ClosedChannelException();
                }
            } else {
                this.decoderBlockedThread = Thread.currentThread();
                this.clientProtocolHandler.acceptResponseHeader();
                this.currentReceivePacket = this.tunnel.readTunnelPacket(this.clientProtocolHandler, 4);
                byte[] burstBuffer = this.currentReceivePacket.getBuffer();
                Vector<byte[]> responses = new Vector<byte[]>();
                if (burstBuffer != null) {
                    int burstCount = Tunnel_V2.getValue(burstBuffer);
                    int currentCount = 0;
                    int totalBytes = 0;
                    while (currentCount++ < burstCount) {
                        this.currentReceivePacket = this.tunnel.readTunnelPacket(this.clientProtocolHandler, 2);
                        byte[] response = this.currentReceivePacket.getBuffer();
                        responses.add(response);
                        totalBytes += response.length;
                    }
                    int currentPosition = 0;
                    byte[] holding = new byte[totalBytes];
                    for (byte[] response : responses) {
                        System.arraycopy(response, 0, holding, currentPosition, response.length);
                        currentPosition += response.length;
                    }
                    this.holdingPosition = 0;
                    this.currentReceivePacket.setBuffer(holding);
                }
            }
        }
        this.decoderBlockedThread = null;
        int bytesToCopy = Math.min(this.currentReceivePacket.getSize() - this.holdingPosition, buffer.length);
        System.arraycopy(this.currentReceivePacket.getBuffer(), this.holdingPosition, buffer, 0, bytesToCopy);
        this.holdingPosition += bytesToCopy;
        if (this.holdingPosition >= this.currentReceivePacket.getSize()) {
            this.holdingPosition = 0;
            this.freeByteBuffer(this.currentReceivePacket.getBuffer());
            this.currentReceivePacket = null;
        }
        return bytesToCopy;
    }

    public int encodeProtocolStream(byte[] buffer, int numberOfBytesToWrite) throws IOException {
        this.touchLastAccessTime();
        if (this.isSynchronous()) {
            int chunk;
            int requiredCapacity = this.optimalSendBurst * this.currentNumberOfTransferThreads;
            this.resourcePool.ensureCapacity(requiredCapacity + 24);
            for (int total = 0; total < numberOfBytesToWrite; total += chunk) {
                chunk = Math.min(numberOfBytesToWrite - total, BUFFER_SIZE);
                try {
                    ByteBufferResource resource = this.allocateByteBuffer();
                    System.arraycopy(buffer, total, resource.getBuffer(), 0, chunk);
                    resource.setContentLength(chunk);
                    this.clientTransmitQueue.put(resource);
                    continue;
                }
                catch (InterruptedException discard) {
                    return -1;
                }
            }
        } else {
            this.clientProtocolHandler.prepareRequestHeader(numberOfBytesToWrite + 17);
            this.tunnel.emitTunnelPacket(this.clientProtocolHandler, 1, this.sessionId.getBytes(), ServerConnectionService.SESSION_ID_LENGTH, this.clientSequenceGenerator);
            if (buffer == null) {
                this.tunnel.emitBurstPacket(this.serverProtocolHandler, 0, this.clientSequenceGenerator);
            } else {
                this.tunnel.emitBurstPacket(this.serverProtocolHandler, 1, this.clientSequenceGenerator);
                this.tunnel.emitTunnelPacket(this.clientProtocolHandler, 2, buffer, numberOfBytesToWrite, this.clientSequenceGenerator);
            }
        }
        return numberOfBytesToWrite;
    }

    protected void synchronousClientTransferThread(ClientProtocolHandler handler) {
        try {
            int waitInterval = 100;
            Vector<ByteBufferResource> packetsToSend = new Vector<ByteBufferResource>();
            while (this.getState() != ProtocolConnection.State.CLOSED && !Thread.currentThread().isInterrupted()) {
                int packetReceivedCounter;
                int totalBytesToSend = 0;
                int totalBytesReceived = 0;
                this.touchLastAccessTime();
                int requiredCapacity = this.optimalSendBurst * this.currentNumberOfTransferThreads;
                int actualCapacity = this.resourcePool.ensureCapacity(requiredCapacity);
                int currentSendBurst = Math.min(this.optimalSendBurst, actualCapacity / this.currentNumberOfTransferThreads);
                ByteBufferResource request = null;
                try {
                    request = this.clientTransmitQueue.poll(waitInterval, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException discard) {
                    continue;
                }
                if (request != null) {
                    long startOfPoll = System.currentTimeMillis();
                    packetsToSend.add(request);
                    totalBytesToSend += request.getContentLength();
                    while (packetsToSend.size() < currentSendBurst && System.currentTimeMillis() - startOfPoll < 4000L) {
                        this.touchLastAccessTime();
                        request = this.clientTransmitQueue.poll(500L, TimeUnit.MILLISECONDS);
                        if (request == null) break;
                        packetsToSend.add(request);
                        totalBytesToSend += request.getContentLength();
                    }
                }
                int toSend = packetsToSend.size();
                int requestOverhead = 28 + ServerConnectionService.SESSION_ID_LENGTH + 8 * packetsToSend.size();
                requiredCapacity = this.optimalReceiveBurst * this.currentNumberOfTransferThreads;
                this.resourcePool.ensureCapacity(requiredCapacity + 24);
                actualCapacity = this.resourcePool.getFreeCount() - 24;
                if (actualCapacity < 1) {
                    actualCapacity = 1;
                }
                int currentReceiveBurst = Math.min(this.optimalReceiveBurst, actualCapacity / this.currentNumberOfTransferThreads);
                handler.prepareRequestHeader(requestOverhead + totalBytesToSend);
                this.tunnel.emitTunnelPacket(handler, 1, this.sessionId.getBytes(), ServerConnectionService.SESSION_ID_LENGTH, this.clientSequenceGenerator);
                this.tunnel.emitBurstPacket(handler, packetsToSend.size(), this.clientSequenceGenerator);
                this.tunnel.emitBurstPacket(handler, currentReceiveBurst, this.clientSequenceGenerator);
                for (ByteBufferResource packetToSend : packetsToSend) {
                    this.touchLastAccessTime();
                    this.tunnel.emitTunnelPacket(handler, 2, packetToSend.getBuffer(), packetToSend.getContentLength(), this.clientSequenceGenerator);
                    this.freeByteBuffer(packetToSend.getBuffer());
                }
                this.decoderBlockedThread = Thread.currentThread();
                long start = System.currentTimeMillis();
                handler.finishRequest();
                handler.acceptResponseHeader();
                long end = System.currentTimeMillis();
                long duration = end - start;
                this.touchLastAccessTime();
                this.decoderBlockedThread = null;
                TunnelPacket packet = this.tunnel.readTunnelPacket(handler, 4);
                this.clientReceiveQueue.put(packet);
                int numberOfPacketsToReceive = Tunnel_V2.getValue(packet.getBuffer());
                for (packetReceivedCounter = 0; packetReceivedCounter < numberOfPacketsToReceive; ++packetReceivedCounter) {
                    this.touchLastAccessTime();
                    ByteBufferResource resource = this.allocateByteBuffer();
                    packet = this.tunnel.readTunnelPacket(handler, 2, resource.getBuffer());
                    this.clientReceiveQueue.put(packet);
                    totalBytesReceived += packet.getSize();
                }
                packet = this.tunnel.readTunnelPacket(handler, 6);
                this.clientReceiveQueue.put(packet);
                int serverReadDuration = Tunnel_V2.getValue(packet.getBuffer());
                int responseOverhead = 10 + 8 * numberOfPacketsToReceive;
                int totalOverhead = requestOverhead + responseOverhead;
                int totalData = totalBytesToSend + totalBytesReceived;
                if (toSend == 0 && numberOfPacketsToReceive == 0) {
                    long rtt = duration - (long)serverReadDuration;
                    if (rtt < 1L) {
                        rtt = 1L;
                    }
                    this.currentRtt += rtt;
                    this.currentRtt /= 2L;
                    if (this.currentRtt > 0L) {
                        this.linkspeed += (long)totalOverhead * 1000L / this.currentRtt;
                        this.linkspeed /= 2L;
                    }
                }
                if (this.currentRtt > 0L) {
                    this.dataspeed += (long)totalData * 1000L / this.currentRtt;
                    this.dataspeed /= 2L;
                }
                EventService.publishEvent(DataTransmissionRateInfo.class, "Session Id", this.sessionId, "Send burst", packetsToSend.size(), "Optimal send", currentSendBurst, "Total bytes sent", totalBytesToSend, "Receive burst", packetReceivedCounter, "Optimal receive", currentReceiveBurst, "Total bytes received", totalBytesReceived, "Duration", duration, "Current RTT", this.currentRtt, "Link speed", this.dataspeed, "Threads ", this.currentNumberOfTransferThreads);
                if (duration < 4000L && packetsToSend.size() >= this.optimalSendBurst) {
                    this.optimalSendBurst += 5;
                    if (duration < 1000L) {
                        this.optimalSendBurst += 20;
                    }
                    if (this.optimalSendBurst > 8192) {
                        this.optimalSendBurst = 8192;
                    }
                }
                if (duration > 5500L && this.optimalSendBurst > 1) {
                    this.optimalSendBurst -= 10;
                    if (duration > 8000L) {
                        this.optimalSendBurst -= 100;
                    }
                    if (this.optimalSendBurst <= 0) {
                        this.optimalSendBurst = 1;
                    }
                }
                if (numberOfPacketsToReceive > 0) {
                    waitInterval = 0;
                    if (duration < 2000L && numberOfPacketsToReceive >= this.optimalReceiveBurst) {
                        this.optimalReceiveBurst += 5;
                        if (duration < 1000L) {
                            this.optimalReceiveBurst += 20;
                            if (duration < 500L) {
                                this.optimalReceiveBurst += 100;
                            }
                        }
                        if (this.optimalReceiveBurst > 8192) {
                            this.optimalReceiveBurst = 8192;
                        }
                    }
                    if (duration > 5500L && this.optimalReceiveBurst > 1) {
                        this.optimalReceiveBurst -= 10;
                        if (duration > 8000L) {
                            this.optimalReceiveBurst -= 100;
                        }
                        if (this.optimalReceiveBurst <= 0) {
                            this.optimalReceiveBurst = 1;
                        }
                    }
                } else if (waitInterval < 2000) {
                    waitInterval += 100;
                }
                if (numberOfPacketsToReceive > 10 && duration < (long)(15000 / this.currentNumberOfTransferThreads) && (long)this.currentNumberOfTransferThreads <= this.currentRtt / 50L) {
                    this.optimalReceiveBurst /= 2;
                    final ClientProtocolHandler subsequentClient = this.getClientProtocolHandler();
                    subsequentClient.setPeer(this.getPeerHost(), this.getPeerPort());
                    subsequentClient.setSessionId(this.sessionId);
                    EventService.publishEvent(ProtocolConnectionCreated.class, this.getPeerHost(), this.getPeerPort(), this.sessionId);
                    Thread more = new Thread("Synchronous client transfer thread " + ++this.currentNumberOfTransferThreads + ": " + this.getSessionId()){

                        public void run() {
                            EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
                            ProtocolConnection_V2.this.synchronousClientTransferThread(subsequentClient);
                            EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
                        }
                    };
                    more.setDaemon(true);
                    this.synchronousClientTransferThreads.add(more);
                    more.start();
                }
                packetsToSend.clear();
            }
        }
        catch (InterruptedException t) {
            this.terminate();
        }
        catch (IOException t) {
            this.synchronousClientException = t;
        }
        catch (Throwable t) {
            EventService.publishEvent(DebugInfoEvent.class, Thread.currentThread().getName(), "terminating cause", t);
            this.terminate();
        }
    }

    public void terminate() {
        this.setState(ProtocolConnection.State.CLOSED);
        this.propertyChangeListeners.clear();
    }

    public ProtocolConnection.State getState() {
        return this.state;
    }

    protected void setState(ProtocolConnection.State newState) {
        if (newState != this.state && this.state != ProtocolConnection.State.CLOSED) {
            ProtocolConnection.State oldState = this.state;
            this.state = newState;
            this.touchLastAccessTime();
            switch (this.state) {
                case CLOSED: {
                    Thread blocker;
                    EventService.publishEvent(ProtocolConnectionTermination.class, new Object[0]);
                    if (this.isSynchronous() && this.synchronousClientTransferThreads != null) {
                        for (Thread thread : this.synchronousClientTransferThreads) {
                            thread.interrupt();
                        }
                        this.synchronousClientTransferThreads.clear();
                    }
                    if ((blocker = this.decoderBlockedThread) != null) {
                        blocker.interrupt();
                    }
                    if (this.poolService != null) {
                        this.poolService.releaseResourcePool(this.resourcePool);
                    }
                    if (this.serverProtocolHandler == null) break;
                    this.serverProtocolHandler.close();
                    break;
                }
                case CONNECTING: {
                    break;
                }
                case HANDSHAKING: {
                    break;
                }
                case INITIALIZED: {
                    break;
                }
            }
            EventService.publishEvent(ProtocolStateChanged.class, new Object[]{this, oldState, newState});
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "state", (Object)oldState, (Object)newState);
            this.propertyChanged(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(evt);
        }
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    protected void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public void setPeerHost(String peerHost) {
        this.peerHost = peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    public long getTotalBytesSent() {
        long bytes = 0L;
        return bytes;
    }

    public long getCurrentTransferRate() {
        long rate = 0L;
        return rate;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    protected void touchLastAccessTime() {
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " connection to " + (this.peerHost == null ? "local pc" : this.peerHost) + ":" + this.peerPort;
    }

    protected boolean isSynchronous() {
        return false;
    }

    protected abstract ClientProtocolHandler getClientProtocolHandler();

    protected abstract ServerProtocolHandler getServerProtocolHandler();

    public InetAddress getLocalInetAddress() {
        if (this.clientProtocolHandler != null) {
            return this.clientProtocolHandler.getLocalInetAddress();
        }
        return null;
    }

    protected class ByteBufferResourceFactory
    implements ResourceFactory {
        protected ByteBufferResourceFactory() {
        }

        public Resource makeResource() {
            byte[] buffer = new byte[BUFFER_SIZE];
            ByteBufferResource resource = new ByteBufferResource();
            resource.setBuffer(buffer);
            return resource;
        }
    }

    protected class ByteBufferResource
    extends Resource {
        private byte[] buffer;
        private int contentLength;

        protected ByteBufferResource() {
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public void setBuffer(byte[] buffer) {
            this.buffer = buffer;
        }

        public void setContentLength(int contentLength) {
            this.contentLength = contentLength;
        }

        public int getContentLength() {
            return this.contentLength;
        }
    }
}

