/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DataTransmission;
import com.signiant.jsf.services.event.events.EndOfProtocolInputStream;
import com.signiant.jsf.services.event.events.IOExceptionEvent;
import com.signiant.jsf.services.event.events.InactivityTimeoutExpired;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.event.events.ProtocolStateChanged;
import com.signiant.jsf.services.event.events.ThreadFinished;
import com.signiant.jsf.services.event.events.ThreadStarted;
import com.signiant.jsf.services.event.events.UnexpectedPacketLengthReceived;
import com.signiant.jsf.services.protocoltunnel.AcceptedConnection;
import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class ProtocolConnection_V1
implements ProtocolConnection {
    private static int BUFFER_SIZE = 65535;
    private List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private Thread readerThread;
    private Thread writerThread;
    private String peerHost;
    private int peerPort;
    private InstrumentedInputStream encodedInput;
    private InstrumentedOutputStream encodedOutput;
    private InstrumentedInputStream rawInput;
    private InstrumentedOutputStream rawOutput;
    private ProtocolConnection.State state;
    private boolean client;
    private long lastAccessTime;
    private Thread accessMonitor;
    private long maximumInactivityTimeout = 65000L;

    public boolean setupClient() {
        this.setState(ProtocolConnection.State.INITIALIZED);
        if (this.encodedInput == null && this.encodedOutput == null) {
            this.setState(ProtocolConnection.State.CONNECTING);
            if (!this.connectToPeer()) {
                return false;
            }
        }
        this.setState(ProtocolConnection.State.HANDSHAKING);
        this.performHandshakeRequest();
        this.setState(ProtocolConnection.State.TUNNELLING);
        return true;
    }

    public boolean setupServer(AcceptedConnection acceptedConnection, String streamId) {
        return this.setupServer(acceptedConnection.getInputStream(), acceptedConnection.getOutputStream(), streamId);
    }

    protected boolean setupServer(InputStream input, OutputStream output, String streamId) {
        this.setState(ProtocolConnection.State.INITIALIZED);
        this.encodedInput = new InstrumentedInputStream(input, StreamType.WRAPPED, this, streamId);
        this.encodedOutput = new InstrumentedOutputStream(output, StreamType.WRAPPED, this, streamId);
        if (this.rawInput == null && this.rawOutput == null) {
            this.setState(ProtocolConnection.State.CONNECTING);
            if (!this.connectToPeer()) {
                return false;
            }
        }
        this.setState(ProtocolConnection.State.HANDSHAKING);
        this.performHandshakeResponse();
        this.setState(ProtocolConnection.State.TUNNELLING);
        this.startTransferThreads();
        return true;
    }

    public void startTransferThreads() {
        this.readerThread = new Thread("Encoder " + this.peerHost + ":" + this.peerPort + " " + this.encodedOutput){

            public void run() {
                EventService.publishEvent(ThreadStarted.class, this, Thread.currentThread().getName());
                try {
                    ProtocolConnection_V1.this.encoder();
                    EventService.publishEvent(ThreadFinished.class, this, Thread.currentThread().getName());
                }
                catch (Throwable t) {
                    EventService.publishEvent(PrivateError.class, this, Thread.currentThread().getName(), t.getStackTrace()[0]);
                }
            }
        };
        this.writerThread = new Thread("Decoder " + this.peerHost + ":" + this.peerPort + " " + this.encodedInput){

            public void run() {
                EventService.publishEvent(ThreadStarted.class, this, Thread.currentThread().getName());
                try {
                    ProtocolConnection_V1.this.decoder();
                    EventService.publishEvent(ThreadFinished.class, this, Thread.currentThread().getName());
                }
                catch (Throwable t) {
                    EventService.publishEvent(PrivateError.class, this, Thread.currentThread().getName(), t);
                }
            }
        };
        this.readerThread.start();
        this.writerThread.start();
    }

    protected boolean performHandshakeRequest() {
        return true;
    }

    protected boolean performHandshakeResponse() {
        return true;
    }

    protected void encoder() {
        if (this.rawInput == null) {
            return;
        }
        byte[] buffer = new byte[BUFFER_SIZE];
        int bytesRead = 0;
        while (this.state == ProtocolConnection.State.TUNNELLING) {
            try {
                bytesRead = this.rawInput.read(buffer);
            }
            catch (IOException e) {
                if (this.state == ProtocolConnection.State.CLOSED) break;
                this.terminate();
                EventService.publishEvent(IOExceptionEvent.class, e, this.rawInput);
                break;
            }
            if (bytesRead > 0) {
                try {
                    this.encodeProtocolStream(buffer, bytesRead);
                    continue;
                }
                catch (IOException e) {
                    if (this.state == ProtocolConnection.State.CLOSED) break;
                    this.terminate();
                    EventService.publishEvent(IOExceptionEvent.class, e, this.encodedOutput);
                    break;
                }
            }
            this.terminate();
            EventService.publishEvent(EndOfProtocolInputStream.class, new Object[0]);
            break;
        }
    }

    protected void decoder() {
        byte[] buffer = new byte[BUFFER_SIZE];
        int bytesRead = 0;
        while (this.state == ProtocolConnection.State.TUNNELLING) {
            try {
                bytesRead = this.decodeProtocolStream(buffer);
            }
            catch (IOException e) {
                if (this.state == ProtocolConnection.State.CLOSED) break;
                this.terminate();
                EventService.publishEvent(IOExceptionEvent.class, e, this.encodedInput);
                break;
            }
            if (bytesRead > 0) {
                try {
                    this.rawOutput.write(buffer, 0, bytesRead);
                    this.rawOutput.flush();
                    continue;
                }
                catch (IOException e) {
                    if (this.state == ProtocolConnection.State.CLOSED) break;
                    this.terminate();
                    EventService.publishEvent(IOExceptionEvent.class, e, this.rawOutput);
                    break;
                }
            }
            if (bytesRead >= 0) continue;
            this.terminate();
            EventService.publishEvent(EndOfProtocolInputStream.class, this, this.encodedInput);
            break;
        }
    }

    private void monitor() {
        try {
            while (this.state != ProtocolConnection.State.CLOSED) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException discard) {
                    break;
                }
                if (System.currentTimeMillis() - this.lastAccessTime <= this.maximumInactivityTimeout) continue;
                EventService.publishEvent(InactivityTimeoutExpired.class, System.currentTimeMillis(), this, this.lastAccessTime, this.maximumInactivityTimeout);
                this.terminate();
            }
        }
        catch (Throwable t) {
            EventService.publishEvent(PrivateError.class, this, t);
        }
    }

    public int decodeProtocolStream(byte[] buffer) throws IOException {
        this.lastAccessTime = System.currentTimeMillis();
        return this.decodeProtocolStreamImpl(buffer);
    }

    public int encodeProtocolStream(byte[] buffer, int numberOfBytesToWrite) throws IOException {
        this.lastAccessTime = System.currentTimeMillis();
        return this.encodeProtocolStreamImpl(buffer, numberOfBytesToWrite);
    }

    public void terminate() {
        this.setState(ProtocolConnection.State.CLOSED);
        if (this.readerThread != null && this.readerThread.isAlive()) {
            this.readerThread.interrupt();
        }
        if (this.writerThread != null && this.writerThread.isAlive()) {
            this.writerThread.interrupt();
        }
        if (this.encodedInput != null) {
            this.encodedInput.interrupt();
            try {
                this.encodedInput.close();
            }
            catch (Throwable discard) {
                // empty catch block
            }
        }
        if (this.encodedOutput != null) {
            this.encodedOutput.interrupt();
            try {
                this.encodedOutput.close();
            }
            catch (Throwable discard) {
                // empty catch block
            }
        }
        if (this.rawInput != null) {
            this.rawInput.interrupt();
            try {
                this.rawInput.close();
            }
            catch (Throwable discard) {
                // empty catch block
            }
        }
        if (this.rawOutput != null) {
            this.rawOutput.interrupt();
            try {
                this.rawOutput.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.propertyChangeListeners.clear();
    }

    public ProtocolConnection.State getState() {
        return this.state;
    }

    protected void setState(ProtocolConnection.State newState) {
        if (newState != this.state && this.state != ProtocolConnection.State.CLOSED) {
            ProtocolConnection.State oldState = this.state;
            this.state = newState;
            switch (this.state) {
                case CLOSED: {
                    this.accessMonitor.interrupt();
                    break;
                }
                case CONNECTING: {
                    break;
                }
                case HANDSHAKING: {
                    break;
                }
                case INITIALIZED: {
                    this.lastAccessTime = System.currentTimeMillis();
                    this.accessMonitor = new Thread("Inactivity timer for " + this){

                        public void run() {
                            ProtocolConnection_V1.this.monitor();
                        }
                    };
                    this.accessMonitor.start();
                    break;
                }
            }
            EventService.publishEvent(ProtocolStateChanged.class, new Object[]{this, oldState, newState});
            PropertyChangeEvent evt = new PropertyChangeEvent(this, "state", (Object)oldState, (Object)newState);
            this.propertyChanged(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    protected void propertyChanged(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(evt);
        }
    }

    public boolean isClient() {
        return this.client;
    }

    public void setClient(boolean client) {
        this.client = client;
    }

    public long getMaximumInactivityTimeout() {
        return this.maximumInactivityTimeout;
    }

    public void setMaximumInactivityTimeout(long maximumInactivityTimeout) {
        this.maximumInactivityTimeout = maximumInactivityTimeout;
    }

    public String getPeerHost() {
        return this.peerHost;
    }

    public void setPeerHost(String peerHost) {
        this.peerHost = peerHost;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public void setPeerPort(int peerPort) {
        this.peerPort = peerPort;
    }

    protected InputStream getRawInputStream() {
        return this.rawInput;
    }

    protected OutputStream getRawOutputStream() {
        return this.rawOutput;
    }

    public void setRawInputStream(InputStream rawInput, String streamId) {
        this.rawInput = new InstrumentedInputStream(rawInput, StreamType.RAW, this, streamId);
    }

    public void setRawOutputStream(OutputStream rawOutput, String streamId) {
        this.rawOutput = new InstrumentedOutputStream(rawOutput, StreamType.RAW, this, streamId);
    }

    protected InputStream getEncodedInputStream() {
        return this.encodedInput;
    }

    protected void setEncodedInputStream(InstrumentedInputStream input) {
        this.encodedInput = input;
    }

    public void setEncodedInputStream(InputStream input, String streamId) {
        this.encodedInput = new InstrumentedInputStream(input, StreamType.WRAPPED, this, streamId);
    }

    protected OutputStream getEncodedOutputStream() {
        return this.encodedOutput;
    }

    public void setEncodedOutputStream(InstrumentedOutputStream output) {
        this.encodedOutput = output;
    }

    public void setEncodedOutputStream(OutputStream output, String streamId) {
        this.encodedOutput = new InstrumentedOutputStream(output, StreamType.WRAPPED, this, streamId);
    }

    public long getTotalBytesSent() {
        long bytes = 0L;
        if (this.rawInput != null) {
            bytes += this.rawInput.getBytesTransferred();
        }
        if (this.rawOutput != null) {
            bytes += this.rawOutput.getBytesTransferred();
        }
        return bytes;
    }

    public long getCurrentTransferRate() {
        long rate = 0L;
        if (this.rawInput != null) {
            rate += this.rawInput.getBytesPerSecond();
        }
        if (this.rawOutput != null) {
            rate += this.rawOutput.getBytesPerSecond();
        }
        return rate;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " connection to " + (this.peerHost == null ? "local pc" : this.peerHost) + ":" + this.peerPort;
    }

    protected String readLineFromEncodedInputStream() throws IOException {
        return this.encodedInput.readLine();
    }

    protected abstract int decodeProtocolStreamImpl(byte[] var1) throws IOException;

    protected abstract int encodeProtocolStreamImpl(byte[] var1, int var2) throws IOException;

    protected abstract boolean connectToPeer();

    protected class InstrumentedInputStream
    extends InputStream {
        private ProtocolConnection_V1 owner;
        private StreamType type;
        private InputStream input;
        private long bytesTransferred;
        private String id;
        private long startedTime;
        private Thread reader;
        private boolean interrupted;

        InstrumentedInputStream() {
        }

        InstrumentedInputStream(InputStream input, StreamType type, ProtocolConnection_V1 owner) {
            this(input, type, owner, null);
        }

        InstrumentedInputStream(InputStream input, StreamType type, ProtocolConnection_V1 owner, String id) {
            this.input = input;
            this.bytesTransferred = 0L;
            this.startedTime = System.currentTimeMillis();
            this.type = type;
            this.owner = owner;
            this.id = id;
            this.interrupted = false;
        }

        public long getBytesPerSecond() {
            return this.bytesTransferred / ((System.currentTimeMillis() - this.startedTime) / 1000L);
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            InstrumentedInputStream instrumentedInputStream = this;
            synchronized (instrumentedInputStream) {
                if (this.interrupted) {
                    return -1;
                }
                this.reader = Thread.currentThread();
            }
            int c = this._read();
            this.reader = null;
            ++this.bytesTransferred;
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, c});
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String readLine() throws IOException {
            byte[] buffer = new byte[4096];
            String line = null;
            int index = 0;
            boolean first = true;
            block7: while (index < buffer.length) {
                InstrumentedInputStream instrumentedInputStream = this;
                synchronized (instrumentedInputStream) {
                    if (this.interrupted) {
                        return null;
                    }
                    this.reader = Thread.currentThread();
                }
                int byteRead = this._read();
                this.reader = null;
                switch (byteRead) {
                    case -1: {
                        if (index == 0) {
                            return null;
                        }
                        line = new String(buffer, 0, index).trim();
                        this.bytesTransferred += (long)index;
                        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, line});
                        return line;
                    }
                    case 10: {
                        if (index == 0 && first) {
                            first = false;
                            continue block7;
                        }
                        line = new String(buffer, 0, index).trim();
                        this.bytesTransferred += (long)index;
                        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, line});
                        return line;
                    }
                }
                buffer[index++] = (byte)byteRead;
            }
            EventService.publishEvent(UnexpectedPacketLengthReceived.class, this, 4096, buffer);
            return new String(buffer);
        }

        public int available() throws IOException {
            return this.input.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            InstrumentedInputStream instrumentedInputStream = this;
            synchronized (instrumentedInputStream) {
                this.reader = Thread.currentThread();
            }
            this.input.close();
            this.reader = null;
        }

        public synchronized void mark(int readlimit) {
            this.input.mark(readlimit);
        }

        public boolean markSupported() {
            return this.input.markSupported();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            InstrumentedInputStream instrumentedInputStream = this;
            synchronized (instrumentedInputStream) {
                if (this.interrupted) {
                    return -1;
                }
                this.reader = Thread.currentThread();
            }
            int count = this._read(b, off, len);
            this.reader = null;
            if (count >= 0) {
                this.bytesTransferred += (long)count;
                EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, count, this.bytesTransferred, b, off, len});
            } else {
                EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, count, this.bytesTransferred});
            }
            return count;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized void reset() throws IOException {
            this.input.reset();
        }

        public long skip(long n) throws IOException {
            return this.input.skip(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            Thread blocker = null;
            InstrumentedInputStream instrumentedInputStream = this;
            synchronized (instrumentedInputStream) {
                this.interrupted = true;
                blocker = this.reader;
            }
            if (blocker != null) {
                blocker.interrupt();
            }
        }

        public boolean isInterrupted() {
            return this.interrupted;
        }

        protected int _read() throws IOException {
            while (this.available() == 0 && !this.isInterrupted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.isInterrupted()) {
                return -1;
            }
            return this.input.read();
        }

        protected int _read(byte[] b, int off, int len) throws IOException {
            int available = 0;
            while ((available = this.input.available()) == 0 && !this.isInterrupted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException discard) {}
            }
            if (this.isInterrupted()) {
                return -1;
            }
            return this.input.read(b, off, Math.min(available, len));
        }

        public String toString() {
            return (Object)((Object)this.type) + " input stream " + this.input + " " + this.owner + (this.id == null ? "" : " " + this.id);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum StreamType {
        RAW{

            public String toString() {
                return "Plain";
            }
        }
        ,
        WRAPPED{

            public String toString() {
                return "Wrapped";
            }
        };

    }

    protected class InstrumentedOutputStream
    extends OutputStream {
        private ProtocolConnection_V1 owner;
        private StreamType type;
        private OutputStream output;
        private long bytesTransferred;
        private String id;
        private long startedTime;
        private Thread writer;
        private boolean interrupted;

        InstrumentedOutputStream(OutputStream output, StreamType type, ProtocolConnection_V1 owner) {
            this(output, type, owner, null);
        }

        InstrumentedOutputStream(OutputStream output, StreamType type, ProtocolConnection_V1 owner, String id) {
            this.output = output;
            this.bytesTransferred = 0L;
            this.startedTime = System.currentTimeMillis();
            this.type = type;
            this.owner = owner;
            this.id = id;
            this.interrupted = false;
        }

        public void setId(String id) {
            this.id = id;
        }

        public long getBytesTransferred() {
            return this.bytesTransferred;
        }

        public long getBytesPerSecond() {
            return this.bytesTransferred / ((System.currentTimeMillis() - this.startedTime) / 1000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int arg0) throws IOException {
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                if (this.interrupted) {
                    return;
                }
                this.writer = Thread.currentThread();
            }
            this.output.write(arg0);
            this.writer = null;
            ++this.bytesTransferred;
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, 1, this.bytesTransferred, arg0});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                this.writer = Thread.currentThread();
            }
            this.output.close();
            this.writer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush() throws IOException {
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                if (this.interrupted) {
                    return;
                }
                this.writer = Thread.currentThread();
            }
            this.output.flush();
            this.writer = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] arg0, int arg1, int arg2) throws IOException {
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                if (this.interrupted) {
                    return;
                }
                this.writer = Thread.currentThread();
            }
            this.output.write(arg0, arg1, arg2);
            this.writer = null;
            this.bytesTransferred += (long)(arg2 - arg1);
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, arg2 - arg1, this.bytesTransferred, arg0, arg1, arg2});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] arg0) throws IOException {
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                if (this.interrupted) {
                    return;
                }
                this.writer = Thread.currentThread();
            }
            this.output.write(arg0);
            this.writer = null;
            this.bytesTransferred += (long)arg0.length;
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, arg0.length, this.bytesTransferred, arg0, 0, arg0.length});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void interrupt() {
            Thread blocker = null;
            InstrumentedOutputStream instrumentedOutputStream = this;
            synchronized (instrumentedOutputStream) {
                this.interrupted = true;
                blocker = this.writer;
            }
            if (blocker != null) {
                blocker.interrupt();
            }
        }

        public String toString() {
            return (Object)((Object)this.type) + " output stream " + this.output.hashCode() + " " + this.owner + (this.id == null ? "" : " " + this.id);
        }
    }
}

