/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.ClientProtocolVersionQuery;
import com.signiant.jsf.services.event.events.DebugInfoEvent;
import com.signiant.jsf.services.protocoltunnel.AcceptedConnection;
import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProtocolConnectionBaseImpl
implements ProtocolConnection {
    private ProtocolConnection impl;
    private List<String> protocolConnectionImplementations;
    static Map<String, String> supportedClasses = new HashMap<String, String>();
    private List<PropertyChangeListener> propertyChangeListeners;
    private String host;
    private int port;
    private boolean isClient;

    public ProtocolConnectionBaseImpl(String protocol) throws IOException {
        protocol = protocol.substring(0, 1).toUpperCase() + protocol.substring(1).toLowerCase();
        String protocolConnectionClass = protocol + "ProtocolConnection";
        this.protocolConnectionImplementations = new LinkedList<String>();
        for (String candidate : supportedClasses.keySet()) {
            if (!candidate.startsWith(protocolConnectionClass)) continue;
            this.protocolConnectionImplementations.add(candidate);
        }
        Collections.sort(this.protocolConnectionImplementations, String.CASE_INSENSITIVE_ORDER);
        Collections.reverse(this.protocolConnectionImplementations);
        this.propertyChangeListeners = new LinkedList<PropertyChangeListener>();
    }

    public void setPeerHost(String host) {
        this.host = host;
    }

    public void setPeerPort(int port) {
        this.port = port;
    }

    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    private ProtocolConnection getProtocolConnectionInstance(String className) throws Exception {
        ProtocolConnection connection = null;
        if (className != null) {
            Class.forName(className);
            Class<?> protocolImpl = Class.forName(className);
            connection = (ProtocolConnection)protocolImpl.newInstance();
            connection.setPeerHost(this.host);
            connection.setPeerPort(this.port);
            connection.setClient(this.isClient);
            for (PropertyChangeListener listener : this.propertyChangeListeners) {
                connection.addPropertyChangeListener(listener);
            }
        }
        return connection;
    }

    public boolean setupClient() throws IOException {
        IOException lastException = null;
        for (String candidate : this.protocolConnectionImplementations) {
            String className = supportedClasses.get(candidate);
            try {
                this.impl = this.getProtocolConnectionInstance(className);
            }
            catch (Exception classInstantiationException) {
                lastException = new IOException(classInstantiationException.toString());
                continue;
            }
            EventService.publishEvent(ClientProtocolVersionQuery.class, className);
            try {
                if (this.impl.setupClient()) {
                    return true;
                }
                EventService.publishEvent(ClientProtocolVersionQuery.class, className, false);
            }
            catch (IOException t) {
                this.impl.terminate();
                lastException = t;
                EventService.publishEvent(ClientProtocolVersionQuery.class, className, false, t);
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        return false;
    }

    public boolean setupServer(AcceptedConnection acceptedConnection, String streamId) throws IOException {
        IOException lastException = null;
        for (String candidate : this.protocolConnectionImplementations) {
            String className = supportedClasses.get(candidate);
            try {
                this.impl = this.getProtocolConnectionInstance(className);
            }
            catch (Exception classInstantiationException) {
                lastException = new IOException(classInstantiationException.toString());
                continue;
            }
            byte[] header = new byte[64];
            ByteBuffer peekahead = acceptedConnection.peek(64);
            if (peekahead == null) {
                return false;
            }
            peekahead.get(header);
            ByteArrayInputStream bis = new ByteArrayInputStream(header);
            EventService.publishEvent(DebugInfoEvent.class, "Asking for supporability", className, this.impl);
            ProtocolConnection.Support supported = this.impl.isSupported(bis);
            EventService.publishEvent(DebugInfoEvent.class, new Object[]{"Supported", supported});
            if (supported == ProtocolConnection.Support.UNSUPPORTED) continue;
            EventService.publishEvent(DebugInfoEvent.class, "Attempting to set up", className, this.impl);
            if (!this.impl.setupServer(acceptedConnection, streamId)) continue;
            return true;
        }
        if (lastException != null) {
            throw lastException;
        }
        return false;
    }

    public ProtocolConnection.State getState() {
        if (this.impl == null) {
            return ProtocolConnection.State.CLOSED;
        }
        return this.impl.getState();
    }

    public int decodeProtocolStream(byte[] tempBuffer) throws IOException {
        if (this.impl == null) {
            return -1;
        }
        return this.impl.decodeProtocolStream(tempBuffer);
    }

    public void terminate() {
        if (this.impl == null) {
            return;
        }
        this.impl.terminate();
    }

    public int encodeProtocolStream(byte[] tempBuffer, int length) throws IOException {
        if (this.impl == null) {
            return -1;
        }
        return this.impl.encodeProtocolStream(tempBuffer, length);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.impl == null) {
            this.propertyChangeListeners.remove(listener);
        } else {
            this.impl.removePropertyChangeListener(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.impl == null) {
            this.propertyChangeListeners.add(listener);
        } else {
            this.impl.addPropertyChangeListener(listener);
        }
    }

    public long getCurrentTransferRate() {
        if (this.impl == null) {
            return 0L;
        }
        return this.impl.getCurrentTransferRate();
    }

    public ProtocolConnection.Support isSupported(InputStream input) {
        if (this.impl == null) {
            return null;
        }
        return this.impl.isSupported(input);
    }

    public long getLastAccessTime() {
        if (this.impl == null) {
            return 0L;
        }
        return this.impl.getLastAccessTime();
    }

    public InetAddress getLocalInetAddress() {
        if (this.impl == null) {
            return null;
        }
        return this.impl.getLocalInetAddress();
    }

    public String getSessionId() {
        if (this.impl == null) {
            return "<null>";
        }
        return this.impl.getSessionId();
    }

    static {
        URL location = ProtocolConnectionBaseImpl.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            String dir = location.getFile().replaceAll("%20", " ");
            Class<?>[] classes = new File(dir).isDirectory() ? BootStrap.getClassesFromFilesystem("com.signiant.jsf.services.protocoltunnel.versions") : BootStrap.getClassesFromJar(location, "com.signiant.jsf.services.protocoltunnel.versions");
            for (Class<?> c : classes) {
                try {
                    supportedClasses.put(c.getSimpleName(), c.getName());
                }
                catch (Exception discard) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

