/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import com.signiant.jsf.services.protocoltunnel.handlers.ClientProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpClientProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpServerProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.ServerProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.versions.ProtocolConnection_V2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpProtocolConnection_V2
extends ProtocolConnection_V2 {
    protected Pattern httpHeaderPattern = Pattern.compile("(\\w+) (\\S+) HTTP/(\\d+).(\\d+)");

    public ProtocolConnection.Support isSupported(InputStream inputStream) {
        String input;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            input = reader.readLine();
        }
        catch (IOException discard) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        if (input == null) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        Matcher matcher = this.httpHeaderPattern.matcher(input);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        if (!matcher.group(1).equalsIgnoreCase("GET") && !matcher.group(1).equalsIgnoreCase("POST") || !matcher.group(2).startsWith(HttpClientProtocolHandler.uriPath)) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        return ProtocolConnection.Support.SUPPORTED;
    }

    protected boolean isSynchronous() {
        return true;
    }

    protected ClientProtocolHandler getClientProtocolHandler() {
        return new HttpClientProtocolHandler();
    }

    protected ServerProtocolHandler getServerProtocolHandler() {
        return new HttpServerProtocolHandler();
    }
}

