/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.versions;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.DebugInfoEvent;
import com.signiant.jsf.services.event.events.EndOfProtocolInputStream;
import com.signiant.jsf.services.event.events.IOExceptionEvent;
import com.signiant.jsf.services.event.events.InactivityTimeoutExpired;
import com.signiant.jsf.services.event.events.InvalidHTTPServerResponse;
import com.signiant.jsf.services.event.events.InvalidHTTPSessionRequested;
import com.signiant.jsf.services.event.events.InvalidHandshakeReceived;
import com.signiant.jsf.services.event.events.PeerConnectException;
import com.signiant.jsf.services.event.events.StartOfConnection;
import com.signiant.jsf.services.event.events.ThreadFinished;
import com.signiant.jsf.services.event.events.ThreadStarted;
import com.signiant.jsf.services.event.events.UnexpectedPacketTypeReceived;
import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import com.signiant.jsf.services.protocoltunnel.versions.ProtocolConnection_V1;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpProtocolConnection_V1
extends ProtocolConnection_V1 {
    private static final byte TUNNEL_OPEN = 1;
    private static final byte TUNNEL_DATA = 2;
    private static final byte TUNNEL_CLOSE = 3;
    private static final byte TUNNEL_BURST = 4;
    private static final byte PACKET_HEADER_LENGTH = 8;
    private static String uriPath;
    private static int MAX_BUFFER;
    private static int MAX_BACKLOG;
    private static int SESSION_ID_LENGTH;
    private static byte[] HTTP_200_OK;
    private static byte[] KEEP_ALIVE;
    private static byte[] HTTP_HEADERS_END;
    private long bytesDownloaded;
    private long bytesUploaded;
    private String ddsPcSession;
    private URL postUrl;
    private Throwable lastException;
    private int optimalSendBurst = 4;
    private int optimalReceiveBurst = 4;
    private Thread internalTransferThread;
    private long receivePacketSequenceNumber;
    private long transmitPacketSequenceNumber;
    private LinkedBlockingQueue<byte[]> inputQueue;
    private LinkedBlockingQueue<byte[]> outputQueue;
    private Thread decoderBlockedThread;
    private LinkedBlockingQueue<byte[]> copyQueue;
    private static HashMap<String, ServerSession> sessionMap;
    protected Pattern httpHeaderPattern = Pattern.compile("(\\w+) (\\S+) HTTP/(\\d+).(\\d+)");

    public HttpProtocolConnection_V1() {
        this.inputQueue = new LinkedBlockingQueue(MAX_BACKLOG);
        this.outputQueue = new LinkedBlockingQueue(MAX_BACKLOG);
        this.copyQueue = new LinkedBlockingQueue(MAX_BACKLOG);
    }

    public ProtocolConnection.Support isSupported(InputStream inputStream) {
        String input;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            input = reader.readLine();
        }
        catch (IOException discard) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        if (input == null) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        Matcher matcher = this.httpHeaderPattern.matcher(input);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        if (!matcher.group(1).equalsIgnoreCase("GET") && !matcher.group(1).equalsIgnoreCase("POST") || !matcher.group(2).startsWith(uriPath)) {
            return ProtocolConnection.Support.UNSUPPORTED;
        }
        return ProtocolConnection.Support.SUPPORTED;
    }

    protected boolean connectToPeer() {
        if (this.getPeerPort() == 0) {
            return false;
        }
        if (this.isClient()) {
            final AtomicBoolean timeout = new AtomicBoolean(false);
            try {
                URL downloadUrl = new URL("HTTP://" + this.getPeerHost() + ":" + this.getPeerPort() + uriPath + "?downloader=" + System.nanoTime());
                EventService.publishEvent(StartOfConnection.class, this.getPeerHost(), this.getPeerPort(), downloadUrl, "GET");
                final HttpURLConnection getConnection = (HttpURLConnection)downloadUrl.openConnection();
                Thread timer = new Thread("Connection timeout for " + this){

                    public void run() {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException discard) {
                            return;
                        }
                        getConnection.disconnect();
                        timeout.set(true);
                    }
                };
                timer.start();
                getConnection.setConnectTimeout(10000);
                getConnection.setUseCaches(false);
                getConnection.setDoOutput(false);
                getConnection.setRequestProperty("Connection", "Keep-alive");
                getConnection.connect();
                if (getConnection.getResponseCode() != 200) {
                    this.lastException = new ConnectException(this.getPeerHost());
                    EventService.publishEvent(InvalidHTTPServerResponse.class, getConnection.getResponseCode(), getConnection.getResponseMessage(), this.getPeerHost(), this.getPeerPort());
                    return false;
                }
                timer.interrupt();
                if (timeout.get()) {
                    this.lastException = new ConnectException(this.getPeerHost());
                    EventService.publishEvent(InactivityTimeoutExpired.class, this.getPeerHost(), this.getPeerPort());
                    return false;
                }
                this.setEncodedInputStream(new BufferedInputStream(getConnection.getInputStream()), downloadUrl.toString());
                byte[] buffer = new byte[SESSION_ID_LENGTH];
                this.readTunnelPacket(1, buffer);
                this.ddsPcSession = new String(buffer);
                getConnection.getInputStream().close();
                getConnection.disconnect();
                this.internalTransferThread = new Thread(){

                    public void run() {
                        HttpProtocolConnection_V1.this.clientTransferThread();
                    }
                };
                this.internalTransferThread.start();
            }
            catch (IOException e) {
                this.lastException = e;
                EventService.publishEvent(PeerConnectException.class, e, this.getPeerHost(), this.getPeerPort());
                this.terminate();
                return false;
            }
        }
        try {
            this.dealWithServerInput();
        }
        catch (IOException e) {
            this.lastException = e;
            EventService.publishEvent(PeerConnectException.class, e, this.getPeerHost(), this.getPeerPort());
            this.terminate();
            return false;
        }
        return true;
    }

    private String generateSessionId() {
        String sessionId = null;
        boolean unique = false;
        while (!unique) {
            Random r = new Random();
            byte[] raw = new byte[SESSION_ID_LENGTH];
            r.nextBytes(raw);
            for (int i = 0; i < raw.length; ++i) {
                raw[i] = (byte)((raw[i] + 128) % 64 + 32);
            }
            sessionId = new String(raw);
            unique = sessionMap.get(sessionId) == null;
        }
        return sessionId;
    }

    protected int encodeProtocolStreamImpl(byte[] buffer, int numberOfBytesToWrite) {
        if (this.isClient()) {
            byte[] temp = new byte[numberOfBytesToWrite];
            System.arraycopy(buffer, 0, temp, 0, numberOfBytesToWrite);
            try {
                this.outputQueue.put(temp);
            }
            catch (InterruptedException discard) {
                return -1;
            }
            return numberOfBytesToWrite;
        }
        return -1;
    }

    private void clientTransferThread() {
        Thread.currentThread().setName(this + " client transfer thread");
        EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
        try {
            this.postUrl = new URL("HTTP://" + this.getPeerHost() + ":" + this.getPeerPort() + uriPath + "?unique=" + System.currentTimeMillis());
            this.transmitPacketSequenceNumber = 0L;
            int waitInterval = 1000;
            while (this.getState() != ProtocolConnection.State.CLOSED) {
                int maxReceived;
                byte[] outputHoldingBuffer = this.outputQueue.poll(waitInterval, TimeUnit.MILLISECONDS);
                EventService.publishEvent(StartOfConnection.class, this.getPeerHost(), this.getPeerPort(), this.postUrl, "POST", this.ddsPcSession);
                HttpURLConnection activeConnection = (HttpURLConnection)this.postUrl.openConnection();
                activeConnection.setDoOutput(true);
                activeConnection.setDoInput(true);
                activeConnection.setAllowUserInteraction(true);
                activeConnection.setRequestProperty("HTTP-Version", "HTTP/1.1");
                activeConnection.setRequestMethod("POST");
                activeConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF8");
                activeConnection.setRequestProperty("Connection", "Keep-Alive");
                activeConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
                this.setEncodedOutputStream(activeConnection.getOutputStream(), this.ddsPcSession);
                this.emitTunnelPacket(1, this.ddsPcSession.getBytes(), this.ddsPcSession.length());
                this.emitTunnelPacket(4, new byte[]{(byte)this.optimalReceiveBurst}, 1);
                int maxSent = 0;
                if (outputHoldingBuffer != null) {
                    this.emitTunnelPacket(2, outputHoldingBuffer, outputHoldingBuffer.length);
                    while (maxSent++ < this.optimalSendBurst && (outputHoldingBuffer = this.outputQueue.poll(100L, TimeUnit.MILLISECONDS)) != null) {
                        this.emitTunnelPacket(2, outputHoldingBuffer, outputHoldingBuffer.length);
                    }
                }
                activeConnection.getOutputStream().flush();
                long start = System.currentTimeMillis();
                int responseCode = activeConnection.getResponseCode();
                long end = System.currentTimeMillis();
                long duration = end - start;
                if (duration < 1000L && maxSent >= this.optimalSendBurst) {
                    ++this.optimalSendBurst;
                    if (duration < 500L) {
                        this.optimalSendBurst += 10;
                    }
                }
                if (duration > 1500L && this.optimalSendBurst > 1) {
                    --this.optimalSendBurst;
                    if (duration > 2000L) {
                        this.optimalSendBurst = 0;
                    }
                }
                if (responseCode != 200) {
                    this.lastException = new IOException(activeConnection.getResponseMessage());
                    EventService.publishEvent(InvalidHTTPServerResponse.class, responseCode, activeConnection.getResponseMessage());
                    this.terminate();
                    break;
                }
                this.setEncodedInputStream(activeConnection.getInputStream(), this.ddsPcSession);
                if (waitInterval < 2000) {
                    waitInterval += 100;
                }
                int toReceive = this.readTunnelPacket(4)[0];
                for (maxReceived = 0; maxReceived < toReceive; ++maxReceived) {
                    this.inputQueue.put(this.readTunnelPacket(2));
                }
                if (maxReceived > 0) {
                    waitInterval = 0;
                    if (duration < 1000L && maxReceived >= this.optimalReceiveBurst) {
                        ++this.optimalReceiveBurst;
                        if (duration < 500L) {
                            this.optimalReceiveBurst += 10;
                        }
                    }
                    if (duration > 1500L && this.optimalReceiveBurst > 1) {
                        --this.optimalReceiveBurst;
                        if (duration > 2000L) {
                            this.optimalReceiveBurst = 0;
                        }
                    }
                }
                EventService.publishEvent(DebugInfoEvent.class, "Send burst", this.optimalSendBurst, "Receive burst", this.optimalReceiveBurst);
            }
        }
        catch (Throwable t) {
            EventService.publishEvent(DebugInfoEvent.class, Thread.currentThread().getName(), "terminating cause", t);
            this.terminate();
        }
        EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
    }

    protected int decodeProtocolStreamImpl(byte[] buffer) throws IOException {
        if (this.isClient()) {
            try {
                int returnLength;
                byte[] temp;
                do {
                    this.decoderBlockedThread = Thread.currentThread();
                    temp = this.copyQueue.peek() != null ? this.copyQueue.poll() : this.inputQueue.poll(5L, TimeUnit.SECONDS);
                    if (this.lastException != null) {
                        if (this.lastException instanceof IOException) {
                            throw (IOException)this.lastException;
                        }
                        throw new IOException(this.lastException.toString());
                    }
                    if (this.getState() != ProtocolConnection.State.CLOSED) continue;
                    throw new ClosedChannelException();
                } while (temp == null);
                try {
                    if (temp.length > buffer.length) {
                        System.arraycopy(temp, 0, buffer, 0, buffer.length);
                        byte[] leftover = new byte[temp.length - buffer.length];
                        System.arraycopy(temp, buffer.length, leftover, 0, temp.length - buffer.length);
                        this.copyQueue.put(leftover);
                        returnLength = buffer.length;
                    } else {
                        System.arraycopy(temp, 0, buffer, 0, temp.length);
                        returnLength = temp.length;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.decoderBlockedThread = null;
                    throw new ArrayIndexOutOfBoundsException();
                }
                this.decoderBlockedThread = null;
                return returnLength;
            }
            catch (InterruptedException discard) {
                throw new ClosedChannelException();
            }
        }
        while (this.getState() != ProtocolConnection.State.CLOSED) {
            this.dealWithServerInput();
        }
        return 0;
    }

    private void dealWithServerInput() throws IOException {
        this.getEncodedInputStream().mark(1);
        int sentinel = this.getEncodedInputStream().read();
        if (sentinel == -1) {
            EventService.publishEvent(EndOfProtocolInputStream.class, this.getEncodedInputStream());
            this.terminate();
            return;
        }
        this.getEncodedInputStream().reset();
        switch (sentinel) {
            case 71: 
            case 103: {
                if (!this.processServerGet()) break;
                return;
            }
            case 80: 
            case 112: {
                if (!this.processServerPost()) break;
                return;
            }
        }
        this.terminate();
    }

    private boolean processServerGet() throws IOException {
        byte[] buffer = new byte[256];
        BufferedReader lineReader = null;
        int bytesRead = this.getEncodedInputStream().read(buffer);
        lineReader = new BufferedReader(new StringReader(new String(buffer, 0, bytesRead)));
        String input = lineReader.readLine();
        Matcher matcher = this.httpHeaderPattern.matcher(input);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort(), input);
            return false;
        }
        if (!matcher.group(1).equalsIgnoreCase("GET") || !matcher.group(2).startsWith(uriPath)) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort(), input);
            return false;
        }
        String ddsPcSession = this.generateSessionId();
        sessionMap.put(ddsPcSession, new ServerSession(null, SessionState.INITIAL, ddsPcSession));
        this.getEncodedOutputStream().write(HTTP_200_OK);
        this.getEncodedOutputStream().write(KEEP_ALIVE);
        this.getEncodedOutputStream().write(HTTP_HEADERS_END);
        this.emitTunnelPacket(1, ddsPcSession.getBytes(), SESSION_ID_LENGTH);
        this.getEncodedOutputStream().flush();
        return true;
    }

    private boolean processServerPost() throws IOException {
        String input = this.readLineFromEncodedInputStream();
        if (input == null) {
            return false;
        }
        Matcher matcher = this.httpHeaderPattern.matcher(input);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort(), input);
            return false;
        }
        if (!matcher.group(1).equalsIgnoreCase("POST") || !matcher.group(2).startsWith(uriPath)) {
            EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort(), input);
            return false;
        }
        int maxHeaderLines = 12;
        while ((input = this.readLineFromEncodedInputStream()) != null) {
            if (maxHeaderLines-- == 0) {
                EventService.publishEvent(InvalidHandshakeReceived.class, this.getPeerHost(), this.getPeerPort(), input, 12);
                return false;
            }
            if (!input.equals("")) continue;
        }
        byte[] session = new byte[SESSION_ID_LENGTH];
        this.readTunnelPacket(1, session);
        this.ddsPcSession = new String(session);
        ServerSession serverSession = sessionMap.get(this.ddsPcSession);
        if (serverSession == null) {
            EventService.publishEvent(InvalidHTTPSessionRequested.class, this.getPeerHost(), this.getPeerPort(), this.ddsPcSession);
            return false;
        }
        if (serverSession.getSocket() == null) {
            EventService.publishEvent(StartOfConnection.class, this.getPeerHost(), this.getPeerPort());
            try {
                Socket ddsPcSocket = new Socket(this.getPeerHost(), this.getPeerPort());
                serverSession.setSocket(ddsPcSocket);
                serverSession.setState(SessionState.ESTABLISHED);
            }
            catch (IOException cannotConnect) {
                this.getEncodedOutputStream().write(HTTP_200_OK);
                this.getEncodedOutputStream().write(KEEP_ALIVE);
                this.getEncodedOutputStream().write(HTTP_HEADERS_END);
                this.emitTunnelPacket(3, cannotConnect.getLocalizedMessage().getBytes(), cannotConnect.getLocalizedMessage().getBytes().length);
                this.getEncodedOutputStream().flush();
                return false;
            }
        }
        byte[] burstBuffer = new byte[1];
        this.readTunnelPacket(4, burstBuffer);
        byte[] transmitBuffer = new byte[MAX_BUFFER];
        while (this.getEncodedInputStream().available() > 0) {
            int bytesRead = this.readTunnelPacket(2, transmitBuffer);
            serverSession.write(transmitBuffer, 0, bytesRead, this.receivePacketSequenceNumber);
        }
        this.getEncodedOutputStream().write(HTTP_200_OK);
        int availableResponse = serverSession.available();
        if (availableResponse > 0) {
            int burstCount;
            Vector<byte[]> responses = new Vector<byte[]>();
            int bytesRead = 0;
            for (burstCount = 0; serverSession.available() > 0 && burstCount < burstBuffer[0]; ++burstCount) {
                availableResponse = Math.min(serverSession.available(), MAX_BUFFER);
                byte[] response = new byte[availableResponse];
                bytesRead += serverSession.read(response);
                responses.add(response);
            }
            this.getEncodedOutputStream().write(("Content-length: " + (8 * burstCount + 8 + 1 + bytesRead) + "\r\n").getBytes());
            this.getEncodedOutputStream().write(KEEP_ALIVE);
            this.getEncodedOutputStream().write(HTTP_HEADERS_END);
            this.emitTunnelPacket(4, new byte[]{(byte)burstCount}, 1);
            for (byte[] response : responses) {
                this.emitTunnelPacket(2, response, response.length);
            }
        } else if (availableResponse == 0) {
            this.getEncodedOutputStream().write("Content-length: 9\r\n".getBytes());
            this.getEncodedOutputStream().write(KEEP_ALIVE);
            this.getEncodedOutputStream().write(HTTP_HEADERS_END);
            this.emitTunnelPacket(4, new byte[]{0}, 1);
        } else if (availableResponse == -1) {
            byte[] endOfStream = "End of stream".getBytes();
            this.getEncodedOutputStream().write(("Content-length: " + (8 + endOfStream.length) + "\r\n").getBytes());
            this.getEncodedOutputStream().write(KEEP_ALIVE);
            this.getEncodedOutputStream().write(HTTP_HEADERS_END);
            this.emitTunnelPacket(4, new byte[]{0}, 1);
            this.emitTunnelPacket(3, endOfStream, endOfStream.length);
        }
        this.getEncodedOutputStream().flush();
        return true;
    }

    private void emitTunnelPacket(int packetType, byte[] payload, int size) throws IOException {
        this.getEncodedOutputStream().write(packetType);
        byte[] sequence = new byte[]{(byte)(this.transmitPacketSequenceNumber >> 24), (byte)((this.transmitPacketSequenceNumber >> 16) % 256L), (byte)((this.transmitPacketSequenceNumber >> 8) % 256L), (byte)(this.transmitPacketSequenceNumber % 256L)};
        ++this.transmitPacketSequenceNumber;
        if (this.transmitPacketSequenceNumber == 0L) {
            throw new IOException("Sequence number wraparound!");
        }
        byte[] sizeinfo = new byte[]{(byte)((size >> 16) % 256), (byte)((size >> 8) % 256), (byte)(size % 256)};
        this.getEncodedOutputStream().write(sequence);
        this.getEncodedOutputStream().write(sizeinfo);
        if (size > 0) {
            this.getEncodedOutputStream().write(payload, 0, size);
        }
        this.bytesUploaded += (long)(size + 8);
    }

    private int readTunnelPacket(int expectedPacketType, byte[] buffer) throws IOException {
        int packetType = this.getEncodedInputStream().read();
        ++this.bytesDownloaded;
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.getPeerHost(), this.getPeerPort(), expectedPacketType, packetType);
            return -1;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(sequence, sequence.length);
        this._readBuffer(sizeinfo, sizeinfo.length);
        this.bytesDownloaded += 8L;
        this.receivePacketSequenceNumber = (sequence[0] & 0xFF) * 0x1000000 + (sequence[1] & 0xFF) * 65536 + (sequence[2] & 0xFF) * 256 + (sequence[3] & 0xFF);
        int length = (sizeinfo[0] & 0xFF) * 65536 + (sizeinfo[1] & 0xFF) * 256 + (sizeinfo[2] & 0xFF);
        if (buffer == null) {
            return 0;
        }
        int bytesRead = this._readBuffer(buffer, length);
        this.bytesDownloaded += (long)bytesRead;
        return bytesRead;
    }

    private int _readBuffer(byte[] buffer, int length) throws IOException {
        int bytesRead = 0;
        if (length > 0) {
            bytesRead = this.getEncodedInputStream().read(buffer, 0, length);
        }
        while (length <= buffer.length && bytesRead < length) {
            int newRead = this.getEncodedInputStream().read(buffer, bytesRead, length - bytesRead);
            if (newRead == -1) {
                return bytesRead;
            }
            bytesRead += newRead;
        }
        return bytesRead;
    }

    private byte[] readTunnelPacket(int expectedPacketType) throws IOException {
        int packetType = this.getEncodedInputStream().read();
        if (expectedPacketType != packetType) {
            EventService.publishEvent(UnexpectedPacketTypeReceived.class, this.getPeerHost(), this.getPeerPort(), expectedPacketType, packetType);
            return null;
        }
        byte[] sequence = new byte[4];
        byte[] sizeinfo = new byte[3];
        this._readBuffer(sequence, sequence.length);
        this._readBuffer(sizeinfo, sizeinfo.length);
        this.bytesDownloaded += 8L;
        this.receivePacketSequenceNumber = (sequence[0] & 0xFF) * 0x1000000 + (sequence[1] & 0xFF) * 65536 + (sequence[2] & 0xFF) * 256 + (sequence[3] & 0xFF);
        int length = (sizeinfo[0] & 0xFF) * 65536 + (sizeinfo[1] & 0xFF) * 256 + (sizeinfo[2] & 0xFF);
        this.bytesDownloaded += 8L;
        byte[] buffer = new byte[length];
        this._readBuffer(buffer, length);
        return buffer;
    }

    public void terminate() {
        Thread blocker;
        if (this.ddsPcSession != null) {
            this.ddsPcSession = null;
        }
        if ((blocker = this.decoderBlockedThread) != null) {
            blocker.interrupt();
        }
        super.terminate();
    }

    public String toString() {
        return (this.isClient() ? "Client: " : "Server: ") + (this.getPeerHost() == null ? "local pc" : this.getPeerHost()) + ":" + this.getPeerPort();
    }

    public InetAddress getLocalInetAddress() {
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public String getSessionId() {
        return this.ddsPcSession;
    }

    static {
        MAX_BUFFER = 65536;
        MAX_BACKLOG = 4;
        SESSION_ID_LENGTH = 20;
        HTTP_200_OK = "HTTP/1.1 200 OK\r\n".getBytes();
        KEEP_ALIVE = "Keep-Alive: timeout=10, max=2000\r\nConnection: Keep-alive\r\n".getBytes();
        HTTP_HEADERS_END = "\r\n".getBytes();
        sessionMap = new HashMap();
        uriPath = BootStrap.getInstance().getProperty("com.signiant.tunnel.protocol.HTTP.path");
        if (uriPath == null) {
            uriPath = "/signiant/tunnel/http";
        }
    }

    private class ServerSession {
        private Socket socket;
        private SessionState state;
        private String sessionId;
        private long lastAccessTime;
        private boolean running;
        private Thread monitor;
        private InputStream is;
        private OutputStream os;
        private long highestSequenceNumber;

        public ServerSession(Socket socket, SessionState state, String sessionId) {
            this.socket = socket;
            this.state = state;
            this.sessionId = sessionId;
            this.lastAccessTime = System.currentTimeMillis();
            this.monitor = new Thread("PC Session " + sessionId + " reaper " + socket){

                public void run() {
                    ServerSession.this.timeoutThread();
                }
            };
            this.setSocket(socket);
        }

        public Socket getSocket() {
            return this.socket;
        }

        public void setSocket(Socket socket) {
            this.socket = socket;
            if (socket != null) {
                try {
                    this.is = new ProtocolConnection_V1.InstrumentedInputStream(HttpProtocolConnection_V1.this, socket.getInputStream(), ProtocolConnection_V1.StreamType.RAW, HttpProtocolConnection_V1.this, "");
                    this.os = new ProtocolConnection_V1.InstrumentedOutputStream(HttpProtocolConnection_V1.this, socket.getOutputStream(), ProtocolConnection_V1.StreamType.RAW, HttpProtocolConnection_V1.this, "");
                }
                catch (IOException discard) {
                    return;
                }
                this.running = true;
                this.monitor.start();
            }
        }

        public SessionState getState() {
            return this.state;
        }

        public void setState(SessionState state) {
            this.state = state;
        }

        public int available() {
            try {
                this.lastAccessTime = System.currentTimeMillis();
                EventService.publishEvent(DebugInfoEvent.class, "Available", this.sessionId, this.lastAccessTime);
                return this.is.available();
            }
            catch (IOException e) {
                EventService.publishEvent(IOExceptionEvent.class, e);
                this.running = false;
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                EventService.publishEvent(DebugInfoEvent.class, "Removing session", this.sessionId);
                sessionMap.remove(this.sessionId);
                return -1;
            }
        }

        public void write(byte[] buffer, int offset, int length, long sequenceNumber) {
            try {
                this.lastAccessTime = System.currentTimeMillis();
                if (sequenceNumber > this.highestSequenceNumber) {
                    this.highestSequenceNumber = sequenceNumber;
                    EventService.publishEvent(DebugInfoEvent.class, "write", this.sessionId, this.lastAccessTime);
                    this.os.write(buffer, offset, length);
                    this.os.flush();
                } else {
                    EventService.publishEvent(DebugInfoEvent.class, "duplicate discard", this.sessionId, sequenceNumber, this.highestSequenceNumber);
                }
            }
            catch (IOException e) {
                EventService.publishEvent(IOExceptionEvent.class, e);
                this.running = false;
                try {
                    this.socket.close();
                }
                catch (Throwable discard) {
                    // empty catch block
                }
                EventService.publishEvent(DebugInfoEvent.class, "Removing session", this.sessionId);
                sessionMap.remove(this.sessionId);
            }
        }

        public int read(byte[] buffer) {
            try {
                EventService.publishEvent(DebugInfoEvent.class, "read", this.sessionId, this.lastAccessTime);
                this.lastAccessTime = System.currentTimeMillis();
                return this.is.read(buffer);
            }
            catch (IOException e) {
                EventService.publishEvent(IOExceptionEvent.class, e);
                this.running = false;
                try {
                    this.socket.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                EventService.publishEvent(DebugInfoEvent.class, "Removing session", this.sessionId);
                sessionMap.remove(this.sessionId);
                return -1;
            }
        }

        private void timeoutThread() {
            while (this.running) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException discard) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - this.lastAccessTime <= 10000L) continue;
                EventService.publishEvent(InactivityTimeoutExpired.class, System.currentTimeMillis(), this.lastAccessTime, this.sessionId);
                this.running = false;
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                EventService.publishEvent(DebugInfoEvent.class, "Removing session", this.sessionId);
                sessionMap.remove(this.sessionId);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SessionState {
        INITIAL,
        AWAITING_HANDSHAKE,
        ESTABLISHED,
        DISCONNECTED;

    }
}

