/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.handlers;

import com.signiant.jsf.services.event.InstrumentedInputStream;
import com.signiant.jsf.services.event.StreamType;
import com.signiant.jsf.services.protocoltunnel.AcceptedConnection;
import com.signiant.jsf.services.protocoltunnel.ProtocolService;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpClientProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpMethod;
import com.signiant.jsf.services.protocoltunnel.handlers.ServerProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.versions.Base64;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpServerProtocolHandler
implements ServerProtocolHandler {
    public static final ByteBuffer HTTP_200_OK;
    public static final ByteBuffer KEEP_ALIVE;
    public static final ByteBuffer CONNECTION_CLOSE;
    public static final ByteBuffer HTTP_HEADERS_END;
    private AcceptedConnection acceptedConnection;
    private HttpMethod method;
    private boolean proxied;
    private InstrumentedInputStream putbackInput;
    protected static Pattern httpHeaderPattern;

    public void setAcceptedConnection(AcceptedConnection acceptedConnection) {
        this.acceptedConnection = acceptedConnection;
    }

    public boolean acceptRequestHeader() throws IOException {
        String input = this.readLineFromEncodedInputStream();
        if (input == null) {
            return false;
        }
        Matcher matcher = httpHeaderPattern.matcher(input);
        if (!matcher.matches() || matcher.groupCount() != 4) {
            return false;
        }
        if (!matcher.group(1).equalsIgnoreCase("GET") && !matcher.group(1).equalsIgnoreCase("POST") || !matcher.group(2).startsWith(HttpClientProtocolHandler.uriPath)) {
            return false;
        }
        this.method = matcher.group(1).equalsIgnoreCase("GET") ? HttpMethod.GET : HttpMethod.POST;
        this.proxied = false;
        ByteArrayInputStream decodedInputStream = null;
        int maxHeaderLines = 20;
        while ((input = this.readLineFromEncodedInputStream()) != null) {
            if (input.contains("Via:")) {
                this.proxied = true;
            }
            if (this.method == HttpMethod.GET && input.startsWith("Cookie: ")) {
                String[] cookieCrumbs;
                String cookiePayload = input.substring("Cookie: ".length());
                for (String crumb : cookieCrumbs = cookiePayload.split(";")) {
                    if (!(crumb = crumb.trim()).startsWith("p=")) continue;
                    String base64payload = crumb.substring("p=".length()).trim();
                    byte[] payload = Base64.decode(base64payload, 24);
                    decodedInputStream = new ByteArrayInputStream(payload);
                    break;
                }
            }
            if (maxHeaderLines-- == 0) {
                return false;
            }
            if (!input.equals("")) continue;
        }
        if (decodedInputStream != null) {
            this.setPutbackEncodedInputStream(decodedInputStream, "Cookie");
        }
        return true;
    }

    protected void setPutbackEncodedInputStream(InputStream input, String stremIdPrefix) {
        this.putbackInput = new InstrumentedInputStream(new BufferedInputStream(input), StreamType.WRAPPED, this, stremIdPrefix + ":");
    }

    public void finishResponse() throws IOException {
        if (this.proxied) {
            // empty if block
        }
    }

    public void prepareResponseHeader(int bytesToTransmit) throws IOException {
        ByteBuffer[] scatter = new ByteBuffer[]{HTTP_200_OK.slice(), ByteBuffer.wrap(("Content-length: " + bytesToTransmit + "\r\n").getBytes()), this.proxied && this.method == HttpMethod.POST ? CONNECTION_CLOSE.slice() : KEEP_ALIVE.slice(), HTTP_HEADERS_END.slice()};
        this.acceptedConnection.write(scatter);
    }

    protected String readLineFromEncodedInputStream() throws IOException {
        if (this.putbackInput != null && this.putbackInput.available() > 0) {
            return this.putbackInput.readLine();
        }
        this.putbackInput = null;
        return this.acceptedConnection.readLine();
    }

    public int peek() throws IOException {
        int peek = -1;
        if (this.putbackInput != null && this.putbackInput.available() > 0) {
            this.putbackInput.mark(1);
            peek = this.putbackInput.read();
            this.putbackInput.reset();
        } else {
            this.putbackInput = null;
            peek = this.acceptedConnection.peek();
        }
        return peek;
    }

    public int read() throws IOException {
        if (this.putbackInput != null && this.putbackInput.available() > 0) {
            return this.putbackInput.read();
        }
        this.putbackInput = null;
        return this.acceptedConnection.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.putbackInput != null && this.putbackInput.available() > 0) {
            return this.putbackInput.read(buffer, offset, length);
        }
        this.putbackInput = null;
        return this.acceptedConnection.read(buffer, offset, length);
    }

    public ByteBuffer readSlice(int length) throws IOException {
        if (this.putbackInput != null && this.putbackInput.available() > 0) {
            byte[] buffer = new byte[length];
            this.putbackInput.read(buffer);
            return ByteBuffer.wrap(buffer);
        }
        this.putbackInput = null;
        return this.acceptedConnection.slice(length);
    }

    public void write(int data) throws IOException {
        byte[] tmp = new byte[]{(byte)data};
        this.write(tmp);
    }

    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.acceptedConnection.write(buffer, offset, length);
    }

    public String toString() {
        return this.acceptedConnection.toString();
    }

    public void close() {
        this.acceptedConnection.close();
    }

    static {
        httpHeaderPattern = Pattern.compile("(\\w+) (\\S+) HTTP/(\\d+).(\\d+)");
        byte[] tmp = "HTTP/1.1 200 OK\r\n".getBytes();
        HTTP_200_OK = ByteBuffer.allocateDirect(tmp.length);
        HTTP_200_OK.put(tmp);
        HTTP_200_OK.flip();
        tmp = ("Keep-Alive: timeout=" + ProtocolService.MAX_KEEPALIVE + ", max=1000\r\nConnection: Keep-alive\r\n").getBytes();
        KEEP_ALIVE = ByteBuffer.allocateDirect(tmp.length);
        KEEP_ALIVE.put(tmp);
        KEEP_ALIVE.flip();
        tmp = "Connection: Close\r\n".getBytes();
        CONNECTION_CLOSE = ByteBuffer.allocateDirect(tmp.length);
        CONNECTION_CLOSE.put(tmp);
        CONNECTION_CLOSE.flip();
        tmp = "\r\n".getBytes();
        HTTP_HEADERS_END = ByteBuffer.allocateDirect(tmp.length);
        HTTP_HEADERS_END.put(tmp);
        HTTP_HEADERS_END.flip();
    }
}

