/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.handlers;

import com.signiant.jsf.services.protocoltunnel.handlers.HttpMethod;
import com.signiant.jsf.services.protocoltunnel.versions.Base64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutputStream
extends OutputStream {
    private ByteArrayOutputStream holding;
    private OutputStream output;
    private HttpMethod method;

    public HttpOutputStream() {
        this(new ByteArrayOutputStream(), HttpMethod.GET);
    }

    public HttpOutputStream(OutputStream output) {
        this(output, HttpMethod.POST);
    }

    HttpOutputStream(OutputStream output, HttpMethod method) {
        this.output = output;
        this.method = method;
        this.holding = new ByteArrayOutputStream();
    }

    public void write(int arg0) throws IOException {
        if (this.method == HttpMethod.GET) {
            this.holding.write(arg0);
        } else {
            this.output.write(arg0);
        }
    }

    public void close() throws IOException {
        this.output.close();
    }

    public void flush() throws IOException {
        if (this.method == HttpMethod.GET) {
            byte[] buf = this.holding.toByteArray();
            this.output.write(Base64.encodeBytes(buf, 0, buf.length, 24).getBytes());
        }
        this.output.flush();
    }

    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        if (this.method == HttpMethod.GET) {
            this.holding.write(arg0, arg1, arg2);
        } else {
            this.output.write(arg0, arg1, arg2);
        }
    }

    public void write(byte[] arg0) throws IOException {
        this.write(arg0, 0, arg0.length);
    }

    public String toString() {
        return this.output.toString();
    }
}

