/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel.handlers;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.InvalidHTTPServerResponse;
import com.signiant.jsf.services.event.events.StartOfConnection;
import com.signiant.jsf.services.protocoltunnel.handlers.ClientProtocolHandler;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpMethod;
import com.signiant.jsf.services.protocoltunnel.handlers.HttpOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;

public class HttpClientProtocolHandler
implements ClientProtocolHandler {
    public static final String uriPath;
    public static final int GET_THRESHOLD = 1024;
    public static final String COOKIE_PAYLOAD = "p=";
    private String peerHost;
    private int peerPort;
    private URL peerUrl;
    private HttpURLConnection activeConnection;
    private InputStream activeInputStream;
    private OutputStream activeOutputStream;
    private HttpMethod method;
    private HttpOutputStream httpOutputStream;
    private String sessionId;
    int postCount = 0;

    public void setPeer(String peerHost, int peerPort) {
        this.peerHost = peerHost;
        this.peerPort = peerPort;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void prepareRequestHeader(int bytesToTransmit) throws IOException {
        this.peerUrl = new URL("HTTP://" + this.peerHost + ":" + this.peerPort + uriPath + "?unique=" + System.currentTimeMillis());
        EventService.publishEvent(StartOfConnection.class, this.peerHost, this.peerPort, this.peerUrl, "POST", this.sessionId);
        this.activeConnection = (HttpURLConnection)this.peerUrl.openConnection();
        this.activeConnection.setDoInput(true);
        this.activeConnection.setAllowUserInteraction(true);
        this.activeConnection.setRequestProperty("HTTP-Version", "HTTP/1.1");
        this.activeConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF8");
        this.activeConnection.setRequestProperty("Connection", "Keep-Alive");
        this.activeConnection.setRequestProperty("Proxy-Connection", "Keep-Alive");
        this.activeConnection.setConnectTimeout(10000);
        this.activeConnection.setReadTimeout(30000);
        if (bytesToTransmit < 1024) {
            this.method = HttpMethod.GET;
            this.activeConnection.setRequestMethod("GET");
            this.httpOutputStream = new HttpOutputStream();
            this.activeOutputStream = null;
        } else {
            this.method = HttpMethod.POST;
            this.activeConnection.setDoOutput(true);
            this.activeConnection.setRequestMethod("POST");
            this.activeConnection.setFixedLengthStreamingMode(bytesToTransmit);
            this.activeConnection.connect();
            this.httpOutputStream = null;
            this.activeOutputStream = new BufferedOutputStream(this.activeConnection.getOutputStream());
        }
    }

    public void finishRequest() throws IOException {
        if (this.method == HttpMethod.GET) {
            this.httpOutputStream.flush();
            this.activeConnection.setRequestProperty("Cookie", COOKIE_PAYLOAD + this.httpOutputStream.toString());
            this.activeConnection.connect();
        } else {
            this.activeOutputStream.flush();
        }
        this.httpOutputStream = null;
        this.activeOutputStream = null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.httpOutputStream != null) {
            return this.httpOutputStream;
        }
        return this.activeOutputStream;
    }

    public boolean acceptResponseHeader() throws IOException {
        int responseCode = this.activeConnection.getResponseCode();
        if (responseCode != 200) {
            EventService.publishEvent(InvalidHTTPServerResponse.class, responseCode, this.activeConnection.getResponseMessage());
            throw new IOException(this.activeConnection.getResponseMessage());
        }
        this.activeInputStream = new BufferedInputStream(this.activeConnection.getInputStream());
        return true;
    }

    public int peek() throws IOException {
        int peek = -1;
        if (this.activeInputStream != null) {
            this.activeInputStream.mark(1);
            peek = this.read();
            this.activeInputStream.reset();
        }
        return peek;
    }

    public int read() throws IOException {
        if (this.activeInputStream != null) {
            return this.activeInputStream.read();
        }
        return -1;
    }

    public int read(byte[] buffer) throws IOException {
        if (this.activeInputStream != null) {
            return this.activeInputStream.read(buffer);
        }
        return -1;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.activeInputStream != null) {
            return this.activeInputStream.read(buffer, offset, length);
        }
        return -1;
    }

    public ByteBuffer readSlice(int length) throws IOException {
        return null;
    }

    public void write(int data) throws IOException {
        this.getOutputStream().write(data);
    }

    public void write(byte[] buffer) throws IOException {
        this.getOutputStream().write(buffer);
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.getOutputStream().write(buffer, offset, length);
    }

    public InetAddress getLocalInetAddress() {
        if (this.activeConnection == null) {
            return null;
        }
        try {
            Class<?> httpURLConnectionClass = Class.forName("sun.net.www.protocol.http.HttpURLConnection");
            Field httpClientField = httpURLConnectionClass.getDeclaredField("http");
            httpClientField.setAccessible(true);
            Class<?> networkClientClass = Class.forName("sun.net.NetworkClient");
            Field serverSocketField = networkClientClass.getDeclaredField("serverSocket");
            serverSocketField.setAccessible(true);
            Object httpClientObject = httpClientField.get(this.activeConnection);
            Object serverSocketObject = serverSocketField.get(httpClientObject);
            if (serverSocketObject instanceof Socket) {
                return ((Socket)serverSocketObject).getLocalAddress();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "HTTP Client " + this.sessionId;
    }

    static {
        String path = BootStrap.getInstance().getProperty("com.signiant.jsf.protocoltunnel.HTTP.path");
        uriPath = path == null ? "/signiant/tunnel/v2/http" : path;
    }
}

