/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.Service;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.InactivityTimeoutExpired;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.event.events.ProtocolConnectionCreated;
import com.signiant.jsf.services.event.events.ThreadFinished;
import com.signiant.jsf.services.event.events.ThreadStarted;
import com.signiant.jsf.services.protocoltunnel.AcceptedConnection;
import com.signiant.jsf.services.protocoltunnel.ProtocolConnection;
import com.signiant.jsf.services.serverconnection.ServerConnectionService;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.nio.channels.ClosedSelectorException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProtocolService
implements Service,
PropertyChangeListener {
    private List<ProtocolConnection> connectionList;
    private boolean running;
    private Thread reaper;
    public static int MAX_KEEPALIVE = 20;

    public int getConnectionListCount() {
        return this.connectionList.size();
    }

    public long getCurrentThroughputRate() {
        long bytesPerSecond = 0L;
        for (ProtocolConnection p : this.connectionList) {
            bytesPerSecond += p.getCurrentTransferRate();
        }
        return bytesPerSecond;
    }

    public ProtocolConnection attachConnection(String protocol, boolean server, AcceptedConnection acceptedConnection, String host, int port, String streamId) {
        ProtocolConnection connection = null;
        try {
            Class<?> connectionClass = Class.forName("com.signiant.jsf.services.protocoltunnel.versions.ProtocolConnectionBaseImpl");
            Constructor<?> connectionConstructor = connectionClass.getConstructor(String.class);
            Object connectionObject = connectionConstructor.newInstance(protocol);
            if (connectionObject instanceof ProtocolConnection) {
                connection = (ProtocolConnection)connectionObject;
                EventService.publishEvent(ProtocolConnectionCreated.class, connection, host, port, server, streamId);
                connection.setPeerHost(host);
                connection.setPeerPort(port);
                connection.setClient(!server);
                if (connection.setupServer(acceptedConnection, streamId)) {
                    this.connectionList.add(connection);
                    connection.addPropertyChangeListener(this);
                    return connection;
                }
            } else {
                EventService.publishEvent(PrivateError.class, ProtocolConnection.class, connectionObject, streamId);
                return null;
            }
            connection = null;
        }
        catch (Exception oops) {
            if (!(oops instanceof ClosedSelectorException)) {
                EventService.publishEvent(PrivateError.class, ProtocolConnection.class, oops);
            }
            try {
                connection.terminate();
            }
            catch (Throwable discard) {
                // empty catch block
            }
            return null;
        }
        return connection;
    }

    public void init() throws Exception {
        this.connectionList = new CopyOnWriteArrayList<ProtocolConnection>();
        this.reaper = new Thread("ProtocolService Reaper"){

            public void run() {
                EventService.publishEvent(ThreadStarted.class, Thread.currentThread().getName());
                try {
                    ProtocolService.this.reaper();
                }
                catch (Throwable fatal) {
                    EventService.publishEvent(PrivateError.class, fatal);
                }
                EventService.publishEvent(ThreadFinished.class, Thread.currentThread().getName());
            }
        };
    }

    public void pause() {
        this.running = false;
        this.reaper.interrupt();
    }

    public void start() {
        this.running = true;
        this.reaper.setDaemon(true);
        this.reaper.start();
    }

    public void stop() {
        this.pause();
        for (ProtocolConnection p : this.connectionList) {
            p.terminate();
        }
        this.connectionList.clear();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() == ProtocolConnection.State.CLOSED) {
            ProtocolConnection p = (ProtocolConnection)evt.getSource();
            p.removePropertyChangeListener(this);
            this.connectionList.remove(p);
        }
    }

    public void healthCheck() {
    }

    private void reaper() {
        int keepaliveTimeout = MAX_KEEPALIVE * 1000 + 5000;
        ServerConnectionService serverConnectionService = (ServerConnectionService)BootStrap.getInstance().getService(ServerConnectionService.class);
        while (this.running) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException discard) {
                // empty catch block
            }
            long now = System.currentTimeMillis();
            for (ProtocolConnection connection : this.connectionList) {
                if (connection.getState() != ProtocolConnection.State.CLOSED) {
                    if (now - connection.getLastAccessTime() <= (long)keepaliveTimeout) continue;
                    if (serverConnectionService == null || !serverConnectionService.isSessionCurrent(connection.getSessionId())) {
                        EventService.publishEvent(InactivityTimeoutExpired.class, now, connection.getLastAccessTime(), connection.getSessionId(), connection);
                    }
                    try {
                        connection.terminate();
                    }
                    catch (Throwable t) {
                        EventService.publishEvent(PrivateError.class, t, connection);
                    }
                    this.connectionList.remove(connection);
                    continue;
                }
                try {
                    connection.terminate();
                }
                catch (Throwable t) {
                    EventService.publishEvent(PrivateError.class, t, connection);
                }
                this.connectionList.remove(connection);
            }
        }
    }

    public String getAdvertisedCapability() {
        return this.getClass().getSimpleName();
    }
}

