/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.protocoltunnel;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.PrivateError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class AcceptedConnection {
    public static final int DEFAULT_BUFFER_SIZE = 262144;
    private SocketChannel socketChannel;
    private Selector readSelector;
    private Selector writeSelector;
    private SelectionKey readSelectionKey;
    private SelectionKey writeSelectionKey;
    private ByteBuffer receiveBuffer;
    private InetAddress remoteAddress;
    private int localport;
    private int remoteport;
    private InputStream inputStreamHelper;
    private OutputStream outputStreamHelper;

    public AcceptedConnection(SocketChannel socketChannel) throws IOException {
        this.socketChannel = socketChannel;
        this.receiveBuffer = ByteBuffer.allocateDirect(262144);
        this.localport = socketChannel.socket().getLocalPort();
        this.remoteport = socketChannel.socket().getPort();
        this.remoteAddress = socketChannel.socket().getInetAddress();
        int socksize = 0;
        Socket socket = socketChannel.socket();
        socksize = socket.getReceiveBufferSize();
        while (socksize < 0x1000000) {
            socket.setReceiveBufferSize(socksize *= 2);
            if (socksize == socket.getReceiveBufferSize()) continue;
        }
        socksize = socket.getSendBufferSize();
        while (socksize < 0x1000000) {
            socket.setSendBufferSize(socksize *= 2);
            if (socksize == socket.getSendBufferSize()) continue;
        }
        try {
            this.socketChannel.configureBlocking(false);
        }
        catch (IOException e) {
            EventService.publishEvent(PrivateError.class, "Cannot set blocking mode", this, this.socketChannel, e);
        }
        this.readSelector = Selector.open();
        this.writeSelector = Selector.open();
        this.readSelectionKey = socketChannel.register(this.readSelector, 1);
        this.writeSelectionKey = socketChannel.register(this.writeSelector, 4);
        this.receiveBuffer.flip();
    }

    public void close() {
        if (this.readSelectionKey != null) {
            this.readSelectionKey.cancel();
        }
        if (this.writeSelectionKey != null) {
            this.writeSelectionKey.cancel();
        }
        if (this.readSelector != null) {
            try {
                this.readSelector.close();
            }
            catch (IOException discard) {
                // empty catch block
            }
        }
        if (this.writeSelector != null) {
            try {
                this.writeSelector.close();
            }
            catch (IOException discard) {
                // empty catch block
            }
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public InputStream getInputStream() {
        if (this.inputStreamHelper == null) {
            this.inputStreamHelper = new InputStream(){
                private byte[] markedRead;
                private int markPosition;
                private boolean marking;

                public int available() {
                    int available = 0;
                    if (!this.marking && this.markedRead != null && this.markPosition < this.markedRead.length) {
                        available += this.markedRead.length - this.markPosition;
                    }
                    return available += AcceptedConnection.this.available();
                }

                public int read() throws IOException {
                    if (this.marking) {
                        int b = AcceptedConnection.this.read();
                        if (this.markPosition < this.markedRead.length) {
                            this.markedRead[this.markPosition++] = (byte)b;
                        }
                        return b;
                    }
                    if (this.markedRead != null) {
                        if (this.markPosition < this.markedRead.length) {
                            return this.markedRead[this.markPosition++];
                        }
                        this.markedRead = null;
                        this.markPosition = 0;
                    }
                    return AcceptedConnection.this.read();
                }

                public void mark(int limit) {
                    this.markedRead = new byte[limit];
                    this.markPosition = 0;
                    this.marking = true;
                }

                public void reset() {
                    this.markPosition = 0;
                    this.marking = false;
                }
            };
        }
        return this.inputStreamHelper;
    }

    public OutputStream getOutputStream() {
        if (this.outputStreamHelper == null) {
            this.outputStreamHelper = new OutputStream(){

                public void write(int b) throws IOException {
                    AcceptedConnection.this.write(b);
                }

                public void write(byte[] buffer, int offset, int length) throws IOException {
                    AcceptedConnection.this.write(buffer, offset, length);
                }
            };
        }
        return this.outputStreamHelper;
    }

    public ByteBuffer getBuffer() {
        return this.receiveBuffer;
    }

    public void setBuffer(ByteBuffer buffer) {
        this.receiveBuffer = buffer;
    }

    private int readMore() throws IOException {
        if (this.receiveBuffer.remaining() != 0) {
            return this.receiveBuffer.remaining();
        }
        this.receiveBuffer.clear();
        try {
            this.waitForReadReady();
        }
        catch (Throwable closed) {
            return -1;
        }
        int bytesRead = this.socketChannel.read(this.receiveBuffer);
        this.receiveBuffer.flip();
        return bytesRead;
    }

    private void waitForReadReady() throws ClosedChannelException {
        try {
            this.readSelector.select();
            Iterator<SelectionKey> iterator = this.readSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int available() {
        if (this.receiveBuffer.hasRemaining()) {
            return this.receiveBuffer.remaining();
        }
        int avail = 0;
        try {
            avail = this.readSelector.selectNow();
            Iterator<SelectionKey> iterator = this.readSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            if (avail != 0) {
                avail = this.readMore();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return avail;
    }

    public int peek() throws IOException {
        this.ensureReadCapacity(1);
        int position = this.receiveBuffer.position();
        int peek = -1;
        peek = this.receiveBuffer.get(position);
        return peek;
    }

    public ByteBuffer slice(int length) throws IOException {
        if (this.ensureReadCapacity(length) == -1) {
            return null;
        }
        ByteBuffer slice = this.receiveBuffer.slice();
        slice.limit(length);
        this.receiveBuffer.position(this.receiveBuffer.position() + length);
        return slice;
    }

    public ByteBuffer peek(int length) throws IOException {
        if (this.ensureReadCapacity(length) == -1) {
            return null;
        }
        ByteBuffer slice = this.receiveBuffer.slice();
        slice.limit(length);
        return slice;
    }

    protected int ensureReadCapacity(int length) throws IOException {
        while (this.receiveBuffer.remaining() < length) {
            this.receiveBuffer.compact();
            try {
                this.waitForReadReady();
            }
            catch (ClosedChannelException closed) {
                return -1;
            }
            int bytesRead = this.socketChannel.read(this.receiveBuffer);
            if (bytesRead == -1) {
                return -1;
            }
            this.receiveBuffer.flip();
        }
        return this.receiveBuffer.remaining();
    }

    public int read() throws IOException {
        if (this.receiveBuffer.remaining() == 0) {
            this.readMore();
        }
        return this.receiveBuffer.get();
    }

    public int read(byte[] dst) throws IOException {
        return this.read(dst, 0, dst.length);
    }

    public int read(byte[] dst, int offset, int length) throws IOException {
        if (this.receiveBuffer.remaining() == 0) {
            this.readMore();
        }
        this.ensureReadCapacity(length - offset);
        int start = this.receiveBuffer.position();
        this.receiveBuffer.get(dst, offset, length);
        return this.receiveBuffer.position() - start;
    }

    public String readLine() throws IOException {
        int position = this.receiveBuffer.position();
        int remaining = this.receiveBuffer.remaining();
        if (remaining == 0) {
            if (this.readMore() != -1) {
                return this.readLine();
            }
            return null;
        }
        byte[] holding = new byte[Math.min(remaining, 4096)];
        this.receiveBuffer.get(holding);
        int index = 0;
        while (holding[index++] != 10 && index < holding.length) {
        }
        if (index >= holding.length && holding.length == 4096) {
            return null;
        }
        if (index > holding.length) {
            this.receiveBuffer.clear();
            this.receiveBuffer.put(holding);
            int bytesRead = this.socketChannel.read(this.receiveBuffer);
            if (bytesRead == -1) {
                return null;
            }
            this.receiveBuffer.flip();
            return this.readLine();
        }
        this.receiveBuffer.position(index + position);
        String response = new String(holding, 0, index);
        response = response.trim();
        return response;
    }

    public int write(int b) throws IOException {
        return this.write(new byte[]{(byte)b});
    }

    public int write(byte[] b) throws IOException {
        return this.write(b, 0, b.length);
    }

    public int write(byte[] b, int offset, int length) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(b, offset, length);
        int written = 0;
        while (buffer.hasRemaining()) {
            this.writeSelector.select();
            written += this.socketChannel.write(buffer);
            Iterator<SelectionKey> iterator = this.writeSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        return written;
    }

    public long write(ByteBuffer[] gather) throws IOException {
        this.writeSelector.select();
        long written = this.socketChannel.write(gather);
        Iterator<SelectionKey> iterator = this.writeSelector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        for (ByteBuffer buffer : gather) {
            while (buffer.hasRemaining()) {
                this.writeSelector.select();
                written += (long)this.socketChannel.write(buffer);
                iterator = this.writeSelector.selectedKeys().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
        }
        return written;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("AcceptedConnection from ");
        b.append(this.remoteAddress.getCanonicalHostName());
        b.append(":");
        b.append(this.remoteport);
        b.append(" => ");
        b.append(this.localport);
        return b.toString();
    }
}

