/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.event;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.StreamType;
import com.signiant.jsf.services.event.events.DataTransmission;
import java.io.IOException;
import java.io.OutputStream;

public class InstrumentedOutputStream
extends OutputStream {
    private Object owner;
    private StreamType type;
    private OutputStream output;
    private long bytesTransferred;
    private String id;
    private long startedTime;
    private Thread writer;
    private boolean interrupted;

    public InstrumentedOutputStream(OutputStream output, StreamType type, Object owner) {
        this(output, type, owner, null);
    }

    public InstrumentedOutputStream(OutputStream output, StreamType type, Object owner, String id) {
        this.output = output;
        this.bytesTransferred = 0L;
        this.startedTime = System.currentTimeMillis();
        this.type = type;
        this.owner = owner;
        this.id = id;
        this.interrupted = false;
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    public long getBytesPerSecond() {
        return this.bytesTransferred / ((System.currentTimeMillis() - this.startedTime) / 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int arg0) throws IOException {
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            if (this.interrupted) {
                return;
            }
            this.writer = Thread.currentThread();
        }
        this.output.write(arg0);
        this.writer = null;
        ++this.bytesTransferred;
        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, 1, this.bytesTransferred, arg0});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            this.writer = Thread.currentThread();
        }
        this.output.close();
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            if (this.interrupted) {
                return;
            }
            this.writer = Thread.currentThread();
        }
        this.output.flush();
        this.writer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] arg0, int arg1, int arg2) throws IOException {
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            if (this.interrupted) {
                return;
            }
            this.writer = Thread.currentThread();
        }
        this.output.write(arg0, arg1, arg2);
        this.writer = null;
        this.bytesTransferred += (long)(arg2 - arg1);
        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, arg2 - arg1, this.bytesTransferred, arg0, arg1, arg2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] arg0) throws IOException {
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            if (this.interrupted) {
                return;
            }
            this.writer = Thread.currentThread();
        }
        this.output.write(arg0);
        this.writer = null;
        this.bytesTransferred += (long)arg0.length;
        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.TRANSMIT, arg0.length, this.bytesTransferred, arg0, 0, arg0.length});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Thread blocker = null;
        InstrumentedOutputStream instrumentedOutputStream = this;
        synchronized (instrumentedOutputStream) {
            this.interrupted = true;
            blocker = this.writer;
        }
        if (blocker != null) {
            blocker.interrupt();
        }
    }

    public String toString() {
        return (Object)((Object)this.type) + " output stream " + this.output.hashCode() + " " + this.owner + (this.id == null ? "" : " " + this.id);
    }
}

