/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.event;

import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.StreamType;
import com.signiant.jsf.services.event.events.DataTransmission;
import java.io.IOException;
import java.io.InputStream;

public class InstrumentedInputStream
extends InputStream {
    private Object owner;
    private StreamType type;
    private InputStream input;
    private long bytesTransferred;
    private String id;
    private long startedTime;
    private Thread reader;
    private boolean interrupted;

    public InstrumentedInputStream() {
    }

    public InstrumentedInputStream(InputStream input, StreamType type, Object owner) {
        this(input, type, owner, null);
    }

    public InstrumentedInputStream(InputStream input, StreamType type, Object owner, String id) {
        this.input = input;
        this.bytesTransferred = 0L;
        this.startedTime = System.currentTimeMillis();
        this.type = type;
        this.owner = owner;
        this.id = id;
        this.interrupted = false;
    }

    public long getBytesPerSecond() {
        return this.bytesTransferred / ((System.currentTimeMillis() - this.startedTime) / 1000L);
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public long getBytesTransferred() {
        return this.bytesTransferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        InstrumentedInputStream instrumentedInputStream = this;
        synchronized (instrumentedInputStream) {
            if (this.interrupted) {
                return -1;
            }
            this.reader = Thread.currentThread();
        }
        int c = this._read();
        this.reader = null;
        ++this.bytesTransferred;
        EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, c});
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        byte[] buffer = new byte[8192];
        String line = null;
        int index = 0;
        boolean first = true;
        block7: while (index < buffer.length) {
            InstrumentedInputStream instrumentedInputStream = this;
            synchronized (instrumentedInputStream) {
                if (this.interrupted) {
                    return null;
                }
                this.reader = Thread.currentThread();
            }
            int byteRead = this._read();
            this.reader = null;
            switch (byteRead) {
                case -1: {
                    if (index == 0) {
                        return null;
                    }
                    line = new String(buffer, 0, index).trim();
                    this.bytesTransferred += (long)index;
                    EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, line});
                    return line;
                }
                case 10: {
                    if (index == 0 && first) {
                        first = false;
                        continue block7;
                    }
                    line = new String(buffer, 0, index).trim();
                    this.bytesTransferred += (long)index;
                    EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, 1, this.bytesTransferred, line});
                    return line;
                }
            }
            buffer[index++] = (byte)byteRead;
        }
        return null;
    }

    public int available() throws IOException {
        return this.input.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        InstrumentedInputStream instrumentedInputStream = this;
        synchronized (instrumentedInputStream) {
            this.reader = Thread.currentThread();
        }
        this.input.close();
        this.reader = null;
    }

    public synchronized void mark(int readlimit) {
        this.input.mark(readlimit);
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        InstrumentedInputStream instrumentedInputStream = this;
        synchronized (instrumentedInputStream) {
            if (this.interrupted) {
                return -1;
            }
            this.reader = Thread.currentThread();
        }
        int count = this._read(b, off, len);
        this.reader = null;
        if (count >= 0) {
            this.bytesTransferred += (long)count;
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, count, this.bytesTransferred, b, off, len});
        } else {
            EventService.publishEvent(DataTransmission.class, new Object[]{this, DataTransmission.Direction.RECEIVE, count, this.bytesTransferred});
        }
        return count;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        this.input.reset();
    }

    public long skip(long n) throws IOException {
        return this.input.skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Thread blocker = null;
        InstrumentedInputStream instrumentedInputStream = this;
        synchronized (instrumentedInputStream) {
            this.interrupted = true;
            blocker = this.reader;
        }
        if (blocker != null) {
            blocker.interrupt();
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    protected int _read() throws IOException {
        while (this.available() == 0 && !this.isInterrupted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.isInterrupted()) {
            return -1;
        }
        return this.input.read();
    }

    protected int _read(byte[] b, int off, int len) throws IOException {
        int available = 0;
        while ((available = this.input.available()) == 0 && !this.isInterrupted()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException discard) {}
        }
        if (this.isInterrupted()) {
            return -1;
        }
        return this.input.read(b, off, Math.min(available, len));
    }

    public String toString() {
        return (Object)((Object)this.type) + " input stream " + this.input + " " + this.owner + (this.id == null ? "" : " " + this.id);
    }
}

