/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.event;

import com.signiant.jsf.BootStrap;
import com.signiant.jsf.services.Service;
import com.signiant.jsf.services.event.Event;
import com.signiant.jsf.services.event.EventListener;
import com.signiant.jsf.services.event.EventMask;
import com.signiant.jsf.services.event.events.PrivateError;
import java.util.HashMap;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventService
implements Service {
    private HashMap<EventListener, EventDispatcher> eventListeners;
    private HashMap<EventListener, Vector<Class<?>>> eventMasks;
    private HashMap<Class<?>, Integer> eventSubscription;
    private Vector<Event> initialEvents;
    private boolean initialCollection;
    private static EventService eventService;

    public static void publishEvent(Class<?> base, Object ... eventInfo) {
        if (eventService != null) {
            eventService._publishEvent(base, eventInfo);
        } else {
            eventService = (EventService)BootStrap.getInstance().getService(EventService.class);
            if (eventService != null) {
                eventService._publishEvent(base, eventInfo);
            } else {
                System.err.println(eventInfo);
            }
        }
        if (base == PrivateError.class && eventInfo.length > 0 && eventInfo[0] instanceof OutOfMemoryError) {
            try {
                BootStrap.getInstance().stopServices();
                Thread.sleep(5000L);
                System.exit(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void _publishEvent(Class<?> base, Object ... eventInfo) {
        if (!this.initialCollection && this.eventSubscription.get(base) == null) {
            return;
        }
        try {
            Event.Type type = (Event.Type)((Object)base.getField("type").get(base));
            Event.Severity severity = (Event.Severity)((Object)base.getField("severity").get(base));
            Event event = new Event(base, type, severity, eventInfo);
            if (this.initialCollection) {
                this.initialEvents.add(event);
            } else {
                this.publishEvent(event);
            }
        }
        catch (SecurityException discard) {
        }
        catch (NoSuchFieldException discard) {
        }
        catch (IllegalArgumentException discard) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishEvent(Event event) {
        HashMap<EventListener, EventDispatcher> hashMap = this.eventListeners;
        synchronized (hashMap) {
            for (EventListener listener : this.eventListeners.keySet()) {
                EventDispatcher dispatcher = this.eventListeners.get(listener);
                if (dispatcher == null) continue;
                dispatcher.add(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed(EventListener listener) {
        boolean result = false;
        HashMap<EventListener, EventDispatcher> hashMap = this.eventListeners;
        synchronized (hashMap) {
            EventDispatcher exists = this.eventListeners.get(listener);
            if (listener != null && exists != null) {
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(EventListener listener, EventMask eventMask) {
        HashMap<EventListener, EventDispatcher> hashMap = this.eventListeners;
        synchronized (hashMap) {
            Integer n;
            EventDispatcher old = this.eventListeners.get(listener);
            if (old != null) {
                Vector<Class<?>> oldMask = this.eventMasks.get(listener);
                for (Class<?> e : oldMask) {
                    Integer i = this.eventSubscription.get(e);
                    if (i == null) continue;
                    n = i;
                    Integer n2 = i = Integer.valueOf(i - 1);
                    if (i != 0) continue;
                    this.eventSubscription.remove(e);
                }
            } else {
                this.eventListeners.put(listener, new EventDispatcher(listener));
            }
            if (eventMask != null) {
                for (Class<?> e : eventMask.getEventMask()) {
                    Integer i = this.eventSubscription.get(e);
                    if (i != null) {
                        Integer n3 = i;
                        n = i = Integer.valueOf(i + 1);
                        continue;
                    }
                    this.eventSubscription.put(e, new Integer(1));
                }
                this.eventMasks.put(listener, eventMask.getEventMask());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribe(EventListener listener) {
        EventDispatcher old = null;
        HashMap<EventListener, EventDispatcher> hashMap = this.eventListeners;
        synchronized (hashMap) {
            Vector<Class<?>> oldMask = this.eventMasks.get(listener);
            if (oldMask != null) {
                for (Class<?> e : oldMask) {
                    Integer i = this.eventSubscription.get(e);
                    if (i == null) continue;
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i - 1);
                    if (i != 0) continue;
                    this.eventSubscription.remove(e);
                }
            }
            old = this.eventListeners.remove(listener);
            this.eventMasks.remove(listener);
        }
        if (old != null) {
            old.stop();
        }
    }

    @Override
    public void init() {
        this.eventListeners = new HashMap();
        this.eventSubscription = new HashMap();
        this.eventMasks = new HashMap();
        eventService = this;
        this.initialEvents = new Vector();
        this.initialCollection = true;
    }

    @Override
    public void pause() {
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPublishing() {
        this.initialCollection = false;
        Vector<Event> vector = this.initialEvents;
        synchronized (vector) {
            if (this.initialEvents.size() != 0) {
                for (Event e : this.initialEvents) {
                    this.publishEvent(e);
                }
                this.initialEvents.clear();
            }
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public void healthCheck() {
    }

    @Override
    public String getAdvertisedCapability() {
        return this.getClass().getSimpleName();
    }

    private class EventDispatcher {
        private BlockingQueue<Event> eventQueue = new LinkedBlockingQueue<Event>();
        private EventListener listener;
        private Thread eventPublisher;
        private boolean running;

        EventDispatcher(EventListener listener) {
            this.listener = listener;
            this.running = true;
            this.eventPublisher = new Thread("Event publisher: " + listener){

                public void run() {
                    EventDispatcher.this.publishEvents();
                }
            };
            this.eventPublisher.setDaemon(true);
            this.eventPublisher.start();
        }

        private void add(Event event) {
            Vector mask = (Vector)EventService.this.eventMasks.get(this.listener);
            if (mask.contains(event.getBase())) {
                this.eventQueue.add(event);
            }
        }

        private void stop() {
            this.running = false;
            this.eventPublisher.interrupt();
            this.eventQueue.clear();
        }

        private void publishEvents() {
            while (this.running) {
                try {
                    this.listener.eventOccured(this.eventQueue.take());
                }
                catch (InterruptedException e) {
                    this.running = false;
                    break;
                }
                catch (Throwable throwable) {
                }
            }
        }
    }
}

