/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf.services.event;

import com.signiant.jsf.services.event.events.DataTransmission;
import java.net.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event {
    private Class<?> base;
    private Type type;
    private Severity severity;
    private StackTraceElement[] backtrace;
    private String threadName;
    private Object[] details;
    private long time;
    private long nanos = System.nanoTime();

    public Event(Class<?> base, Type type, Severity severity, Object[] details) {
        this.time = System.currentTimeMillis();
        this.base = base;
        this.type = type;
        this.severity = severity;
        StackTraceElement[] fullbacktrace = Thread.currentThread().getStackTrace();
        this.backtrace = new StackTraceElement[fullbacktrace.length - 2];
        System.arraycopy(fullbacktrace, 2, this.backtrace, 0, this.backtrace.length);
        this.threadName = Thread.currentThread().getName();
        this.details = (Object[])details.clone();
        int i = 0;
        for (Object o : this.details) {
            if (o instanceof byte[]) {
                int size = ((byte[])o).length;
                this.details[i] = new byte[size];
                System.arraycopy(details[i], 0, this.details[i], 0, size);
            }
            ++i;
        }
    }

    public Type getType() {
        return this.type;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Class<?> getBase() {
        return this.base;
    }

    public StackTraceElement getCaller() {
        String stackClassName;
        int backtraceIndex;
        String myName = this.getClass().getPackage().getName();
        for (backtraceIndex = 0; backtraceIndex < this.backtrace.length && !(stackClassName = this.backtrace[backtraceIndex].getClassName()).startsWith(myName); ++backtraceIndex) {
        }
        while (backtraceIndex < this.backtrace.length && (stackClassName = this.backtrace[backtraceIndex].getClassName()).startsWith(myName)) {
            ++backtraceIndex;
        }
        return this.backtrace[backtraceIndex];
    }

    public StackTraceElement[] getBacktrace() {
        return this.backtrace;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public Object[] getDetails() {
        return this.details;
    }

    public long getTime() {
        return this.time;
    }

    public long getNanos() {
        return this.nanos;
    }

    public String toString() {
        if (this.details == null) {
            return (Object)((Object)this.getSeverity()) + ": " + (Object)((Object)this.getType());
        }
        StringBuffer a = new StringBuffer();
        a.append(this.getSeverity().toString());
        a.append(" ");
        a.append(this.base.getSimpleName());
        a.append(" (");
        a.append(this.getCaller().getFileName());
        a.append(":");
        a.append(this.getCaller().getLineNumber());
        a.append(")");
        if (this.base == DataTransmission.class) {
            a.append("\n  ==> ");
            a.append(this.getDetails()[0]);
            a.append("\n  ==> ");
            a.append(this.getDetails()[1]);
            a.append("\n  ==> Current: ");
            a.append(this.getDetails()[2]);
            a.append("\n  ==> Total: ");
            a.append(this.getDetails()[3]);
            if (this.getDetails().length == 5) {
                a.append("\n  ==> [");
                if (this.getDetails()[4] instanceof byte[]) {
                    a.append(new String((byte[])this.getDetails()[4]));
                } else {
                    a.append(this.getDetails()[4]);
                }
                a.append("]");
            }
            if (this.getDetails().length == 7) {
                a.append("\n  ==> [");
                a.append(new String((byte[])this.getDetails()[4], (int)((Integer)this.getDetails()[5]), Math.min((Integer)this.getDetails()[6], 64)));
                a.append("]");
            }
        } else {
            for (Object o : this.getDetails()) {
                a.append("\n  ==> ");
                a.append(Event.prettyPrint(o));
            }
        }
        return a.toString();
    }

    public static String prettyPrint(Object o) {
        if (o == null) {
            return "<null>";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Socket) {
            return "Socket: " + ((Socket)o).getLocalSocketAddress() + ":" + ((Socket)o).getLocalPort() + "->" + ((Socket)o).getRemoteSocketAddress() + ":" + ((Socket)o).getPort();
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof Throwable) {
            return o.toString();
        }
        return o.getClass().getSimpleName() + ": " + o.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        SEVERE,
        ERROR,
        WARNING,
        INFO,
        FINE,
        FINER,
        FINEST;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STATUS,
        DATA,
        PROBLEM;

    }
}

