/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.jsf;

import com.signiant.jsf.services.Service;
import com.signiant.jsf.services.event.EventService;
import com.signiant.jsf.services.event.events.PrivateError;
import com.signiant.jsf.services.event.events.ServiceStarted;
import com.signiant.jsf.services.event.events.ServiceStopped;
import com.signiant.jsf.services.event.events.StdErrEvent;
import com.signiant.jsf.services.event.events.StdOutEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootStrap {
    private HashMap<String, Service> services;
    private HashMap<String, String> properties = new HashMap();
    private static BootStrap bootstrapInstance;
    private static final String IO_TO_EVENT = "com.signiant.jsf.stdio";
    public static final String SUBSYSTEM = "com.signiant.jsf.subsystem";
    private static final String EVENT_SERVICE = "com.signiant.jsf.services.event.EventService";
    public static final String DEFAULT_PROPERTY_FILENAME = "jsf.properties";

    public static void main(String[] args) {
        try {
            String properties = DEFAULT_PROPERTY_FILENAME;
            if (args.length > 0) {
                properties = args[0];
            }
            bootstrapInstance = new BootStrap(properties);
            if (args.length > 1) {
                for (int i = 1; i < args.length; ++i) {
                    bootstrapInstance.addProperty(args[i]);
                }
            }
            bootstrapInstance.startServices();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public BootStrap() {
        this.services = new HashMap();
        bootstrapInstance = this;
    }

    public BootStrap(String propertiesFilename) throws IOException {
        this();
        this.loadService(EVENT_SERVICE);
        this.loadProperties(propertiesFilename);
        String outputToEvent = this.properties.get(IO_TO_EVENT);
        if (outputToEvent != null && outputToEvent.equalsIgnoreCase("event")) {
            System.setOut(new PrintStream(new EventOutputStream(StdOutEvent.class), true));
            System.setErr(new PrintStream(new EventOutputStream(StdErrEvent.class), true));
            System.out.println("Redirected system out and error to event service");
        }
    }

    public static synchronized BootStrap getInstance() {
        if (bootstrapInstance == null) {
            bootstrapInstance = new BootStrap();
        }
        return bootstrapInstance;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Service getService(Class<?> capability) {
        String capabilityDescription = capability.getSimpleName();
        return this.getServiceByCapability(capabilityDescription);
    }

    public Service getServiceByCapability(String capabilityDescription) {
        for (Map.Entry<String, Service> service : this.services.entrySet()) {
            if (!service.getValue().getAdvertisedCapability().equals(capabilityDescription)) continue;
            return service.getValue();
        }
        return null;
    }

    public Set<String> getServices() {
        return this.services.keySet();
    }

    public List<String> getCapabilities() {
        LinkedList<String> capabilities = new LinkedList<String>();
        for (Map.Entry<String, Service> service : this.services.entrySet()) {
            capabilities.add(service.getValue().getAdvertisedCapability());
        }
        return capabilities;
    }

    public void addProperty(String propertyLine) {
        if (propertyLine.startsWith("#")) {
            return;
        }
        if (propertyLine.indexOf(61) == -1) {
            return;
        }
        String key = propertyLine.substring(0, propertyLine.indexOf(61));
        String value = propertyLine.substring(propertyLine.indexOf(61) + 1);
        if (key.equals("com.signiant.jsf.loadService")) {
            this.loadService(value);
        } else {
            this.properties.put(key, value);
        }
    }

    protected void loadProperties(String propertiesFilename) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(propertiesFilename));
        String line = null;
        while ((line = in.readLine()) != null) {
            this.addProperty(line);
        }
        String fullname = new File(propertiesFilename).getName();
        String basename = fullname.substring(0, fullname.lastIndexOf(46));
        this.properties.put(SUBSYSTEM, basename);
    }

    public void loadService(String serviceName) {
        if (this.services.get(serviceName) != null) {
            return;
        }
        try {
            Class<?> serviceClass = Class.forName(serviceName);
            Object serviceObject = serviceClass.newInstance();
            if (serviceObject instanceof Service) {
                Service service = (Service)serviceObject;
                service.init();
                this.services.put(serviceName, service);
            }
        }
        catch (Throwable t) {
            EventService.publishEvent(PrivateError.class, t);
        }
    }

    public void startServices() {
        for (Service service : this.services.values()) {
            try {
                service.start();
            }
            catch (Throwable t) {
                EventService.publishEvent(PrivateError.class, ServiceStarted.class, service, t);
            }
            EventService.publishEvent(ServiceStarted.class, service);
        }
        EventService es = (EventService)this.getServiceByCapability("EventService");
        es.startPublishing();
    }

    public void stopServices() {
        for (Service service : this.services.values()) {
            try {
                service.stop();
            }
            catch (Throwable t) {
                EventService.publishEvent(PrivateError.class, ServiceStopped.class, service, t);
            }
            EventService.publishEvent(ServiceStopped.class, service);
        }
    }

    public static Class<?>[] getClassesFromJar(URL url, String packageName) {
        ArrayList classes = new ArrayList();
        try {
            packageName = packageName.replaceAll("\\.", "/");
            URL jarUrl = new URL("jar:" + url + "!/");
            JarURLConnection conn = (JarURLConnection)jarUrl.openConnection();
            JarFile jar = conn.getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(packageName)) continue;
                try {
                    String name = entry.getName();
                    if (!name.endsWith(".class") || name.indexOf("$") != -1) continue;
                    name = name.substring(0, name.length() - 6).replaceAll("/", ".");
                    classes.add(Class.forName(name));
                }
                catch (ClassNotFoundException discard) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class<?>[] getClassesFromFilesystem(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        assert (classLoader != null);
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile().replaceAll("%20", " ")));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(BootStrap.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static List<Class<?>> findClasses(File directory, String packageName) throws ClassNotFoundException {
        File[] files;
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        for (File file : files = directory.listFiles()) {
            if (file.isDirectory()) {
                assert (!file.getName().contains("."));
                classes.addAll(BootStrap.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class") || file.getName().indexOf("$") != -1) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EventOutputStream
    extends ByteArrayOutputStream {
        private String lineSeparator = System.getProperty("line.separator");
        private Class<?> baseEventClass;

        EventOutputStream(Class<?> base) {
            this.baseEventClass = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            EventOutputStream eventOutputStream = this;
            synchronized (eventOutputStream) {
                super.flush();
                String record = this.toString();
                super.reset();
                if (record.length() != 0 && !record.equals(this.lineSeparator)) {
                    EventService.publishEvent(this.baseEventClass, record);
                }
            }
        }
    }
}

