/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth;

import com.signiant.interactivetransfer.engine.resourcemanagement.ResourceNotDefinedException;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResource;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.InitiatorResourceBandwidthMap;
import com.signiant.mobilize.ddsclient.messagebus.DdsBandwidthCommandType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceBandwidthMap {
    protected String slaveName;
    protected HashMap<String, InitiatorResourceBandwidthMap> initiatorResourceMap;
    protected BandwidthResource prioritizedBandwidth = null;

    public ResourceBandwidthMap(String slaveAgent) {
        this.slaveName = slaveAgent;
        this.initiatorResourceMap = new HashMap();
    }

    public String getSlaveAgentName() {
        return this.slaveName;
    }

    public synchronized void addBandwidthResource(BandwidthResource resource) {
        String initiatorId = resource.getCommandInitiator();
        if (this.initiatorResourceMap.containsKey(initiatorId)) {
            this.initiatorResourceMap.get(initiatorId).addBandwidthResource(resource);
        } else {
            InitiatorResourceBandwidthMap initiatorMap = this.getInitiatorResourceMap(initiatorId);
            initiatorMap.addBandwidthResource(resource);
            this.initiatorResourceMap.put(initiatorId, initiatorMap);
        }
        this.prioritizedBandwidth = null;
    }

    public synchronized boolean removeBandwidthResource(BandwidthResource resource) {
        String initiatorId = resource.getCommandInitiator();
        boolean bwHasBeenRemoved = false;
        if (this.initiatorResourceMap.containsKey(initiatorId)) {
            bwHasBeenRemoved = this.initiatorResourceMap.get(initiatorId).removeBandwidthResource(resource);
        }
        this.prioritizedBandwidth = null;
        return bwHasBeenRemoved;
    }

    public synchronized void prioritizeResources() {
        ArrayList<BandwidthResource> bandwidthEntries = new ArrayList<BandwidthResource>();
        Iterator<Map.Entry<String, InitiatorResourceBandwidthMap>> iter = this.initiatorResourceMap.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                InitiatorResourceBandwidthMap sourceMap = iter.next().getValue();
                sourceMap.prioritizeResources();
                bandwidthEntries.add(sourceMap.getPriorityBandwidthResource());
            }
            catch (ResourceNotDefinedException resourceNotDefinedException) {}
        }
        this.prioritizedBandwidth = this.prioritizeBandwidth(bandwidthEntries);
    }

    public synchronized BandwidthResource getPriorityBandwidth() throws ResourceNotDefinedException {
        if (this.prioritizedBandwidth == null) {
            this.prioritizeResources();
        }
        if (this.prioritizedBandwidth == null) {
            throw new ResourceNotDefinedException();
        }
        return this.prioritizedBandwidth;
    }

    public List<BandwidthResource> getBandwidthResourceByType(DdsBandwidthCommandType commandType) {
        ArrayList<BandwidthResource> bandwidthResource = new ArrayList<BandwidthResource>();
        Iterator<Map.Entry<String, InitiatorResourceBandwidthMap>> iter = this.initiatorResourceMap.entrySet().iterator();
        while (iter.hasNext()) {
            InitiatorResourceBandwidthMap sourceMap = iter.next().getValue();
            bandwidthResource.addAll(sourceMap.getBandwidthResourceByType(commandType));
        }
        return bandwidthResource;
    }

    protected InitiatorResourceBandwidthMap getInitiatorResourceMap(String initiatorName) {
        return new InitiatorResourceBandwidthMap(initiatorName);
    }

    protected BandwidthResource prioritizeBandwidth(ArrayList<BandwidthResource> bandwidthEntries) {
        BandwidthResource priorityBandwidth = null;
        for (BandwidthResource nextResource : bandwidthEntries) {
            if (priorityBandwidth == null) {
                priorityBandwidth = nextResource;
            }
            if (nextResource.getCommandType().equals((Object)DdsBandwidthCommandType.MANUAL_JOB)) continue;
            if (priorityBandwidth.getCommandType().equals((Object)DdsBandwidthCommandType.MANUAL_JOB)) {
                priorityBandwidth = nextResource;
                continue;
            }
            if (priorityBandwidth.getBandwidthThrottle() == nextResource.getBandwidthThrottle()) {
                priorityBandwidth = nextResource;
                continue;
            }
            if (nextResource.getBandwidthThrottle() > BandwidthResource.UnlimitedThrottle && nextResource.getBandwidthThrottle() < priorityBandwidth.getBandwidthThrottle()) {
                priorityBandwidth = nextResource;
                continue;
            }
            if (priorityBandwidth.getBandwidthThrottle() != BandwidthResource.UnlimitedThrottle) continue;
            priorityBandwidth = nextResource;
        }
        return priorityBandwidth;
    }
}

