/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth;

import com.signiant.interactivetransfer.engine.resourcemanagement.ResourceNotDefinedException;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResource;
import com.signiant.mobilize.ddsclient.messagebus.DdsBandwidthCommandType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InitiatorResourceBandwidthMap {
    protected String initiatorName;
    protected ArrayList<BandwidthResource> resourceMap;

    InitiatorResourceBandwidthMap(String name) {
        this.initiatorName = name;
        this.resourceMap = new ArrayList();
    }

    String getInitiatorName() {
        return this.initiatorName;
    }

    public void addBandwidthResource(BandwidthResource resource) {
        if (this.resourceMap.contains(resource)) {
            this.resourceMap.remove(resource);
        }
        this.resourceMap.add(resource);
    }

    public boolean removeBandwidthResource(BandwidthResource resource) {
        return this.resourceMap.remove(resource);
    }

    void prioritizeResources() {
        Collections.sort(this.resourceMap);
    }

    public BandwidthResource getPriorityBandwidthResource() throws ResourceNotDefinedException {
        if (this.resourceMap.isEmpty()) {
            throw new ResourceNotDefinedException();
        }
        this.prioritizeResources();
        return this.resourceMap.get(0);
    }

    public List<BandwidthResource> getBandwidthResourceByType(DdsBandwidthCommandType commandType) {
        ArrayList<BandwidthResource> bwResourceList = new ArrayList<BandwidthResource>();
        if (!this.resourceMap.isEmpty()) {
            for (BandwidthResource currentBandwidthResource : this.resourceMap) {
                if (commandType != currentBandwidthResource.getCommandType()) continue;
                bwResourceList.add(currentBandwidthResource);
            }
        }
        return bwResourceList;
    }
}

