/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth;

import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.BandwidthResource;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.ClientBandwidthManualJob;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.ClientBandwidthManualOverride;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.ManagerBandwidthAutoAgent;
import com.signiant.interactivetransfer.engine.resourcemanagement.bandwidth.ManagerBandwidthManualOverride;
import com.signiant.mobilize.ddsclient.messagebus.DdsBandwidthCommandType;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BandwidthResourceFactory {
    public static final String MANAGERNAME = "managername";
    public static final String CMDSOURCE = "cmdsource";
    public static final String CMDTYPE = "commandtype";
    public static final String ISSUERNAME = "issuername";
    public static final String GUISOURCE = "GUI";
    public static final String THROTTLE = "throttle";
    private static BandwidthResourceFactory instance = new BandwidthResourceFactory();

    public static BandwidthResourceFactory getInstance() {
        return instance;
    }

    public BandwidthResource getBandwidthResource(HashMap<String, String> map) throws IllegalArgumentException {
        String managerName = map.get(MANAGERNAME);
        if (managerName == null) {
            managerName = "";
        }
        String commandSource = map.get(CMDSOURCE);
        String commandType = map.get(CMDTYPE);
        DdsBandwidthCommandType type = this.resolveCommandType(commandType, commandSource);
        String throttleString = map.get(THROTTLE);
        Long throttle = this.resolveThrottleValue(throttleString);
        String issuerName = commandSource;
        BandwidthResource bwResource = this.createBandwidthResource(managerName, type, issuerName, throttle);
        return bwResource;
    }

    public BandwidthResource getCTELocalManualOverride(HashMap<String, String> map) throws IllegalArgumentException {
        String managerName = map.get(MANAGERNAME);
        if (managerName == null) {
            managerName = "";
        }
        String issuerName = map.get(ISSUERNAME);
        String throttleString = map.get(THROTTLE);
        Long throttle = this.resolveThrottleValue(throttleString);
        ClientBandwidthManualOverride bwResource = new ClientBandwidthManualOverride(managerName, issuerName, throttle);
        return bwResource;
    }

    protected BandwidthResource createBandwidthResource(String managerName, DdsBandwidthCommandType type, String issuerName, Long throttle) throws IllegalArgumentException {
        BandwidthResource bwResource = null;
        if (type.equals((Object)DdsBandwidthCommandType.AUTO_AGENT)) {
            bwResource = new ManagerBandwidthAutoAgent(managerName, issuerName, throttle);
        } else if (type.equals((Object)DdsBandwidthCommandType.MANUAL_OVERRIDE)) {
            bwResource = new ManagerBandwidthManualOverride(managerName, issuerName, throttle);
        } else if (type.equals((Object)DdsBandwidthCommandType.MANUAL_JOB)) {
            bwResource = new ClientBandwidthManualJob(managerName, issuerName, throttle);
        } else {
            throw new IllegalArgumentException("Invalid command type specified " + (Object)((Object)type));
        }
        return bwResource;
    }

    protected Long resolveThrottleValue(String throttleString) throws IllegalArgumentException {
        Long throttle = BandwidthResource.UndefinedThrottle;
        if (throttleString == null || throttleString.length() == 0) {
            throw new IllegalArgumentException("unspecified throttle value");
        }
        try {
            throttle = Long.valueOf(throttleString);
        }
        catch (NumberFormatException exception) {
            throw new IllegalArgumentException("invalid throttle value: " + throttleString);
        }
        return throttle;
    }

    protected DdsBandwidthCommandType resolveCommandType(String commandType, String commandSource) throws IllegalArgumentException {
        DdsBandwidthCommandType type = commandType == null ? (commandSource.equalsIgnoreCase(GUISOURCE) ? DdsBandwidthCommandType.MANUAL_OVERRIDE : DdsBandwidthCommandType.AUTO_AGENT) : DdsBandwidthCommandType.getCommandType(commandType);
        if (type.equals((Object)DdsBandwidthCommandType.UNDEFINED)) {
            throw new IllegalArgumentException("Undefined command type received");
        }
        return type;
    }
}

