/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.remote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElementParser {
    public static String DDS = "dds";
    public static String RPC = "rpc";
    private Object[] tokens;
    private HashMap<String, String> parseResult = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized HashMap<String, String> parse(String s) {
        HashMap<String, String> resultSet = null;
        try {
            for (Object c : this.tokens) {
                ((Elements)c).match(s);
            }
            resultSet = new HashMap<String, String>(this.parseResult);
            return resultSet;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.parseResult.clear();
            throw throwable;
        }
    }

    public SimpleElementParser(String s) {
        ArrayList<Elements> list = new ArrayList<Elements>();
        if (DDS.equalsIgnoreCase(s)) {
            try {
                list.add(new TypeElement());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                list.add(new HeaderElement());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                list.add(new StatsElement());
            }
            catch (Exception e) {}
        } else if (RPC.equalsIgnoreCase(s)) {
            try {
                list.add(new OriginatorJIDElement());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                list.add(new RunReleasedElement());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                list.add(new MethodNameElement());
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                list.add(new NameValueElement());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tokens = list.toArray();
    }

    private class NameValueElement
    extends Elements {
        public NameValueElement() {
            super("<name>(\\w*)</name><value>([\\w[^<]]*)</value>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put(args[0], args[1]);
        }
    }

    private class MethodNameElement
    extends Elements {
        public MethodNameElement() {
            super("<methodName>(\\w*)</methodName>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("methodName", args[0]);
        }
    }

    private class RunReleasedElement
    extends Elements {
        public RunReleasedElement() {
            super("<run_released>(.*)</run_released>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("run_released", args[0]);
        }
    }

    private class OriginatorJIDElement
    extends Elements {
        public OriginatorJIDElement() {
            super("<originator_jid>(.*)</originator_jid>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("originator_jid", args[0]);
        }
    }

    private class StatsElement
    extends Elements {
        public StatsElement() {
            super("<stats>(.*)</stats>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("stats", args[0]);
        }
    }

    private class HeaderElement
    extends Elements {
        public HeaderElement() {
            super("<header>(.*)</header>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("header", args[0]);
        }
    }

    private class TypeElement
    extends Elements {
        public TypeElement() {
            super("<type>(\\d+)</type>");
        }

        public void perform(String cmd, String[] args) {
            SimpleElementParser.this.parseResult.put("type", args[0]);
        }
    }

    private abstract class Elements {
        private Pattern pattern;

        protected Elements(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public void match(String s) {
            Matcher matcher = this.pattern.matcher(s);
            while (matcher.find()) {
                int n = matcher.groupCount();
                String[] args = new String[n];
                for (int i = 0; i < n; ++i) {
                    args[i] = matcher.group(i + 1);
                }
                this.perform(s, args);
            }
        }

        public abstract void perform(String var1, String[] var2);
    }
}

