/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.remote;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleElement {
    private String tag = null;
    private String content = null;
    private Vector<SimpleElement> otherElments = new Vector();

    public static SimpleElement addMember(SimpleElement[] leaves) {
        if (leaves == null || leaves.length < 1) {
            return null;
        }
        SimpleElement value = null;
        SimpleElement struct = new SimpleElement("struct");
        for (SimpleElement leaf : leaves) {
            struct.addElement(leaf);
        }
        if (struct.getElementCount() > 0) {
            value = new SimpleElement("value");
            value.addElement(struct);
        }
        return value;
    }

    public static SimpleElement addMember(String name, SimpleElement value) {
        if (name == null || value == null) {
            return null;
        }
        SimpleElement member = new SimpleElement("member");
        member.addElement(new SimpleElement("name", name));
        member.addElement(value);
        return member;
    }

    public static SimpleElement addMember(String name, String value) {
        if (name == null || value == null) {
            return null;
        }
        SimpleElement member = new SimpleElement("member");
        member.addElement(new SimpleElement("name", name));
        member.addElement(new SimpleElement("value", value));
        return member;
    }

    public static SimpleElement addMember(String name, int value) {
        if (name == null) {
            return null;
        }
        SimpleElement member = new SimpleElement("member");
        member.addElement(new SimpleElement("name", name));
        SimpleElement val = new SimpleElement("value");
        member.addElement(val);
        val.addElement(new SimpleElement("int", Integer.toString(value)));
        return member;
    }

    public static String formatPayload(HashMap<String, String> payload, boolean quotable) {
        String result;
        StringWriter out = new StringWriter();
        if (!payload.isEmpty()) {
            String delimiter = "";
            for (String key : payload.keySet()) {
                String value = payload.get(key);
                if (value == null) continue;
                if (quotable) {
                    out.write(delimiter + key + "=\"" + value + "\"");
                } else {
                    out.write(delimiter + key + "=" + value);
                }
                if (payload.size() <= 1) continue;
                delimiter = " ";
            }
        }
        if ((result = out.toString()).length() == 0) {
            result = null;
        }
        return result;
    }

    public SimpleElement(String name, String value) {
        this.tag = name != null && name.matches("\\w{1,30}") ? name : "ddsSimpleElement";
        this.content = value;
    }

    public SimpleElement(String name) {
        this(name, null);
    }

    public String getElementName() {
        return this.tag;
    }

    public String getElementContent() {
        return this.content;
    }

    public int getElementCount() {
        return this.otherElments.size();
    }

    public boolean addElement(SimpleElement e) {
        if (e == null || this == e || this.content != null) {
            return false;
        }
        return this.otherElments.add(e);
    }

    public String asString() {
        StringWriter out = new StringWriter();
        out.write("<" + this.tag + ">");
        if (this.content != null) {
            out.write(this.content);
        } else {
            Object[] tokens;
            for (Object c : tokens = this.otherElments.toArray()) {
                out.write(((SimpleElement)c).asString());
            }
        }
        out.write("</" + this.tag + ">");
        return out.toString();
    }
}

