/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.elements.DataElement;
import com.signiant.interactivetransfer.engine.elements.ElementType;
import com.signiant.interactivetransfer.engine.elements.FileResponse;
import com.signiant.mobilize.ddsclient.connection.Stream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;

public class ManifestResponse
extends DataElement {
    ByteArrayOutputStream deflatedOutput;
    Stream stream;
    Deflater deflater;

    public static void write(Stream stream, byte handle) throws Exception {
        new ManifestResponse(null, handle).write(stream);
    }

    ManifestResponse(byte handle, ByteBuffer data) {
        super(ElementType.MANIFEST_RESP, handle, data);
    }

    public ManifestResponse(Stream stream, byte handle) {
        super(ElementType.MANIFEST_RESP, handle);
        this.deflatedOutput = new ByteArrayOutputStream();
        this.deflater = new Deflater();
        this.stream = stream;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void flush() throws Exception {
        this.deflater.finish();
        while (!this.deflater.finished()) {
            byte[] decompressedData = new byte[1024];
            int size = this.deflater.deflate(decompressedData);
            if (size <= 0) continue;
            this.deflatedOutput.write(decompressedData, 0, size);
        }
        this.setData(ByteBuffer.wrap(this.deflatedOutput.toByteArray()));
        this.write(this.stream);
        this.deflatedOutput = new ByteArrayOutputStream();
        this.deflater.reset();
    }

    public void addResponse(FileResponse fresp) throws Exception {
        byte[] serialized = fresp.serialize();
        this.deflater.setInput(serialized);
        while (!this.deflater.needsInput()) {
            byte[] decompressedData = new byte[30000];
            int size = this.deflater.deflate(decompressedData);
            if (size <= 0) continue;
            this.deflatedOutput.write(decompressedData, 0, size);
            this.setData(ByteBuffer.wrap(this.deflatedOutput.toByteArray()));
            this.write(this.stream);
            this.deflatedOutput = new ByteArrayOutputStream();
        }
    }
}

