/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.elements.DataElement;
import com.signiant.interactivetransfer.engine.elements.ElementType;
import com.signiant.interactivetransfer.engine.elements.FileDescriptor;
import com.signiant.mobilize.ddsclient.connection.Stream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;

public class ManifestInfo
extends DataElement {
    ByteArrayOutputStream deflatedOutput;
    Stream stream;
    Deflater deflater;

    public static void write(Stream stream, byte handle) throws Exception {
        new ManifestInfo(handle).write(stream);
    }

    ManifestInfo(byte handle, ByteBuffer data) {
        super(ElementType.MANIFEST_INFO, handle, data);
    }

    public ManifestInfo(byte handle) {
        super(ElementType.MANIFEST_INFO, handle);
    }

    public ManifestInfo(Stream stream, byte handle) {
        super(ElementType.MANIFEST_INFO, handle);
        this.deflatedOutput = new ByteArrayOutputStream();
        this.deflater = new Deflater();
        this.stream = stream;
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public void setData(ByteBuffer data) {
        this.data = data;
    }

    public void flush() throws Exception {
        this.deflater.finish();
        while (!this.deflater.finished()) {
            byte[] decompressedData = new byte[1024];
            int size = this.deflater.deflate(decompressedData);
            if (size <= 0) continue;
            this.deflatedOutput.write(decompressedData, 0, size);
        }
        this.setData(ByteBuffer.wrap(this.deflatedOutput.toByteArray()));
        this.write(this.stream);
        this.deflatedOutput = new ByteArrayOutputStream();
        this.deflater.reset();
    }

    public void addDescriptor(FileDescriptor fdesc) throws Exception {
        byte[] serialized = fdesc.serialize();
        this.deflater.setInput(serialized);
        while (!this.deflater.needsInput()) {
            byte[] decompressedData = new byte[30000];
            int size = this.deflater.deflate(decompressedData);
            if (size <= 0) continue;
            this.deflatedOutput.write(decompressedData, 0, size);
            this.setData(ByteBuffer.wrap(this.deflatedOutput.toByteArray()));
            this.write(this.stream);
            this.deflatedOutput = new ByteArrayOutputStream();
        }
    }
}

