/*
 * Decompiled with CFR 0.152.
 */
package com.signiant.interactivetransfer.engine.elements;

import com.signiant.interactivetransfer.engine.FileTransfer;
import com.signiant.interactivetransfer.engine.elements.ManifestResponse;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class FileResponse {
    static final byte FILE_RESP_VERSION = 1;
    static final short FILE_RESP_LENGTH = 16;
    private static final int CHUNK_SIZE = 32768;
    private ByteBuffer data;
    private Inflater inflater;
    short fresp_length;
    byte fresp_disp;
    byte fresp_version;
    int fresp_sequence;
    long fresp_chkpt_offset;
    private long eb_offset;
    private int eb_len;
    private int eb_digest_type;
    private String eb_digest;

    public FileResponse(FileTransfer ft) {
        this.fresp_length = (short)16;
        this.fresp_version = 1;
        this.setCheckpointOffest(ft.getCheckpointPosition());
        this.setDisposition(ft.getState());
        this.setSequence(ft.getSequence());
    }

    public FileResponse(ManifestResponse mi) throws DataFormatException {
        this.inflater = new Inflater();
        this.data = this.a(mi.getData().array());
    }

    public void append(ManifestResponse mi) throws DataFormatException {
        int remaining = this.data.remaining();
        ByteBuffer more = this.a(mi.getData().array());
        byte[] merged = new byte[remaining + more.limit()];
        this.data.get(merged, 0, remaining);
        more.get(merged, remaining, more.limit());
        this.data = ByteBuffer.wrap(merged);
    }

    protected ByteBuffer a(byte[] compressed) throws DataFormatException {
        this.inflater.setInput(compressed);
        byte[] buffer = new byte[32768];
        int length = this.inflater.inflate(buffer);
        while (!this.inflater.finished()) {
            byte[] biggerBuffer = new byte[length + 32768];
            System.arraycopy(buffer, 0, biggerBuffer, 0, length);
            buffer = biggerBuffer;
            int nextChunk = this.inflater.inflate(buffer, length, 32768);
            if (nextChunk == 0) break;
            length += nextChunk;
        }
        return ByteBuffer.wrap(buffer, 0, length);
    }

    public boolean getNextResponse() {
        if (this.data.remaining() < 2) {
            return false;
        }
        this.data.mark();
        this.fresp_length = this.data.getShort();
        if (this.data.remaining() < this.fresp_length - 2) {
            this.data.reset();
            return false;
        }
        this.fresp_disp = this.data.get();
        this.fresp_version = this.data.get();
        this.fresp_sequence = this.data.getInt();
        this.fresp_chkpt_offset = this.data.getLong();
        if (this.fresp_version >= 2) {
            this.eb_offset = this.data.getLong();
            this.eb_len = this.data.getInt();
            this.eb_digest_type = this.data.getInt();
            byte[] digest = new byte[32];
            this.data.get(digest);
            this.eb_digest = new String(digest);
        }
        return true;
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeShort(this.getLength());
        dos.write(this.getDisposition());
        dos.write(this.getVersion());
        dos.writeInt(this.getSequence());
        dos.writeLong(this.getCheckpointOffest());
        dos.flush();
        dos.close();
        return bos.toByteArray();
    }

    public long getEb_offset() {
        return this.eb_offset;
    }

    public void setEb_offset(long ebOffset) {
        this.eb_offset = ebOffset;
    }

    public long getEb_len() {
        return this.eb_len;
    }

    public void setEb_len(int ebLen) {
        this.eb_len = ebLen;
    }

    public int getEb_digest_type() {
        return this.eb_digest_type;
    }

    public void setEb_digest_type(int ebDigestType) {
        this.eb_digest_type = ebDigestType;
    }

    public String getEb_digest() {
        return this.eb_digest;
    }

    public void setEb_digest(String ebDigest) {
        this.eb_digest = ebDigest;
    }

    public short getLength() {
        return this.fresp_length;
    }

    public byte getVersion() {
        return this.fresp_version;
    }

    public void setVersion(byte fresp_version) {
        this.fresp_version = fresp_version;
    }

    public byte getDisposition() {
        return this.fresp_disp;
    }

    public FileTransfer.State getDispositionType() {
        if (this.fresp_disp == (byte)PROTOCOL_MESSAGE_TYPES.SKIPFILE_ERROR.ordinal()) {
            return FileTransfer.State.ERROR;
        }
        if (this.fresp_disp == (byte)PROTOCOL_MESSAGE_TYPES.SKIPFILE.ordinal()) {
            return FileTransfer.State.SKIPPED_EXISTS;
        }
        if (this.fresp_disp == (byte)PROTOCOL_MESSAGE_TYPES.DONEFILE.ordinal()) {
            return FileTransfer.State.TRANSFERRED;
        }
        return FileTransfer.State.PENDING;
    }

    public void setDisposition(FileTransfer.State disposition) {
        switch (disposition) {
            case ERROR: {
                this.fresp_disp = (byte)PROTOCOL_MESSAGE_TYPES.SKIPFILE_ERROR.ordinal();
                break;
            }
            case PENDING: {
                this.fresp_disp = (byte)PROTOCOL_MESSAGE_TYPES.SENDFILE.ordinal();
                break;
            }
            case SKIPPED_DENIED: {
                this.fresp_disp = (byte)PROTOCOL_MESSAGE_TYPES.SKIPFILE.ordinal();
                break;
            }
            case SKIPPED_EXISTS: {
                this.fresp_disp = (byte)PROTOCOL_MESSAGE_TYPES.SKIPFILE.ordinal();
                break;
            }
            case TRANSFERRED: {
                this.fresp_disp = (byte)PROTOCOL_MESSAGE_TYPES.DONEFILE.ordinal();
            }
        }
    }

    public int getSequence() {
        return this.fresp_sequence;
    }

    public void setSequence(int fresp_sequence) {
        this.fresp_sequence = fresp_sequence;
    }

    public long getCheckpointOffest() {
        return this.fresp_chkpt_offset;
    }

    public void setCheckpointOffest(long fresp_chkpt_offset) {
        this.fresp_chkpt_offset = fresp_chkpt_offset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("file_response:");
        sb.append(" sq=" + this.getSequence());
        sb.append(" disp=" + this.getDisposition());
        sb.append(" chpt=" + this.getCheckpointOffest());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PROTOCOL_MESSAGE_TYPES {
        STREAM_TERM,
        STREAM_TERM_ACK,
        PROCTRANS_TERM,
        PROCTRANS_TERM_ACK,
        PROTOCOL_COMMAND,
        DATA_CHANNEL_ERROR,
        SLAVE_DONE,
        CMD_DONE,
        TGT_SYNC_DONE,
        STATS_UPDATE,
        UDP_SESSION_PORT,
        STREAM_DATA_PORT,
        DATA_CHANNEL_PORT,
        PROCTRANS_DATA_PORT,
        SENDFILE,
        SENDATTRIBUTES,
        SKIPFILE,
        SKIPFILE_ERROR,
        DONEFILE,
        DELETEDFILE,
        FILE_HEADER,
        FILE_INFO,
        FILE_ABANDON,
        RESTARTED,
        RESPONSE,
        TNNLPRVDR_LISTEN_CID;

    }
}

